/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.analysis;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.urls.NormUrl;
import ai.platon.scent.common.Auth;
import ai.platon.scent.dom.HNormUrl;
import ai.platon.scent.entities.HarvestTaskStatus;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0007J\"\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00072\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u000eJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u0007J\u0013\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u0007H\u0086\u0002J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u0007J\u0019\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\bH\u0086\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lai/platon/scent/analysis/HarvestTaskTracker;", "", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "activeTaskStatus", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lai/platon/scent/entities/HarvestTaskStatus;", "computeIfAbsent", "normUrl", "Lai/platon/pulsar/common/urls/NormUrl;", "configuredUrl", "mappingFunction", "Lkotlin/Function1;", "findByUuid", "uuid", "get", "getIfActive", "Lai/platon/scent/dom/HNormUrl;", "remove", "set", "", "task", "scent-auto-mining"})
public final class HarvestTaskTracker {
    @NotNull
    private final ImmutableConfig conf;
    @NotNull
    private final ConcurrentHashMap<String, HarvestTaskStatus> activeTaskStatus;

    public HarvestTaskTracker(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.conf = conf;
        this.activeTaskStatus = new ConcurrentHashMap();
    }

    @Nullable
    public final HarvestTaskStatus get(@NotNull String configuredUrl) {
        Intrinsics.checkNotNullParameter((Object)configuredUrl, (String)"configuredUrl");
        return this.activeTaskStatus.get(configuredUrl);
    }

    @Nullable
    public final HarvestTaskStatus getIfActive(@NotNull HNormUrl normUrl) {
        Intrinsics.checkNotNullParameter((Object)normUrl, (String)"normUrl");
        HarvestTaskStatus activeTask = this.activeTaskStatus.get(normUrl.getConfiguredUrl());
        if (activeTask != null && activeTask.getStatusCode() == 200) {
            if (!activeTask.getHasResult()) {
                this.remove(normUrl.getConfiguredUrl());
            } else {
                Duration duration = normUrl.getOptions().getExpires();
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"normUrl.options.expires");
                if (!activeTask.isExpired(duration)) {
                    return activeTask;
                }
            }
        }
        return null;
    }

    public final void set(@NotNull String configuredUrl, @NotNull HarvestTaskStatus task) {
        Intrinsics.checkNotNullParameter((Object)configuredUrl, (String)"configuredUrl");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Map map = this.activeTaskStatus;
        boolean bl = false;
        map.put(configuredUrl, task);
    }

    @Nullable
    public final HarvestTaskStatus remove(@NotNull String configuredUrl) {
        Intrinsics.checkNotNullParameter((Object)configuredUrl, (String)"configuredUrl");
        return this.activeTaskStatus.remove(configuredUrl);
    }

    @NotNull
    public final HarvestTaskStatus computeIfAbsent(@NotNull NormUrl normUrl) {
        Intrinsics.checkNotNullParameter((Object)normUrl, (String)"normUrl");
        return this.computeIfAbsent(normUrl.getConfiguredUrl());
    }

    @NotNull
    public final HarvestTaskStatus computeIfAbsent(@NotNull String configuredUrl) {
        Intrinsics.checkNotNullParameter((Object)configuredUrl, (String)"configuredUrl");
        HarvestTaskStatus harvestTaskStatus = this.activeTaskStatus.computeIfAbsent(configuredUrl, arg_0 -> HarvestTaskTracker.computeIfAbsent$lambda-0(configuredUrl, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)harvestTaskStatus, (String)"activeTaskStatus.compute\u2026 configuredUrl)\n        }");
        return harvestTaskStatus;
    }

    @NotNull
    public final HarvestTaskStatus computeIfAbsent(@NotNull String configuredUrl, @NotNull Function1<? super String, HarvestTaskStatus> mappingFunction) {
        Intrinsics.checkNotNullParameter((Object)configuredUrl, (String)"configuredUrl");
        Intrinsics.checkNotNullParameter(mappingFunction, (String)"mappingFunction");
        Function1<? super String, HarvestTaskStatus> function1 = mappingFunction;
        HarvestTaskStatus harvestTaskStatus = this.activeTaskStatus.computeIfAbsent(configuredUrl, arg_0 -> HarvestTaskTracker.computeIfAbsent$lambda-1(function1, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)harvestTaskStatus, (String)"activeTaskStatus.compute\u2026uredUrl, mappingFunction)");
        return harvestTaskStatus;
    }

    @Nullable
    public final HarvestTaskStatus findByUuid(@NotNull String uuid) {
        Object object;
        block1: {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Iterable<Object> iterable = this.activeTaskStatus.values();
            Intrinsics.checkNotNullExpressionValue(iterable, (String)"activeTaskStatus.values");
            iterable = iterable;
            boolean bl = false;
            Iterable<Object> iterable2 = iterable;
            boolean bl2 = false;
            for (Object object2 : iterable2) {
                HarvestTaskStatus it = (HarvestTaskStatus)object2;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getUuid(), (Object)uuid)) continue;
                object = object2;
                break block1;
            }
            object = null;
        }
        return (HarvestTaskStatus)object;
    }

    private static final HarvestTaskStatus computeIfAbsent$lambda-0(String $configuredUrl, String it) {
        Intrinsics.checkNotNullParameter((Object)$configuredUrl, (String)"$configuredUrl");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new HarvestTaskStatus(Auth.INSTANCE.getSYSTEM_AUTH(), $configuredUrl, 0, null, null, 0, 0, 0, 0, 0, 0.0, 0, 0, null, null, 32764, null);
    }

    private static final HarvestTaskStatus computeIfAbsent$lambda-1(Function1 $tmp0, String p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        return (HarvestTaskStatus)$tmp0.invoke((Object)p0);
    }
}

