/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.analysis.corpus;

import ai.platon.pulsar.common.AppFiles;
import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.geometric.GeometricsKt;
import ai.platon.pulsar.common.math.vectors.VectorsKt;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt;
import ai.platon.pulsar.dom.nodes.NodesKt;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.pulsar.jsoup.ext.NodeExt;
import ai.platon.scent.analysis.corpus.AnalysablePageCorpus;
import ai.platon.scent.analysis.corpus.CorpusTextView;
import ai.platon.scent.analysis.diagnosis.ClusterDiagnosor;
import ai.platon.scent.analysis.diagnosis.ClusterTaskDiagnotor;
import ai.platon.scent.analysis.diagnosis.Distance;
import ai.platon.scent.analysis.diagnosis.DistanceType;
import ai.platon.scent.analysis.diagnosis.NodeClusterDiagnotor;
import ai.platon.scent.dom.nodes.NodeVertex;
import ai.platon.scent.dom.nodes.VisualComponent;
import ai.platon.scent.dom.nodes.VisualDocument;
import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.unsupervised.Cluster;
import ai.platon.scent.ml.unsupervised.NodeCluster;
import ai.platon.scent.ml.unsupervised.SeedSensitiveCluster;
import com.google.common.base.Strings;
import java.awt.Rectangle;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.util.FastMath;
import org.jetbrains.annotations.NotNull;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.ConnectivityInspector;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\"\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0014\u001a\u00060\u0012j\u0002`\u0013H\u0002J\"\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0015\u001a\u00020\u00062\f\b\u0002\u0010\u0014\u001a\u00060\u0012j\u0002`\u0013H\u0002J\"\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0016\u001a\u00020\u00172\f\b\u0002\u0010\u0014\u001a\u00060\u0012j\u0002`\u0013H\u0002J\u0006\u0010\u0018\u001a\u00020\u0019J\u001e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\f\b\u0002\u0010\u0014\u001a\u00060\u0012j\u0002`\u0013H\u0002J\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u001cJ\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lai/platon/scent/analysis/corpus/CorpusTextView;", "", "corpus", "Lai/platon/scent/analysis/corpus/AnalysablePageCorpus;", "diagnotors", "", "Lai/platon/scent/analysis/diagnosis/ClusterTaskDiagnotor;", "(Lai/platon/scent/analysis/corpus/AnalysablePageCorpus;Ljava/util/List;)V", "getCorpus", "()Lai/platon/scent/analysis/corpus/AnalysablePageCorpus;", "getDiagnotors", "()Ljava/util/List;", "reportDirectory", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getReportDirectory", "()Ljava/nio/file/Path;", "abstractOf", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "sb", "diagnotor", "doc", "Lai/platon/scent/dom/nodes/VisualDocument;", "build", "", "componentsAbstractOf", "reportIndexDocument", "Lai/platon/pulsar/dom/FeaturedDocument;", "saveAbstractOf", "document", "directory", "scent-auto-mining"})
public final class CorpusTextView {
    @NotNull
    private final AnalysablePageCorpus corpus;
    @NotNull
    private final List<ClusterTaskDiagnotor> diagnotors;

    public CorpusTextView(@NotNull AnalysablePageCorpus corpus, @NotNull List<ClusterTaskDiagnotor> diagnotors) {
        Intrinsics.checkNotNullParameter((Object)corpus, (String)"corpus");
        Intrinsics.checkNotNullParameter(diagnotors, (String)"diagnotors");
        this.corpus = corpus;
        this.diagnotors = diagnotors;
    }

    @NotNull
    public final AnalysablePageCorpus getCorpus() {
        return this.corpus;
    }

    @NotNull
    public final List<ClusterTaskDiagnotor> getDiagnotors() {
        return this.diagnotors;
    }

    private final Path getReportDirectory() {
        return this.corpus.getReportDirectory();
    }

    /*
     * WARNING - void declaration
     */
    public final void build() {
        StringBuilder stringBuilder = null;
        stringBuilder = CorpusTextView.abstractOf$default(this, this.corpus, null, 2, null);
        Object filename = null;
        filename = "corpus-textual-abstract.txt";
        Path path = null;
        Path path2 = path = this.getReportDirectory().resolve((String)filename);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
        AppFiles.INSTANCE.saveTo((Object)stringBuilder, path2, true);
        Iterable $this$forEachIndexed$iv = this.diagnotors;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void diagnotor;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ClusterTaskDiagnotor clusterTaskDiagnotor = (ClusterTaskDiagnotor)item$iv;
            int i = n;
            boolean bl2 = false;
            stringBuilder = CorpusTextView.abstractOf$default(this, (ClusterTaskDiagnotor)diagnotor, null, 2, null);
            filename = "c" + i + "-component-clustering-report.txt";
            Path path3 = path = this.getReportDirectory().resolve((String)filename);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"path");
            AppFiles.INSTANCE.saveTo((Object)stringBuilder, path3, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final StringBuilder abstractOf(ClusterTaskDiagnotor diagnotor, StringBuilder sb) {
        void $this$forEach$iv;
        Iterator $this$mapIndexedTo$iv$iv;
        void $this$sortedBy$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Object it;
        void $this$mapTo$iv$iv;
        Object object;
        StringBuilder it2;
        boolean bl;
        Collection collection;
        void $this$mapTo$iv$iv222;
        CharSequence $this$map$iv;
        NodeCluster p1;
        int n;
        int index$iv;
        Object $this$forEachIndexed$iv;
        List<RealVector> centroids = diagnotor.getCentroids();
        StringBuilder stringBuilder = sb;
        Object object2 = "Clusters diagnotor\n";
        boolean bl2 = false;
        StringBuilder stringBuilder2 = stringBuilder.append((String)object2);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        StringBuilder stringBuilder3 = stringBuilder2;
        boolean bl3 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        stringBuilder = sb;
        object2 = LocalDateTime.now();
        bl2 = false;
        StringBuilder stringBuilder4 = stringBuilder.append(object2);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        stringBuilder3 = stringBuilder4;
        bl3 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        stringBuilder = sb;
        boolean bl4 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        stringBuilder = sb;
        String string = "Total " + centroids.size() + " clusters";
        bl2 = false;
        StringBuilder stringBuilder5 = stringBuilder.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
        stringBuilder3 = stringBuilder5;
        bl3 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        stringBuilder = sb;
        string = "Url of random sample page: \n" + NodeExtKt.getLocation((Node)((NodePoint)((Object)((NodeCluster)CollectionsKt.first(diagnotor.getClusterGroup().getClusters())).getSample())).getNode());
        bl2 = false;
        StringBuilder stringBuilder6 = stringBuilder.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
        stringBuilder3 = stringBuilder6;
        bl3 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        stringBuilder = sb;
        boolean bl5 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        stringBuilder = sb;
        CharSequence charSequence = "Inter cluster distance matrix: ";
        bl2 = false;
        StringBuilder stringBuilder7 = stringBuilder.append((String)charSequence);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
        stringBuilder3 = stringBuilder7;
        bl3 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        String header2 = CollectionsKt.joinToString$default((Iterable)((Iterable)new IntRange(0, centroids.size() - 1)), (CharSequence)"", null, null, (int)0, null, (Function1)abstractOf.header.1.INSTANCE, (int)30, null);
        charSequence = sb;
        String string2 = StringsKt.repeat((CharSequence)" ", (int)10) + header2;
        boolean bl6 = false;
        StringBuilder stringBuilder8 = ((StringBuilder)charSequence).append(string2);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(value)");
        Object object3 = stringBuilder8;
        boolean bl7 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object3).append('\n'), (String)"append('\\n')");
        Object $this$forEachIndexed$iv2 = centroids;
        boolean $i$f$forEachIndexed4222 = false;
        int index$iv22 = 0;
        object3 = $this$forEachIndexed$iv2.iterator();
        while (object3.hasNext()) {
            Object item$iv = object3.next();
            int n2 = index$iv22++;
            boolean bl8 = false;
            if (n2 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            RealVector realVector = (RealVector)item$iv;
            int i = n2;
            boolean bl9 = false;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string3 = "%10d";
            Object[] objectArray = new Object[]{i};
            boolean bl10 = false;
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
            sb.append(string4);
            $this$forEachIndexed$iv = centroids;
            boolean $i$f$forEachIndexed = false;
            index$iv = 0;
            Iterator iterator = $this$forEachIndexed$iv.iterator();
            while (iterator.hasNext()) {
                boolean bl11;
                Object[] objectArray2;
                String string5;
                StringCompanionObject stringCompanionObject2;
                Object item$iv2 = iterator.next();
                n = index$iv++;
                boolean bl12 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                RealVector realVector2 = (RealVector)item$iv2;
                int j = n;
                boolean bl13 = false;
                if (i < j) {
                    void p2;
                    stringCompanionObject2 = StringCompanionObject.INSTANCE;
                    string5 = "%10.4f";
                    objectArray2 = new Object[]{diagnotor.distance((RealVector)p1, (RealVector)p2)};
                    bl11 = false;
                    String string6 = String.format(string5, Arrays.copyOf(objectArray2, objectArray2.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"java.lang.String.format(format, *args)");
                    sb.append(string6);
                    continue;
                }
                stringCompanionObject2 = StringCompanionObject.INSTANCE;
                string5 = "%10s";
                objectArray2 = new Object[]{"-"};
                bl11 = false;
                String string7 = String.format(string5, Arrays.copyOf(objectArray2, objectArray2.length));
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"java.lang.String.format(format, *args)");
                sb.append(string7);
            }
            $this$forEachIndexed$iv = sb;
            $i$f$forEachIndexed = false;
            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$forEachIndexed$iv).append('\n'), (String)"append('\\n')");
        }
        $this$forEachIndexed$iv2 = sb;
        $i$f$forEachIndexed4222 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$forEachIndexed$iv2).append('\n'), (String)"append('\\n')");
        $this$forEachIndexed$iv2 = sb;
        String $i$f$forEachIndexed4222 = "Inter cluster distance summaries: ";
        index$iv22 = 0;
        StringBuilder stringBuilder9 = ((StringBuilder)$this$forEachIndexed$iv2).append($i$f$forEachIndexed4222);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(value)");
        object3 = stringBuilder9;
        boolean item$iv = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object3).append('\n'), (String)"append('\\n')");
        diagnotor.getDistanceSummary().forEach((arg_0, arg_1) -> CorpusTextView.abstractOf$lambda-5(sb, arg_0, arg_1));
        $this$forEachIndexed$iv2 = sb;
        boolean $i$f$forEachIndexed4222 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$forEachIndexed$iv2).append('\n'), (String)"append('\\n')");
        $this$forEachIndexed$iv2 = sb;
        String $i$f$forEachIndexed4222 = "Distortions: ";
        index$iv22 = 0;
        StringBuilder stringBuilder10 = ((StringBuilder)$this$forEachIndexed$iv2).append($i$f$forEachIndexed4222);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(value)");
        object3 = stringBuilder10;
        item$iv = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object3).append('\n'), (String)"append('\\n')");
        Iterable $this$sortedByDescending$iv = diagnotor.getClusterGroup().getClusters();
        boolean $i$f$sortedByDescending = false;
        index$iv22 = 0;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                NodeCluster it = (NodeCluster)b;
                boolean bl2 = false;
                Comparable comparable = Double.valueOf(it.getDistortion());
                it = (NodeCluster)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Double d = it.getDistortion();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
            }
        });
        boolean $i$f$map = false;
        void index$iv22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv222) {
            p1 = (NodeCluster)item$iv$iv;
            collection = destination$iv$iv;
            bl = false;
            StringCompanionObject bl9 = StringCompanionObject.INSTANCE;
            $this$forEachIndexed$iv = "#%d: %-10.4f";
            Object[] $i$f$forEachIndexed = new Object[]{((Cluster)((Object)it2)).getLabel(), ((Cluster)((Object)it2)).getDistortion()};
            index$iv = 0;
            Intrinsics.checkNotNullExpressionValue((Object)String.format((String)$this$forEachIndexed$iv, Arrays.copyOf($i$f$forEachIndexed, $i$f$forEachIndexed.length)), (String)"java.lang.String.format(format, *args)");
            collection.add(object);
        }
        $this$map$iv = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\t", null, null, (int)0, null, null, (int)62, null);
        $i$f$map = false;
        boolean $this$mapTo$iv$iv222 = false;
        Object it322 = $this$map$iv;
        boolean bl14 = false;
        Object object4 = sb;
        boolean item$iv$iv = false;
        StringBuilder stringBuilder11 = ((StringBuilder)object4).append((String)it322);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11, (String)"append(value)");
        it2 = stringBuilder11;
        bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)it2.append('\n'), (String)"append('\\n')");
        $this$map$iv = sb;
        $i$f$map = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$map$iv).append('\n'), (String)"append('\\n')");
        Object $this$mapTo$iv$iv222 = diagnotor.getWidestCluster();
        NodePoint nodePoint = $this$mapTo$iv$iv222 == null ? null : ($i$f$map = (it322 = ((ClusterDiagnosor)$this$mapTo$iv$iv222).getCluster()) == null ? null : (NodePoint)((Object)((Cluster)it322).getFirst()));
        if ($i$f$map == null) {
            return sb;
        }
        NodePoint sample = $i$f$map;
        $this$mapTo$iv$iv222 = diagnotor.getWidestCluster();
        if ($this$mapTo$iv$iv222 == null) {
            return sb;
        }
        NodeClusterDiagnotor widest = $this$mapTo$iv$iv222;
        $this$mapTo$iv$iv222 = sb;
        it322 = "Widest cluster (diameter: " + widest.getDiameter() + ", distortion: " + widest.getCluster().getDistortion() + ") ";
        bl14 = false;
        StringBuilder stringBuilder12 = ((StringBuilder)$this$mapTo$iv$iv222).append((String)it322);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12, (String)"append(value)");
        object4 = stringBuilder12;
        item$iv$iv = false;
        StringBuilder stringBuilder13 = ((StringBuilder)object4).append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder13, (String)"append('\\n')");
        $this$mapTo$iv$iv222 = stringBuilder13;
        it322 = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getPath((Node)sample.getNode()).getSelector3();
        bl14 = false;
        StringBuilder stringBuilder14 = ((StringBuilder)$this$mapTo$iv$iv222).append((String)it322);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder14, (String)"append(value)");
        object4 = stringBuilder14;
        item$iv$iv = false;
        StringBuilder stringBuilder15 = ((StringBuilder)object4).append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder15, (String)"append('\\n')");
        $this$mapTo$iv$iv222 = stringBuilder15;
        it322 = ">>>";
        bl14 = false;
        StringBuilder stringBuilder16 = ((StringBuilder)$this$mapTo$iv$iv222).append((String)it322);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder16, (String)"append(value)");
        object4 = stringBuilder16;
        item$iv$iv = false;
        StringBuilder stringBuilder17 = ((StringBuilder)object4).append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder17, (String)"append('\\n')");
        $this$mapTo$iv$iv222 = stringBuilder17;
        it322 = NodeExtKt.getCleanText((Node)sample.getNode());
        bl14 = false;
        StringBuilder stringBuilder18 = ((StringBuilder)$this$mapTo$iv$iv222).append((String)it322);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder18, (String)"append(value)");
        object4 = stringBuilder18;
        item$iv$iv = false;
        StringBuilder stringBuilder19 = ((StringBuilder)object4).append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder19, (String)"append('\\n')");
        $this$mapTo$iv$iv222 = stringBuilder19;
        it322 = "<<<";
        bl14 = false;
        StringBuilder stringBuilder20 = ((StringBuilder)$this$mapTo$iv$iv222).append((String)it322);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder20, (String)"append(value)");
        object4 = stringBuilder20;
        item$iv$iv = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object4).append('\n'), (String)"append('\\n')");
        $this$mapTo$iv$iv222 = sb;
        boolean it322 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$mapTo$iv$iv222).append('\n'), (String)"append('\\n')");
        $this$mapTo$iv$iv222 = sb;
        String it322 = "Components: ";
        bl14 = false;
        StringBuilder stringBuilder21 = ((StringBuilder)$this$mapTo$iv$iv222).append(it322);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder21, (String)"append(value)");
        object4 = stringBuilder21;
        item$iv$iv = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object4).append('\n'), (String)"append('\\n')");
        Iterable $this$map$iv2 = diagnotor.getInspectors();
        boolean $i$f$map2 = false;
        object4 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            $this$forEachIndexed$iv = (NodeClusterDiagnotor)item$iv$iv2;
            collection = destination$iv$iv2;
            boolean bl15 = false;
            object = ((ClusterDiagnosor)it).getCluster();
            collection.add(object);
        }
        $this$map$iv2 = (List)destination$iv$iv2;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            SeedSensitiveCluster seedSensitiveCluster;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl16 = false;
            Cluster it4 = (Cluster)element$iv$iv;
            boolean bl17 = false;
            if ((it4 instanceof SeedSensitiveCluster ? (SeedSensitiveCluster)it4 : null) == null) continue;
            seedSensitiveCluster = seedSensitiveCluster;
            boolean bl18 = false;
            boolean bl19 = false;
            SeedSensitiveCluster it$iv$iv = seedSensitiveCluster;
            boolean bl20 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv2;
        $i$f$map2 = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            it = (SeedSensitiveCluster)item$iv$iv3;
            collection = destination$iv$iv2;
            boolean bl21 = false;
            object = ((NodePoint)((Object)((SeedSensitiveCluster)it).getSeed())).getNode();
            collection.add(object);
        }
        $this$map$iv2 = (List)destination$iv$iv2;
        boolean $i$f$sortedBy = false;
        boolean $this$mapTo$iv$iv42 = false;
        List components = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Node it = (Node)a;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(NodeExtKt.getSequence((Node)it));
                it = (Node)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = NodeExtKt.getSequence((Node)it);
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
        Iterable $this$mapIndexed$iv = components;
        boolean $i$f$mapIndexed = false;
        Iterable $this$mapTo$iv$iv42 = $this$mapIndexed$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        Object object5 = $this$mapIndexedTo$iv$iv.iterator();
        while (object5.hasNext()) {
            void n3;
            void i;
            Object item$iv$iv4 = object5.next();
            int bl21 = index$iv$iv++;
            boolean element$iv$iv = false;
            if (bl21 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Node bl16 = (Node)item$iv$iv4;
            int it4 = bl21;
            collection = destination$iv$iv2;
            boolean bl22 = false;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string8 = "%d\t%d\t%50s\t[df:%.2f]\t%s\t%s";
            Object[] objectArray = new Object[]{(int)(i + true), NodeExtKt.getSequence((Node)n3), ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getPath((Node)n3).getSelector2(), FastMath.max((double)ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getCaptionDocFrequency((Node)n3), (double)ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getTextDocFrequency((Node)n3)), GeometricsKt.getStr((Rectangle)NodeExtKt.getRectangle((Node)n3)), NodeExtKt.getCleanText((Node)n3)};
            boolean bl23 = false;
            Intrinsics.checkNotNullExpressionValue((Object)String.format(string8, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
            collection.add(object);
        }
        $this$mapIndexed$iv = (List)destination$iv$iv2;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            StringBuilder bl21;
            String it5 = (String)element$iv;
            boolean bl24 = false;
            object5 = sb;
            boolean item$iv$iv4 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object5).append(it5), (String)"append(value)");
            boolean element$iv$iv = false;
            Intrinsics.checkNotNullExpressionValue((Object)bl21.append('\n'), (String)"append('\\n')");
        }
        Iterable $this$forEachIndexed$iv3 = diagnotor.getInspectors();
        boolean $i$f$forEachIndexed = false;
        int index$iv3 = 0;
        for (Object item$iv3 : $this$forEachIndexed$iv3) {
            StringBuilder stringBuilder22;
            int n4 = index$iv3++;
            boolean bl25 = false;
            if (n4 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            NodeClusterDiagnotor item$iv$iv4 = (NodeClusterDiagnotor)item$iv3;
            int i = n4;
            boolean bl26 = false;
            StringBuilder stringBuilder23 = sb;
            String string9 = "\n\n" + i + ".\t===================== c" + it.getCluster().getLabel() + " ======================";
            n = 0;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder23.append(string9), (String)"append(value)");
            boolean bl27 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder22.append('\n'), (String)"append('\\n')");
            ClusterDiagnosor.show$default((ClusterDiagnosor)it, 0, sb, 1, null);
        }
        return sb;
    }

    static /* synthetic */ StringBuilder abstractOf$default(CorpusTextView corpusTextView, ClusterTaskDiagnotor clusterTaskDiagnotor, StringBuilder stringBuilder, int n, Object object) {
        if ((n & 2) != 0) {
            stringBuilder = new StringBuilder();
        }
        return corpusTextView.abstractOf(clusterTaskDiagnotor, stringBuilder);
    }

    private final void componentsAbstractOf(VisualDocument doc, StringBuilder sb) {
        Path path = NodeExtKt.getExportPaths((Document)doc.getDocument()).getAnnotatedView();
        StringBuilder stringBuilder = sb.append('\n').append(doc.getLocation()).append('\n').append(doc.getComponents().size()).append('\n').append(CollectionsKt.joinToString$default((Iterable)doc.getComponents(), null, null, null, (int)0, null, (Function1)componentsAbstractOf.1.INSTANCE, (int)31, null)).append('\n').append(path);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"sb.append('\\n').append(d\u2026append('\\n').append(path)");
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
    }

    static /* synthetic */ void componentsAbstractOf$default(CorpusTextView corpusTextView, VisualDocument visualDocument, StringBuilder stringBuilder, int n, Object object) {
        if ((n & 2) != 0) {
            stringBuilder = new StringBuilder();
        }
        corpusTextView.componentsAbstractOf(visualDocument, stringBuilder);
    }

    /*
     * WARNING - void declaration
     */
    private final StringBuilder abstractOf(AnalysablePageCorpus corpus, StringBuilder sb) {
        void $this$forEachIndexed$iv;
        void $this$filterTo$iv$iv;
        Object element$iv;
        StringBuilder $this$forEach$iv;
        Iterator $this$flatMapTo$iv$iv322;
        Iterable $this$filterTo$iv$iv2;
        Iterable list$iv$iv;
        VisualDocument it;
        void $this$flatMapTo$iv$iv;
        Object text22;
        List<VisualDocument> documents = corpus.getQualifiedDocuments$scent_auto_mining();
        StringBuilder stringBuilder = sb;
        String string = "Total " + documents.size() + " documents";
        boolean bl = false;
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        Object object = stringBuilder2;
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object).append('\n'), (String)"append('\\n')");
        stringBuilder = sb;
        boolean bl3 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        stringBuilder = sb;
        LocalDateTime localDateTime = LocalDateTime.now();
        bl = false;
        StringBuilder stringBuilder3 = stringBuilder.append(localDateTime);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        object = stringBuilder3;
        bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object).append('\n'), (String)"append('\\n')");
        Ref.IntRef k = new Ref.IntRef();
        int size = corpus.getConstantCaptionedElementIndexer$scent_auto_mining().keySet().size();
        Object object2 = sb;
        object = "\nTotal " + size + " constant captions: ";
        bl2 = false;
        StringBuilder stringBuilder4 = ((StringBuilder)object2).append((String)object);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        Object object3 = stringBuilder4;
        boolean bl4 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object3).append('\n'), (String)"append('\\n')");
        corpus.getConstantCaptionedElementIndexer$scent_auto_mining().asMap().forEach((arg_0, arg_1) -> CorpusTextView.abstractOf$lambda-16(sb, k, arg_0, arg_1));
        k.element = 0;
        size = corpus.getCategorizedTextNodeIndexer$scent_auto_mining().keySet().size();
        object2 = sb;
        object = "\nTotal " + size + " categorized texts: ";
        bl2 = false;
        StringBuilder stringBuilder5 = ((StringBuilder)object2).append((String)object);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
        object3 = stringBuilder5;
        bl4 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object3).append('\n'), (String)"append('\\n')");
        for (Object text22 : corpus.getCategorizedTextNodeIndexer$scent_auto_mining().keySet()) {
            Object object4;
            NavigableSet nodes2 = corpus.getCategorizedTextNodeIndexer$scent_auto_mining().get(text22);
            object3 = sb;
            ++k.element;
            String string2 = k.element + ".\t[" + 1.0 * (double)nodes2.size() / (double)documents.size() + "]\t" + (String)text22;
            boolean bl5 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object3).append(string2), (String)"append(value)");
            boolean bl6 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object4).append('\n'), (String)"append('\\n')");
        }
        k.element = 0;
        size = corpus.getPseudoConstantTextBlockIndexer$scent_auto_mining().keySet().size();
        object2 = sb;
        text22 = "\nTotal " + size + " pseudo constant text blocks (almost all text node are constant): ";
        boolean nodes2 = false;
        StringBuilder stringBuilder6 = ((StringBuilder)object2).append((String)text22);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
        object3 = stringBuilder6;
        bl4 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object3).append('\n'), (String)"append('\\n')");
        corpus.getPseudoConstantTextBlockIndexer$scent_auto_mining().asMap().forEach((arg_0, arg_1) -> CorpusTextView.abstractOf$lambda-17(sb, k, arg_0, arg_1));
        object2 = sb;
        text22 = "\nDocument frequencies of terms: ";
        nodes2 = false;
        StringBuilder stringBuilder7 = ((StringBuilder)object2).append((String)text22);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
        object3 = stringBuilder7;
        bl4 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object3).append('\n'), (String)"append('\\n')");
        object2 = sb;
        text22 = corpus.getDocumentFrequency$scent_auto_mining();
        nodes2 = false;
        StringBuilder stringBuilder8 = ((StringBuilder)object2).append(text22);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(value)");
        object3 = stringBuilder8;
        bl4 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object3).append('\n'), (String)"append('\\n')");
        object2 = sb;
        text22 = "\nVertical edges: ";
        nodes2 = false;
        StringBuilder stringBuilder9 = ((StringBuilder)object2).append((String)text22);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(value)");
        object3 = stringBuilder9;
        bl4 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object3).append('\n'), (String)"append('\\n')");
        Iterable $this$flatMap$iv = documents;
        boolean $i$f$flatMap = false;
        object3 = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (VisualDocument)element$iv$iv;
            boolean bl7 = false;
            NavigableSet navigableSet = it.getTileLeftIndexer().keySet();
            Intrinsics.checkNotNullExpressionValue((Object)navigableSet, (String)"it.tileLeftIndexer.keySet()");
            list$iv$iv = navigableSet;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Sequence edges = SequencesKt.sorted((Sequence)SequencesKt.distinct((Sequence)CollectionsKt.asSequence((Iterable)((List)destination$iv$iv))));
        Object $this$forEachIndexed$iv2 = documents;
        boolean $i$f$forEachIndexed22 = false;
        int index$iv22 = 0;
        destination$iv$iv = $this$forEachIndexed$iv2.iterator();
        while (destination$iv$iv.hasNext()) {
            Object item$iv = destination$iv$iv.next();
            int n = index$iv22++;
            boolean element$iv$iv = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            list$iv$iv = (VisualDocument)item$iv;
            int i = n;
            boolean bl8 = false;
            sb.append(i + "\t");
            for (Integer edge : edges) {
                void doc;
                int sz = doc.getTileLeftIndexer().get((Object)edge).size();
                if (sz <= 1) continue;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string3 = "%5s:%-2s\t";
                Object[] objectArray = new Object[]{edge, sz};
                boolean bl9 = false;
                String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
                sb.append(string4);
            }
            sb.append("\n");
        }
        $this$forEachIndexed$iv2 = sb;
        String $i$f$forEachIndexed22 = "\nSample document variables: ";
        index$iv22 = 0;
        StringBuilder stringBuilder10 = ((StringBuilder)$this$forEachIndexed$iv2).append($i$f$forEachIndexed22);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(value)");
        destination$iv$iv = stringBuilder10;
        boolean item$iv = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)destination$iv$iv).append('\n'), (String)"append('\\n')");
        Iterable $this$filter$iv = documents;
        boolean $i$f$filter = false;
        Iterable index$iv22 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (VisualDocument)element$iv$iv;
            boolean bl10 = false;
            if (!it.getVerbose()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$filterTo$iv$iv2 = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv322.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            it = (VisualDocument)element$iv$iv;
            boolean bl11 = false;
            list$iv$iv = it.getComponents();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$forEach22 = false;
        $this$flatMapTo$iv$iv322 = $this$forEach$iv.iterator();
        while ($this$flatMapTo$iv$iv322.hasNext()) {
            element$iv = $this$flatMapTo$iv$iv322.next();
            VisualComponent it2 = (VisualComponent)element$iv;
            boolean bl12 = false;
            int sz = it2.getVariables().size();
            sb.append("VisualComponent " + NodeExtKt.getName((Node)((Node)it2.getElement())) + " has a " + it2.getPattern() + " table and find " + sz + " variables\n");
            it2.getVariables().asMap().forEach((arg_0, arg_1) -> CorpusTextView.abstractOf$lambda-23$lambda-22(sb, arg_0, arg_1));
        }
        $this$forEach$iv = sb;
        String $i$f$forEach22 = "\nRecognized components";
        boolean $this$flatMapTo$iv$iv322 = false;
        StringBuilder stringBuilder11 = $this$forEach$iv.append($i$f$forEach22);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11, (String)"append(value)");
        element$iv = stringBuilder11;
        boolean it2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)element$iv).append('\n'), (String)"append('\\n')");
        Iterable $this$sortedBy$iv = documents;
        boolean $i$f$sortedBy = false;
        $this$flatMapTo$iv$iv322 = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                VisualDocument it = (VisualDocument)a;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(it.getComponents().size());
                it = (VisualDocument)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = it.getComponents().size();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
        boolean $i$f$forEach32 = false;
        Iterator $this$flatMapTo$iv$iv322 = $this$forEach$iv.iterator();
        while ($this$flatMapTo$iv$iv322.hasNext()) {
            element$iv = $this$flatMapTo$iv$iv322.next();
            VisualDocument it3 = (VisualDocument)element$iv;
            boolean bl13 = false;
            this.componentsAbstractOf(it3, sb);
        }
        Object[] $i$f$forEach32 = new String[]{"body", ".header-nav", ".content .w1004", ".show", ".M_productInfo", ".con_detail", ".con_detail .area.rel", "#wrap_con"};
        List selectors = CollectionsKt.mutableListOf((Object[])$i$f$forEach32);
        Iterable $this$filter$iv2 = documents;
        boolean $i$f$filter2 = false;
        element$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VisualDocument it4 = (VisualDocument)element$iv$iv;
            boolean bl14 = false;
            if (!it4.getVerbose()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv2 : $this$forEachIndexed$iv) {
            void document;
            int n = index$iv++;
            boolean bl15 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            VisualDocument it4 = (VisualDocument)item$iv2;
            int i = n;
            boolean bl16 = false;
            document.getTrackingSelectors().clear();
            document.getTrackingSelectors().addAll(selectors);
            Path path = this.getReportDirectory();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"reportDirectory");
            this.saveAbstractOf((VisualDocument)document, path);
        }
        return sb;
    }

    static /* synthetic */ StringBuilder abstractOf$default(CorpusTextView corpusTextView, AnalysablePageCorpus analysablePageCorpus, StringBuilder stringBuilder, int n, Object object) {
        if ((n & 2) != 0) {
            stringBuilder = new StringBuilder();
        }
        return corpusTextView.abstractOf(analysablePageCorpus, stringBuilder);
    }

    private final void saveAbstractOf(VisualDocument document, Path directory) {
        StringBuilder report = CorpusTextView.abstractOf$default(this, document, null, 2, null);
        String filename = AppPaths.fromUri$default((AppPaths)AppPaths.INSTANCE, (String)document.getLocation(), null, null, (int)6, null);
        Path path = directory.resolve("abstract").resolve(filename + ".txt");
        String string = report.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"report.toString()");
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
        AppFiles.INSTANCE.saveTo(byArray, path, true);
    }

    /*
     * WARNING - void declaration
     */
    private final StringBuilder abstractOf(VisualDocument doc, StringBuilder sb) {
        Pair[] pairArray;
        Object $this$filterTo$iv$iv;
        Object object;
        StringBuilder stringBuilder = sb;
        CharSequence charSequence = "\n== Components ==";
        boolean bl = false;
        StringBuilder stringBuilder2 = stringBuilder.append((String)charSequence);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        Object object2 = stringBuilder2;
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object2).append('\n'), (String)"append('\\n')");
        Object format = null;
        format = "%10s%10s%60s" + Strings.repeat((String)"%15s", (int)5);
        charSequence = sb;
        Object object3 = StringCompanionObject.INSTANCE;
        object2 = format;
        Object object4 = new Object[]{"", "sequence", "name", "descend", "caption", "df", "type", "tabular"};
        boolean bl3 = false;
        String string = String.format((String)object2, Arrays.copyOf(object4, ((Object[])object4).length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(format, *args)");
        object3 = string;
        boolean bl4 = false;
        StringBuilder stringBuilder3 = ((StringBuilder)charSequence).append((String)object3);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        object4 = stringBuilder3;
        bl3 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object4).append('\n'), (String)"append('\\n')");
        format = "%10d%10d%60s%15.2f%15d%15.2f%15s";
        Object $this$forEachIndexed$iv = doc.getComponents();
        boolean $i$f$forEachIndexed22 = false;
        int index$iv = 0;
        object4 = $this$forEachIndexed$iv.iterator();
        while (object4.hasNext()) {
            String line;
            void it;
            Object item$iv = object4.next();
            int n = index$iv++;
            boolean bl5 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            VisualComponent visualComponent = (VisualComponent)item$iv;
            int i = n;
            boolean bl6 = false;
            Element ele = it.getElement();
            Object object5 = StringCompanionObject.INSTANCE;
            Object object6 = format;
            object = new Object[7];
            object[0] = 1 + i;
            object[1] = NodeExtKt.getSequence((Node)((Node)ele));
            object[2] = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getPath((Node)((Node)ele)).getSelector2();
            RealVector realVector = ele.getExtension().getFeatures();
            Intrinsics.checkNotNullExpressionValue((Object)realVector, (String)"ele.extension.features");
            object[3] = VectorsKt.get((RealVector)realVector, (int)ai.platon.scent.dom.features.defined.DefinedFeaturesKt.getD());
            object[4] = NodeExtKt.getCaption((Node)((Node)ele)).length();
            object[5] = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getTextDocFrequency((Node)((Node)ele));
            object[6] = it.getPattern();
            boolean bl7 = false;
            Intrinsics.checkNotNullExpressionValue((Object)String.format((String)object6, Arrays.copyOf(object, ((Object[])object).length)), (String)"java.lang.String.format(format, *args)");
            object5 = sb;
            boolean bl8 = false;
            StringBuilder stringBuilder4 = ((StringBuilder)object5).append(line);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            object = stringBuilder4;
            bl7 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object).append('\n'), (String)"append('\\n')");
        }
        $this$forEachIndexed$iv = sb;
        Object $i$f$forEachIndexed22 = "\n== Connected sets ==";
        index$iv = 0;
        StringBuilder stringBuilder5 = ((StringBuilder)$this$forEachIndexed$iv).append((String)$i$f$forEachIndexed22);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
        object4 = stringBuilder5;
        boolean item$iv = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object4).append('\n'), (String)"append('\\n')");
        $i$f$forEachIndexed22 = new ConnectivityInspector((DirectedGraph)doc.getTileGraph()).connectedSets();
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$forEachIndexed22, (String)"ConnectivityInspector(do\u2026         .connectedSets()");
        Iterable $this$filter$iv = (Iterable)$i$f$forEachIndexed22;
        boolean $i$f$filter = false;
        object4 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            Set it = (Set)element$iv$iv;
            boolean bl9 = false;
            if (!(it.size() > 4)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List connectedSets = (List)destination$iv$iv;
        Iterable $this$forEach$iv = connectedSets;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            Set vertices = (Set)element$iv;
            boolean bl10 = false;
            Intrinsics.checkNotNullExpressionValue((Object)vertices, (String)"vertices");
            Sequence sorted2 = SequencesKt.sorted((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)vertices), (Function1)abstractOf.20.sorted.1.INSTANCE));
            int size = SequencesKt.count((Sequence)sorted2);
            NodeVertex v1 = (NodeVertex)SequencesKt.first((Sequence)sorted2);
            NodeVertex v2 = (NodeVertex)SequencesKt.last((Sequence)sorted2);
            Node node = v1.getData().getNode();
            Intrinsics.checkNotNull((Object)node);
            Node e1 = node.parent();
            Node node2 = v2.getData().getNode();
            Intrinsics.checkNotNull((Object)node2);
            Node e2 = node2.parent();
            object = sb;
            int n = vertices.size();
            Node node3 = e1;
            Intrinsics.checkNotNull((Object)node3);
            String string2 = NodeExtKt.getUniqueName((Node)node3);
            Node node4 = e2;
            Intrinsics.checkNotNull((Object)node4);
            String string3 = "Connected set in graph: total " + size + "/" + n + " nodes, " + string2 + ", " + NodeExtKt.getUniqueName((Node)node4);
            boolean line = false;
            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object).append(string3), (String)"append(value)");
            boolean bl11 = false;
            Intrinsics.checkNotNullExpressionValue((Object)pairArray.append('\n'), (String)"append('\\n')");
        }
        Object $i$f$forEach22 = new String[]{"tn", "ctn", "ctr", "tnd", "ctnd", "vtnd", "dvcocd", "dvcovd", "dvcod", "dvcocr", "dvcovr", "dvcor"};
        String[] names2 = $i$f$forEach22;
        $i$f$forEach22 = sb;
        $this$filterTo$iv$iv = "\n== Induced indicators ==";
        boolean bl12 = false;
        Object[] objectArray = ((StringBuilder)$i$f$forEach22).append((String)$this$filterTo$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"append(value)");
        Object vertices = objectArray;
        boolean bl10 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)vertices).append('\n'), (String)"append('\\n')");
        format = "%-40s" + Strings.repeat((String)"%10s", (int)names2.length);
        $i$f$forEach22 = sb;
        $this$filterTo$iv$iv = StringCompanionObject.INSTANCE;
        Object object7 = format;
        vertices = new SpreadBuilder(2);
        vertices.add((Object)"selector");
        vertices.addSpread((Object)names2);
        vertices = vertices.toArray(new Object[vertices.size()]);
        bl10 = false;
        String string4 = String.format((String)object7, Arrays.copyOf(vertices, ((Object[])vertices).length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
        $this$filterTo$iv$iv = string4;
        boolean bl13 = false;
        StringBuilder stringBuilder6 = ((StringBuilder)$i$f$forEach22).append((String)$this$filterTo$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
        vertices = stringBuilder6;
        bl10 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)vertices).append('\n'), (String)"append('\\n')");
        Iterable $this$forEach$iv2 = doc.getTrackingSelectors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            String selector = (String)element$iv;
            boolean bl14 = false;
            Iterable $this$forEach$iv3 = (Iterable)FeaturedDocument.select$default((FeaturedDocument)doc.getFeaturedDocument(), (String)selector, (int)0, (int)0, (int)6, null);
            boolean $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv3) {
                Object[] values;
                StringBuilder stringBuilder7;
                void $this$toTypedArray$iv;
                void $this$mapTo$iv$iv;
                Element ele = (Element)element$iv2;
                boolean bl15 = false;
                NodeExt nodeExt = ele.getExtension();
                Intrinsics.checkNotNullExpressionValue((Object)nodeExt, (String)"ele.extension");
                NodeExt ext = nodeExt;
                pairArray = new Pair[12];
                RealVector realVector = ext.getFeatures();
                Intrinsics.checkNotNullExpressionValue((Object)realVector, (String)"ext.features");
                pairArray[0] = TuplesKt.to((Object)"tn", (Object)VectorsKt.get((RealVector)realVector, (int)DefinedFeaturesKt.TN));
                realVector = ext.getFeatures();
                Intrinsics.checkNotNullExpressionValue((Object)realVector, (String)"ext.features");
                pairArray[1] = TuplesKt.to((Object)"ctn", (Object)VectorsKt.get((RealVector)realVector, (int)ai.platon.scent.dom.features.defined.DefinedFeaturesKt.getCTN()));
                pairArray[2] = TuplesKt.to((Object)"ctr", ext.getVariables().get("ctr"));
                pairArray[3] = TuplesKt.to((Object)"tnd", ext.getVariables().get("tnd"));
                pairArray[4] = TuplesKt.to((Object)"ctnd", ext.getVariables().get("ctnd"));
                pairArray[5] = TuplesKt.to((Object)"vtnd", ext.getVariables().get("vtnd"));
                pairArray[6] = TuplesKt.to((Object)"dvcocd", ext.getVariables().get("dvcocd"));
                pairArray[7] = TuplesKt.to((Object)"dvcovd", ext.getVariables().get("dvcovd"));
                pairArray[8] = TuplesKt.to((Object)"dvcod", ext.getVariables().get("dvcod"));
                pairArray[9] = TuplesKt.to((Object)"dvcocr", ext.getVariables().get("dvcocr"));
                pairArray[10] = TuplesKt.to((Object)"dvcovr", ext.getVariables().get("dvcovr"));
                pairArray[11] = TuplesKt.to((Object)"dvcor", ext.getVariables().get("dvcor"));
                Map features = MapsKt.mapOf((Pair[])pairArray);
                Iterable $this$map$iv = features.values();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void v;
                    Object item$iv$iv;
                    Object t = item$iv$iv = iterator2.next();
                    Collection collection = destination$iv$iv2;
                    boolean bl16 = false;
                    void var31_69 = v;
                    Double d = var31_69 == null ? Double.valueOf(0.0) : var31_69;
                    collection.add(d);
                }
                $this$map$iv = (List)destination$iv$iv2;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                if (thisCollection$iv.toArray(new Object[0]) == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String s2 = selector.length() > 35 ? StringsKt.substringAfterLast$default((String)selector, (String)" > ", null, (int)2, null) : selector;
                StringBuilder stringBuilder8 = sb;
                boolean bl17 = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append(s2), (String)"append(value)");
                boolean bl18 = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append('\\n')");
                ArraysKt.joinTo$default((Object[])values, (Appendable)sb, (CharSequence)" ", null, null, (int)0, null, null, (int)124, null);
            }
        }
        return sb;
    }

    static /* synthetic */ StringBuilder abstractOf$default(CorpusTextView corpusTextView, VisualDocument visualDocument, StringBuilder stringBuilder, int n, Object object) {
        if ((n & 2) != 0) {
            stringBuilder = new StringBuilder();
        }
        return corpusTextView.abstractOf(visualDocument, stringBuilder);
    }

    public final void reportIndexDocument(@NotNull FeaturedDocument doc) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        String string = "== Images report ==";
        boolean bl = false;
        System.out.println((Object)string);
        string = StringCompanionObject.INSTANCE;
        String string2 = "%50s%10s%10s%10s%10s%10s%10s%10s";
        Object[] objectArray = new Object[]{"name", "numImg", "numVisImg", "imgTW", "imgTH", "imgAW", "imgAH", "isHidden"};
        boolean bl2 = false;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
        string = string3;
        boolean bl3 = false;
        System.out.println((Object)string);
        NodesKt.forEach$default((Node)((Node)doc.getBody()), (boolean)false, (Function1)reportIndexDocument.1.INSTANCE, (int)1, null);
        string = "== Anchors report ==";
        bl3 = false;
        System.out.println((Object)string);
        string = StringCompanionObject.INSTANCE;
        String string4 = "%50s%10s%10s%10s%10s%10s%10s%10s";
        objectArray = new Object[]{"name", "numA", "numVisA", "aTW", "aTH", "aAW", "aAH", "isHidden"};
        bl2 = false;
        String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(format, *args)");
        string = string5;
        boolean bl4 = false;
        System.out.println((Object)string);
        NodesKt.forEach$default((Node)((Node)doc.getBody()), (boolean)false, (Function1)reportIndexDocument.2.INSTANCE, (int)1, null);
        string = doc.first("div.content.detail");
        if (string != null) {
            NodesKt.forEach$default((Node)((Node)string), (boolean)false, (Function1)reportIndexDocument.3.INSTANCE, (int)1, null);
        }
        Path path = doc.export();
    }

    /*
     * WARNING - void declaration
     */
    private static final void abstractOf$lambda-5(StringBuilder $sb, DistanceType type, List summary) {
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$sb, (String)"$sb");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)summary, (String)"summary");
        Iterable $this$map$iv = summary;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void it;
            object = (Distance)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "(%d,%d):%.2f";
            Object[] objectArray = new Object[]{it.getI(), it.getJ(), it.getDistance()};
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
            collection.add(string);
        }
        String string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, (Function1)abstractOf.2.2.INSTANCE, (int)30, null);
        boolean bl = false;
        boolean bl3 = false;
        String it = string;
        boolean bl4 = false;
        StringBuilder stringBuilder = $sb;
        Object object2 = StringCompanionObject.INSTANCE;
        object = "%-20s%s";
        Object object3 = new Object[]{type, it};
        boolean bl5 = false;
        String string3 = String.format((String)object, Arrays.copyOf(object3, ((Object[])object3).length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
        object2 = string3;
        boolean bl6 = false;
        StringBuilder stringBuilder2 = stringBuilder.append((String)object2);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        object3 = stringBuilder2;
        bl5 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object3).append('\n'), (String)"append('\\n')");
    }

    private static final void abstractOf$lambda-16(StringBuilder $sb, Ref.IntRef $k, Integer $noName_0, Collection nodes2) {
        Intrinsics.checkNotNullParameter((Object)$sb, (String)"$sb");
        Intrinsics.checkNotNullParameter((Object)$k, (String)"$k");
        StringBuilder stringBuilder = $sb;
        int n = ++$k.element;
        int n2 = nodes2.size();
        Intrinsics.checkNotNullExpressionValue((Object)nodes2, (String)"nodes");
        Object object = CollectionsKt.first((Iterable)nodes2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"nodes.first()");
        object = n + ".\t[size:" + n2 + "]\t" + NodeExtKt.getCaption((Node)((Node)object));
        boolean bl = false;
        StringBuilder stringBuilder2 = stringBuilder.append((String)object);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        StringBuilder stringBuilder3 = stringBuilder2;
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
    }

    private static final void abstractOf$lambda-17(StringBuilder $sb, Ref.IntRef $k, Integer $noName_0, Collection nodes2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$sb, (String)"$sb");
        Intrinsics.checkNotNullParameter((Object)$k, (String)"$k");
        ++$k.element;
        StringBuilder stringBuilder = $sb.append($k.element + ".\t(size:" + nodes2.size() + ")\t");
        Intrinsics.checkNotNullExpressionValue((Object)nodes2, (String)"nodes");
        Element element = (Element)CollectionsKt.firstOrNull((Iterable)nodes2);
        stringBuilder.append(element == null ? "" : ((string = NodeExtKt.getCaption((Node)((Node)element))) == null ? "" : string)).append('\n');
    }

    private static final void abstractOf$lambda-23$lambda-22(StringBuilder $sb, Node key, Collection values) {
        Intrinsics.checkNotNullParameter((Object)$sb, (String)"$sb");
        Intrinsics.checkNotNullExpressionValue((Object)values, (String)"values");
        String text2 = CollectionsKt.joinToString$default((Iterable)values, null, null, null, (int)0, null, (Function1)abstractOf.14.1.text.1.INSTANCE, (int)31, null);
        $sb.append(NodeExtKt.getCleanText((Node)key)).append("\t:\t").append(text2).append("\t|\t");
    }
}

