/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.analysis.diagnosis;

import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.Frequency;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.scent.analysis.AutoMiningResult;
import ai.platon.scent.analysis.corpus.AnalysablePageCorpus;
import ai.platon.scent.analysis.corpus.CorpusTextView;
import ai.platon.scent.analysis.diagnosis.AutoMiningDiagnotor;
import ai.platon.scent.analysis.diagnosis.ClusterTaskDiagnotor;
import ai.platon.scent.dom.nodes.HyperPathBuilder;
import ai.platon.scent.dom.nodes.NodePathBuilder;
import ai.platon.scent.dom.nodes.VisualComponent;
import ai.platon.scent.dom.nodes.VisualDocument;
import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.semisupervised.NodeClusterRunner;
import ai.platon.scent.ml.unsupervised.ComponentClusterGroup;
import ai.platon.scent.ml.unsupervised.IRMetric;
import ai.platon.scent.ml.unsupervised.TileCluster;
import ai.platon.scent.ml.unsupervised.TileClusterGroup;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001e\u001a\u00060\u001fj\u0002` H\u0002J\u0006\u0010!\u001a\u00020\u001bJ\b\u0010\"\u001a\u00020\u001bH\u0002J\u0006\u0010#\u001a\u00020\u001bJ\b\u0010$\u001a\u00020%H\u0002J\u001e\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*H\u0002J\u0010\u0010,\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\u000eH\u0002J\u0006\u0010.\u001a\u00020\u001bJ\b\u0010/\u001a\u00020\u001bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00060"}, d2={"Lai/platon/scent/analysis/diagnosis/AutoMiningDiagnotor;", "", "corpus", "Lai/platon/scent/analysis/corpus/AnalysablePageCorpus;", "clusterer", "Lai/platon/scent/ml/semisupervised/NodeClusterRunner;", "miningResult", "Lai/platon/scent/analysis/AutoMiningResult;", "(Lai/platon/scent/analysis/corpus/AnalysablePageCorpus;Lai/platon/scent/ml/semisupervised/NodeClusterRunner;Lai/platon/scent/analysis/AutoMiningResult;)V", "componentDiagnotors", "", "Lai/platon/scent/analysis/diagnosis/ClusterTaskDiagnotor;", "diagnotors", "documents", "Lai/platon/scent/dom/nodes/VisualDocument;", "expectedComponents", "", "getExpectedComponents", "()Ljava/util/List;", "logger", "Lorg/slf4j/Logger;", "reportDirectory", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getReportDirectory", "()Ljava/nio/file/Path;", "appendComponentReportTo", "", "component", "Lorg/jsoup/nodes/Element;", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "diagnose", "estimateSegmentation", "evaluate", "evaluateKMeans", "Lai/platon/scent/ml/unsupervised/IRMetric;", "getComponentPathReport", "i", "", "components", "", "Lai/platon/scent/dom/nodes/VisualComponent;", "getFrequencyReport", "document", "report", "reportHyperPaths", "scent-auto-mining"})
public final class AutoMiningDiagnotor {
    @NotNull
    private final AnalysablePageCorpus corpus;
    @NotNull
    private final NodeClusterRunner clusterer;
    @NotNull
    private final AutoMiningResult miningResult;
    @NotNull
    private final Logger logger;
    @NotNull
    private final List<VisualDocument> documents;
    @NotNull
    private final List<String> expectedComponents;
    @NotNull
    private List<ClusterTaskDiagnotor> componentDiagnotors;
    @NotNull
    private final List<ClusterTaskDiagnotor> diagnotors;

    public AutoMiningDiagnotor(@NotNull AnalysablePageCorpus corpus, @NotNull NodeClusterRunner clusterer, @NotNull AutoMiningResult miningResult) {
        Intrinsics.checkNotNullParameter((Object)corpus, (String)"corpus");
        Intrinsics.checkNotNullParameter((Object)clusterer, (String)"clusterer");
        Intrinsics.checkNotNullParameter((Object)miningResult, (String)"miningResult");
        this.corpus = corpus;
        this.clusterer = clusterer;
        this.miningResult = miningResult;
        Logger logger = LoggerFactory.getLogger(AutoMiningDiagnotor.class);
        Intrinsics.checkNotNull((Object)logger);
        this.logger = logger;
        this.documents = this.corpus.getQualifiedDocuments$scent_auto_mining();
        boolean bl = false;
        this.expectedComponents = new ArrayList();
        bl = false;
        this.componentDiagnotors = new ArrayList();
        bl = false;
        this.diagnotors = new ArrayList();
    }

    private final Path getReportDirectory() {
        return this.corpus.getReportDirectory();
    }

    @NotNull
    public final List<String> getExpectedComponents() {
        return this.expectedComponents;
    }

    public final void evaluate() {
    }

    public final void diagnose() {
        ClusterTaskDiagnotor clusterTaskDiagnotor;
        TileClusterGroup it;
        Collection collection;
        Iterable $this$mapTo$iv;
        if (this.corpus.getQualifiedDocuments$scent_auto_mining().isEmpty()) {
            return;
        }
        this.logger.info("Diagnose components ...");
        Iterable iterable = this.clusterer.getComponentClusterGroups$scent_auto_mining();
        Collection destination$iv = this.componentDiagnotors;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            ComponentClusterGroup componentClusterGroup = (ComponentClusterGroup)item$iv;
            collection = destination$iv;
            boolean bl = false;
            clusterTaskDiagnotor = new ClusterTaskDiagnotor(this.miningResult, it, 0, 4, null);
            collection.add(clusterTaskDiagnotor);
        }
        this.componentDiagnotors.parallelStream().forEach(AutoMiningDiagnotor::diagnose$lambda-1);
        this.logger.info("Diagnose tiles ...");
        $this$mapTo$iv = this.clusterer.getTileClusterGroups$scent_auto_mining();
        destination$iv = this.diagnotors;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            it = (TileClusterGroup)item$iv;
            collection = destination$iv;
            boolean bl = false;
            clusterTaskDiagnotor = new ClusterTaskDiagnotor(this.miningResult, it, 0, 4, null);
            collection.add(clusterTaskDiagnotor);
        }
        this.diagnotors.parallelStream().forEach(AutoMiningDiagnotor::diagnose$lambda-3);
    }

    public final void report() {
        try {
            Files.createDirectories(this.getReportDirectory(), new FileAttribute[0]);
            this.reportHyperPaths();
            new CorpusTextView(this.corpus, this.componentDiagnotors).build();
            this.logger.info("Corpus analysis results are saved in " + this.getReportDirectory());
        }
        catch (Exception e) {
            this.logger.warn(ExceptionsKt.stringify$default((Throwable)e, (String)"Failed to report - ", null, (int)2, null));
        }
    }

    private final void estimateSegmentation() {
        Iterable $this$forEach$iv = this.documents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualDocument it = (VisualDocument)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = this.getExpectedComponents();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String selector = (String)element$iv2;
                boolean bl2 = false;
                Element element = it.getFeaturedDocument().first(selector);
                if (element == null) continue;
                element.attr("a-man-label", "component");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportHyperPaths() {
        StringBuilder sb = new StringBuilder();
        Sequence $this$forEachIndexed$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.clusterer.getTileClusterGroups$scent_auto_mining()), (Function1)reportHyperPaths.1.INSTANCE);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void group;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TileClusterGroup tileClusterGroup = (TileClusterGroup)item$iv;
            int i = n;
            boolean bl2 = false;
            Element element = group.getSampleComponent();
            if (element == null) continue;
            Element component = element;
            this.appendComponentReportTo(component, sb);
            Iterable $this$forEach$iv = group.getClusters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StringBuilder stringBuilder;
                TileCluster it = (TileCluster)element$iv;
                boolean bl3 = false;
                StringBuilder stringBuilder2 = sb;
                String string = it.getHyperPath().format();
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append(string), (String)"append(value)");
                boolean bl5 = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
            }
        }
        Path path = this.getReportDirectory().resolve("hyper-paths.txt");
        Files.writeString(path, (CharSequence)sb.toString(), new OpenOption[0]);
    }

    private final void appendComponentReportTo(Element component, StringBuilder sb) {
        String text2 = StringUtils.abbreviateMiddle((String)component.text(), (String)"...", (int)1000);
        StringBuilder stringBuilder = sb;
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder $this$appendComponentReportTo_u24lambda_u2d8 = stringBuilder;
        boolean bl3 = false;
        StringBuilder stringBuilder2 = $this$appendComponentReportTo_u24lambda_u2d8;
        String string = "\n-------------------";
        boolean bl4 = false;
        StringBuilder stringBuilder3 = stringBuilder2.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        StringBuilder stringBuilder4 = stringBuilder3;
        boolean bl5 = false;
        StringBuilder stringBuilder5 = stringBuilder4.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append('\\n')");
        stringBuilder2 = stringBuilder5;
        string = component.baseUri();
        bl4 = false;
        StringBuilder stringBuilder6 = stringBuilder2.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
        stringBuilder4 = stringBuilder6;
        bl5 = false;
        StringBuilder stringBuilder7 = stringBuilder4.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append('\\n')");
        stringBuilder2 = stringBuilder7;
        string = NodeExtKt.getNamedRect((Node)((Node)component));
        bl4 = false;
        StringBuilder stringBuilder8 = stringBuilder2.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(value)");
        stringBuilder4 = stringBuilder8;
        bl5 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        stringBuilder2 = $this$appendComponentReportTo_u24lambda_u2d8;
        string = ">>>";
        bl4 = false;
        StringBuilder stringBuilder9 = stringBuilder2.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(value)");
        stringBuilder4 = stringBuilder9;
        bl5 = false;
        StringBuilder stringBuilder10 = stringBuilder4.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append('\\n')");
        stringBuilder2 = stringBuilder10;
        boolean bl6 = false;
        StringBuilder stringBuilder11 = stringBuilder2.append(text2);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11, (String)"append(value)");
        StringBuilder stringBuilder12 = stringBuilder11;
        boolean bl7 = false;
        StringBuilder stringBuilder13 = stringBuilder12.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder13, (String)"append('\\n')");
        stringBuilder2 = stringBuilder13;
        String string2 = "<<<";
        boolean bl8 = false;
        StringBuilder stringBuilder14 = stringBuilder2.append(string2);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder14, (String)"append(value)");
        StringBuilder stringBuilder15 = stringBuilder14;
        bl5 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder15.append('\n'), (String)"append('\\n')");
        stringBuilder2 = $this$appendComponentReportTo_u24lambda_u2d8;
        string2 = component.cssSelector();
        bl8 = false;
        StringBuilder stringBuilder16 = stringBuilder2.append(string2);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder16, (String)"append(value)");
        stringBuilder15 = stringBuilder16;
        bl5 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder15.append('\n'), (String)"append('\\n')");
        stringBuilder2 = $this$appendComponentReportTo_u24lambda_u2d8;
        boolean bl9 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
    }

    /*
     * WARNING - void declaration
     */
    private final IRMetric evaluateKMeans() {
        void $this$groupByTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        void $this$mapTo$iv;
        Object object;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable list$iv$iv;
        VisualDocument it;
        Iterable $this$flatMapTo$iv$iv2;
        Iterable $this$flatMap$iv = this.documents;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            it = (VisualDocument)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getComponents();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map22 = false;
        $this$flatMapTo$iv$iv2 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (VisualComponent)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = it.getElement();
            collection.add(object);
        }
        List components = (List)destination$iv$iv;
        Iterable $i$f$map22 = this.documents;
        Collection destination$iv = (Collection)new Frequency(null, 1, null);
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it2;
            Object item$iv$iv;
            item$iv$iv = (VisualDocument)item$iv;
            collection = destination$iv;
            boolean bl = false;
            object = it2.getComponents().size();
            collection.add(object);
        }
        Frequency frequency = (Frequency)destination$iv;
        this.logger.info("VisualComponent size frequency: \n" + frequency);
        Iterable $this$flatMap$iv2 = this.clusterer.getTileClusterGroups$scent_auto_mining();
        boolean $i$f$flatMap2 = false;
        Iterable $i$f$mapTo22 = $this$flatMap$iv2;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            TileClusterGroup it3 = (TileClusterGroup)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv2 = it3.getClusters();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv2);
        }
        List clusters = (List)destination$iv$iv2;
        Iterable $this$groupBy$iv = components;
        boolean $i$f$groupBy = false;
        destination$iv$iv2 = $this$groupBy$iv;
        Map destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            Element it4 = (Element)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = NodeExtKt.getCaption((Node)((Node)it4));
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv3;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv3 = (List)object2;
            list$iv$iv3.add(element$iv$iv);
        }
        Map expectedClusters = destination$iv$iv3;
        IRMetric metrics = new IRMetric(components.size(), 0, 0, 6, null);
        for (TileCluster cluster2 : clusters) {
            int n;
            void $this$count$iv;
            Map.Entry entry;
            Iterator iterator;
            Object $this$getOrPut$iv$iv$iv;
            Object $this$groupByTo$iv$iv2;
            Object element$iv$iv;
            Iterable $this$groupBy$iv2 = cluster2.getPoints();
            boolean $i$f$groupBy2 = false;
            element$iv$iv = $this$groupBy$iv2;
            Map destination$iv$iv4 = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            Iterator iterator2 = $this$groupByTo$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                Object object3;
                Object element$iv$iv2 = iterator2.next();
                NodePoint it5 = (NodePoint)((Object)element$iv$iv2);
                boolean bl = false;
                String key$iv$iv = NodeExtKt.getCaption((Node)it5.getNode());
                $this$getOrPut$iv$iv$iv = destination$iv$iv4;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object3 = answer$iv$iv$iv;
                } else {
                    object3 = value$iv$iv$iv;
                }
                List list$iv$iv4 = (List)object3;
                list$iv$iv4.add(element$iv$iv2);
            }
            Object object4 = destination$iv$iv4;
            $i$f$groupBy2 = false;
            $this$groupByTo$iv$iv2 = object4.entrySet();
            boolean bl = false;
            Iterator iterator3 = $this$groupByTo$iv$iv2.iterator();
            if (!iterator3.hasNext()) {
                iterator = null;
            } else {
                iterator2 = iterator3.next();
                if (!iterator3.hasNext()) {
                    iterator = iterator2;
                } else {
                    Map.Entry it6 = (Map.Entry)((Object)iterator2);
                    boolean bl42 = false;
                    int n2 = ((List)it6.getValue()).size();
                    do {
                        Object bl42 = iterator3.next();
                        Map.Entry it22 = (Map.Entry)bl42;
                        boolean $i$a$-maxByOrNull-AutoMiningDiagnotor$evaluateKMeans$entry$3 = false;
                        int it22 = ((List)it22.getValue()).size();
                        if (n2 >= it22) continue;
                        iterator2 = bl42;
                        n2 = it22;
                    } while (iterator3.hasNext());
                    iterator = iterator2;
                }
            }
            if ((entry = (Map.Entry)((Object)iterator)) == null) continue;
            $this$groupByTo$iv$iv2 = object4 = entry;
            bl = false;
            String caption = (String)$this$groupByTo$iv$iv2.getKey();
            Object object5 = object4;
            boolean bl5 = false;
            List points = (List)object5.getValue();
            object5 = metrics;
            ((IRMetric)object5).setRetrieved(((IRMetric)object5).getRetrieved() + points.size());
            object5 = (List)expectedClusters.get(caption);
            if (object5 == null) continue;
            Object object6 = object5;
            boolean bl6 = false;
            boolean bl7 = false;
            Object expectedNodes = object6;
            boolean bl8 = false;
            IRMetric iRMetric = metrics;
            $this$getOrPut$iv$iv$iv = points;
            int n3 = iRMetric.getHit();
            IRMetric iRMetric2 = iRMetric;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    NodePoint it7 = (NodePoint)((Object)element$iv);
                    boolean bl9 = false;
                    if (!CollectionsKt.contains((Iterable)((Iterable)expectedNodes), (Object)it7.getNode())) continue;
                    int n4 = ++count$iv;
                    boolean bl10 = false;
                    if (n4 >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int n5 = n;
            iRMetric2.setHit(n3 + n5);
        }
        this.logger.info("Cluster evaluation: " + metrics);
        return metrics;
    }

    /*
     * WARNING - void declaration
     */
    private final String getFrequencyReport(VisualDocument document) {
        StringBuilder sb;
        CharSequence charSequence = sb = new StringBuilder();
        String string = document.getLocation();
        boolean bl = false;
        StringBuilder stringBuilder = charSequence.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        StringBuilder stringBuilder2 = stringBuilder;
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        charSequence = StringCompanionObject.INSTANCE;
        string = "%5s%30s%20s%20s%20s";
        Object[] objectArray = new Object[]{"", "name", "numComponents", "numCaptionWords", "captionDF"};
        boolean bl3 = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        charSequence = string2;
        boolean bl4 = false;
        boolean bl5 = false;
        CharSequence it = charSequence;
        boolean bl6 = false;
        StringBuilder stringBuilder3 = sb;
        boolean bl7 = false;
        StringBuilder stringBuilder4 = stringBuilder3.append((String)it);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        StringBuilder stringBuilder5 = stringBuilder4;
        boolean bl8 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
        Iterable $this$forEachIndexed$iv = document.getComponents();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            StringBuilder stringBuilder6;
            void component;
            int n = index$iv++;
            bl7 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            stringBuilder5 = (VisualComponent)item$iv;
            int j = n;
            boolean bl9 = false;
            Element e = component.getElement();
            int capW = NodeExtKt.getCaptionWords((Node)((Node)e)).size();
            double capDF = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getCaptionDocFrequency((Node)((Node)e));
            int numC = document.getComponents().size();
            Object object = StringCompanionObject.INSTANCE;
            String string3 = "%5s%30s%20d%20d%20.1f";
            Object[] objectArray2 = new Object[]{1 + j, NodeExtKt.getName((Node)((Node)e)), numC, capW, capDF};
            boolean bl10 = false;
            String string4 = String.format(string3, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
            object = string4;
            boolean bl11 = false;
            boolean bl12 = false;
            Object it2 = object;
            boolean bl13 = false;
            StringBuilder stringBuilder7 = sb;
            boolean bl14 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append((String)it2), (String)"append(value)");
            boolean bl15 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append('\\n')");
        }
        charSequence = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"sb.toString()");
        return charSequence;
    }

    /*
     * WARNING - void declaration
     */
    private final String getComponentPathReport(int i, List<VisualComponent> components) {
        Collection<Element> collection;
        void $this$mapTo$iv$iv;
        VisualComponent component = (VisualComponent)CollectionsKt.first(components);
        int capW = NodeExtKt.getCaptionWords((Node)((Node)component.getElement())).size();
        double capDF = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getCaptionDocFrequency((Node)((Node)component.getElement()));
        double cDF = 1.0 * (double)components.size() / (double)this.documents.size();
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%-5s%20s%20s%20s";
        StringCompanionObject stringCompanionObject2 = new Object[4];
        stringCompanionObject2[0] = i;
        StringCompanionObject stringCompanionObject3 = StringCompanionObject.INSTANCE;
        String string2 = "numCaptionWords: %d";
        Object[] objectArray = new Object[]{capW};
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
        stringCompanionObject3 = StringCompanionObject.INSTANCE;
        string2 = "captionDF: %.1f";
        objectArray = new Object[]{capDF};
        bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
        stringCompanionObject3 = StringCompanionObject.INSTANCE;
        string2 = "componentDF: %.1f";
        objectArray = new Object[]{cDF};
        bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
        boolean bl2 = false;
        String string3 = String.format(string, Arrays.copyOf(stringCompanionObject2, ((Object[])stringCompanionObject2).length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
        Object result = string3;
        result = (String)result + "\n\t----- paths -----";
        NodePathBuilder p = new NodePathBuilder((Node)component.getElement());
        string = StringCompanionObject.INSTANCE;
        stringCompanionObject2 = StringUtils.repeat((String)"\n\t%s", (int)8);
        Intrinsics.checkNotNullExpressionValue((Object)stringCompanionObject2, (String)"repeat(\"\\n\\t%s\", 8)");
        Object[] objectArray2 = new Object[]{p.getPath1(), p.getPath2(), p.getPath3(), p.getPath4(), p.getPath5(), p.getPath9()};
        boolean bl3 = false;
        String string4 = String.format((String)stringCompanionObject2, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
        result = (String)result + string4;
        result = (String)result + "\n\t----- hyper paths -----";
        Object[] $this$map$iv = (Object[])components;
        boolean $i$f$map = false;
        Object[] objectArray3 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VisualComponent visualComponent = (VisualComponent)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            Element element = it.getElement();
            collection.add(element);
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        HyperPathBuilder hp = new HyperPathBuilder(list);
        stringCompanionObject2 = StringCompanionObject.INSTANCE;
        String string5 = StringUtils.repeat((String)"\n\t%s", (int)8);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"repeat(\"\\n\\t%s\", 8)");
        objectArray3 = new Object[]{hp.getPath1(), hp.getPath2(), hp.getPath3(), hp.getPath4(), hp.getPath5(), hp.getPath9()};
        boolean bl5 = false;
        String string6 = String.format(string5, Arrays.copyOf(objectArray3, objectArray3.length));
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"java.lang.String.format(format, *args)");
        result = (String)result + string6;
        return result;
    }

    private static final void diagnose$lambda-1(ClusterTaskDiagnotor it) {
        it.diagnose();
    }

    private static final void diagnose$lambda-3(ClusterTaskDiagnotor it) {
        it.diagnose();
    }
}

