/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.classifier;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.dom.DocumentFragment;
import ai.platon.scent.classifier.FragmentClassifier;
import ai.platon.scent.classifier.FragmentsClassifier;
import ai.platon.scent.diagnosis.ClassifierMatrixFormatter;
import ai.platon.scent.diagnosis.ScentDiagnostor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.linear.RealMatrix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.perf4j.slf4j.Slf4JStopWatch;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0002J)\u0010\u0010\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012H\u0016\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u000fH\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0015H\u0014J\b\u0010\u001c\u001a\u00020\u000fH\u0014J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00150\u001fH\u0016R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00010\bj\b\u0012\u0004\u0012\u00020\u0001`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Lai/platon/scent/classifier/FragmentsClassifier;", "Lai/platon/scent/classifier/FragmentClassifier;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "diagnostor", "Lai/platon/scent/diagnosis/ScentDiagnostor;", "(Lai/platon/pulsar/common/config/ImmutableConfig;Lai/platon/scent/diagnosis/ScentDiagnostor;)V", "classifiers", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "stopWatch", "Lorg/perf4j/slf4j/Slf4JStopWatch;", "getStopWatch", "()Lorg/perf4j/slf4j/Slf4JStopWatch;", "calculateOverallScore", "", "classify", "fragments", "", "Lai/platon/pulsar/dom/DocumentFragment;", "labels", "", "([Lai/platon/pulsar/dom/DocumentFragment;[Ljava/lang/String;)V", "diagnose", "getMaxScore", "", "fragment", "", "label", "getScore", "labelsInCharge", "", "scent-auto-mining"})
public final class FragmentsClassifier
extends FragmentClassifier {
    @NotNull
    private final ArrayList<FragmentClassifier> classifiers;
    @Nullable
    private final Slf4JStopWatch stopWatch;

    public FragmentsClassifier(@NotNull ImmutableConfig conf, @Nullable ScentDiagnostor diagnostor) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        super(conf, diagnostor);
        this.classifiers = new ArrayList();
        ScentDiagnostor scentDiagnostor = diagnostor;
        this.stopWatch = scentDiagnostor == null ? null : scentDiagnostor.getStopWatch();
    }

    public /* synthetic */ FragmentsClassifier(ImmutableConfig immutableConfig, ScentDiagnostor scentDiagnostor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            scentDiagnostor = null;
        }
        this(immutableConfig, scentDiagnostor);
    }

    @Override
    @Nullable
    public Slf4JStopWatch getStopWatch() {
        return this.stopWatch;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void classify(@NotNull DocumentFragment[] fragments, @NotNull String[] labels) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)fragments, (String)"fragments");
        Intrinsics.checkNotNullParameter((Object)labels, (String)"labels");
        super.classify(fragments, labels);
        if (this.getLog().isDebugEnabled()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.classifiers;
            boolean $i$f$map = false;
            void var6_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FragmentClassifier fragmentClassifier = (FragmentClassifier)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Pair pair = new Pair((Object)it.getClass().getSimpleName(), (Object)CollectionsKt.joinToString$default(it.labelsInCharge(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
                collection.add(pair);
            }
            String message2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, (Function1)classify.message.2.INSTANCE, (int)31, null);
            this.getLog().debug(message2);
        }
        if ((object = this.getStopWatch()) != null) {
            object.start();
        }
        for (FragmentClassifier classifier : this.classifiers) {
            classifier.classify(fragments, labels);
            Slf4JStopWatch slf4JStopWatch = this.getStopWatch();
            if (slf4JStopWatch == null) continue;
            slf4JStopWatch.lap(classifier.getClass().getSimpleName());
        }
        this.label();
    }

    @Override
    protected void label() {
        this.calculateOverallScore();
        this.normalize(-100.0, 100.0);
        super.label();
        this.inheritLabels();
    }

    private final void calculateOverallScore() {
        for (FragmentClassifier classifier : this.classifiers) {
            RealMatrix matrix = classifier.getScoreMatrix();
            RealMatrix realMatrix = matrix.scalarMultiply(classifier.getWeight());
            Intrinsics.checkNotNullExpressionValue((Object)realMatrix, (String)"matrix.scalarMultiply(classifier.weight)");
            matrix = realMatrix;
            realMatrix = this.getScoreMatrix().add(matrix);
            Intrinsics.checkNotNullExpressionValue((Object)realMatrix, (String)"this.scoreMatrix.add(matrix)");
            this.setScoreMatrix(realMatrix);
        }
        int n = 0;
        int n2 = this.getFragments().length + -1;
        if (n <= n2) {
            do {
                int row = n++;
                int n3 = 0;
                int n4 = this.getLabels().length + -1;
                if (n3 > n4) continue;
                do {
                    int col = n3++;
                    double score2 = this.getScoreMatrix().getEntry(row, col);
                    score2 = score2 > 0.0 ? this.getMaxScore(row, col) : 0.0;
                    this.getScoreMatrix().setEntry(row, col, score2);
                } while (n3 <= n4);
            } while (n <= n2);
        }
    }

    private final double getMaxScore(int fragment, int label) {
        double maxScore = -10.0;
        for (FragmentClassifier classifier : this.classifiers) {
            double score2 = classifier.getScoreMatrix().getEntry(fragment, label);
            if (!(score2 > maxScore)) continue;
            maxScore = score2;
        }
        return maxScore;
    }

    private final void diagnose() {
        for (FragmentClassifier classifier : this.classifiers) {
            ScentDiagnostor scentDiagnostor = this.getDiagnostor();
            if (scentDiagnostor == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)classifier, (String)"classifier");
            scentDiagnostor.addFormatter(new ClassifierMatrixFormatter(classifier, this.getConf()));
        }
        ScentDiagnostor scentDiagnostor = this.getDiagnostor();
        if (scentDiagnostor != null) {
            scentDiagnostor.addFormatter(new ClassifierMatrixFormatter(this, this.getConf()));
        }
    }

    @Override
    protected double getScore(@NotNull DocumentFragment fragment, @NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        return 0.0;
    }

    @Override
    @NotNull
    public Iterable<String> labelsInCharge() {
        return ArraysKt.asIterable((Object[])this.getLabels());
    }
}

