/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.diagnosis;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.dom.DocumentFragment;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.dom.data.BlockLabel;
import ai.platon.scent.diagnosis.DiagnosisFormatter;
import ai.platon.scent.segment.BlockFiltersKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lai/platon/scent/diagnosis/BlockLabelFormatter;", "Lai/platon/scent/diagnosis/DiagnosisFormatter;", "doc", "Lai/platon/pulsar/dom/FeaturedDocument;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/dom/FeaturedDocument;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "labels", "", "", "getLabels", "()[Ljava/lang/String;", "[Ljava/lang/String;", "process", "", "scent-auto-mining"})
public final class BlockLabelFormatter
extends DiagnosisFormatter {
    @NotNull
    private final FeaturedDocument doc;
    @NotNull
    private final String[] labels;

    public BlockLabelFormatter(@NotNull FeaturedDocument doc, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        super(conf);
        this.doc = doc;
        Validate.notNull((Object)this.doc);
        this.labels = conf.getStrings("scent.classifier.block.labels");
    }

    @NotNull
    protected final String[] getLabels() {
        return this.labels;
    }

    @Override
    public void process() {
        String[] stringArray = new String[]{"Label", "All Labels", "Segment", "Parent Segment", "Text"};
        this.buildHeader(stringArray);
        int counter = 0;
        String[] stringArray2 = this.labels;
        int n = 0;
        int n2 = stringArray2.length;
        while (n < n2) {
            String label = stringArray2[n];
            ++n;
            BlockLabel bl = new BlockLabel(label);
            for (DocumentFragment fragment : BlockFiltersKt.filterBy$default(this.doc.getFragments(), bl, null, 2, null)) {
                String string;
                String[] parent = fragment.getParent();
                String[] stringArray3 = parent;
                String parentName = stringArray3 == null ? "" : ((string = stringArray3.getElementName()) == null ? "" : string);
                stringArray3 = new String[5];
                stringArray3[0] = label;
                stringArray3[1] = CollectionsKt.joinToString$default((Iterable)fragment.getLabels(), null, null, null, (int)0, null, null, (int)63, null);
                stringArray3[2] = fragment.getElementName();
                stringArray3[3] = parentName;
                string = fragment.getElement().text();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fragment.element.text()");
                stringArray3[4] = string;
                this.buildRow(stringArray3);
                ++counter;
            }
        }
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "all block labels : %s\n total %d tagged fragments";
        Object[] objectArray = new Object[2];
        String[] stringArray4 = this.labels;
        objectArray[0] = Arrays.asList(Arrays.copyOf(stringArray4, stringArray4.length)).toString();
        objectArray[1] = counter;
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        String desc = string2;
        this.setDescription(desc);
    }
}

