/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.diagnosis;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.dom.DocumentFragment;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.dom.data.BlockPattern;
import ai.platon.scent.diagnosis.DiagnosisFormatter;
import ai.platon.scent.segment.BlockFiltersKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lai/platon/scent/diagnosis/BlockPatternFormatter;", "Lai/platon/scent/diagnosis/DiagnosisFormatter;", "doc", "Lai/platon/pulsar/dom/FeaturedDocument;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/dom/FeaturedDocument;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "process", "", "scent-auto-mining"})
public final class BlockPatternFormatter
extends DiagnosisFormatter {
    @NotNull
    private final FeaturedDocument doc;

    public BlockPatternFormatter(@NotNull FeaturedDocument doc, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        super(conf);
        this.doc = doc;
    }

    @Override
    public void process() {
        String[] stringArray = new String[]{"Pattern", "All Patterns", "Segment", "Parent Segment", "Text"};
        this.buildHeader(stringArray);
        int counter = 0;
        for (BlockPattern pattern : BlockPattern.Companion.getPatterns()) {
            for (DocumentFragment fragment : BlockFiltersKt.filterBy$default(this.doc.getFragments(), pattern, null, 2, null)) {
                String string;
                String[] stringArray2 = new String[5];
                stringArray2[0] = pattern.getText();
                stringArray2[1] = CollectionsKt.joinToString$default((Iterable)fragment.getPatterns(), null, null, null, (int)0, null, null, (int)63, null);
                stringArray2[2] = fragment.getElementName();
                Object object = fragment.getParent();
                stringArray2[3] = object == null ? "" : ((string = object.getElementName()) == null ? "" : string);
                object = fragment.getElement().text();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fragment.element.text()");
                stringArray2[4] = object;
                this.buildRow(stringArray2);
                ++counter;
            }
        }
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "all block patterns : %s\n total %d tagged fragments";
        Object[] objectArray = new Object[]{BlockPattern.Companion.getPatterns().toString(), counter};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        String desc = string2;
        this.setDescription(desc);
    }
}

