/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.diagnosis;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.dom.DocumentFragment;
import ai.platon.pulsar.dom.DocumentFragments;
import ai.platon.pulsar.dom.features.FeatureFormatter;
import ai.platon.scent.diagnosis.DiagnosisFormatter;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.linear.RealVector;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lai/platon/scent/diagnosis/FragmentFormatter;", "Lai/platon/scent/diagnosis/DiagnosisFormatter;", "fragments", "Lai/platon/pulsar/dom/DocumentFragments;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/dom/DocumentFragments;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "doc", "Lorg/jsoup/nodes/Document;", "asTable", "", "buildFeatureVectorTable", "Lorg/jsoup/nodes/Element;", "parent", "features", "Lorg/apache/commons/math3/linear/RealVector;", "buildImagesString", "root", "buildLinksString", "buildTable", "fragment", "Lai/platon/pulsar/dom/DocumentFragment;", "formatFeatures", "scent-auto-mining"})
public final class FragmentFormatter
extends DiagnosisFormatter {
    @NotNull
    private final DocumentFragments fragments;
    @NotNull
    private final Document doc;

    public FragmentFormatter(@NotNull DocumentFragments fragments, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)fragments, (String)"fragments");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        super(conf);
        this.fragments = fragments;
        Document document = Document.createShell((String)"http://internal.pulsar.platon.ai/empty");
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"createShell(AppConstants.EMPTY_PAGE_URL)");
        this.doc = document;
    }

    @Override
    @NotNull
    public String asTable() {
        this.doc.body().appendElement("h3").text(this.getClass().getName());
        Iterable $this$forEach$iv = this.fragments.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DocumentFragment it = (DocumentFragment)element$iv;
            boolean bl = false;
            this.doc.body().appendChild((Node)this.buildTable(it));
        }
        String string = this.doc.body().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"doc.body().toString()");
        return string;
    }

    private final Element buildTable(DocumentFragment fragment) {
        String string;
        Element element = this.doc.body().appendElement("table").addClass("table");
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"doc.body().appendElement\u2026table\").addClass(\"table\")");
        Element table = element;
        table.appendElement("caption").text(fragment.getElementName());
        String row1 = "<tr><th>Parent Segment</th><th>Patterns</th><th>Labels</th><th class='last'>Clues</th></tr>";
        DocumentFragment parent = fragment.getParent();
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = "<tr><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>";
        StringCompanionObject stringCompanionObject2 = new Object[4];
        DocumentFragment documentFragment = parent;
        stringCompanionObject2[0] = documentFragment == null ? "" : ((string = documentFragment.getElementName()) == null ? "" : string);
        stringCompanionObject2[1] = CollectionsKt.joinToString$default((Iterable)fragment.getPatterns(), null, null, null, (int)0, null, null, (int)63, null);
        stringCompanionObject2[2] = CollectionsKt.joinToString$default((Iterable)fragment.getLabels(), null, null, null, (int)0, null, null, (int)63, null);
        stringCompanionObject2[3] = fragment.getClues().getAsString();
        boolean bl = false;
        String string3 = String.format(string2, Arrays.copyOf(stringCompanionObject2, ((Object[])stringCompanionObject2).length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
        String row2 = string3;
        string2 = StringCompanionObject.INSTANCE;
        stringCompanionObject2 = "<tr class='vi'><td colspan='4'>VI : %s</td></tr>";
        Object[] objectArray = new Object[]{fragment.getElement().attr("vi")};
        boolean bl2 = false;
        String string4 = String.format((String)stringCompanionObject2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
        String row3 = string4;
        stringCompanionObject2 = StringCompanionObject.INSTANCE;
        objectArray = "<tr class='features'><td colspan='4' class='features'>FeatureVector : %s</td></tr>";
        Object[] objectArray2 = new Object[]{this.formatFeatures(fragment)};
        boolean bl3 = false;
        String string5 = String.format((String)objectArray, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(format, *args)");
        String row4 = string5;
        objectArray = StringCompanionObject.INSTANCE;
        objectArray2 = "<tr class='clues'><td colspan='4'>Clues : %s</td></tr>";
        Object[] objectArray3 = new Object[]{fragment.getClues().getAsString()};
        boolean bl4 = false;
        String string6 = String.format((String)objectArray2, Arrays.copyOf(objectArray3, objectArray3.length));
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"java.lang.String.format(format, *args)");
        String row5 = string6;
        objectArray2 = StringCompanionObject.INSTANCE;
        objectArray3 = "<tr class='text'><td colspan='4'>Text : %s</td></tr>";
        Object[] objectArray4 = new Object[]{StringUtils.substring((String)fragment.getElement().text(), (int)0, (int)800)};
        boolean bl5 = false;
        String string7 = String.format((String)objectArray3, Arrays.copyOf(objectArray4, objectArray4.length));
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"java.lang.String.format(format, *args)");
        String row6 = string7;
        objectArray3 = StringCompanionObject.INSTANCE;
        objectArray4 = "<tr class='links'><td colspan='4'>Links : %s</td></tr>";
        Object[] objectArray5 = new Object[]{this.buildLinksString(fragment.getElement())};
        boolean bl6 = false;
        String string8 = String.format((String)objectArray4, Arrays.copyOf(objectArray5, objectArray5.length));
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"java.lang.String.format(format, *args)");
        String row7 = string8;
        objectArray4 = StringCompanionObject.INSTANCE;
        objectArray5 = "<tr class='images'><td colspan='4'>Images : %s</td></tr>";
        Object[] objectArray6 = new Object[]{this.buildImagesString(fragment.getElement())};
        boolean bl7 = false;
        String string9 = String.format((String)objectArray5, Arrays.copyOf(objectArray6, objectArray6.length));
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"java.lang.String.format(format, *args)");
        String row8 = string9;
        table.append(row1);
        table.append(row2);
        table.append(row3);
        table.append(row4);
        table.append(row5);
        table.append(row6);
        table.append(row7);
        table.append(row8);
        Object[] objectArray7 = table.select("td.features").first();
        Intrinsics.checkNotNull((Object)objectArray7);
        objectArray5 = objectArray7;
        Intrinsics.checkNotNullExpressionValue((Object)objectArray5, (String)"table.select(\"td.features\").first()!!");
        Object[] featureContainer = objectArray5;
        objectArray5 = fragment.getElement().getExtension().getFeatures();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray5, (String)"fragment.element.extension.features");
        this.buildFeatureVectorTable((Element)featureContainer, (RealVector)objectArray5);
        return table;
    }

    private final String formatFeatures(DocumentFragment fragment) {
        RealVector realVector = fragment.getElement().getExtension().getFeatures();
        Intrinsics.checkNotNullExpressionValue((Object)realVector, (String)"fragment.element.extension.features");
        String string = FeatureFormatter.format$default((FeatureFormatter)FeatureFormatter.INSTANCE, (RealVector)realVector, null, (double)0.0, (int)6, null).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FeatureFormatter.format(\u2026sion.features).toString()");
        return StringsKt.replace$default((String)string, (String)"_", (String)"&nbsp;", (boolean)false, (int)4, null);
    }

    private final Element buildFeatureVectorTable(Element parent, RealVector features) {
        Element element = parent.appendElement("table").addClass("table").addClass("features");
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"parent.appendElement(\"ta\u2026le\").addClass(\"features\")");
        return element;
    }

    private final String buildLinksString(Element root) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Element link : root.getElementsByTag("a")) {
            int n = i;
            i = n + 1;
            if (n > 0) {
                sb.append(", ");
            }
            if (i > 10) {
                sb.append("...");
                break;
            }
            sb.append(link.attr("href"));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private final String buildImagesString(Element root) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Element link : root.getElementsByTag("img")) {
            int n = i;
            i = n + 1;
            if (n > 0) {
                sb.append(", ");
            }
            if (i > 10) {
                sb.append("...");
                break;
            }
            sb.append(link.attr("src"));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }
}

