/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.feature;

import ai.platon.pulsar.common.ResourceLoader;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.dom.DocumentFragment;
import ai.platon.pulsar.dom.data.BlockPattern;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 &2\u00020\u0001:\u0002&'B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0006J$\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00062\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ(\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00062\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0007J\u0016\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0006J&\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00062\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH&J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0006H\u0004J\u0010\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020%H$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006("}, d2={"Lai/platon/scent/feature/BlockFeature;", "", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "resources0", "", "", "(Lai/platon/pulsar/common/config/ImmutableConfig;[Ljava/lang/String;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "labels", "", "getLabels", "()Ljava/util/Set;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "resources", "", "getResources", "()Ljava/util/List;", "getScore", "", "fragment", "Lai/platon/pulsar/dom/DocumentFragment;", "label", "patterns", "", "Lai/platon/pulsar/dom/data/BlockPattern;", "getScore1", "getScore10", "loadIgnoreMissing", "", "resource", "parse", "doc", "Lorg/jsoup/nodes/Document;", "Companion", "Phase", "scent-auto-mining"})
public abstract class BlockFeature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImmutableConfig conf;
    @NotNull
    private final Logger log;
    @NotNull
    private final List<String> resources;
    @NotNull
    private final Set<String> labels;
    @NotNull
    public static final String PRIMARY_CONFIG_FILE = "feature/classify/common/block-stat-basic.xml";

    public BlockFeature(@NotNull ImmutableConfig conf, @NotNull String[] resources0) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter((Object)resources0, (String)"resources0");
        this.conf = conf;
        Logger logger = LoggerFactory.getLogger(BlockFeature.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(BlockFeature::class.java)");
        this.log = logger;
        this.resources = ArraysKt.toMutableList((Object[])resources0);
        this.labels = new HashSet();
        this.resources.add(0, PRIMARY_CONFIG_FILE);
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    @NotNull
    public final List<String> getResources() {
        return this.resources;
    }

    @NotNull
    public Set<String> getLabels() {
        return this.labels;
    }

    public final double getScore(@NotNull DocumentFragment fragment, @NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        return this.getScore10(fragment, label);
    }

    public final double getScore(@NotNull DocumentFragment fragment, @NotNull String label, @NotNull Collection<BlockPattern> patterns) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
        return this.getScore10(fragment, label, patterns);
    }

    @JvmOverloads
    public final double getScore1(@NotNull DocumentFragment fragment, @NotNull String label, @NotNull Collection<BlockPattern> patterns) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
        return this.getScore10(fragment, label, patterns) / 10.0;
    }

    public static /* synthetic */ double getScore1$default(BlockFeature blockFeature, DocumentFragment documentFragment, String string, Collection collection, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getScore1");
        }
        if ((n & 4) != 0) {
            collection = CollectionsKt.emptyList();
        }
        return blockFeature.getScore1(documentFragment, string, collection);
    }

    public final double getScore10(@NotNull DocumentFragment fragment, @NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        return this.getScore10(fragment, label, CollectionsKt.emptyList());
    }

    public abstract double getScore10(@NotNull DocumentFragment var1, @NotNull String var2, @NotNull Collection<BlockPattern> var3);

    protected abstract void parse(@NotNull Document var1);

    protected final void loadIgnoreMissing(@NotNull String resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        InputStream stream = ResourceLoader.INSTANCE.getResourceAsStream(resource);
        if (stream != null) {
            Document document = Jsoup.parse((InputStream)stream, (String)"utf-8", (String)resource, (Parser)Parser.xmlParser());
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(stream, \"utf-8\", r\u2026urce, Parser.xmlParser())");
            Document doc = document;
            this.parse(doc);
        } else {
            Logger logger;
            Logger logger2 = this.log;
            boolean bl = false;
            boolean bl2 = false;
            Logger it = logger2;
            boolean bl3 = false;
            Object object = logger = it.isDebugEnabled() ? logger2 : null;
            if (logger != null) {
                logger.debug("No resource " + resource);
            }
        }
    }

    @JvmOverloads
    public final double getScore1(@NotNull DocumentFragment fragment, @NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        return BlockFeature.getScore1$default(this, fragment, label, null, 4, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lai/platon/scent/feature/BlockFeature$Phase;", "", "(Ljava/lang/String;I)V", "ALL", "SEGMENT", "CLASSIFY", "EXTRACT", "BUILD", "scent-auto-mining"})
    public static final class Phase
    extends Enum<Phase> {
        public static final /* enum */ Phase ALL = new Phase();
        public static final /* enum */ Phase SEGMENT = new Phase();
        public static final /* enum */ Phase CLASSIFY = new Phase();
        public static final /* enum */ Phase EXTRACT = new Phase();
        public static final /* enum */ Phase BUILD = new Phase();
        private static final /* synthetic */ Phase[] $VALUES;

        public static Phase[] values() {
            return (Phase[])$VALUES.clone();
        }

        public static Phase valueOf(String value) {
            return Enum.valueOf(Phase.class, value);
        }

        static {
            $VALUES = phaseArray = new Phase[]{Phase.ALL, Phase.SEGMENT, Phase.CLASSIFY, Phase.EXTRACT, Phase.BUILD};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/platon/scent/feature/BlockFeature$Companion;", "", "()V", "PRIMARY_CONFIG_FILE", "", "scent-auto-mining"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

