/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.feature.statistics;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.dom.DocumentFragment;
import ai.platon.pulsar.dom.data.BlockPattern;
import ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.pulsar.dom.select.QueriesKt;
import ai.platon.scent.feature.BlockFeature;
import ai.platon.scent.feature.ScentRule;
import ai.platon.scent.feature.statistics.BlockStatRule;
import ai.platon.scent.feature.statistics.StatFeature;
import ai.platon.scent.feature.statistics.StatRule;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.DoubleSummaryStatistics;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u001a\u001a\u00020\u0006J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001f\u001a\u00020\u0006J\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0!2\u0006\u0010\"\u001a\u00020\u0006J&\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\"\u001a\u00020\u00062\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0!H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0014J\u0010\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u001dH\u0002J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020(002\u0006\u00101\u001a\u00020\u0006H\u0002J\u0006\u00102\u001a\u00020\u0006J\u0006\u00103\u001a\u00020*J\u0016\u00104\u001a\u00020*2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u0006J\b\u00106\u001a\u00020\u0006H\u0016RQ\u0010\b\u001aB\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000b0\u000b \n* \u0012\f\u0012\n \n*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR-\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00100\u000fj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0010`\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R-\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000fj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006`\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00067"}, d2={"Lai/platon/scent/feature/statistics/BlockStatFeature;", "Lai/platon/scent/feature/BlockFeature;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "resources", "", "", "(Lai/platon/pulsar/common/config/ImmutableConfig;[Ljava/lang/String;)V", "blockRules", "Lcom/google/common/collect/LinkedListMultimap;", "kotlin.jvm.PlatformType", "Lai/platon/scent/feature/statistics/BlockStatRule;", "getBlockRules", "()Lcom/google/common/collect/LinkedListMultimap;", "features", "Ljava/util/HashMap;", "Lai/platon/scent/feature/statistics/StatFeature;", "Lkotlin/collections/HashMap;", "getFeatures", "()Ljava/util/HashMap;", "globalVars", "getGlobalVars", "labels", "", "getLabels", "()Ljava/util/Set;", "dumpGlobalVars", "getBlockRuleId", "eleBlock", "Lorg/jsoup/nodes/Element;", "getGlobalVar", "name", "getRules", "", "label", "getScore10", "", "fragment", "Lai/platon/pulsar/dom/DocumentFragment;", "patterns", "Lai/platon/pulsar/dom/data/BlockPattern;", "parse", "", "doc", "Lorg/jsoup/nodes/Document;", "parseBlockRule", "block", "parsePatterns", "", "text", "report", "reset", "setGlobalVar", "value", "toString", "scent-auto-mining"})
public final class BlockStatFeature
extends BlockFeature {
    @NotNull
    private final HashMap<String, String> globalVars;
    @NotNull
    private final HashMap<String, StatFeature> features;
    private final LinkedListMultimap<String, BlockStatRule> blockRules;

    public BlockStatFeature(@NotNull ImmutableConfig conf, @NotNull String[] resources) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        super(conf, resources);
        this.globalVars = new HashMap();
        this.features = new HashMap();
        this.blockRules = LinkedListMultimap.create();
        Iterable $this$forEach$iv = this.getResources();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.loadIgnoreMissing(it);
        }
    }

    @NotNull
    public final HashMap<String, String> getGlobalVars() {
        return this.globalVars;
    }

    @NotNull
    public final HashMap<String, StatFeature> getFeatures() {
        return this.features;
    }

    public final LinkedListMultimap<String, BlockStatRule> getBlockRules() {
        return this.blockRules;
    }

    @Override
    @NotNull
    public Set<String> getLabels() {
        Set set = this.blockRules.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"blockRules.keySet()");
        return set;
    }

    @Override
    public double getScore10(@NotNull DocumentFragment fragment, @NotNull String label, @NotNull Collection<BlockPattern> patterns) {
        double d;
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
        Collection<BlockStatRule> rules = this.getRules(label);
        if (rules.isEmpty()) {
            return 0.0;
        }
        DoubleSummaryStatistics doubleSummaryStatistics = (DoubleSummaryStatistics)fragment.getFragments().getSummaries().get(DefinedFeaturesKt.SEQ);
        double maxSeq = doubleSummaryStatistics == null ? Double.MAX_VALUE : (d = doubleSummaryStatistics.getMax());
        this.setGlobalVar("$_last_seq", String.valueOf(maxSeq));
        double maxScore = ScentRule.Companion.getMIN_SCORE();
        for (BlockStatRule rule : rules) {
            double score2 = rule.getScore(fragment, patterns);
            if (!(score2 > maxScore)) continue;
            maxScore = score2;
        }
        return maxScore;
    }

    public final void setGlobalVar(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Map map = this.globalVars;
        boolean bl = false;
        map.put(name, value);
        for (BlockStatRule rule : this.blockRules.values()) {
            rule.setGlobalVar(name, value);
        }
    }

    @Nullable
    public final String getGlobalVar(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.globalVars.get(name);
    }

    @NotNull
    public final String dumpGlobalVars() {
        String string = this.globalVars.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"globalVars.toString()");
        return string;
    }

    @NotNull
    public final Collection<BlockStatRule> getRules(@NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        List list = this.blockRules.get((Object)label);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"blockRules.get(label)");
        return list;
    }

    @NotNull
    public final String report() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String name : this.blockRules.keySet()) {
            int n = i;
            i = n + 1;
            if (n > 0) {
                sb.append(", ");
            }
            sb.append(name);
            sb.append(": ");
            sb.append(((BlockStatRule)this.blockRules.get((Object)name).iterator().next()).getRules().size());
        }
        return this.getClass().getSimpleName() + " - " + sb;
    }

    public final void reset() {
        this.globalVars.clear();
        this.features.clear();
        this.blockRules.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void parse(@NotNull Document doc) {
        void $this$mapTo$iv$iv;
        Element it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Iterable $this$forEach$iv = (Iterable)QueriesKt.select2$default((Node)((Node)doc), (String)"blocks > features > feature", (int)0, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element it2 = (Element)element$iv;
            boolean bl = false;
            Object object = it2.attr("name");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.attr(\"name\")");
            String name = object;
            object = this.getFeatures();
            Object object2 = it2.text();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"it.text()");
            object2 = new StatFeature(name, (String)object2);
            boolean bl2 = false;
            object.put(name, object2);
        }
        Iterable $this$filter$iv = (Iterable)QueriesKt.select2$default((Node)((Node)doc), (String)"blocks > block", (int)0, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Element)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it.attr("label");
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"it.attr(\"label\")");
            charSequence = charSequence;
            boolean bl3 = false;
            boolean bl4 = charSequence.length() > 0;
            if (!bl4) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            BlockStatRule blockStatRule = this.parseBlockRule(it);
            collection.add(blockStatRule);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BlockStatRule it3 = (BlockStatRule)element$iv;
            boolean bl = false;
            this.getBlockRules().put((Object)it3.getLabel(), (Object)it3);
        }
    }

    private final String getBlockRuleId(Element eleBlock) {
        String string = eleBlock.attr("label");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"eleBlock.attr(\"label\")");
        String label = string;
        return NodeExtKt.getLocation((Node)((Node)eleBlock)) + "/" + label + "#" + eleBlock.attr("id");
    }

    /*
     * WARNING - void declaration
     */
    private final BlockStatRule parseBlockRule(Element block) {
        String string = block.attr("label");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"block.attr(\"label\")");
        String label = string;
        String id = this.getBlockRuleId(block);
        String string2 = block.attr("leaf-only");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"block.attr(\"leaf-only\")");
        String leafOnly = string2;
        String string3 = block.attr("domain");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"block.attr(\"domain\")");
        String domain = string3;
        String string4 = block.attr("patterns");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"block.attr(\"patterns\")");
        String allowedPatterns = string4;
        String string5 = block.attr("negative-patterns");
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"block.attr(\"negative-patterns\")");
        String disallowedPatterns = string5;
        BlockStatRule blockStatRule = new BlockStatRule(id, label, Intrinsics.areEqual((Object)leafOnly, (Object)"true"), domain, this.parsePatterns(allowedPatterns), this.parsePatterns(disallowedPatterns));
        for (Element eleRule : block.getElementsByTag("rule")) {
            int n;
            int n2;
            String[] range;
            void $this$toTypedArray$iv;
            StatFeature feature = this.features.get(eleRule.attr("feature"));
            if (feature == null) {
                this.getLog().error("invalid rule, miss feature {}", (Object)eleRule.attr("feature"));
                continue;
            }
            Object object = eleRule.attr("range");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"eleRule.attr(\"range\")");
            object = (CharSequence)object;
            String string6 = ",";
            int n3 = 0;
            string6 = new Regex(string6);
            n3 = 2;
            boolean bl = false;
            object = string6.split((CharSequence)object, n3);
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            if (thisCollection$iv.toArray(new String[0]) == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            if (range.length != 2) {
                this.getLog().error("invalid rule range {}", (Object)eleRule.attr("range"));
                continue;
            }
            double min = NumberUtils.toDouble((String)range[0], (double)ScentRule.Companion.getMIN_SCORE());
            double max = NumberUtils.toDouble((String)range[1], (double)ScentRule.Companion.getMAX_SCORE());
            double score2 = NumberUtils.toDouble((String)eleRule.attr("score"));
            double negativeScore = NumberUtils.toDouble((String)eleRule.attr("negative-score"));
            StatRule rule = new StatRule(feature, min, max, score2, negativeScore);
            if (!feature.isSimple() && (n2 = 1) <= (n = ScentRule.Companion.getMAX_PLACE_HOLDERS())) {
                int i;
                do {
                    i = n2++;
                    String ref = "_" + i;
                    CharSequence charSequence = eleRule.attr(ref);
                    Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"eleRule.attr(ref)");
                    String v = charSequence;
                    charSequence = v;
                    boolean bl2 = false;
                    if (charSequence.length() == 0) continue;
                    rule.ref("$" + ref, v);
                } while (i != n);
            }
            blockStatRule.getRules().add(rule);
        }
        return blockStatRule;
    }

    /*
     * WARNING - void declaration
     */
    private final List<BlockPattern> parsePatterns(String text2) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        ArrayList patterns = Lists.newArrayList();
        Object object = text2;
        String string = ",";
        int n = 0;
        string = new Regex(string);
        n = 0;
        boolean bl = false;
        object = string.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl2 = false;
                CharSequence charSequence = it;
                boolean bl3 = false;
                if (charSequence.length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        for (String pattern : stringArray) {
            BlockPattern p = new BlockPattern(pattern);
            if (!BlockPattern.Companion.getPatterns().contains(p)) continue;
            patterns.add(p);
        }
        Intrinsics.checkNotNullExpressionValue((Object)patterns, (String)"patterns");
        return patterns;
    }

    @NotNull
    public String toString() {
        String string = this.blockRules.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"blockRules.toString()");
        return string;
    }
}

