/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.feature.words.blackwhite;

import ai.platon.pulsar.common.BlackWhiteResourceConfig;
import ai.platon.pulsar.common.Strings;
import ai.platon.scent.feature.WordFeature;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\u000e"}, d2={"Lai/platon/scent/feature/words/blackwhite/HtmlTitleFeature;", "Lai/platon/scent/feature/WordFeature;", "blackWhiteConfig", "Lai/platon/pulsar/common/BlackWhiteResourceConfig;", "(Lai/platon/pulsar/common/BlackWhiteResourceConfig;)V", "getPotentialTitles", "", "", "title", "strip", "trim", "validate", "", "Companion", "scent-auto-mining"})
public final class HtmlTitleFeature
extends WordFeature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Pattern PAT_REMOVE_CHARACTERS = Pattern.compile("[?\uff1f!\uff01.\u3002\\-:\uff1a]+");
    @NotNull
    private static final Pattern[] PotentialTitlePatterns;
    private static final int MinTitleSize;
    private static final int MaxTitleSize;
    private static final Pattern PAT_REMOVE_COMMENT_POTION;

    public HtmlTitleFeature(@NotNull BlackWhiteResourceConfig blackWhiteConfig) {
        Intrinsics.checkNotNullParameter((Object)blackWhiteConfig, (String)"blackWhiteConfig");
        super(blackWhiteConfig);
    }

    @NotNull
    public final Set<String> getPotentialTitles(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        TreeSet<String> potentialTitles = new TreeSet<String>(Strings.LongerFirstComparator);
        potentialTitles.add(title);
        String candidate = this.strip(title);
        if (!this.validate(candidate)) {
            return potentialTitles;
        }
        potentialTitles.add(candidate);
        int middle = candidate.length() / 2;
        potentialTitles.add(StringUtils.substring((String)candidate, (int)0, (int)middle));
        potentialTitles.add(StringUtils.substring((String)candidate, (int)middle));
        Pattern[] object = PotentialTitlePatterns;
        int n = object.length;
        for (int i = 0; i < n; ++i) {
            Pattern pattern = object[i];
            String p = Strings.getLongestPart((String)candidate, (Pattern)pattern);
            Intrinsics.checkNotNullExpressionValue((Object)p, (String)"p");
            if (!this.validate(p)) continue;
            potentialTitles.add(p);
        }
        String string = PAT_REMOVE_COMMENT_POTION.matcher(title).replaceAll("");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PAT_REMOVE_COMMENT_POTIO\u2026her(title).replaceAll(\"\")");
        String string2 = string;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = string2;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if (!this.validate(candidate = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())) {
            return potentialTitles;
        }
        potentialTitles.add(candidate);
        for (Pattern pattern : PotentialTitlePatterns) {
            String p = Strings.getLongestPart((String)candidate, (Pattern)pattern);
            Intrinsics.checkNotNullExpressionValue((Object)p, (String)"p");
            if (!this.validate(p)) continue;
            potentialTitles.add(p);
        }
        return potentialTitles;
    }

    @Override
    public boolean validate(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        return title.length() > MinTitleSize && title.length() < MaxTitleSize;
    }

    @NotNull
    public final String strip(@NotNull String title) {
        int pos;
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        String title2 = title;
        int lastTitleLength = title2.length();
        boolean removed = false;
        for (String word : this.getBlackWords()) {
            String string = StringUtils.remove((String)title2, (String)word);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"remove(title, word)");
            title2 = string;
            if (title2.length() >= lastTitleLength) continue;
            removed = true;
        }
        if (!removed && (pos = StringsKt.lastIndexOf$default((CharSequence)title2, (char)'-', (int)0, (boolean)false, (int)6, null)) > title2.length() / 2) {
            String string = title2;
            int n = 0;
            boolean bl = false;
            String string2 = string.substring(n, pos);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            title2 = string2;
        }
        if (!this.validate(title2)) {
            title2 = "";
        }
        return this.trim(title2);
    }

    @NotNull
    public final String trim(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        String title2 = title;
        if (!this.validate(title2)) {
            return "";
        }
        String string = Strings.trimNonCJKChar((String)title2, (String)"[]()\u3010\u3011\uff08\uff09");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimNonCJKChar(title, \"[]()\u3010\u3011\uff08\uff09\")");
        title2 = string;
        return title2;
    }

    static {
        Pattern[] patternArray = new Pattern[]{Pattern.compile("[ ]*[\u00bb,\uff0c:\uff1a_\uff08\uff09\u3010\u3011|\\-()][ ]*"), Pattern.compile("[ ]*[\u00bb,\uff0c:\uff1a_\uff08\uff09\u3010\u3011|()][ ]*"), Pattern.compile("[ ]*[\u00bb,\uff0c_\uff08\uff09\u3010\u3011|()][ ]*"), Pattern.compile("[ ]*[\u00bb,\uff0c\uff08\uff09\u3010\u3011|()][ ]*"), Pattern.compile("[ ]*[\u00bb\u3010\u3011][ ]*")};
        PotentialTitlePatterns = patternArray;
        MinTitleSize = 6;
        MaxTitleSize = 200;
        PAT_REMOVE_COMMENT_POTION = Pattern.compile("((\uff08.+?\uff09)|(\u3010.+?\u3011))");
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0019\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u000e\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR!\u0010\u0010\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\u0011\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lai/platon/scent/feature/words/blackwhite/HtmlTitleFeature$Companion;", "", "()V", "MaxTitleSize", "", "getMaxTitleSize", "()I", "MinTitleSize", "getMinTitleSize", "PAT_REMOVE_CHARACTERS", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getPAT_REMOVE_CHARACTERS", "()Ljava/util/regex/Pattern;", "PAT_REMOVE_COMMENT_POTION", "getPAT_REMOVE_COMMENT_POTION", "PotentialTitlePatterns", "", "getPotentialTitlePatterns", "()[Ljava/util/regex/Pattern;", "[Ljava/util/regex/Pattern;", "scent-auto-mining"})
    public static final class Companion {
        private Companion() {
        }

        public final Pattern getPAT_REMOVE_CHARACTERS() {
            return PAT_REMOVE_CHARACTERS;
        }

        @NotNull
        public final Pattern[] getPotentialTitlePatterns() {
            return PotentialTitlePatterns;
        }

        public final int getMinTitleSize() {
            return MinTitleSize;
        }

        public final int getMaxTitleSize() {
            return MaxTitleSize;
        }

        public final Pattern getPAT_REMOVE_COMMENT_POTION() {
            return PAT_REMOVE_COMMENT_POTION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

