/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.gui;

import ai.platon.scent.dom.nodes.DirectedGeometricGraph;
import ai.platon.scent.gui.Corner;
import ai.platon.scent.gui.Rule;
import ai.platon.scent.gui.ScrollableCanvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Line2D;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B%\u0012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lai/platon/scent/gui/GeometricGraphViewer;", "Ljavax/swing/JPanel;", "Ljava/awt/event/ItemListener;", "graphs", "", "Lai/platon/scent/dom/nodes/DirectedGeometricGraph;", "lines", "Ljava/awt/geom/Line2D;", "(Ljava/lang/Iterable;Ljava/lang/Iterable;)V", "canvas", "Lai/platon/scent/gui/ScrollableCanvas;", "columnView", "Lai/platon/scent/gui/Rule;", "isMetric", "Ljavax/swing/JToggleButton;", "rowView", "itemStateChanged", "", "e", "Ljava/awt/event/ItemEvent;", "Companion", "scent-auto-mining"})
public final class GeometricGraphViewer
extends JPanel
implements ItemListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Rule columnView;
    @NotNull
    private final Rule rowView;
    @NotNull
    private final JToggleButton isMetric;
    @NotNull
    private final ScrollableCanvas canvas;

    public GeometricGraphViewer(@NotNull Iterable<DirectedGeometricGraph> graphs, @NotNull Iterable<? extends Line2D> lines) {
        Intrinsics.checkNotNullParameter(graphs, (String)"graphs");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        this.setLayout(new BoxLayout(this, 2));
        this.columnView = new Rule(Rule.Companion.getHORIZONTAL(), true);
        this.rowView = new Rule(Rule.Companion.getVERTICAL(), true);
        JPanel buttonCorner = new JPanel();
        this.isMetric = new JToggleButton("cm", true);
        this.isMetric.setFont(new Font("SansSerif", 0, 11));
        this.isMetric.setMargin(new Insets(2, 2, 2, 2));
        this.isMetric.addItemListener(this);
        buttonCorner.add(this.isMetric);
        this.canvas = new ScrollableCanvas(graphs, lines, this.columnView.getIncrement(), null, 8, null);
        JScrollPane canvasPanel = new JScrollPane(this.canvas);
        canvasPanel.setViewportBorder(BorderFactory.createLineBorder(Color.black));
        this.columnView.setPreferredWidth(this.canvas.getPreferredWidth());
        this.rowView.setPreferredHeight(this.canvas.getPreferredHeight());
        canvasPanel.setColumnHeaderView(this.columnView);
        canvasPanel.setRowHeaderView(this.rowView);
        canvasPanel.setCorner("UPPER_LEFT_CORNER", buttonCorner);
        canvasPanel.setCorner("LOWER_LEFT_CORNER", new Corner());
        canvasPanel.setCorner("UPPER_RIGHT_CORNER", new Corner());
        this.add(canvasPanel);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    public /* synthetic */ GeometricGraphViewer(Iterable iterable, Iterable iterable2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        boolean bl;
        if ((n & 1) != 0) {
            bl = false;
            iterable = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            bl = false;
            iterable2 = CollectionsKt.emptyList();
        }
        this(iterable, iterable2);
    }

    @Override
    public void itemStateChanged(@NotNull ItemEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getStateChange() == 1) {
            this.rowView.setIsMetric(true);
            this.columnView.setIsMetric(true);
        } else {
            this.rowView.setIsMetric(false);
            this.columnView.setIsMetric(false);
        }
        this.canvas.setMaxUnitIncrement(this.rowView.getIncrement());
    }

    public GeometricGraphViewer() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006J\u0014\u0010\n\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0014\u0010\u000b\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u00a8\u0006\f"}, d2={"Lai/platon/scent/gui/GeometricGraphViewer$Companion;", "", "()V", "show", "", "graphs", "", "Lai/platon/scent/dom/nodes/DirectedGeometricGraph;", "lines", "Ljava/awt/geom/Line2D;", "showGraphs", "showLines", "scent-auto-mining"})
    public static final class Companion {
        private Companion() {
        }

        public final void showGraphs(@NotNull Iterable<DirectedGeometricGraph> graphs) {
            Intrinsics.checkNotNullParameter(graphs, (String)"graphs");
            boolean bl = false;
            this.show(graphs, CollectionsKt.emptyList());
        }

        public final void showLines(@NotNull Iterable<? extends Line2D> lines) {
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            boolean bl = false;
            this.show(CollectionsKt.emptyList(), lines);
        }

        /*
         * WARNING - void declaration
         */
        public final void show(@NotNull Iterable<DirectedGeometricGraph> graphs, @NotNull Iterable<? extends Line2D> lines) {
            void it;
            Intrinsics.checkNotNullParameter(graphs, (String)"graphs");
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            JFrame frame = new JFrame("Page Graph Viewer");
            frame.setDefaultCloseOperation(3);
            frame.setExtendedState(6);
            GeometricGraphViewer geometricGraphViewer = new GeometricGraphViewer(graphs, lines);
            boolean bl = false;
            boolean bl2 = false;
            GeometricGraphViewer geometricGraphViewer2 = geometricGraphViewer;
            JFrame jFrame = frame;
            boolean bl3 = false;
            it.setOpaque(true);
            Unit unit = Unit.INSTANCE;
            jFrame.setContentPane(geometricGraphViewer);
            frame.pack();
            frame.setVisible(true);
        }

        public static /* synthetic */ void show$default(Companion companion, Iterable iterable, Iterable iterable2, int n, Object object) {
            boolean bl;
            if ((n & 1) != 0) {
                bl = false;
                iterable = CollectionsKt.emptyList();
            }
            if ((n & 2) != 0) {
                bl = false;
                iterable2 = CollectionsKt.emptyList();
            }
            companion.show(iterable, iterable2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

