/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml;

import ai.platon.pulsar.common.math.vectors.VectorsKt;
import ai.platon.pulsar.dom.features.FeatureRegistry;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.scent.ml.BucketBundle;
import ai.platon.scent.ml.FeatureTransformer;
import ai.platon.scent.ml.HyperParametersKt;
import ai.platon.scent.ml.NodePoint;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.RealVector;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Node;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u0003H\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\r"}, d2={"Lai/platon/scent/ml/Bucketizer;", "Lai/platon/scent/ml/FeatureTransformer;", "verbose", "", "(Z)V", "ensureBucket", "", "x", "Lai/platon/scent/ml/NodePoint;", "j", "", "debug", "transform", "scent-auto-mining"})
public final class Bucketizer
extends FeatureTransformer {
    public Bucketizer(boolean verbose) {
        super(null, verbose, 1, null);
    }

    public /* synthetic */ Bucketizer(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @Override
    @NotNull
    public NodePoint transform(@NotNull NodePoint x) {
        Intrinsics.checkNotNullParameter((Object)((Object)x), (String)"x");
        int n = 0;
        int n2 = this.getSchema().getDimension();
        if (n < n2) {
            do {
                int j = n++;
                BucketBundle bucket = HyperParametersKt.getFeatureBuckets()[j];
                VectorsKt.set((RealVector)((RealVector)x), (int)j, (double)bucket.map(VectorsKt.get((RealVector)((RealVector)x), (int)j)));
                this.ensureBucket(x, j, true);
            } while (n < n2);
        }
        return x;
    }

    private final void ensureBucket(NodePoint x, int j, boolean debug) throws MathArithmeticException {
        BucketBundle bucket = HyperParametersKt.getFeatureBuckets()[j];
        if (!bucket.isIdentity()) {
            double y = bucket.map(VectorsKt.get((RealVector)((RealVector)x), (int)j));
            if (debug) {
                boolean bl = y >= 0.0;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    double d = VectorsKt.get((RealVector)((RealVector)x), (int)j);
                    String string = NodeExtKt.getName((Node)x.getNode());
                    Object e = FeatureRegistry.INSTANCE.getFeatureNames().get(j);
                    RealVector realVector = x.getNode().getExtension().getFeatures();
                    Intrinsics.checkNotNullExpressionValue((Object)realVector, (String)"x.node.extension.features");
                    String string2 = "positive bucket index is expected, actual: " + y + ", value: " + d + " " + string + "  feature: " + e + " " + VectorsKt.get((RealVector)realVector, (int)j) + "\n" + HyperParametersKt.getFeatureBuckets()[j];
                    throw (Throwable)new IllegalArgumentException(string2.toString());
                }
            }
            if (y < 0.0) {
                Object[] objectArray = new Object[]{(int)VectorsKt.get((RealVector)((RealVector)x), (int)j)};
                throw new MathArithmeticException((Localizable)LocalizedFormats.INDEX_NOT_POSITIVE, objectArray);
            }
        }
    }

    static /* synthetic */ void ensureBucket$default(Bucketizer bucketizer, NodePoint nodePoint, int n, boolean bl, int n2, Object object) throws MathArithmeticException {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        bucketizer.ensureBucket(nodePoint, n, bl);
    }

    public Bucketizer() {
        this(false, 1, null);
    }
}

