/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml;

import ai.platon.scent.ml.NodePoint;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.util.FastMath;
import org.jetbrains.annotations.NotNull;
import smile.math.Math;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\u001a\u0019\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004\u001a\u0014\u0010\u0005\u001a\u00020\u00062\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00060\u0007\u001a\u0014\u0010\b\u001a\u00020\u00062\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\t0\u0007\u001a8\u0010\n\u001a\u00020\u000b2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00110\u0010H\u0000\u001a\u0016\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0001\u00a8\u0006\u0015"}, d2={"colMeans", "", "points", "", "([[D)[D", "colMeans2", "Lorg/apache/commons/math3/linear/ArrayRealVector;", "", "colSds", "Lai/platon/scent/ml/NodePoint;", "fillSymmetricalMatrix", "", "Lorg/apache/commons/math3/linear/RealVector;", "matrix", "Lorg/apache/commons/math3/linear/RealMatrix;", "computer", "Lkotlin/Function2;", "", "squaredDistance", "x", "y", "scent-auto-mining"})
public final class MathsKt {
    public static final void fillSymmetricalMatrix(@NotNull List<? extends RealVector> points, @NotNull RealMatrix matrix, @NotNull Function2<? super RealVector, ? super RealVector, Double> computer) {
        int j;
        int n;
        int i;
        Intrinsics.checkNotNullParameter(points, (String)"points");
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        Intrinsics.checkNotNullParameter(computer, (String)"computer");
        int size = points.size();
        int n2 = 0;
        if (n2 < size) {
            do {
                i = n2++;
                n = 0;
                if (n >= size) continue;
                do {
                    if ((j = n++) < i) continue;
                    matrix.setEntry(i, j, ((Number)computer.invoke((Object)points.get(i), (Object)points.get(j))).doubleValue());
                } while (n < size);
            } while (n2 < size);
        }
        if ((n2 = 0) < size) {
            do {
                i = n2++;
                n = 0;
                if (n >= size) continue;
                do {
                    if ((j = n++) >= i) continue;
                    double value = matrix.getEntry(j, i);
                    matrix.setEntry(i, j, value);
                } while (n < size);
            } while (n2 < size);
        }
    }

    public static final double squaredDistance(@NotNull double[] x, @NotNull double[] y) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        if (x.length != y.length) {
            throw new IllegalArgumentException("Input vector sizes are different.");
        }
        double sum = 0.0;
        int n = 0;
        int n2 = x.length + -1;
        if (n <= n2) {
            do {
                int i = n++;
                double z = x[i] - y[i];
                sum += z * z;
            } while (n <= n2);
        }
        return sum;
    }

    @NotNull
    public static final double[] colMeans(@NotNull double[][] points) {
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        double[] x = (double[])points[0].clone();
        int n = 1;
        int n2 = ((Object[])points).length;
        if (n < n2) {
            do {
                int i = n++;
                int n3 = 0;
                int n4 = x.length + -1;
                if (n3 > n4) continue;
                do {
                    int j = n3++;
                    double[] dArray = x;
                    int n5 = j;
                    dArray[n5] = dArray[n5] + points[i][j];
                } while (n3 <= n4);
            } while (n < n2);
        }
        Math.scale((double)(1.0 / (double)((Object[])points).length), (double[])x);
        return x;
    }

    @NotNull
    public static final ArrayRealVector colMeans2(@NotNull List<? extends ArrayRealVector> points) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        double[] x = (double[])points.get(0).getDataRef().clone();
        int n = 1;
        int n2 = points.size();
        if (n < n2) {
            do {
                int i = n++;
                int n3 = 0;
                int n4 = x.length + -1;
                if (n3 > n4) continue;
                do {
                    int j = n3++;
                    double[] dArray = x;
                    int n5 = j;
                    dArray[n5] = dArray[n5] + points.get(i).getDataRef()[j];
                } while (n3 <= n4);
            } while (n < n2);
        }
        Math.scale((double)(1.0 / (double)points.size()), (double[])x);
        return new ArrayRealVector(x, false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ArrayRealVector colSds(@NotNull List<? extends NodePoint> points) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        if (points.size() < 2) {
            throw new IllegalArgumentException("Array length is less than 2.");
        }
        int dimension = points.get(0).getDimension();
        double[] sum = new double[dimension];
        double[] sumsq = new double[dimension];
        for (NodePoint nodePoint : points) {
            double[] x = nodePoint.getDataRef();
            int n = 0;
            if (n >= dimension) continue;
            do {
                int i = n++;
                double[] dArray = sum;
                int n2 = i;
                dArray[n2] = dArray[n2] + x[i];
                dArray = sumsq;
                n2 = i;
                dArray[n2] = dArray[n2] + x[i] * x[i];
            } while (n < dimension);
        }
        int n = points.size() - 1;
        int n3 = 0;
        if (n3 < dimension) {
            void var5_8;
            do {
                void i = var5_8++;
                sumsq[i] = FastMath.sqrt((double)(sumsq[i] / (double)n - sum[i] / (double)points.size() * (sum[i] / (double)n)));
            } while (var5_8 < dimension);
        }
        return new ArrayRealVector(sumsq, false);
    }
}

