/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml.unsupervised;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0019\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0000J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J'\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001J\b\u0010$\u001a\u00020%H\u0016R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR\u0011\u0010\u0011\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\f\"\u0004\b\u0016\u0010\u000eR\u001a\u0010\u0017\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\n\"\u0004\b\u0019\u0010\u001a\u00a8\u0006&"}, d2={"Lai/platon/scent/ml/unsupervised/IRMetric;", "", "relevant", "", "hit", "retrieved", "(III)V", "f1", "", "getF1", "()D", "getHit", "()I", "setHit", "(I)V", "precision", "getPrecision", "recall", "getRecall", "getRelevant", "setRelevant", "getRetrieved", "setRetrieved", "smooth", "getSmooth", "setSmooth", "(D)V", "accumulate", "other", "component1", "component2", "component3", "copy", "equals", "", "hashCode", "toString", "", "scent-auto-mining"})
public final class IRMetric {
    private int relevant;
    private int hit;
    private int retrieved;
    private double smooth;

    public IRMetric(int relevant, int hit, int retrieved) {
        this.relevant = relevant;
        this.hit = hit;
        this.retrieved = retrieved;
        this.smooth = 0.01;
    }

    public /* synthetic */ IRMetric(int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            n = 0;
        }
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        this(n, n2, n3);
    }

    public final int getRelevant() {
        return this.relevant;
    }

    public final void setRelevant(int n) {
        this.relevant = n;
    }

    public final int getHit() {
        return this.hit;
    }

    public final void setHit(int n) {
        this.hit = n;
    }

    public final int getRetrieved() {
        return this.retrieved;
    }

    public final void setRetrieved(int n) {
        this.retrieved = n;
    }

    public final double getSmooth() {
        return this.smooth;
    }

    public final void setSmooth(double d) {
        this.smooth = d;
    }

    public final double getPrecision() {
        return (double)this.hit / (this.smooth + (double)this.retrieved);
    }

    public final double getRecall() {
        return (double)this.hit / (this.smooth + (double)this.relevant);
    }

    public final double getF1() {
        return (double)2 * this.getPrecision() * this.getRecall() / (this.smooth + this.getPrecision() + this.getRecall());
    }

    @NotNull
    public final IRMetric accumulate(@NotNull IRMetric other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        IRMetric iRMetric = this;
        iRMetric.hit += other.hit;
        iRMetric = this;
        iRMetric.relevant += other.relevant;
        iRMetric = this;
        iRMetric.retrieved += other.retrieved;
        return this;
    }

    @NotNull
    public String toString() {
        return "hit: " + this.hit + "\tretrieved: " + this.retrieved + "\trelevant: " + this.relevant + "\nrecall: " + this.getRecall() + "\tprecision: " + this.getPrecision() + "\tf1:" + this.getF1();
    }

    public final int component1() {
        return this.relevant;
    }

    public final int component2() {
        return this.hit;
    }

    public final int component3() {
        return this.retrieved;
    }

    @NotNull
    public final IRMetric copy(int relevant, int hit, int retrieved) {
        return new IRMetric(relevant, hit, retrieved);
    }

    public static /* synthetic */ IRMetric copy$default(IRMetric iRMetric, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = iRMetric.relevant;
        }
        if ((n4 & 2) != 0) {
            n2 = iRMetric.hit;
        }
        if ((n4 & 4) != 0) {
            n3 = iRMetric.retrieved;
        }
        return iRMetric.copy(n, n2, n3);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.relevant);
        result = result * 31 + Integer.hashCode(this.hit);
        result = result * 31 + Integer.hashCode(this.retrieved);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IRMetric)) {
            return false;
        }
        IRMetric iRMetric = (IRMetric)other;
        if (this.relevant != iRMetric.relevant) {
            return false;
        }
        if (this.hit != iRMetric.hit) {
            return false;
        }
        return this.retrieved == iRMetric.retrieved;
    }

    public IRMetric() {
        this(0, 0, 0, 7, null);
    }
}

