/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml.unsupervised;

import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.unsupervised.CentroidCluster;
import ai.platon.scent.ml.unsupervised.Cluster;
import ai.platon.scent.ml.unsupervised.HasCentroid;
import ai.platon.scent.ml.unsupervised.Measurable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.distance.EuclideanDistance;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B5\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00180\u0004J\u0014\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00180\u0004H\u0002J8\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00180\u001b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00052\u0012\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00180\u0004H\u0016J\u001c\u0010\u001f\u001a\u00020\b2\u0012\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00180\u0004H\u0002J(\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00180\u00042\u0012\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00180\u0004H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000f\u00a8\u0006!"}, d2={"Lai/platon/scent/ml/unsupervised/KMeans;", "Lai/platon/scent/ml/unsupervised/Measurable;", "Lai/platon/scent/ml/unsupervised/HasCentroid;", "points", "", "Lai/platon/scent/ml/NodePoint;", "initCenters", "maxIterations", "", "measure", "Lorg/apache/commons/math3/ml/distance/DistanceMeasure;", "(Ljava/util/List;Ljava/util/List;ILorg/apache/commons/math3/ml/distance/DistanceMeasure;)V", "assignmentMap", "", "getInitCenters", "()Ljava/util/List;", "k", "getK", "()I", "getMaxIterations", "getMeasure", "()Lorg/apache/commons/math3/ml/distance/DistanceMeasure;", "getPoints", "cluster", "Lai/platon/scent/ml/unsupervised/CentroidCluster;", "createInitClusters", "findClosestCluster", "Lkotlin/collections/IndexedValue;", "i", "point", "clusters", "updateAssignments", "updateCentroids", "scent-auto-mining"})
public final class KMeans
implements Measurable,
HasCentroid {
    @NotNull
    private final List<NodePoint> points;
    @NotNull
    private final List<NodePoint> initCenters;
    private final int maxIterations;
    @NotNull
    private final DistanceMeasure measure;
    private final int k;
    @NotNull
    private final int[] assignmentMap;

    public KMeans(@NotNull List<? extends NodePoint> points, @NotNull List<? extends NodePoint> initCenters, int maxIterations, @NotNull DistanceMeasure measure) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        Intrinsics.checkNotNullParameter(initCenters, (String)"initCenters");
        Intrinsics.checkNotNullParameter((Object)measure, (String)"measure");
        this.points = points;
        this.initCenters = initCenters;
        this.maxIterations = maxIterations;
        this.measure = measure;
        this.k = this.initCenters.size();
        int n = 0;
        int n2 = this.points.size();
        int[] nArray = new int[n2];
        KMeans kMeans = this;
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = -1;
        }
        kMeans.assignmentMap = nArray;
    }

    public /* synthetic */ KMeans(List list, List list2, int n, DistanceMeasure distanceMeasure, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 100;
        }
        if ((n2 & 8) != 0) {
            distanceMeasure = (DistanceMeasure)new EuclideanDistance();
        }
        this(list, list2, n, distanceMeasure);
    }

    @NotNull
    public final List<NodePoint> getPoints() {
        return this.points;
    }

    @NotNull
    public final List<NodePoint> getInitCenters() {
        return this.initCenters;
    }

    public final int getMaxIterations() {
        return this.maxIterations;
    }

    @Override
    @NotNull
    public DistanceMeasure getMeasure() {
        return this.measure;
    }

    public final int getK() {
        return this.k;
    }

    @NotNull
    public final List<CentroidCluster<NodePoint>> cluster() {
        if (this.points.isEmpty() || this.initCenters.isEmpty()) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        List<CentroidCluster<NodePoint>> clusters = this.createInitClusters();
        this.updateAssignments(clusters);
        Pair pair = TuplesKt.to((Object)0, (Object)Integer.MAX_VALUE);
        int i = ((Number)pair.component1()).intValue();
        int changes = ((Number)pair.component2()).intValue();
        while (true) {
            int n = i;
            i = n + 1;
            if (n >= this.maxIterations || changes <= 0) break;
            clusters = this.updateCentroids(clusters);
            changes = this.updateAssignments(clusters);
        }
        return clusters;
    }

    /*
     * WARNING - void declaration
     */
    private final List<CentroidCluster<NodePoint>> createInitClusters() {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = this.initCenters;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i;
            void p;
            int n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            NodePoint nodePoint = (NodePoint)((Object)item$iv$iv);
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            CentroidCluster centroidCluster = new CentroidCluster((RealVector)p, (int)i);
            collection.add(centroidCluster);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<CentroidCluster<NodePoint>> updateCentroids(List<? extends CentroidCluster<NodePoint>> clusters) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = clusters;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i;
            void c;
            int n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            CentroidCluster centroidCluster = (CentroidCluster)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            CentroidCluster centroidCluster2 = new CentroidCluster(this.centroidOf(c.getPoints(), c.getCentroid().getDimension()), (int)i);
            collection.add(centroidCluster2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final int updateAssignments(List<? extends CentroidCluster<NodePoint>> clusters) {
        Collection collection = clusters;
        boolean bl = false;
        boolean bl2 = !collection.isEmpty();
        bl = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl2) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int changes = 0;
        Iterable $this$forEachIndexed$iv = this.points;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void p;
            int n = index$iv++;
            boolean bl6 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            NodePoint nodePoint = (NodePoint)((Object)item$iv);
            int i = n;
            boolean bl7 = false;
            IndexedValue<CentroidCluster<NodePoint>> indexedValue = this.findClosestCluster(i, (NodePoint)p, clusters);
            int j = indexedValue.component1();
            CentroidCluster cluster2 = (CentroidCluster)indexedValue.component2();
            int n2 = Intrinsics.areEqual((Object)cluster2, clusters.get(j));
            boolean bl8 = false;
            boolean bl9 = false;
            bl9 = false;
            boolean bl10 = false;
            if (n2 == 0) {
                boolean bl11 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            cluster2.getPoints().add(p);
            if (j == this.assignmentMap[i]) continue;
            this.assignmentMap[i] = j;
            n2 = changes;
            changes = n2 + 1;
        }
        return changes;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IndexedValue<CentroidCluster<NodePoint>> findClosestCluster(int i, @NotNull NodePoint point, @NotNull List<? extends CentroidCluster<NodePoint>> clusters) {
        Intrinsics.checkNotNullParameter((Object)((Object)point), (String)"point");
        Intrinsics.checkNotNullParameter(clusters, (String)"clusters");
        Triple triple = new Triple((Object)-1, new CentroidCluster((RealVector)new ArrayRealVector(), 0, 2, null), (Object)Double.MAX_VALUE);
        int index = 0;
        index = ((Number)triple.component1()).intValue();
        Object closestCluster = null;
        closestCluster = triple.component2();
        double minDistance = 0.0;
        minDistance = ((Number)triple.component3()).doubleValue();
        Iterable $this$forEachIndexed$iv = clusters;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void cluster2;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            CentroidCluster centroidCluster = (CentroidCluster)item$iv;
            int j = n;
            boolean bl2 = false;
            boolean bl3 = j == cluster2.getLabel();
            boolean bl4 = false;
            boolean bl5 = false;
            if (!bl3) {
                boolean bl6 = false;
                String string = "Invalid index " + j + ", should be " + cluster2.getLabel();
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            double d = this.distance((RealVector)point, cluster2.getCentroid());
            if (!(d < minDistance)) continue;
            index = j;
            closestCluster = cluster2;
            minDistance = d;
        }
        return new IndexedValue(index, closestCluster);
    }

    @Override
    @NotNull
    public <T extends RealVector> RealVector centroidOf(@NotNull Cluster<T> cluster2) {
        return HasCentroid.DefaultImpls.centroidOf(this, cluster2);
    }

    @Override
    @NotNull
    public <T extends RealVector> RealVector centroidOf(@NotNull Collection<? extends T> points, int dimension) {
        return HasCentroid.DefaultImpls.centroidOf(this, points, dimension);
    }

    @Override
    public double distance(@NotNull ArrayRealVector p1, @NotNull ArrayRealVector p2) {
        return Measurable.DefaultImpls.distance((Measurable)this, p1, p2);
    }

    @Override
    public double distance(@NotNull RealVector p1, @NotNull RealVector p2) {
        return Measurable.DefaultImpls.distance((Measurable)this, p1, p2);
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> findClosestCluster(@NotNull List<? extends RealVector> cluster2, @NotNull List<? extends RealVector> cluster22) {
        return Measurable.DefaultImpls.findClosestCluster(this, cluster2, cluster22);
    }

    @Override
    @NotNull
    public IndexedValue<RealVector> findClosestPoint(@NotNull RealVector point, @NotNull List<? extends RealVector> points) {
        return Measurable.DefaultImpls.findClosestPoint(this, point, points);
    }

    @Override
    @NotNull
    public IndexedValue<RealVector> findFarthestPoint(@NotNull RealVector point, @NotNull List<? extends RealVector> points) {
        return Measurable.DefaultImpls.findFarthestPoint(this, point, points);
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> findFarthestPoints(@NotNull List<? extends RealVector> cluster2, @NotNull List<? extends RealVector> cluster22) {
        return Measurable.DefaultImpls.findFarthestPoints(this, cluster2, cluster22);
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> findFarthestPoints(@NotNull List<? extends RealVector> points) {
        return Measurable.DefaultImpls.findFarthestPoints(this, points);
    }
}

