/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml.unsupervised;

import ai.platon.scent.ml.MathsKt;
import ai.platon.scent.ml.NodePoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.jetbrains.annotations.NotNull;
import smile.math.Math;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.EVD;
import smile.math.matrix.Matrix;
import smile.math.matrix.SVD;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B5\u0012\u001a\u0010\u0002\u001a\u0016\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003j\n\u0012\u0006\b\u0001\u0012\u00020\u0004`\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J\u001f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u001d\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\fJ$\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020 0\u0003j\b\u0012\u0004\u0012\u00020 `\u00052\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\"J\u0010\u0010#\u001a\u00020\u00002\b\b\u0002\u0010$\u001a\u00020\tJ\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0012R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006%"}, d2={"Lai/platon/scent/ml/unsupervised/PCA;", "", "data", "Ljava/util/ArrayList;", "Lorg/apache/commons/math3/linear/ArrayRealVector;", "Lkotlin/collections/ArrayList;", "cor", "", "projectionRate", "", "(Ljava/util/ArrayList;ZD)V", "cumulativeProportion", "", "eigvalues", "eigvectors", "Lsmile/math/matrix/DenseMatrix;", "mu", "n", "", "p", "pmu", "projection", "proportion", "variance", "getVariance", "()[D", "calculateProjectionInternal", "topP", "project", "", "x", "([[D)[[D", "Lai/platon/scent/ml/NodePoint;", "xs", "", "withProjection", "percentage", "scent-auto-mining"})
public final class PCA {
    private final int n;
    @NotNull
    private final double[] mu;
    @NotNull
    private DenseMatrix eigvectors;
    @NotNull
    private double[] eigvalues;
    @NotNull
    private final double[] proportion;
    @NotNull
    private final double[] cumulativeProportion;
    private int p;
    private DenseMatrix projection;
    private double[] pmu;

    /*
     * WARNING - void declaration
     */
    public PCA(@NotNull ArrayList<? extends ArrayRealVector> data, boolean cor, double projectionRate) {
        int i;
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.n = data.get(0).getDimension();
        double[] dArray = MathsKt.colMeans2((List<? extends ArrayRealVector>)data).getDataRef();
        Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"colMeans2(data).dataRef");
        this.mu = dArray;
        int m = data.size();
        Iterable $this$map$iv = data;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        int $i$f$mapTo = 0;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ArrayRealVector arrayRealVector = (ArrayRealVector)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            double[] dArray2 = it.getDataRef();
            collection.add(dArray2);
        }
        $this$map$iv = (List)destination$iv$iv;
        int $i$f$toTypedArray = 0;
        void thisCollection$iv42222 = $this$toTypedArray$iv;
        T[] TArray = thisCollection$iv42222.toArray((T[])new double[0][]);
        if (TArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        double[][] array2D = (double[][])TArray;
        DenseMatrix x = Matrix.newInstance((double[][])array2D);
        $i$f$toTypedArray = 0;
        int thisCollection$iv42222 = this.n;
        if ($i$f$toTypedArray < thisCollection$iv42222) {
            do {
                int j = $i$f$toTypedArray++;
                $i$f$mapTo = 0;
                if ($i$f$mapTo >= m) continue;
                do {
                    int i2 = $i$f$mapTo++;
                    x.sub(i2, j, this.mu[j]);
                } while ($i$f$mapTo < m);
            } while ($i$f$toTypedArray < thisCollection$iv42222);
        }
        if (m > this.n && !cor) {
            SVD svd = x.svd();
            double[] thisCollection$iv42222 = svd.getSingularValues();
            Intrinsics.checkNotNullExpressionValue((Object)thisCollection$iv42222, (String)"svd.singularValues");
            this.eigvalues = thisCollection$iv42222;
            int thisCollection$iv42222 = 0;
            int j = this.eigvalues.length + -1;
            if (thisCollection$iv42222 <= j) {
                do {
                    i = thisCollection$iv42222++;
                    double[] i2 = this.eigvalues;
                    int item$iv$iv = i;
                    i2[item$iv$iv] = i2[item$iv$iv] * this.eigvalues[i];
                } while (thisCollection$iv42222 <= j);
            }
            DenseMatrix thisCollection$iv42222 = svd.getV();
            Intrinsics.checkNotNullExpressionValue((Object)thisCollection$iv42222, (String)"svd.v");
            this.eigvectors = thisCollection$iv42222;
        } else {
            int n;
            int n2;
            int k2;
            DenseMatrix cov = Matrix.zeros((int)this.n, (int)this.n);
            thisCollection$iv42222 = 0;
            if (thisCollection$iv42222 < m) {
                do {
                    int k2 = thisCollection$iv42222++;
                    i = 0;
                    int i2 = this.n;
                    if (i >= i2) continue;
                    do {
                        int j;
                        int i3;
                        int it;
                        if ((it = 0) > (i3 = i++)) continue;
                        do {
                            j = it++;
                            cov.add(i3, j, x.get(k2, i3) * x.get(k2, j));
                        } while (j != i3);
                    } while (i < i2);
                } while (thisCollection$iv42222 < m);
            }
            if ((thisCollection$iv42222 = 0) < (k2 = this.n)) {
                do {
                    int j;
                    int i2;
                    if ((i2 = 0) > (i = thisCollection$iv42222++)) continue;
                    do {
                        j = i2++;
                        cov.div(i, j, (double)m);
                        cov.set(j, i, cov.get(i, j));
                    } while (j != i);
                } while (thisCollection$iv42222 < k2);
            }
            double[] sd = null;
            if (cor) {
                sd = new double[this.n];
                k2 = 0;
                i = this.n;
                if (k2 < i) {
                    do {
                        int i4 = k2++;
                        sd[i4] = Math.sqrt((double)cov.get(i4, i4));
                    } while (k2 < i);
                }
                if ((k2 = 0) < (i = this.n)) {
                    do {
                        int j;
                        int i5;
                        int n3;
                        if ((n3 = 0) > (i5 = k2++)) continue;
                        do {
                            j = n3++;
                            cov.div(i5, j, sd[i5] * sd[j]);
                            cov.set(j, i5, cov.get(i5, j));
                        } while (j != i5);
                    } while (k2 < i);
                }
            }
            cov.setSymmetric(true);
            EVD eigen = cov.eigen();
            DenseMatrix loadings = eigen.getEigenVectors();
            if (cor && sd != null && (n2 = 0) < (n = this.n)) {
                do {
                    int i6 = n2++;
                    int n4 = 0;
                    int n5 = this.n;
                    if (n4 >= n5) continue;
                    do {
                        int j = n4++;
                        loadings.div(i6, j, sd[i6]);
                    } while (n4 < n5);
                } while (n2 < n);
            }
            Object object = eigen.getEigenValues();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"eigen.eigenValues");
            this.eigvalues = (double[])object;
            Intrinsics.checkNotNullExpressionValue((Object)loadings, (String)"loadings");
            this.eigvectors = loadings;
        }
        this.proportion = (double[])this.eigvalues.clone();
        Math.unitize1((double[])this.proportion);
        this.cumulativeProportion = new double[this.eigvalues.length];
        this.cumulativeProportion[0] = this.proportion[0];
        int n = 1;
        int n6 = this.eigvalues.length;
        if (n < n6) {
            do {
                int i7 = n++;
                this.cumulativeProportion[i7] = this.cumulativeProportion[i7 - 1] + this.proportion[i7];
            } while (n < n6);
        }
        if (projectionRate < 1.0) {
            this.withProjection(projectionRate);
        } else {
            this.withProjection((int)projectionRate);
        }
    }

    public /* synthetic */ PCA(ArrayList arrayList, boolean bl, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            d = 0.95;
        }
        this(arrayList, bl, d);
    }

    @NotNull
    public final double[] getVariance() {
        return this.eigvalues;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PCA withProjection(double percentage) {
        DenseMatrix denseMatrix;
        int n;
        double[] dArray;
        block5: {
            void $this$indexOfFirst$iv;
            if (percentage <= 0.0 || percentage > 1.0) {
                throw new IllegalArgumentException("Invalid percentage of variance: " + percentage);
            }
            dArray = this.cumulativeProportion;
            PCA pCA = this;
            boolean $i$f$indexOfFirst = false;
            int n2 = 0;
            int n3 = ((void)$this$indexOfFirst$iv).length;
            while (n2 < n3) {
                void index$iv;
                void it = $this$indexOfFirst$iv[index$iv];
                boolean bl = false;
                if (it >= percentage) {
                    n = index$iv;
                    break block5;
                }
                ++index$iv;
            }
            n = -1;
        }
        int n4 = n;
        pCA.p = n4 + 1;
        DenseMatrix denseMatrix2 = this.projection = this.calculateProjectionInternal(this.p);
        if (denseMatrix2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projection");
            denseMatrix = null;
        } else {
            denseMatrix = denseMatrix2;
        }
        dArray = denseMatrix.ax(this.mu, new double[this.p]);
        Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"projection.ax(mu, DoubleArray(p))");
        this.pmu = dArray;
        return this;
    }

    public static /* synthetic */ PCA withProjection$default(PCA pCA, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.9;
        }
        return pCA.withProjection(d);
    }

    @NotNull
    public final PCA withProjection(int topP) {
        DenseMatrix denseMatrix;
        if (topP < 1 || topP > this.n) {
            throw new IllegalArgumentException("Invalid dimension of feature space: " + topP);
        }
        this.p = topP;
        this.projection = this.calculateProjectionInternal(this.p);
        DenseMatrix denseMatrix2 = this.projection;
        if (denseMatrix2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projection");
            denseMatrix = null;
        } else {
            denseMatrix = denseMatrix2;
        }
        double[] dArray = denseMatrix.ax(this.mu, new double[this.p]);
        Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"projection.ax(mu, DoubleArray(p))");
        this.pmu = dArray;
        return this;
    }

    @NotNull
    public final double[] project(@NotNull double[] x) {
        Object object;
        DenseMatrix denseMatrix;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        if (x.length != this.n) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Invalid input vector size: %d, expected: %d";
            Object[] objectArray = new Object[]{x.length, this.n};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            throw new IllegalArgumentException(string2);
        }
        double[] y = new double[this.p];
        Object object2 = this.projection;
        if (object2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projection");
            denseMatrix = null;
        } else {
            denseMatrix = object2;
        }
        denseMatrix.ax(x, y);
        object2 = this.pmu;
        if (object2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pmu");
            object = null;
        } else {
            object = object2;
        }
        Math.minus((double[])y, (double[])object);
        return y;
    }

    @NotNull
    public final double[][] project(@NotNull double[][] x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        if (x[0].length != this.mu.length) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Invalid input vector size: %d, expected: %d";
            Object[] objectArray = new Object[]{x[0].length, this.n};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            throw new IllegalArgumentException(string2);
        }
        int n = 0;
        int n2 = ((Object[])x).length;
        double[][] dArrayArray = new double[n2][];
        while (n < n2) {
            int n3 = n++;
            dArrayArray[n3] = new double[this.p];
        }
        double[][] y = dArrayArray;
        n = 0;
        n2 = ((Object[])x).length + -1;
        if (n <= n2) {
            do {
                Object object;
                DenseMatrix denseMatrix;
                int i = n++;
                Object object2 = this.projection;
                if (object2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"projection");
                    denseMatrix = null;
                } else {
                    denseMatrix = object2;
                }
                denseMatrix.ax(x[i], y[i]);
                double[] dArray = y[i];
                object2 = this.pmu;
                if (object2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"pmu");
                    object = null;
                } else {
                    object = object2;
                }
                Math.minus((double[])dArray, (double[])object);
            } while (n <= n2);
        }
        return y;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ArrayList<NodePoint> project(@NotNull List<? extends NodePoint> xs) {
        void $this$mapIndexedTo$iv;
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        if (xs.get(0).getDimension() != this.mu.length) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Invalid input vector size: %d, expected: %d";
            Object[] objectArray = new Object[]{xs.get(0).getDimension(), this.n};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            String message2 = string2;
            throw new IllegalArgumentException(message2);
        }
        int n = 0;
        int n2 = xs.size();
        double[][] dArrayArray = new double[n2][];
        while (n < n2) {
            int n3 = n++;
            dArrayArray[n3] = new double[this.p];
        }
        double[][] ys = dArrayArray;
        n = 0;
        n2 = xs.size() + -1;
        if (n <= n2) {
            do {
                Object object;
                DenseMatrix denseMatrix;
                int i = n++;
                Object object2 = this.projection;
                if (object2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"projection");
                    denseMatrix = null;
                } else {
                    denseMatrix = object2;
                }
                denseMatrix.ax(xs.get(i).getDataRef(), ys[i]);
                double[] dArray = ys[i];
                object2 = this.pmu;
                if (object2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"pmu");
                    object = null;
                } else {
                    object = object2;
                }
                Math.minus((double[])dArray, (double[])object);
            } while (n <= n2);
        }
        Object[] objectArray = (Object[])ys;
        Collection destination$iv = new ArrayList(xs.size());
        boolean $i$f$mapIndexedTo = false;
        int index$iv = 0;
        for (void item$iv : $this$mapIndexedTo$iv) {
            void data;
            void i;
            int n4 = index$iv++;
            double[] dArray = (double[])item$iv;
            int n5 = n4;
            Collection collection = destination$iv;
            boolean bl = false;
            NodePoint nodePoint = new NodePoint(xs.get((int)i).getNode(), (double[])data, false, 4, null);
            collection.add(nodePoint);
        }
        return (ArrayList)destination$iv;
    }

    private final DenseMatrix calculateProjectionInternal(int topP) {
        int p = topP;
        DenseMatrix projection = Matrix.zeros((int)p, (int)this.n);
        int n = 0;
        int n2 = this.n;
        if (n < n2) {
            do {
                int i = n++;
                int n3 = 0;
                if (n3 >= p) continue;
                do {
                    int j = n3++;
                    projection.set(j, i, this.eigvectors.get(i, j));
                } while (n3 < p);
            } while (n < n2);
        }
        Intrinsics.checkNotNullExpressionValue((Object)projection, (String)"projection");
        return projection;
    }
}

