/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.boot.autoconfigure.component;

import ai.platon.common.distributed.lock.Interval;
import ai.platon.common.distributed.lock.mongo.alias.MongoLocked;
import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.NotSupportedException;
import ai.platon.pulsar.common.collect.DelayExternalUrlLoader;
import ai.platon.pulsar.common.collect.UrlTopic;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.metrics.AppMetricRegistry;
import ai.platon.pulsar.common.metrics.AppMetrics;
import ai.platon.pulsar.common.metrics.MultiMetric;
import ai.platon.pulsar.common.urls.ComparableUrlAware;
import ai.platon.pulsar.common.urls.Hyperlink;
import ai.platon.pulsar.common.urls.UrlAware;
import ai.platon.scent.boot.autoconfigure.component.ScrapeTaskV1Handler;
import ai.platon.scent.boot.autoconfigure.persist.CrawlSeedV3Repository;
import ai.platon.scent.common.ClusterTools;
import ai.platon.scent.mongo.v1.CrawlSeedV3;
import ai.platon.scent.mongo.v1.ScrapeTask;
import ai.platon.scent.mongo.v2.ScrapeTaskStatusV2;
import com.google.common.collect.Iterables;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.ExperimentalTime;
import kotlin.time.TimedValue;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0001JB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010&\u001a\u00020'H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020+H\u0002J\u0010\u00101\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0013H\u0016J\b\u00105\u001a\u000203H\u0016J\b\u00106\u001a\u00020'H\u0016J\u0010\u00106\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u00107\u001a\u0002082\u0006\u0010(\u001a\u00020)H\u0002J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020+0:2\u0006\u0010(\u001a\u00020)H\u0002JF\u0010;\u001a\b\u0012\u0004\u0012\u0002H=0<\"\u0004\b\u0000\u0010=2\f\u0010>\u001a\b\u0012\u0004\u0012\u0002H=0?2\u0006\u0010@\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u0002H=0BH\u0017J\b\u0010C\u001a\u000203H\u0016J\b\u0010D\u001a\u000203H\u0016J\u0018\u0010E\u001a\u0002032\u0006\u0010,\u001a\u00020-2\u0006\u0010(\u001a\u00020)H\u0016J\u001e\u0010F\u001a\u0002032\f\u0010G\u001a\b\u0012\u0004\u0012\u00020-0H2\u0006\u0010(\u001a\u00020)H\u0016J\u0016\u0010F\u001a\u0002032\f\u0010I\u001a\b\u0012\u0004\u0012\u00020+0:H\u0002R*\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0014*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006K"}, d2={"Lai/platon/scent/boot/autoconfigure/component/CrawlSeedV3Loader;", "Lai/platon/pulsar/common/collect/DelayExternalUrlLoader;", "repository", "Lai/platon/scent/boot/autoconfigure/persist/CrawlSeedV3Repository;", "mongoTemplate", "Lorg/springframework/data/mongodb/core/MongoTemplate;", "unmodifiedConfig", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/scent/boot/autoconfigure/persist/CrawlSeedV3Repository;Lorg/springframework/data/mongodb/core/MongoTemplate;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "lastCount", "Lkotlin/time/TimedValue;", "", "getLastCount$annotations", "()V", "getLastCount", "()Lkotlin/time/TimedValue;", "setLastCount", "(Lkotlin/time/TimedValue;)V", "lastMaintainTime", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "metrics", "Lai/platon/scent/boot/autoconfigure/component/CrawlSeedV3Loader$Metrics;", "getMongoTemplate", "()Lorg/springframework/data/mongodb/core/MongoTemplate;", "nextLoadTime", "getRepository", "()Lai/platon/scent/boot/autoconfigure/persist/CrawlSeedV3Repository;", "taskV1Handler", "Lai/platon/scent/boot/autoconfigure/component/ScrapeTaskV1Handler;", "getTaskV1Handler", "()Lai/platon/scent/boot/autoconfigure/component/ScrapeTaskV1Handler;", "setTaskV1Handler", "(Lai/platon/scent/boot/autoconfigure/component/ScrapeTaskV1Handler;)V", "getUnmodifiedConfig", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "countRemaining", "", "topic", "Lai/platon/pulsar/common/collect/UrlTopic;", "createCrawlSeed", "Lai/platon/scent/mongo/v1/CrawlSeedV3;", "url", "Lai/platon/pulsar/common/urls/UrlAware;", "createHyperlink", "Lai/platon/pulsar/common/urls/Hyperlink;", "seed", "deleteAll", "deleteAllFinishedTasksBefore", "", "endTime", "deleteAllOld", "doCountRemaining", "format", "", "getTopTaskBatchUnlocked", "", "loadToNow", "", "T", "sink", "", "size", "transformer", "Lkotlin/Function1;", "maintainDb", "reset", "save", "saveAll", "urls", "", "seeds", "Metrics", "scent-boot"})
public class CrawlSeedV3Loader
extends DelayExternalUrlLoader {
    @NotNull
    private final CrawlSeedV3Repository repository;
    @NotNull
    private final MongoTemplate mongoTemplate;
    @NotNull
    private final ImmutableConfig unmodifiedConfig;
    private final Logger logger;
    @NotNull
    private final Metrics metrics;
    private Instant lastMaintainTime;
    private Instant nextLoadTime;
    @NotNull
    private TimedValue<Long> lastCount;
    public ScrapeTaskV1Handler taskV1Handler;

    public CrawlSeedV3Loader(@NotNull CrawlSeedV3Repository repository, @NotNull MongoTemplate mongoTemplate, @NotNull ImmutableConfig unmodifiedConfig) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)mongoTemplate, (String)"mongoTemplate");
        Intrinsics.checkNotNullParameter((Object)unmodifiedConfig, (String)"unmodifiedConfig");
        java.time.Duration duration = java.time.Duration.ofSeconds(30L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(30)");
        super(null, duration, 1, null);
        this.repository = repository;
        this.mongoTemplate = mongoTemplate;
        this.unmodifiedConfig = unmodifiedConfig;
        this.logger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(CrawlSeedV3Loader.class));
        this.metrics = new Metrics();
        this.lastMaintainTime = Instant.now();
        this.nextLoadTime = Instant.now();
        this.lastCount = new TimedValue((Object)0L, Duration.Companion.getZERO-UwyO8pc(), null);
    }

    @NotNull
    public CrawlSeedV3Repository getRepository() {
        return this.repository;
    }

    @NotNull
    public MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    @NotNull
    public ImmutableConfig getUnmodifiedConfig() {
        return this.unmodifiedConfig;
    }

    @NotNull
    public TimedValue<Long> getLastCount() {
        return this.lastCount;
    }

    public void setLastCount(@NotNull TimedValue<Long> timedValue) {
        Intrinsics.checkNotNullParameter(timedValue, (String)"<set-?>");
        this.lastCount = timedValue;
    }

    @ExperimentalTime
    public static /* synthetic */ void getLastCount$annotations() {
    }

    @NotNull
    public ScrapeTaskV1Handler getTaskV1Handler() {
        ScrapeTaskV1Handler scrapeTaskV1Handler = this.taskV1Handler;
        if (scrapeTaskV1Handler != null) {
            return scrapeTaskV1Handler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"taskV1Handler");
        return null;
    }

    public void setTaskV1Handler(@NotNull ScrapeTaskV1Handler scrapeTaskV1Handler) {
        Intrinsics.checkNotNullParameter((Object)scrapeTaskV1Handler, (String)"<set-?>");
        this.taskV1Handler = scrapeTaskV1Handler;
    }

    public synchronized void reset() {
        super.reset();
    }

    public synchronized void save(@NotNull UrlAware url, @NotNull UrlTopic topic) throws IllegalStateException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        this.metrics.getSaves().mark();
        CrawlSeedV3 seed = this.createCrawlSeed(url, topic);
        this.getRepository().save(seed);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void saveAll(@NotNull Iterable<? extends UrlAware> urls, @NotNull UrlTopic topic) throws IllegalStateException {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        this.metrics.getSaves().inc(Iterables.size(urls));
        Iterable<? extends UrlAware> $this$mapIndexed$iv = urls;
        boolean $i$f$mapIndexed = false;
        Iterable<? extends UrlAware> iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void url;
            int n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            UrlAware urlAware = (UrlAware)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            CrawlSeedV3 crawlSeedV3 = this.createCrawlSeed((UrlAware)url, topic);
            collection.add(crawlSeedV3);
        }
        List seeds = (List)destination$iv$iv;
        this.getRepository().saveAll(seeds);
    }

    public synchronized int countRemaining() {
        this.metrics.getCounts().mark();
        return super.countRemaining();
    }

    public synchronized int countRemaining(@NotNull UrlTopic topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        this.metrics.getCounts().mark();
        int count = super.countRemaining(topic);
        topic.setRemainingCount(count);
        return count;
    }

    public int doCountRemaining() {
        boolean bl;
        boolean bl2;
        Object object;
        boolean bl3 = false;
        try {
            object = Result.Companion;
            boolean bl4 = false;
            Long l = this.getRepository().countByStatusCode(201);
            bl2 = false;
            object = Result.constructor-impl((Object)l);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            bl = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object object2 = object;
        boolean bl5 = false;
        boolean bl6 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Throwable throwable2 = throwable;
            bl2 = false;
            bl = false;
            Throwable throwable3 = throwable2;
            boolean bl7 = false;
            Throwable it = throwable3;
            boolean bl8 = false;
            this.logger.warn("Failed to estimate size", it);
        }
        Long l = 0L;
        boolean bl9 = false;
        return (int)((Number)(Result.isFailure-impl((Object)object2) ? l : object2)).longValue();
    }

    public int doCountRemaining(@NotNull UrlTopic topic) {
        boolean bl;
        boolean bl2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        boolean bl3 = false;
        try {
            object = Result.Companion;
            boolean bl4 = false;
            Long l = this.getRepository().countByJobIdAndGroupAndPriorityAndStatusCode(topic.getName(), topic.getGroup(), topic.getPriority(), 201);
            bl2 = false;
            object = Result.constructor-impl((Object)l);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            bl = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object object2 = object;
        boolean bl5 = false;
        boolean bl6 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Throwable throwable2 = throwable;
            bl2 = false;
            bl = false;
            Throwable throwable3 = throwable2;
            boolean bl7 = false;
            Throwable it = throwable3;
            boolean bl8 = false;
            this.logger.warn("Failed to estimate size", it);
        }
        Long l = 0L;
        boolean bl9 = false;
        return (int)((Number)(Result.isFailure-impl((Object)object2) ? l : object2)).longValue();
    }

    @MongoLocked(storeId="distributeLock", expression="'F6fEYb8ir7r5JSr2'", expiration=@Interval(value="20", unit=TimeUnit.SECONDS))
    @NotNull
    public synchronized <T> Collection<T> loadToNow(@NotNull Collection<T> sink, int size, @NotNull UrlTopic topic, @NotNull Function1<? super UrlAware, ? extends T> transformer) throws IllegalStateException {
        Intrinsics.checkNotNullParameter(sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        int count = this.countRemaining(topic);
        if (count == 0) {
            if (topic.getLoadedCount() > 0) {
                this.logger.info("No seeds in topic <{}>", (Object)topic);
            }
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        List<CrawlSeedV3> seeds = this.getTopTaskBatchUnlocked(topic);
        if (seeds.isEmpty()) {
            if (topic.getLoadedCount() > 0) {
                this.logger.info("No seeds in topic <{}>", (Object)topic);
            }
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        int deaths = 0;
        Instant now = Instant.now();
        Iterable $this$forEach$iv = seeds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ComparableUrlAware hyperlink;
            ComparableUrlAware comparableUrlAware;
            CrawlSeedV3 seed = (CrawlSeedV3)element$iv;
            boolean bl = false;
            ScrapeTask taskV1 = seed.getTaskV1();
            ScrapeTaskStatusV2 taskV2 = seed.getTaskV2();
            if (taskV1 != null) {
                comparableUrlAware = (ComparableUrlAware)this.getTaskV1Handler().createHyperlink(taskV1);
            } else {
                if (taskV2 != null) {
                    throw new NotSupportedException("Scrape v2 is not supported currently");
                }
                comparableUrlAware = hyperlink = (ComparableUrlAware)this.createHyperlink(seed);
            }
            if (now.compareTo(hyperlink.getDeadTime()) < 0) {
                sink.add(transformer.invoke((Object)hyperlink));
                continue;
            }
            ++deaths;
        }
        this.metrics.getDeadTasks().inc(deaths);
        if (deaths == seeds.size()) {
            this.logger.info("All {} seeds are dead in topic <{}>", (Object)deaths, (Object)this.format(topic));
            return sink;
        }
        $this$forEach$iv = topic;
        $this$forEach$iv.setLoadedCount($this$forEach$iv.getLoadedCount() + seeds.size());
        Object deathMsg = deaths > 0 ? " with " + deaths + " dead" : "";
        Object[] objectArray = new Object[]{seeds.size(), topic.getLoadedCount(), topic.getRemainingCount(), deathMsg, this.format(topic)};
        this.logger.info("Loaded top {}/{}/{} seeds{} in topic <{}>", objectArray);
        this.maintainDb();
        return sink;
    }

    private final Hyperlink createHyperlink(CrawlSeedV3 seed) {
        String string = seed.getAnchorText();
        String text = string == null ? "" : string;
        String string2 = seed.getArgs();
        String args = string2 == null ? "" : string2;
        Object object = seed.getLabel();
        boolean bl = false;
        boolean bl2 = false;
        String label = object == null || StringsKt.isBlank((CharSequence)object) ? "seed" : seed.getLabel();
        object = args + " -label " + label;
        bl = false;
        Object object2 = object;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        args = ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString();
        return new Hyperlink(seed.getUrl(), text, seed.getOrder(), seed.getReferrer(), args, null, 32, null);
    }

    public synchronized long deleteAll(@NotNull UrlTopic topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        return this.getRepository().deleteAllByJobIdAndGroupAndPriority(topic.getName(), topic.getGroup(), topic.getPriority());
    }

    public synchronized void maintainDb() {
        if (java.time.Duration.between(this.lastMaintainTime, Instant.now()).toHours() < 1L) {
            return;
        }
        int dayOfMonth = LocalDate.now().getDayOfMonth();
        int mod = dayOfMonth % ClusterTools.INSTANCE.getCrawlerCount();
        if (ClusterTools.INSTANCE.getInstancePartition() == mod) {
            this.deleteAllOld();
            this.lastMaintainTime = Instant.now();
        }
    }

    public synchronized void deleteAllOld() {
        Instant now = Instant.now();
        Instant hoursBefore = now.minus(java.time.Duration.ofHours(3L));
        Intrinsics.checkNotNullExpressionValue((Object)hoursBefore, (String)"hoursBefore");
        this.deleteAllFinishedTasksBefore(hoursBefore);
    }

    public synchronized void deleteAllFinishedTasksBefore(@NotNull Instant endTime) {
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        Instant now = Instant.now();
        int statusCode = 201;
        try {
            long count = this.getRepository().deleteAllByStatusCodeNotAndCreatedAtBefore(statusCode, endTime);
            Long l = count;
            Intrinsics.checkNotNullExpressionValue((Object)now, (String)"now");
            this.logger.info("Removed {} old seeds in {}", (Object)l, (Object)DateTimes.elapsedTime$default((DateTimes)DateTimes.INSTANCE, (Instant)now, null, (int)2, null));
        }
        catch (Exception e) {
            this.logger.warn("Failed to delete from seed repository", (Throwable)e);
        }
    }

    @NotNull
    public CrawlSeedV3 createCrawlSeed(@NotNull UrlAware url, @NotNull UrlTopic topic) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        CrawlSeedV3 seed = new CrawlSeedV3(url.getUrl(), url.getArgs(), url.getReferrer(), null, url.getLabel(), 0, topic.getName(), topic.getGroup(), topic.getPriority(), 201, null, false, null, null, 15400, null);
        if (url instanceof Hyperlink) {
            seed.setAnchorText(((Hyperlink)url).getText());
            seed.setOrder(((Hyperlink)url).getOrder());
        }
        return seed;
    }

    private final List<CrawlSeedV3> getTopTaskBatchUnlocked(UrlTopic topic) {
        this.metrics.getQueries().mark();
        int statusCode = 201;
        PageRequest pageRequest = PageRequest.of((int)0, (int)topic.getPageSize());
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(0, topic.pageSize)");
        PageRequest pageRequest2 = pageRequest;
        try {
            Page<CrawlSeedV3> result = this.getRepository().findAllByJobIdAndGroupAndPriorityAndStatusCode(topic.getName(), topic.getGroup(), topic.getPriority(), statusCode, pageRequest2);
            if (result.isEmpty()) {
                boolean bl = false;
                return CollectionsKt.emptyList();
            }
            List list = result.getContent();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"result.content");
            List tasks = list;
            Iterable $this$forEach$iv = tasks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CrawlSeedV3 it = (CrawlSeedV3)element$iv;
                boolean bl = false;
                it.setStatusCode(102);
            }
            this.saveAll(tasks);
            this.metrics.getUpdates().inc(tasks.size());
            return tasks;
        }
        catch (Exception e) {
            this.logger.warn("Failed to load seeds", (Throwable)e);
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
    }

    private final void saveAll(List<CrawlSeedV3> seeds) {
        this.getRepository().saveAll(seeds);
    }

    private final String format(UrlTopic topic) {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%s, grp: %s, pri: %s, limit: %s";
        Object[] objectArray = new Object[]{topic.getName(), topic.getGroup(), topic.getPriority(), topic.getPageSize()};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lai/platon/scent/boot/autoconfigure/component/CrawlSeedV3Loader$Metrics;", "", "()V", "counts", "Lai/platon/pulsar/common/metrics/MultiMetric;", "getCounts", "()Lai/platon/pulsar/common/metrics/MultiMetric;", "deadTasks", "getDeadTasks", "queries", "getQueries", "registry", "Lai/platon/pulsar/common/metrics/AppMetricRegistry;", "saves", "getSaves", "updates", "getUpdates", "scent-boot"})
    public static final class Metrics {
        @NotNull
        private final AppMetricRegistry registry = AppMetrics.Companion.getDefaultMetricRegistry();
        @NotNull
        private final MultiMetric saves = this.registry.multiMetric((Object)this, "saves");
        @NotNull
        private final MultiMetric updates = this.registry.multiMetric((Object)this, "updates");
        @NotNull
        private final MultiMetric queries = this.registry.multiMetric((Object)this, "queries");
        @NotNull
        private final MultiMetric counts = this.registry.multiMetric((Object)this, "counts");
        @NotNull
        private final MultiMetric deadTasks = this.registry.multiMetric((Object)this, "deadTasks");

        @NotNull
        public final MultiMetric getSaves() {
            return this.saves;
        }

        @NotNull
        public final MultiMetric getUpdates() {
            return this.updates;
        }

        @NotNull
        public final MultiMetric getQueries() {
            return this.queries;
        }

        @NotNull
        public final MultiMetric getCounts() {
            return this.counts;
        }

        @NotNull
        public final MultiMetric getDeadTasks() {
            return this.deadTasks;
        }
    }
}

