/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.support;

import ai.platon.scent.crawl.serialize.CompactedScrapeResponse;
import ai.platon.scent.crawl.serialize.ScrapeRequest;
import ai.platon.scent.crawl.serialize.ScrapeResponse;
import ai.platon.scent.entities.UserDashboard;
import ai.platon.scent.support.JacksonPageImpl;
import ai.platon.scent.support.ScentRestClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u00052\b\b\u0002\u0010\u001d\u001a\u00020\u001eJ(\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\u001c\u001a\u00020\u00052\b\b\u0002\u0010\"\u001a\u00020\u00072\b\b\u0002\u0010#\u001a\u00020\u0007J\u0018\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005J\"\u0010'\u001a\b\u0012\u0004\u0012\u00020%0(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050*2\u0006\u0010\u001c\u001a\u00020\u0005J\u0010\u0010+\u001a\u0004\u0018\u00010\u00052\u0006\u0010,\u001a\u00020-R\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\fR\u000e\u0010\u0019\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lai/platon/scent/support/ScentRestClient;", "", "restTemplate", "Lorg/springframework/web/client/RestTemplate;", "server", "", "port", "", "contextPath", "(Lorg/springframework/web/client/RestTemplate;Ljava/lang/String;ILjava/lang/String;)V", "baseUri", "getBaseUri", "()Ljava/lang/String;", "getContextPath", "dashboardApi", "downloadApi", "getPort", "()I", "getRestTemplate", "()Lorg/springframework/web/client/RestTemplate;", "scrapeApi", "scrapeBaseUri", "scrapeStatusApi", "scrapeStatusesApi", "getServer", "userBaseUri", "dashboard", "Lai/platon/scent/entities/UserDashboard;", "authToken", "refresh", "", "download", "Lorg/springframework/data/domain/Page;", "Lai/platon/scent/crawl/serialize/CompactedScrapeResponse;", "pageNumber", "pageSize", "getScrapeStatus", "Lai/platon/scent/crawl/serialize/ScrapeResponse;", "id", "getScrapeStatuses", "", "ids", "", "scrape", "request", "Lai/platon/scent/crawl/serialize/ScrapeRequest;", "scent-boot"})
public final class ScentRestClient {
    @NotNull
    private final RestTemplate restTemplate;
    @NotNull
    private final String server;
    private final int port;
    @NotNull
    private final String contextPath;
    @NotNull
    private final String scrapeBaseUri;
    @NotNull
    private final String scrapeApi;
    @NotNull
    private final String scrapeStatusApi;
    @NotNull
    private final String scrapeStatusesApi;
    @NotNull
    private final String userBaseUri;
    @NotNull
    private final String dashboardApi;
    @NotNull
    private final String downloadApi;

    public ScentRestClient(@NotNull RestTemplate restTemplate, @NotNull String server, int port, @NotNull String contextPath) {
        Intrinsics.checkNotNullParameter((Object)restTemplate, (String)"restTemplate");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)contextPath, (String)"contextPath");
        this.restTemplate = restTemplate;
        this.server = server;
        this.port = port;
        this.contextPath = contextPath;
        this.scrapeBaseUri = this.getBaseUri() + "/x/a";
        this.scrapeApi = this.scrapeBaseUri + "/q";
        this.scrapeStatusApi = this.scrapeBaseUri + "/status?id={id}&authToken={authToken}";
        this.scrapeStatusesApi = this.scrapeBaseUri + "/statuses?id={id}&authToken={authToken}";
        this.userBaseUri = this.getBaseUri() + "/users/{authToken}";
        this.dashboardApi = this.userBaseUri + "/dashboard";
        this.downloadApi = this.userBaseUri + "/download";
    }

    public /* synthetic */ ScentRestClient(RestTemplate restTemplate, String string, int n, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string = "localhost";
        }
        if ((n2 & 4) != 0) {
            n = 8182;
        }
        if ((n2 & 8) != 0) {
            string2 = "/api";
        }
        this(restTemplate, string, n, string2);
    }

    @NotNull
    public final RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    @NotNull
    public final String getServer() {
        return this.server;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final String getContextPath() {
        return this.contextPath;
    }

    @NotNull
    public final String getBaseUri() {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "http://%s:%d%s";
        Object[] objectArray = new Object[]{this.server, this.port, this.contextPath};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    @Nullable
    public final UserDashboard dashboard(@NotNull String authToken, boolean refresh) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        String url = this.dashboardApi + "?refresh={refresh}";
        Object[] objectArray = new Object[]{authToken, refresh};
        return (UserDashboard)this.restTemplate.getForObject(url, UserDashboard.class, objectArray);
    }

    public static /* synthetic */ UserDashboard dashboard$default(ScentRestClient scentRestClient, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return scentRestClient.dashboard(string, bl);
    }

    @Nullable
    public final String scrape(@NotNull ScrapeRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return (String)this.restTemplate.postForObject(this.scrapeApi, (Object)request, String.class, new Object[0]);
    }

    @Nullable
    public final ScrapeResponse getScrapeStatus(@NotNull String id, @NotNull String authToken) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Object[] objectArray = new Object[]{id, authToken};
        return (ScrapeResponse)this.restTemplate.getForObject(this.scrapeStatusApi, ScrapeResponse.class, objectArray);
    }

    @NotNull
    public final List<ScrapeResponse> getScrapeStatuses(@NotNull Iterable<String> ids, @NotNull String authToken) {
        List list;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        ParameterizedTypeReference<ArrayList<ScrapeResponse>> responseType2 = new ParameterizedTypeReference<ArrayList<ScrapeResponse>>(){};
        Object[] objectArray = new Object[]{CollectionsKt.joinToString$default(ids, (CharSequence)"|", null, null, (int)0, null, (Function1)getScrapeStatuses.responseEntity.1.INSTANCE, (int)30, null), authToken};
        Object object = this.restTemplate.exchange(this.scrapeStatusesApi, HttpMethod.GET, null, (ParameterizedTypeReference)responseType2, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"restTemplate.exchange(\n \u2026() }, authToken\n        )");
        ResponseEntity responseEntity2 = object;
        object = (ArrayList)responseEntity2.getBody();
        if (object == null) {
            boolean bl = false;
            list = CollectionsKt.emptyList();
        } else {
            list = (List)object;
        }
        return list;
    }

    @NotNull
    public final Page<CompactedScrapeResponse> download(@NotNull String authToken, int pageNumber, int pageSize) {
        Page page;
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        String uri = this.downloadApi + "?pageNumber={pageNumber}&pageSize={pageSize}";
        ParameterizedTypeReference<JacksonPageImpl<CompactedScrapeResponse>> responseType2 = new ParameterizedTypeReference<JacksonPageImpl<CompactedScrapeResponse>>(){};
        Object[] objectArray = new Object[]{authToken, pageNumber, pageSize};
        Object object = this.restTemplate.exchange(uri, HttpMethod.GET, null, (ParameterizedTypeReference)responseType2, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"restTemplate.exchange(\n \u2026umber, pageSize\n        )");
        ResponseEntity responseEntity2 = object;
        object = (JacksonPageImpl)((Object)responseEntity2.getBody());
        if (object == null) {
            boolean bl = false;
            page = (Page)new PageImpl(CollectionsKt.emptyList());
        } else {
            page = (Page)object;
        }
        return page;
    }

    public static /* synthetic */ Page download$default(ScentRestClient scentRestClient, String string, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 500;
        }
        return scentRestClient.download(string, n, n2);
    }
}

