/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.boot.autoconfigure.component;

import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.JvmTimedValue;
import ai.platon.pulsar.common.LangKt;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.ResourceLoader;
import ai.platon.pulsar.common.collect.ExternalUrlLoader;
import ai.platon.pulsar.common.collect.LocalFileHyperlinkCollector;
import ai.platon.pulsar.common.collect.UrlFeederHelper;
import ai.platon.pulsar.common.collect.collector.PriorityDataCollector;
import ai.platon.pulsar.common.collect.collector.UrlCacheCollector;
import ai.platon.pulsar.common.collect.queue.AbstractLoadingQueue;
import ai.platon.pulsar.common.urls.Hyperlink;
import ai.platon.pulsar.persist.WebDb;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.gora.generated.GWebPage;
import ai.platon.scent.boot.autoconfigure.component.LoadingSeedsGenerator;
import ai.platon.scent.common.Runtimes;
import ai.platon.scent.common.WebDbLongTimeTask;
import ai.platon.scent.crawl.CollectedResidentTask;
import ai.platon.scent.crawl.ResidentTask;
import ai.platon.scent.crawl.ResidentTaskKt;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B9\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u001e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0002J\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00020,0-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020)0\u0003H\u0002J\b\u0010/\u001a\u00020'H\u0002J\u0010\u00100\u001a\u00020'2\u0006\u00101\u001a\u00020)H\u0002J\u0016\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u00102\u0006\u00105\u001a\u00020\u0018J\u0018\u00106\u001a\u0002032\u0006\u00107\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u00108\u001a\b\u0012\u0004\u0012\u0002030\u00032\u0006\u00105\u001a\u00020\u0018J\u0016\u00109\u001a\b\u0012\u0004\u0012\u0002030\u00032\u0006\u00107\u001a\u00020\u0004H\u0002J\u000e\u0010:\u001a\u00020\u00182\u0006\u00107\u001a\u00020\u0004J\u0016\u0010;\u001a\b\u0012\u0004\u0012\u0002030\u00032\u0006\u00107\u001a\u00020\u0004H\u0002R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00060\u00060\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0012R\u000e\u0010\u001c\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006<"}, d2={"Lai/platon/scent/boot/autoconfigure/component/LoadingSeedsGenerator;", "", "tasks", "", "Lai/platon/scent/crawl/ResidentTask;", "searchDirectories", "", "urlFeederHelper", "Lai/platon/pulsar/common/collect/UrlFeederHelper;", "urlLoader", "Lai/platon/pulsar/common/collect/ExternalUrlLoader;", "webDb", "Lai/platon/pulsar/persist/WebDb;", "(Ljava/util/List;Ljava/util/List;Lai/platon/pulsar/common/collect/UrlFeederHelper;Lai/platon/pulsar/common/collect/ExternalUrlLoader;Lai/platon/pulsar/persist/WebDb;)V", "collectedTasks", "", "Lai/platon/scent/crawl/CollectedResidentTask;", "getCollectedTasks", "()Ljava/util/List;", "fields", "", "kotlin.jvm.PlatformType", "[Ljava/lang/String;", "isDev", "", "logger", "Lorg/slf4j/Logger;", "getSearchDirectories", "taskId", "taskTime", "Ljava/time/Instant;", "getTasks", "getUrlFeederHelper", "()Lai/platon/pulsar/common/collect/UrlFeederHelper;", "getUrlLoader", "()Lai/platon/pulsar/common/collect/ExternalUrlLoader;", "getWebDb", "()Lai/platon/pulsar/persist/WebDb;", "collectHyperlinks", "", "path", "Ljava/nio/file/Path;", "hyperlinks", "", "Lai/platon/pulsar/common/urls/Hyperlink;", "", "paths", "collectLoadingTasks", "collectLoadingTasksInDirectory", "directory", "createCollector", "Lai/platon/pulsar/common/collect/collector/UrlCacheCollector;", "collectedTask", "refresh", "createFetchCacheCollector", "task", "generate", "getRelevantCollectors", "isSupervisor", "removeOldCollectors", "scent-boot"})
public final class LoadingSeedsGenerator {
    @NotNull
    private final List<ResidentTask> tasks;
    @NotNull
    private final List<String> searchDirectories;
    @NotNull
    private final UrlFeederHelper urlFeederHelper;
    @NotNull
    private final ExternalUrlLoader urlLoader;
    @NotNull
    private final WebDb webDb;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Instant taskTime;
    @NotNull
    private final String taskId;
    private final boolean isDev;
    @NotNull
    private final List<CollectedResidentTask> collectedTasks;
    @NotNull
    private final String[] fields;

    /*
     * WARNING - void declaration
     */
    public LoadingSeedsGenerator(@NotNull List<ResidentTask> tasks, @NotNull List<String> searchDirectories, @NotNull UrlFeederHelper urlFeederHelper, @NotNull ExternalUrlLoader urlLoader, @NotNull WebDb webDb) {
        void $this$toTypedArray$iv;
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Intrinsics.checkNotNullParameter(tasks, (String)"tasks");
        Intrinsics.checkNotNullParameter(searchDirectories, (String)"searchDirectories");
        Intrinsics.checkNotNullParameter((Object)urlFeederHelper, (String)"urlFeederHelper");
        Intrinsics.checkNotNullParameter((Object)urlLoader, (String)"urlLoader");
        Intrinsics.checkNotNullParameter((Object)webDb, (String)"webDb");
        this.tasks = tasks;
        this.searchDirectories = searchDirectories;
        this.urlFeederHelper = urlFeederHelper;
        this.urlLoader = urlLoader;
        this.webDb = webDb;
        this.logger = LogsKt.getLogger((Object)this);
        this.taskTime = DateTimes.INSTANCE.startOfDay();
        String string = this.taskTime.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"taskTime.toString()");
        this.taskId = string;
        this.isDev = Runtimes.INSTANCE.isDevInstance();
        boolean bl = false;
        this.collectedTasks = new ArrayList();
        Object object = new GWebPage.Field[]{GWebPage.Field.PREV_FETCH_TIME, GWebPage.Field.PREV_CRAWL_TIME1};
        object = CollectionsKt.listOf((Object[])object);
        LoadingSeedsGenerator loadingSeedsGenerator = this;
        boolean $i$f$map = false;
        void var8_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GWebPage.Field field = (GWebPage.Field)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            String string2 = it.getName();
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        loadingSeedsGenerator.fields = stringArray;
    }

    @NotNull
    public final List<ResidentTask> getTasks() {
        return this.tasks;
    }

    @NotNull
    public final List<String> getSearchDirectories() {
        return this.searchDirectories;
    }

    @NotNull
    public final UrlFeederHelper getUrlFeederHelper() {
        return this.urlFeederHelper;
    }

    @NotNull
    public final ExternalUrlLoader getUrlLoader() {
        return this.urlLoader;
    }

    @NotNull
    public final WebDb getWebDb() {
        return this.webDb;
    }

    @NotNull
    public final List<CollectedResidentTask> getCollectedTasks() {
        return this.collectedTasks;
    }

    public final boolean isSupervisor(@NotNull ResidentTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        return this.isDev || ResidentTaskKt.isSupervised((ResidentTask)task);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<UrlCacheCollector> generate(boolean refresh) {
        ResidentTask it;
        Iterable $this$filterTo$iv$iv;
        this.collectLoadingTasks();
        this.logger.info("Collected tasks: " + CollectionsKt.joinToString$default((Iterable)this.collectedTasks, null, null, null, (int)0, null, (Function1)generate.1.INSTANCE, (int)31, null));
        boolean bl = false;
        List collectors = new ArrayList();
        Iterable $this$forEach$iv = this.collectedTasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CollectedResidentTask task = (CollectedResidentTask)element$iv;
            boolean bl2 = false;
            collectors.add(this.createCollector(task, refresh));
            LangKt.sleepSeconds((long)15L);
        }
        Iterable $this$filter$iv = this.tasks;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            void $this$mapTo$iv$iv;
            it = (ResidentTask)element$iv$iv;
            boolean bl3 = false;
            Iterable $this$map$iv = this.getCollectedTasks();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                CollectedResidentTask collectedResidentTask = (CollectedResidentTask)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                ResidentTask residentTask = it2.getTask();
                collection.add(residentTask);
            }
            if (!(!((List)destination$iv$iv2).contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ResidentTask)element$iv$iv;
            boolean bl5 = false;
            if (!(!this.getUrlFeederHelper().contains(it.getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapTo$iv = (List)destination$iv$iv;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it3;
            ResidentTask $i$f$filterTo2 = (ResidentTask)item$iv;
            Collection collection = collectors;
            boolean bl6 = false;
            UrlCacheCollector urlCacheCollector = this.createFetchCacheCollector((ResidentTask)it3, this.getUrlLoader());
            collection.add(urlCacheCollector);
        }
        return collectors;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final UrlCacheCollector createCollector(@NotNull CollectedResidentTask collectedTask, boolean refresh) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)collectedTask, (String)"collectedTask");
        ResidentTask task = collectedTask.getTask();
        this.removeOldCollectors(task);
        UrlCacheCollector collector = this.createFetchCacheCollector(task, this.urlLoader);
        if (refresh) {
            collector.deepClear();
        }
        if (collector.getExternalSize() > 0) {
            this.logger.info("There are still {} tasks in collector {}, do not generate", (Object)collector.getEstimatedSize(), (Object)collector.getName());
            return collector;
        }
        Set links = collectedTask.getHyperlinks();
        if (links.isEmpty()) {
            return collector;
        }
        AbstractLoadingQueue readyQueue = (AbstractLoadingQueue)collector.getUrlCache().getNonReentrantQueue();
        this.logger.info("Checking {} links for task <{}> in database", (Object)links.size(), (Object)task.getName());
        boolean $i$f$measureTimedValueJvm = false;
        Instant startTime$iv = Instant.now();
        boolean bl = false;
        Sequence sequence = SequencesKt.filter((Sequence)new WebDbLongTimeTask(this.getWebDb(), task.getName(), null, 4, null).getAll((Iterable)links, this.fields), (Function1)((Function1)new Function1<WebPage, Boolean>(task){
            final /* synthetic */ ResidentTask $task;
            {
                this.$task = $task;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull WebPage it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getPrevFetchTime().compareTo((Instant)this.$task.getStartTime().invoke()) >= 0;
            }
        }));
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            WebPage webPage = (WebPage)item$iv;
            Collection collection = destination$iv;
            boolean bl2 = false;
            String string = it.getUrl();
            collection.add(string);
        }
        HashSet value$iv = (HashSet)destination$iv;
        Duration elapsedTime$iv = Duration.between(startTime$iv, Instant.now());
        Intrinsics.checkNotNullExpressionValue((Object)elapsedTime$iv, (String)"elapsedTime");
        JvmTimedValue jvmTimedValue = new JvmTimedValue((Object)value$iv, elapsedTime$iv);
        HashSet fetchedUrls = (HashSet)jvmTimedValue.component1();
        Duration time = jvmTimedValue.component2();
        SequencesKt.toCollection((Sequence)SequencesKt.onEach((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)links), (Function1)((Function1)new Function1<Hyperlink, Boolean>((HashSet<String>)fetchedUrls){
            final /* synthetic */ HashSet<String> $fetchedUrls;
            {
                this.$fetchedUrls = $fetchedUrls;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Hyperlink it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$fetchedUrls.contains(it.getUrl());
            }
        })), (Function1)((Function1)new Function1<Hyperlink, Unit>(task, this){
            final /* synthetic */ ResidentTask $task;
            final /* synthetic */ LoadingSeedsGenerator this$0;
            {
                this.$task = $task;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Hyperlink it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.setArgs(ResidentTaskKt.createArgs((ResidentTask)this.$task, (String)LoadingSeedsGenerator.access$getTaskId$p(this.this$0), (Instant)LoadingSeedsGenerator.access$getTaskTime$p(this.this$0)).toString());
            }
        })), (Collection)((Collection)readyQueue));
        Object[] objectArray = new Object[]{readyQueue.size(), readyQueue.getExternalSize(), task.getName(), collector.getName(), time, fetchedUrls.size()};
        this.logger.info("Generated {}/{} {} tasks with collector {} in {}, with {} ones removed(fetched)", objectArray);
        return collector;
    }

    /*
     * WARNING - void declaration
     */
    private final List<UrlCacheCollector> getRelevantCollectors(ResidentTask task) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.urlFeederHelper.getFeeder().getCollectors();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PriorityDataCollector it = (PriorityDataCollector)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)it.getName(), (CharSequence)task.getName(), (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$filterTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof UrlCacheCollector)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<UrlCacheCollector> removeOldCollectors(ResidentTask task) {
        Iterable $this$onEach$iv = this.getRelevantCollectors(task);
        boolean $i$f$onEach = false;
        Iterable iterable = $this$onEach$iv;
        boolean bl = false;
        boolean bl2 = false;
        Iterable $this$apply$iv = iterable;
        boolean bl3 = false;
        for (Object element$iv : $this$apply$iv) {
            UrlCacheCollector it = (UrlCacheCollector)element$iv;
            boolean bl4 = false;
            this.getUrlFeederHelper().removeAllLike(task.getName());
        }
        return (List)iterable;
    }

    private final UrlCacheCollector createFetchCacheCollector(ResidentTask task, ExternalUrlLoader urlLoader) {
        int priority = task.getPriority().getValue();
        this.urlFeederHelper.remove(task.getName());
        this.logger.info("Creating collector for {}", (Object)task.getName());
        UrlCacheCollector urlCacheCollector = this.urlFeederHelper.create(task.getName(), priority, urlLoader);
        boolean bl = false;
        boolean bl2 = false;
        UrlCacheCollector it = urlCacheCollector;
        boolean bl3 = false;
        it.setDeadTime((Instant)task.getDeadTime().invoke());
        it.getLabels().add(task.getName());
        return urlCacheCollector;
    }

    /*
     * WARNING - void declaration
     */
    private final void collectLoadingTasks() {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.searchDirectories;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            URI uRI;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            URL uRL = ResourceLoader.INSTANCE.getResource(it);
            if ((uRL == null ? null : uRL.toURI()) == null) continue;
            uRI = uRI;
            boolean bl3 = false;
            boolean bl4 = false;
            URI it$iv$iv = uRI;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (URI)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path path = Paths.get((URI)it);
            collection.add(path);
        }
        Iterable $this$forEach$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Path it = (Path)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.collectLoadingTasksInDirectory(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void collectLoadingTasksInDirectory(Path directory) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Object task;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Stream<Path> stream = Files.list(directory).filter(LoadingSeedsGenerator::collectLoadingTasksInDirectory$lambda-14);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"list(directory).filter { Files.isRegularFile(it) }");
        List candidates = StreamsKt.toList(stream);
        Iterable iterable = this.tasks;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            task = (ResidentTask)element$iv$iv;
            boolean bl = false;
            if (!this.isSupervisor((ResidentTask)task)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            task = (ResidentTask)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = task.getFileName();
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
            if (!bl4) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        task = $this$forEach$iv$iv$iv.iterator();
        while (task.hasNext()) {
            Pair pair;
            List list;
            List paths;
            void $this$filterTo$iv$iv2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = task.next();
            boolean bl = false;
            ResidentTask task2 = (ResidentTask)element$iv$iv;
            boolean bl5 = false;
            Iterable $this$filter$iv2 = candidates;
            boolean $i$f$filter2 = false;
            Iterable iterable2 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                Path it = (Path)element$iv$iv2;
                boolean bl6 = false;
                CharSequence charSequence = ((Object)it).toString();
                String string = task2.getFileName();
                Intrinsics.checkNotNull((Object)string);
                String string2 = string;
                boolean bl7 = false;
                string2 = new Regex(string2);
                bl7 = false;
                if (!string2.containsMatchIn(charSequence)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            List list2 = paths = (List)destination$iv$iv2;
            boolean bl8 = false;
            boolean bl9 = false;
            List it = list2;
            boolean bl10 = false;
            Collection collection = it;
            boolean bl11 = false;
            List list3 = list = !collection.isEmpty() ? list2 : null;
            if (list == null) {
                pair = null;
            } else {
                list2 = list;
                bl8 = false;
                bl9 = false;
                it = list2;
                boolean bl12 = false;
                pair = TuplesKt.to((Object)task2, (Object)it);
            }
            if (pair == null) continue;
            Pair pair2 = pair;
            boolean bl13 = false;
            boolean bl14 = false;
            Pair it$iv$iv = pair2;
            boolean bl15 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $dstr$task$paths;
            task = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ResidentTask task3 = (ResidentTask)$dstr$task$paths.component1();
            List paths = (List)$dstr$task$paths.component2();
            CollectedResidentTask collectedResidentTask = new CollectedResidentTask(task3, this.collectHyperlinks(paths));
            collection.add(collectedResidentTask);
        }
        List collectedResidentTasks = (List)destination$iv$iv;
        this.collectedTasks.addAll(collectedResidentTasks);
    }

    private final Set<Hyperlink> collectHyperlinks(List<? extends Path> paths) {
        boolean bl = false;
        Set hyperlinks = new LinkedHashSet();
        Iterable $this$forEach$iv = paths;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path it = (Path)element$iv;
            boolean bl2 = false;
            this.collectHyperlinks(it, hyperlinks);
        }
        return hyperlinks;
    }

    private final void collectHyperlinks(Path path, Set<Hyperlink> hyperlinks) {
        LocalFileHyperlinkCollector collector = new LocalFileHyperlinkCollector(path, 0, 2, null);
        List links = this.isDev ? CollectionsKt.take((Iterable)collector.getHyperlinks(), (int)100) : collector.getHyperlinks();
        boolean isMaster = Runtimes.INSTANCE.isMaster();
        boolean isCluster = Runtimes.INSTANCE.isCluster();
        if (isCluster) {
            collector.getHyperlinks();
        } else if (isMaster && StringsKt.contains$default((CharSequence)((Object)path).toString(), (CharSequence)"best-sellers", (boolean)false, (int)2, null)) {
            collector.getHyperlinks();
        } else if (isMaster) {
            CollectionsKt.take((Iterable)collector.getHyperlinks(), (int)5000);
        } else {
            CollectionsKt.take((Iterable)collector.getHyperlinks(), (int)100);
        }
        String message = this.isDev ? " (dev mode)" : "";
        this.logger.info("Loaded {} links" + message + " | {}", (Object)links.size(), (Object)path);
        hyperlinks.addAll(links);
    }

    private static final boolean collectLoadingTasksInDirectory$lambda-14(Path it) {
        return Files.isRegularFile(it, new LinkOption[0]);
    }

    public static final /* synthetic */ String access$getTaskId$p(LoadingSeedsGenerator $this) {
        return $this.taskId;
    }

    public static final /* synthetic */ Instant access$getTaskTime$p(LoadingSeedsGenerator $this) {
        return $this.taskTime;
    }
}

