/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.tools;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.urls.Hyperlink;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.skeleton.crawl.common.url.ListenableHyperlink;
import ai.platon.pulsar.skeleton.crawl.filter.ChainedUrlNormalizer;
import ai.platon.pulsar.skeleton.crawl.filter.ScopedUrlNormalizer;
import ai.platon.scent.BasicScentSession;
import ai.platon.scent.common.MLPaths;
import ai.platon.scent.dom.HarvestOptions;
import ai.platon.scent.tools.EBayProductUrlNormalizer;
import ai.platon.scent.tools.EBayUrls;
import ai.platon.scent.tools.VerboseCrawler;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0014\u0010\u0019\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lai/platon/scent/tools/EBayHarvesterStarter;", "", "args", "", "projectId", "(Ljava/lang/String;Ljava/lang/String;)V", "getArgs", "()Ljava/lang/String;", "crawler", "Lai/platon/scent/tools/VerboseCrawler;", "datasetPath", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "htmlBaseDir", "getProjectId", "session", "Lai/platon/scent/BasicScentSession;", "collectListPageLinks", "", "Lai/platon/pulsar/common/urls/Hyperlink;", "createInfoFile", "", "createListenableHyperlink", "Lai/platon/pulsar/skeleton/crawl/common/url/ListenableHyperlink;", "link", "loadAllAndExportToEncode", "portalUrls", "scent-boot"})
@SourceDebugExtension(value={"SMAP\nEBayHarvestStarter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EBayHarvestStarter.kt\nai/platon/scent/tools/EBayHarvesterStarter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1360#2:96\n1446#2,5:97\n1611#2:102\n1855#2:103\n1856#2:105\n1612#2:106\n1549#2:107\n1620#2,3:108\n1#3:104\n*S KotlinDebug\n*F\n+ 1 EBayHarvestStarter.kt\nai/platon/scent/tools/EBayHarvesterStarter\n*L\n37#1:96\n37#1:97,5\n38#1:102\n38#1:103\n38#1:105\n38#1:106\n39#1:107\n39#1:108,3\n38#1:104\n*E\n"})
public final class EBayHarvesterStarter {
    @NotNull
    private final String args;
    @NotNull
    private final String projectId;
    @NotNull
    private final VerboseCrawler crawler;
    @NotNull
    private final BasicScentSession session;
    private final Path datasetPath;
    private final Path htmlBaseDir;

    public EBayHarvesterStarter(@NotNull String args, @NotNull String projectId) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        this.args = args;
        this.projectId = projectId;
        this.crawler = new VerboseCrawler(null, 1, null);
        this.session = this.crawler.getSession();
        this.datasetPath = MLPaths.INSTANCE.getDatasetDir().resolve(this.projectId);
        this.htmlBaseDir = this.datasetPath.resolve("html");
        Files.createDirectories(this.htmlBaseDir, new FileAttribute[0]);
        ChainedUrlNormalizer.add$default((ChainedUrlNormalizer)this.session.getContext().getUrlNormalizer(), (ScopedUrlNormalizer)((ScopedUrlNormalizer)new EBayProductUrlNormalizer()), null, (int)2, null);
    }

    @NotNull
    public final String getArgs() {
        return this.args;
    }

    @NotNull
    public final String getProjectId() {
        return this.projectId;
    }

    @NotNull
    public final List<Hyperlink> collectListPageLinks() {
        return FeaturedDocument.selectHyperlinks$default((FeaturedDocument)this.session.loadDocument("https://www.ebay.com/b/Apple/bn_21819543"), (String)"a[href~=/b/]", (int)0, (int)0, (int)6, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void loadAllAndExportToEncode(@NotNull List<String> portalUrls) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object element$iv;
        Iterable $this$mapNotNullTo$iv;
        FeaturedDocument it;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(portalUrls, (String)"portalUrls");
        HarvestOptions options = this.session.options(this.args);
        HarvestOptions itemOptions = options.createItemOptions();
        List documents2 = this.session.loadDocuments((Iterable)portalUrls, options);
        EBayProductUrlNormalizer urlNormalizer = new EBayProductUrlNormalizer();
        Iterable $this$flatMap$iv = documents2;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (FeaturedDocument)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = FeaturedDocument.selectHyperlinks$default((FeaturedDocument)it, (String)options.getOutLinkSelector(), (int)0, (int)0, (int)6, null);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            Hyperlink it$iv;
            Object element$iv$iv;
            element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            Hyperlink it2 = (Hyperlink)element$iv;
            boolean bl2 = false;
            if (EBayProductUrlNormalizer.normalize$default(urlNormalizer, it2, null, 2, null) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        $this$mapNotNullTo$iv = destination$iv;
        boolean $i$f$map = false;
        void $i$f$mapNotNullTo22 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            element$iv = (Hyperlink)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.createListenableHyperlink((Hyperlink)it, itemOptions.getArgs()));
        }
        List urls = (List)destination$iv$iv;
        this.session.submitAll((Collection)urls);
        this.session.getContext().await();
        this.createInfoFile();
    }

    private final ListenableHyperlink createListenableHyperlink(Hyperlink link, String args) {
        ListenableHyperlink l = new ListenableHyperlink(link);
        l.setArgs(args + " -parse");
        l.getEvent().getLoadEventHandlers().getOnHTMLDocumentParsed().addLast((Function2)new Function2<WebPage, FeaturedDocument, Unit>(this){
            final /* synthetic */ EBayHarvesterStarter this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull WebPage page, @NotNull FeaturedDocument document) {
                Intrinsics.checkNotNullParameter((Object)page, (String)"page");
                Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                String string = page.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
                String url = string;
                if (page.getProtocolStatus().isSuccess() && EBayUrls.INSTANCE.isProductPage(url)) {
                    Path path = EBayHarvesterStarter.access$getHtmlBaseDir$p(this.this$0).resolve(AppPaths.fromUri$default((AppPaths)AppPaths.INSTANCE, (String)url, null, (String)".html", (int)2, null));
                    Files.writeString(path, (CharSequence)document.getOuterHtml(), Charsets.UTF_8, new OpenOption[0]);
                }
            }
        });
        return l;
    }

    private final void createInfoFile() {
        Path path = this.datasetPath.resolve("htmlExportInfo.txt");
        String info = StringsKt.trimIndent((String)("\n            buildTime: " + Instant.now() + "\n            args: " + this.args + "\n        "));
        Files.writeString(path, (CharSequence)info, new OpenOption[0]);
    }

    public static final /* synthetic */ Path access$getHtmlBaseDir$p(EBayHarvesterStarter $this) {
        return $this.htmlBaseDir;
    }
}

