/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.view.builder;

import ai.platon.pulsar.dom.Documents;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.dom.model.FragmentCategory;
import ai.platon.pulsar.dom.model.PageAttribute;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.xml.sax.SAXException;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u0005J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005J\b\u0010\u0017\u001a\u00020\u000fH\u0002J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001a\u0010 \u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lai/platon/scent/view/builder/EntityAttributeBuilderImpl;", "", "()V", "alias2attribute", "Ljava/util/HashMap;", "", "Ljava/util/LinkedList;", "Lai/platon/pulsar/dom/model/PageAttribute;", "configFile", "getConfigFile", "()Ljava/lang/String;", "name2attribute", "pattributes", "Ljava/util/ArrayList;", "buildIndex", "", "cloneByAlias", "aliase", "category", "cloneByAliasOnlyOrNull", "cloneByName", "name", "value", "load", "parse", "doc", "Lai/platon/pulsar/dom/FeaturedDocument;", "parseAttribute", "PageAttribute", "Lorg/jsoup/nodes/Element;", "parentCategory", "Lai/platon/pulsar/dom/model/FragmentCategory;", "parseCategory", "scent-build"})
public final class EntityAttributeBuilderImpl {
    @NotNull
    public static final EntityAttributeBuilderImpl INSTANCE = new EntityAttributeBuilderImpl();
    @NotNull
    private static final String configFile = "config/known-attributes.xml";
    @NotNull
    private static final ArrayList<PageAttribute> pattributes = new ArrayList();
    @NotNull
    private static final HashMap<String, PageAttribute> name2attribute = new HashMap();
    @NotNull
    private static final HashMap<String, LinkedList<PageAttribute>> alias2attribute = new HashMap();

    private EntityAttributeBuilderImpl() {
    }

    @NotNull
    public final String getConfigFile() {
        return configFile;
    }

    @Nullable
    public final PageAttribute cloneByName(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        PageAttribute a = name2attribute.get(name);
        if (a != null) {
            a = new PageAttribute(a.getName(), value, value, a.getExtractor(), a.getValuePath(), a.getCategory(), null, null, 192, null);
        }
        return a;
    }

    @Nullable
    public final PageAttribute cloneByAliasOnlyOrNull(@NotNull String aliase) {
        LinkedList<PageAttribute> attributes;
        LinkedList<PageAttribute> linkedList;
        Intrinsics.checkNotNullParameter((Object)aliase, (String)"aliase");
        PageAttribute PageAttribute2 = this.cloneByName(aliase, "");
        if (PageAttribute2 == null && ((linkedList = (attributes = alias2attribute.get(aliase))) == null ? false : linkedList.size() == 1)) {
            return (PageAttribute)attributes.iterator().next();
        }
        return PageAttribute2;
    }

    @Nullable
    public final PageAttribute cloneByAlias(@NotNull String aliase, @Nullable String category) {
        Intrinsics.checkNotNullParameter((Object)aliase, (String)"aliase");
        PageAttribute PageAttribute2 = this.cloneByName(aliase, "");
        if (PageAttribute2 == null && category != null) {
            LinkedList<PageAttribute> linkedList = alias2attribute.get(aliase);
        }
        return PageAttribute2;
    }

    private final void buildIndex() {
        for (PageAttribute pattribute : pattributes) {
            Map map = name2attribute;
            String string = pattribute.getName();
            Intrinsics.checkNotNullExpressionValue((Object)pattribute, (String)"pattribute");
            PageAttribute pageAttribute = pattribute;
            boolean bl = false;
            map.put(string, pageAttribute);
        }
    }

    private final void load() throws IOException, ParserConfigurationException, SAXException {
        InputStream inputStream = new FileInputStream(configFile);
        Parser parser = Parser.xmlParser();
        Intrinsics.checkNotNullExpressionValue((Object)parser, (String)"xmlParser()");
        FeaturedDocument doc = Documents.INSTANCE.parse(inputStream, "utf-8", "", parser);
        this.parse(doc);
        this.buildIndex();
    }

    private final void parse(FeaturedDocument doc) {
        for (Element category : FeaturedDocument.select$default((FeaturedDocument)doc, (String)"known-attributes > category", (int)0, (int)0, (int)6, null)) {
            Intrinsics.checkNotNullExpressionValue((Object)category, (String)"category");
            this.parseCategory(category, null);
        }
    }

    private final void parseCategory(Element category, FragmentCategory parentCategory) {
        String string = category.attr("name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"category.attr(\"name\")");
        String name = string;
        FragmentCategory entityCategory = new FragmentCategory(name, parentCategory);
        for (Element subCategory : category.select("category > category")) {
            Intrinsics.checkNotNullExpressionValue((Object)subCategory, (String)"subCategory");
            this.parseCategory(subCategory, entityCategory);
        }
        for (Element PageAttribute2 : category.select("category > PageAttribute")) {
            Intrinsics.checkNotNullExpressionValue((Object)PageAttribute2, (String)"PageAttribute");
            PageAttribute entityAttribute = this.parseAttribute(PageAttribute2, entityCategory);
            pattributes.add(entityAttribute);
        }
    }

    private final PageAttribute parseAttribute(Element PageAttribute2, FragmentCategory parentCategory) {
        String string = PageAttribute2.attr("name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PageAttribute.attr(\"name\")");
        String name = string;
        Pattern pattern = Pattern.compile(PageAttribute2.attr("pattern"));
        PageAttribute entityAttribute = new PageAttribute(name, "", null, null, null, null, null, null, 252, null);
        entityAttribute.setCategory(parentCategory);
        HashSet<String> aliasSet = new HashSet<String>();
        for (Element aliases : PageAttribute2.select("PageAttribute > aliases > alias")) {
            aliasSet.add(aliases.text());
        }
        return entityAttribute;
    }
}

