/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.view.builder;

import ai.platon.pulsar.common.Strings;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.dom.DocumentFragment;
import ai.platon.pulsar.dom.model.FragmentCategory;
import ai.platon.pulsar.dom.model.Image;
import ai.platon.pulsar.dom.model.Link;
import ai.platon.pulsar.dom.model.PageAttribute;
import ai.platon.pulsar.dom.model.PageEntity;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.apache.commons.collections4.ComparatorUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001c\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0013J\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016J\u001c\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u0013J\u001c\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u0013J\u000e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lai/platon/scent/view/builder/ExtractPieceFormatter;", "", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "keepMetadata", "", "getKeepMetadata", "()Z", "formatImage", "", "image", "Lai/platon/pulsar/dom/model/Image;", "formatImages", "fragment", "Lai/platon/pulsar/dom/DocumentFragment;", "images", "", "formatLink", "link", "Lai/platon/pulsar/dom/model/Link;", "formatLinkImages", "links", "formatLinks", "formatPageEntity", "pageEntity", "Lai/platon/pulsar/dom/model/PageEntity;", "scent-build"})
public final class ExtractPieceFormatter {
    @NotNull
    private final ImmutableConfig conf;
    private final boolean keepMetadata;

    public ExtractPieceFormatter(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.conf = conf;
        this.keepMetadata = this.conf.getBoolean("scent.extract.keep.element.metadata", false);
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    public final boolean getKeepMetadata() {
        return this.keepMetadata;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String formatLink(@NotNull Link link) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        StringBuilder s = new StringBuilder();
        Map $this$map$iv = link.getAttributes();
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var8_8 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var8_8.entrySet().iterator();
        while (iterator.hasNext()) {
            void $dstr$k$v;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            void var14_14 = $dstr$k$v;
            boolean bl3 = false;
            String k = (String)var14_14.getKey();
            void var15_15 = $dstr$k$v;
            boolean bl4 = false;
            String v = (String)var15_15.getValue();
            String string = "<a " + k + "='" + v + "'>";
            collection.add(string);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        if (link.getImage() != null) {
            s.append(String.valueOf(link.getImage()));
        }
        s.append(link.getText());
        s.append("</a>");
        String string = s.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"s.toString()");
        return string;
    }

    @NotNull
    public final String formatImage(@NotNull Image image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        StringBuilder img = new StringBuilder();
        img.append("<img ");
        int i = 0;
        Object object = image.getAttributes();
        boolean bl = false;
        Object object2 = object.entrySet().iterator();
        while (object2.hasNext()) {
            Object object3 = object = object2.next();
            int n = 0;
            String name = (String)object3.getKey();
            Object object4 = object;
            boolean bl2 = false;
            String value = (String)object4.getValue();
            n = i;
            i = n + 1;
            if (n > 0) {
                img.append(' ');
            }
            img.append(name);
            img.append("='");
            img.append(value);
            img.append("'");
        }
        img.append("/>");
        object2 = img.toString();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"img.toString()");
        return object2;
    }

    @NotNull
    public final String formatLinks(@NotNull DocumentFragment fragment, @NotNull Iterable<Link> links) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter(links, (String)"links");
        StringBuilder linkStr = new StringBuilder();
        if (this.keepMetadata) {
            String cls = Strings.csslize((String)CollectionsKt.joinToString$default((Iterable)fragment.getLabels(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            String extractor = Strings.csslize((String)this.getClass().getSimpleName());
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "<div class='%s' data-extractor='%s'>";
            Object[] objectArray = new Object[]{cls, extractor};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            linkStr.append(string2);
        } else {
            linkStr.append("<div>");
        }
        for (Link link : links) {
            linkStr.append(link.toString());
        }
        linkStr.append("</div>");
        String string = linkStr.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"linkStr.toString()");
        return string;
    }

    @NotNull
    public final String formatImages(@NotNull DocumentFragment fragment, @NotNull Iterable<Image> images) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter(images, (String)"images");
        StringBuilder gallery = new StringBuilder();
        if (this.keepMetadata) {
            String cls = Strings.csslize((String)CollectionsKt.joinToString$default((Iterable)fragment.getLabels(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            String extractor = Strings.csslize((String)this.getClass().getSimpleName());
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "<div class='%s' data-extractor='%s'>";
            Object[] objectArray = new Object[]{cls, extractor};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            gallery.append(string2);
        } else {
            gallery.append("<div>");
        }
        for (Image image : images) {
            gallery.append(image.toString());
        }
        gallery.append("</div>");
        String string = gallery.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gallery.toString()");
        return string;
    }

    @NotNull
    public final String formatLinkImages(@NotNull DocumentFragment fragment, @NotNull Iterable<Link> links) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter(links, (String)"links");
        StringBuilder linkStr = new StringBuilder();
        if (this.keepMetadata) {
            String cls = Strings.csslize((String)CollectionsKt.joinToString$default((Iterable)fragment.getLabels(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            String extractor = Strings.csslize((String)this.getClass().getSimpleName());
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "<div class='%s' data-extractor='%s'>";
            Object[] objectArray = new Object[]{cls, extractor};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            linkStr.append(string2);
        } else {
            linkStr.append("<div>");
        }
        for (Link link : links) {
            linkStr.append("<div>");
            linkStr.append(link.toString());
            linkStr.append("</div>");
        }
        linkStr.append("</div>");
        String string = linkStr.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"linkStr.toString()");
        return string;
    }

    @NotNull
    public final String formatPageEntity(@NotNull PageEntity pageEntity) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)pageEntity, (String)"pageEntity");
        StringBuilder reporter = new StringBuilder();
        Formatter formatter = new Formatter(reporter, Locale.SIMPLIFIED_CHINESE);
        int counter = 0;
        TreeMultimap categorySortedAttributes = TreeMultimap.create((Comparator)ComparatorUtils.reversedComparator((Comparator)ComparatorUtils.NATURAL_COMPARATOR), (Comparator)ComparatorUtils.NATURAL_COMPARATOR);
        for (PageAttribute attr : pageEntity.getAttributes().values()) {
            FragmentCategory fragmentCategory;
            if (attr.getCategory() != null) {
                ++counter;
            }
            categorySortedAttributes.put((fragmentCategory = attr.getCategory()) == null ? "" : ((objectArray = fragmentCategory.getFullName()) == null ? "" : objectArray), (Object)attr);
        }
        Object object = new Object[]{pageEntity.getAttributes().size(), counter};
        formatter.format("\n\n total attributeRow : %d, categorized : %d \n\n", (Object[])object);
        for (PageAttribute attr : categorySortedAttributes.values()) {
            String string;
            String value = StringsKt.take((String)attr.getRichText(), (int)20);
            objectArray = Strings.stripNonCJKChar((String)value, (String)"~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./' \n\r\t");
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"stripNonCJKChar(value, Strings.DEFAULT_KEEP_CHARS)");
            value = objectArray;
            objectArray = new Object[3];
            FragmentCategory fragmentCategory = attr.getCategory();
            objectArray[0] = fragmentCategory == null ? null : ((string = fragmentCategory.getFullName()) == null ? null : StringsKt.take((String)string, (int)20));
            objectArray[1] = StringsKt.take((String)attr.getName(), (int)12);
            objectArray[2] = value;
            formatter.format("%-20s %-15s %-120s\n", objectArray);
        }
        reporter.append("\n");
        object = reporter.toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"reporter.toString()");
        return object;
    }
}

