/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.view.builder;

import ai.platon.pulsar.common.Strings;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.dom.Documents;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.dom.model.FragmentCategory;
import ai.platon.pulsar.dom.model.PageAttribute;
import ai.platon.pulsar.dom.model.PageEntity;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.pulsar.dom.select.QueriesKt;
import ai.platon.scent.view.builder.EntityViewBuilder;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u001e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u001e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0004J\u001e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000eH\u0002J\u0006\u0010\u0019\u001a\u00020\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lai/platon/scent/view/builder/GalleryBuilder;", "Lai/platon/scent/view/builder/EntityViewBuilder;", "pageEntity", "Lai/platon/pulsar/dom/model/PageEntity;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/dom/model/PageEntity;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "doc", "Lai/platon/pulsar/dom/FeaturedDocument;", "template", "", "build", "", "buildGallery", "Lorg/jsoup/nodes/Element;", "root", "attributes", "", "Lai/platon/pulsar/dom/model/PageAttribute;", "buildImages", "buildLinks", "buildTable", "getWidth", "", "ele", "process", "Companion", "scent-build"})
public final class GalleryBuilder
extends EntityViewBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String template;
    @NotNull
    private final FeaturedDocument doc;
    @NotNull
    private static final String[] labels;

    public GalleryBuilder(@NotNull PageEntity pageEntity, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)pageEntity, (String)"pageEntity");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        super(pageEntity, conf);
        this.template = "wwwroot/template/page-entity-gallery-template.html";
        this.doc = Documents.INSTANCE.parse(new File(this.template), "utf-8");
    }

    /*
     * WARNING - void declaration
     */
    public final void process() {
        Element element = FeaturedDocument.select$default((FeaturedDocument)this.doc, (String)"body", (int)0, (int)0, (int)6, null).first();
        Intrinsics.checkNotNull((Object)element);
        Element element2 = element;
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"doc.select(\"body\").first()!!");
        Element body = element2;
        Object object = new String[]{"ProductSpec", "TitleContainer", "Metadata"};
        ArrayList tableLabels = Lists.newArrayList((Object[])object);
        object = labels;
        int n = 0;
        int n2 = ((Object[])object).length;
        while (n < n2) {
            void $this$filterTo$iv$iv;
            Object label = object[n];
            ++n;
            String section = Strings.humanize((String)label);
            Collection collection = this.getPageEntity().getAttributes().values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"pageEntity.attributes.values");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter22 = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PageAttribute it = (PageAttribute)element$iv$iv;
                boolean bl = false;
                FragmentCategory fragmentCategory = it.getCategory();
                if (!Intrinsics.areEqual((Object)(fragmentCategory == null ? null : fragmentCategory.getName()), (Object)label)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List attributes = (List)destination$iv$iv;
            if (attributes.isEmpty()) continue;
            Element $i$f$filter22 = body.appendElement("div");
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$filter22, (String)"body.appendElement(\"div\")");
            Element div = $i$f$filter22;
            div.attr("class", section);
            if (!Intrinsics.areEqual((Object)label, (Object)"Title")) {
                div.appendElement("h2").text(section);
            }
            if (Intrinsics.areEqual((Object)label, (Object)"Title")) {
                String title = ((PageAttribute)CollectionsKt.first((List)attributes)).getValue();
                div.appendElement("h1").text(title);
                this.doc.getDocument().title(title);
            } else if (tableLabels.contains(label)) {
                this.buildTable(div, attributes);
            } else if (Intrinsics.areEqual((Object)label, (Object)"Images")) {
                this.buildImages(div, attributes);
            } else if (Intrinsics.areEqual((Object)label, (Object)"SimilarEntity")) {
                this.buildLinks(div, attributes);
            } else if (Intrinsics.areEqual((Object)label, (Object)"Gallery")) {
                this.buildGallery(div, attributes);
            } else if (Intrinsics.areEqual((Object)label, (Object)"Categories")) {
                div.appendElement("div").text(((PageAttribute)CollectionsKt.first((List)attributes)).getValue());
            }
            body.appendElement("hr");
        }
        for (Element img : QueriesKt.select2$default((Node)((Node)body), (String)"img", (int)0, (int)0, (int)6, null)) {
            Intrinsics.checkNotNullExpressionValue((Object)img, (String)"img");
            if (NodeExtKt.getWidth((Node)((Node)img)) > 500) {
                img.remove();
            }
            img.removeAttr("width");
            img.removeAttr("height");
        }
    }

    @NotNull
    public final FeaturedDocument doc() {
        return this.doc;
    }

    private final Element buildGallery(Element root, Collection<PageAttribute> attributes) {
        for (PageAttribute attr : attributes) {
            root.append(attr.getValue());
        }
        return root;
    }

    private final Element buildImages(Element root, Collection<PageAttribute> attributes) {
        for (PageAttribute attr : attributes) {
            if (attr.hasCategory("Links") || attr.hasCategory("Gallery")) continue;
            root.append(attr.getValue());
        }
        return root;
    }

    @NotNull
    protected final Element buildLinks(@NotNull Element root, @NotNull Collection<PageAttribute> attributes) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        for (PageAttribute attr : attributes) {
            root.append(attr.getValue());
        }
        return root;
    }

    @NotNull
    protected final Element buildTable(@NotNull Element root, @NotNull Collection<PageAttribute> attributes) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Element element = root.appendElement("table");
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"root.appendElement(\"table\")");
        Element table = element;
        for (PageAttribute attr : attributes) {
            if (attr.getValue().length() > 50) continue;
            Element element2 = table.appendElement("tr");
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"table.appendElement(\"tr\")");
            Element tr = element2;
            Element element3 = tr.appendElement("td");
            Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"tr.appendElement(\"td\")");
            Element th = element3;
            Element element4 = tr.appendElement("td");
            Intrinsics.checkNotNullExpressionValue((Object)element4, (String)"tr.appendElement(\"td\")");
            Element td = element4;
            th.text(attr.getName());
            td.text(attr.getValue());
        }
        return table;
    }

    private final int getWidth(Element ele) {
        try {
            return Integer.parseInt(ele.attr("width"));
        }
        catch (Exception exception) {
            return -1;
        }
    }

    @Override
    public void build() {
    }

    static {
        String[] stringArray = new String[]{"Title", "Categories", "Metadata", "Gallery", "TitleContainer", "ProductSpec", "Images", "SimilarEntity", "Links"};
        labels = stringArray;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lai/platon/scent/view/builder/GalleryBuilder$Companion;", "", "()V", "labels", "", "", "[Ljava/lang/String;", "scent-build"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

