/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.view.builder;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.OpenMapTable;
import ai.platon.pulsar.common.ResourceLoader;
import ai.platon.pulsar.dom.Documents;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.dom.model.Image;
import ai.platon.pulsar.dom.model.ModelsKt;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.scent.entities.PageTableGroup;
import ai.platon.scent.entities.PageTableKt;
import ai.platon.scent.entities.TableData;
import ai.platon.scent.view.builder.TableViewBuilder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.slf4j.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0001#B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0014H\u0002J\u001e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u001e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00142\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u001eH\u0002J\u001a\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00142\b\b\u0002\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lai/platon/scent/view/builder/PageTableViewBuilder;", "Lai/platon/scent/view/builder/TableViewBuilder;", "tableGroup", "Lai/platon/scent/entities/PageTableGroup;", "devMode", "", "(Lai/platon/scent/entities/PageTableGroup;Z)V", "logger", "Lorg/slf4j/Logger;", "sampleTable", "Lai/platon/pulsar/common/OpenMapTable;", "getTableGroup", "()Lai/platon/scent/entities/PageTableGroup;", "tables", "", "build", "Lai/platon/pulsar/dom/FeaturedDocument;", "buildGeneratedHyperPaths", "", "rootElement", "Lorg/jsoup/nodes/Element;", "table", "buildGeneratedXSQL", "buildLinkSnapshot", "contentView", "rows", "", "Lai/platon/pulsar/common/OpenMapTable$Row;", "root", "elements", "", "buildLinkTable", "n", "", "buildMLStatistics", "Companion", "scent-build"})
public final class PageTableViewBuilder
extends TableViewBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PageTableGroup tableGroup;
    @NotNull
    private final Logger logger;
    @NotNull
    private final List<OpenMapTable> tables;
    private OpenMapTable sampleTable;
    @NotNull
    private static final String resource = "wwwroot/template/page.table.html";
    @NotNull
    private static final String template = ResourceLoader.INSTANCE.readString("wwwroot/template/page.table.html");

    public PageTableViewBuilder(@NotNull PageTableGroup tableGroup, boolean devMode) {
        Intrinsics.checkNotNullParameter((Object)tableGroup, (String)"tableGroup");
        super(devMode);
        this.tableGroup = tableGroup;
        this.logger = LogsKt.getLogger((Object)this);
        this.tables = this.tableGroup.getTables();
    }

    public /* synthetic */ PageTableViewBuilder(PageTableGroup pageTableGroup, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(pageTableGroup, bl);
    }

    @NotNull
    public final PageTableGroup getTableGroup() {
        return this.tableGroup;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FeaturedDocument build() {
        void $this$forEachIndexed$iv;
        OpenMapTable openMapTable;
        FeaturedDocument output = Documents.INSTANCE.parse(template, "");
        output.getDocument().outputSettings().prettyPrint(false);
        Element element = output.getBody().selectFirst("div#page-message");
        Intrinsics.checkNotNull((Object)element);
        Element element2 = element;
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"output.body.selectFirst(\"div#page-message\")!!");
        Element messageView = element2;
        element2 = (OpenMapTable)CollectionsKt.lastOrNull(this.tables);
        this.sampleTable = element2 == null ? new OpenMapTable(0, 0, 2, null) : element2;
        String host = this.tableGroup.getPortalUrl().getUrl().getHost();
        OpenMapTable openMapTable2 = this.sampleTable;
        if (openMapTable2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sampleTable");
            openMapTable = null;
        } else {
            openMapTable = openMapTable2;
        }
        int documentSize = PageTableKt.getData((OpenMapTable)openMapTable).getDocumentSize();
        output.getDocument().title("PLATON AI - Auto Web Mining - " + host);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "Total %d pages, generated %d tables";
        Object[] objectArray = new Object[]{documentSize, this.tables.size()};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        String caption = string2;
        messageView.appendElement("div").text(caption);
        messageView.appendElement("div").text(LocalDateTime.now().toString());
        messageView.appendElement("hr");
        messageView.appendElement("div").text(this.tableGroup.getCommand());
        Element element3 = output.getBody().selectFirst("div#tables");
        Intrinsics.checkNotNull((Object)element3);
        string = element3;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"output.body.selectFirst(\"div#tables\")!!");
        String tableListView = string;
        Iterable $this$sortedBy$iv = this.tables;
        boolean $i$f$sortedBy = false;
        bl = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                OpenMapTable it = (OpenMapTable)a;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(PageTableKt.getData((OpenMapTable)it).getAlignedTop());
                it = (OpenMapTable)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = PageTableKt.getData((OpenMapTable)it).getAlignedTop();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void table;
            int n = index$iv++;
            boolean bl2 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            OpenMapTable openMapTable3 = (OpenMapTable)item$iv;
            int i = n;
            boolean bl3 = false;
            TableData tableData = PageTableKt.getData((OpenMapTable)table);
            String message = "<div class='message'><i class='no'>" + (1 + i) + ".</i>e<b>X</b>tracted <em>" + (table.getNumColumns() - 2) + "</em> fields from page area <b>" + PageTableKt.getData((OpenMapTable)table).getName() + "</b></div>";
            tableListView.appendElement("div").html(message);
            tableListView.append(TableViewBuilder.buildPageTable$default(this, (OpenMapTable)table, null, 2, null));
            if (this.getDevMode() && !tableData.isCombined()) {
                this.buildGeneratedHyperPaths((Element)tableListView, (OpenMapTable)table);
                tableListView.appendElement("br");
                this.buildGeneratedXSQL((Element)tableListView, (OpenMapTable)table);
                tableListView.appendElement("br");
                this.buildMLStatistics((Element)tableListView, (OpenMapTable)table);
            }
            tableListView.appendElement("br");
        }
        return output;
    }

    /*
     * WARNING - void declaration
     */
    private final void buildMLStatistics(Element rootElement, OpenMapTable table) {
        void $this$forEach$iv;
        Element element = rootElement.appendElement("div").addClass("-hidden").addClass("statistics");
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"rootElement.appendElemen\u2026  .addClass(\"statistics\")");
        Element div = element;
        div.appendElement("h2").text("Machine Learning Statistics");
        Element element2 = div.appendElement("dl");
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"div.appendElement(\"dl\")");
        Element dl = element2;
        TableData d = PageTableKt.getData((OpenMapTable)table);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"score", (Object)d.getScore()), TuplesKt.to((Object)"distortion", (Object)d.getDistortion()), TuplesKt.to((Object)"macroP", (Object)d.getMacroP()), TuplesKt.to((Object)"macroR", (Object)d.getMacroR()), TuplesKt.to((Object)"macroF1", (Object)d.getMacroF1()), TuplesKt.to((Object)"microP", (Object)d.getMicroP()), TuplesKt.to((Object)"microR", (Object)d.getMicroR()), TuplesKt.to((Object)"microF1", (Object)d.getMicroF1()), TuplesKt.to((Object)"ff", (Object)d.getFf()), TuplesKt.to((Object)"ffr", (Object)d.getFfr())};
        boolean $i$f$forEach = false;
        void var8_8 = $this$forEach$iv;
        int n = ((void)var8_8).length;
        for (int i = 0; i < n; ++i) {
            void element$iv;
            void $dstr$name$value = element$iv = var8_8[i];
            boolean bl = false;
            String name = (String)$dstr$name$value.component1();
            Object value = $dstr$name$value.component2();
            dl.append("<dt>" + name + "</dt><dd>" + value + "</dd>");
        }
    }

    private final void buildGeneratedHyperPaths(Element rootElement, OpenMapTable table) {
        Element element = rootElement.appendElement("div").addClass("-hidden").addClass("css-paths");
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"rootElement.appendElemen\u2026   .addClass(\"css-paths\")");
        Element div = element;
        div.appendElement("h2").text("Generated CSS Paths");
        Element element2 = div.appendElement("dl");
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"div.appendElement(\"dl\")");
        Element dl = element2;
        OpenMapTable.Column[] $this$forEach$iv = table.getColumns();
        boolean $i$f$forEach = false;
        OpenMapTable.Column[] columnArray = $this$forEach$iv;
        int n = columnArray.length;
        for (int i = 0; i < n; ++i) {
            String string;
            OpenMapTable.Column element$iv;
            OpenMapTable.Column column = element$iv = columnArray[i];
            boolean bl = false;
            String string2 = PageTableKt.getData((OpenMapTable.Column)column).getHyperPath();
            boolean bl2 = false;
            boolean bl3 = false;
            String it = string2;
            boolean bl4 = false;
            CharSequence charSequence = it;
            boolean bl5 = false;
            String string3 = string = !StringsKt.isBlank((CharSequence)charSequence) ? string2 : null;
            if (string == null) continue;
            string2 = string;
            bl2 = false;
            bl3 = false;
            it = string2;
            boolean bl6 = false;
            dl.append("<dt>" + column.getName() + "</dt><dd>" + it + "</dd>");
        }
    }

    private final void buildGeneratedXSQL(Element rootElement, OpenMapTable table) {
        Element element = rootElement.appendElement("div").addClass("-hidden").addClass("x-sql");
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"rootElement.appendElemen\u2026       .addClass(\"x-sql\")");
        Element div = element;
        div.appendElement("h2").text("Generated X-SQL");
        div.append("<pre>\n" + PageTableKt.getData((OpenMapTable)table).getXsql() + "\n</pre>");
    }

    /*
     * WARNING - void declaration
     */
    private final void buildLinkSnapshot(Element contentView) {
        void $this$mapTo$iv$iv;
        if (this.tables.isEmpty()) {
            return;
        }
        int sampleSize = 10;
        OpenMapTable table = (OpenMapTable)CollectionsKt.first(this.tables);
        List samples = CollectionsKt.take((Iterable)table.getRows(), (int)sampleSize);
        Iterable $this$map$iv = samples;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            OpenMapTable.Row row = (OpenMapTable.Row)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = PageTableKt.getData((OpenMapTable.Row)it).getLocation();
            collection.add(string);
        }
        List sampleUrls = (List)destination$iv$iv;
        contentView.appendElement("div").text("Show " + samples.size() + "/" + table.getNumRows() + " pages: ");
        this.buildLinkSnapshot(contentView, samples);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildLinkSnapshot(Element contentView, Collection<OpenMapTable.Row> rows) {
        Element element = contentView.appendElement("ul");
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"contentView.appendElement(\"ul\")");
        Element ul = element;
        Iterable $this$forEachIndexed$iv = rows;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void row;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            OpenMapTable.Row row2 = (OpenMapTable.Row)item$iv;
            int i = n;
            boolean bl2 = false;
            String uri = PageTableKt.getData((OpenMapTable.Row)row).getLocation();
            String title = PageTableKt.getData((OpenMapTable.Row)row).getTitle();
            Element element2 = ul.appendElement("li");
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"ul.appendElement(\"li\")");
            Element li = element2;
            li.appendElement("span").html(1 + i + ".&nbsp;");
            li.appendElement("a").attr("href", uri).attr("target", "_blank").text(title);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildLinkSnapshot(Element root, Iterable<? extends Element> elements) {
        Element element = root.appendElement("ul");
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"root.appendElement(\"ul\")");
        Element ul = element;
        Iterable<? extends Element> $this$forEachIndexed$iv = elements;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Element element2 : $this$forEachIndexed$iv) {
            void it;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Element element22 = element2;
            int i = n;
            boolean bl2 = false;
            Element element3 = ul.appendElement("li");
            Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"ul.appendElement(\"li\")");
            Element li = element3;
            li.appendElement("span").html(1 + i + ".&nbsp;");
            Element element4 = li.appendElement("a").attr("href", NodeExtKt.getLocation((Node)((Node)it))).attr("target", "_blank");
            Document document = it.ownerDocument();
            Intrinsics.checkNotNull((Object)document);
            element4.text(document.title());
            if (!NodeExtKt.isImage((Node)((Node)it))) continue;
            Image image = ModelsKt.createImage$default((Element)it, (boolean)false, (boolean)false, (int)6, null);
            Map map = image.getAttributes();
            String string = "width";
            String string2 = "200";
            boolean bl3 = false;
            map.put(string, string2);
            map = image.getAttributes();
            string = "height";
            string2 = "200";
            bl3 = false;
            map.put(string, string2);
            li.appendElement(image.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildLinkTable(Element root, int n) {
        if (this.tables.isEmpty()) {
            return;
        }
        OpenMapTable table = (OpenMapTable)CollectionsKt.first(this.tables);
        List rows = CollectionsKt.take((Iterable)table.getRows(), (int)n);
        root.appendElement("hr");
        root.appendElement("div").text("Show " + rows.size() + "/" + table.getRows().size() + " pages: ");
        Element element = root.appendElement("table");
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"root.appendElement(\"table\")");
        Element tableElement = element;
        Element tr = null;
        Element element2 = tableElement.appendElement("tr");
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"tableElement.appendElement(\"tr\")");
        tr = element2;
        tr.append("<th>&nbsp;</th><th>Title</th><th>Url</th>");
        Iterable $this$forEachIndexed$iv = rows;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void row;
            int n2 = index$iv++;
            boolean bl = false;
            if (n2 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            OpenMapTable.Row row2 = (OpenMapTable.Row)item$iv;
            int i = n2;
            boolean bl2 = false;
            String uri = PageTableKt.getData((OpenMapTable.Row)row).getLocation();
            String displayUri = StringUtils.abbreviateMiddle((String)PageTableKt.getData((OpenMapTable.Row)row).getLocation(), (String)"..", (int)200);
            String exportPath = PageTableKt.getData((OpenMapTable.Row)row).getExportPath();
            String title = PageTableKt.getData((OpenMapTable.Row)row).getTitle();
            Element element3 = tableElement.appendElement("tr");
            Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"tableElement.appendElement(\"tr\")");
            tr = element3;
            tr.appendElement("td").text(String.valueOf(1 + i));
            tr.appendElement("td").appendElement("a").attr("href", exportPath.toString()).attr("target", "_blank").text(title);
            tr.appendElement("td").appendElement("a").attr("href", uri).attr("target", "_blank").text(displayUri);
        }
    }

    static /* synthetic */ void buildLinkTable$default(PageTableViewBuilder pageTableViewBuilder, Element element, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 50;
        }
        pageTableViewBuilder.buildLinkTable(element, n);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/platon/scent/view/builder/PageTableViewBuilder$Companion;", "", "()V", "resource", "", "template", "scent-build"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

