/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.view.builder;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.dom.model.PageAttribute;
import ai.platon.pulsar.dom.model.PageEntity;
import ai.platon.scent.view.builder.EntityViewBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0004J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0004J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0004J\b\u0010\u000e\u001a\u00020\nH\u0004J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0004J\b\u0010\u0010\u001a\u00020\bH\u0004J\b\u0010\u0011\u001a\u00020\bH\u0004\u00a8\u0006\u0012"}, d2={"Lai/platon/scent/view/builder/ProductBuilder;", "Lai/platon/scent/view/builder/EntityViewBuilder;", "pageEntity", "Lai/platon/pulsar/dom/model/PageEntity;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/dom/model/PageEntity;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "build", "", "buildCategoryNavigator", "", "buildProductIntroducePageTitle", "pageEntityTitle", "buildProductName", "buildProductTitle", "buildProductTradePageTitle", "rebuildManufacturer", "rebuildModelNumber", "scent-build"})
public class ProductBuilder
extends EntityViewBuilder {
    public ProductBuilder(@NotNull PageEntity pageEntity, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)pageEntity, (String)"pageEntity");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        super(pageEntity, conf);
    }

    @NotNull
    protected final String buildProductName(@NotNull String pageEntityTitle) {
        Intrinsics.checkNotNullParameter((Object)pageEntityTitle, (String)"pageEntityTitle");
        String pageEntityName = this.getPageEntity().firstText("\u4ea7\u54c1\u540d\u79f0");
        CharSequence charSequence = pageEntityName;
        boolean bl = false;
        if (charSequence.length() == 0) {
            pageEntityName = pageEntityTitle;
        }
        return pageEntityName;
    }

    @NotNull
    protected final String buildCategoryNavigator() {
        String[] categories;
        int n;
        StringBuilder sb = new StringBuilder();
        String categoryNav = this.getPageEntity().firstText("categories");
        CharSequence charSequence = categoryNav;
        int n2 = 0;
        if (charSequence.length() == 0) {
            categoryNav = this.getPageEntity().firstText("Categories");
        }
        charSequence = categoryNav;
        n2 = 0;
        if (!(charSequence.length() == 0) && (n2 = 0) <= (n = (categories = StringUtils.split((String)categoryNav, (String)" > ")).length + -1)) {
            do {
                int i = n2++;
                sb.append("[[:Category:");
                sb.append(categories[i]);
                sb.append("]]");
                if (i < categories.length - 1) {
                    sb.append(" > ");
                    continue;
                }
                sb.append("\n");
                sb.append("[[Category:");
                sb.append(categories[i]);
                sb.append("]]");
            } while (n2 <= n);
        }
        charSequence = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"sb.toString()");
        return charSequence;
    }

    @NotNull
    protected final String buildProductTitle() {
        PageAttribute manufacturer = this.getPageEntity().first("\u751f\u4ea7\u5546");
        PageAttribute brand = this.getPageEntity().first("\u54c1\u724c");
        PageAttribute name = this.getPageEntity().first("\u4ea7\u54c1\u540d\u79f0");
        PageAttribute model = this.getPageEntity().first("\u4ea7\u54c1\u578b\u53f7");
        StringBuilder sb = new StringBuilder();
        if (name != null) {
            if (manufacturer != null) {
                sb.append(manufacturer.getName());
            }
            sb.append(' ');
            if (brand != null) {
                sb.append(brand.getName());
            }
            sb.append(' ');
            sb.append(name.getName());
            sb.append(' ');
            if (model != null) {
                sb.append(model.getName());
            }
            sb.append(' ');
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        String pageEntityTitle = string;
        if (pageEntityTitle.length() < 10) {
            pageEntityTitle = "";
        }
        if (StringUtils.isEmpty((CharSequence)pageEntityTitle)) {
            pageEntityTitle = this.getPageEntity().firstText("Title");
        }
        if (StringUtils.isEmpty((CharSequence)pageEntityTitle)) {
            pageEntityTitle = this.getPageEntity().firstText("meta-title");
        }
        return pageEntityTitle;
    }

    @NotNull
    protected final String buildProductTradePageTitle(@NotNull String pageEntityTitle) {
        Intrinsics.checkNotNullParameter((Object)pageEntityTitle, (String)"pageEntityTitle");
        String domain = this.getPageEntity().firstText("domain");
        return "\u8d2d\u7269\u901a\u9053\uff1a" + domain + " - " + pageEntityTitle;
    }

    @NotNull
    protected final String buildProductIntroducePageTitle(@NotNull String pageEntityTitle) {
        Intrinsics.checkNotNullParameter((Object)pageEntityTitle, (String)"pageEntityTitle");
        return "\u4ea7\u54c1\u4ecb\u7ecd\uff1a" + pageEntityTitle;
    }

    protected final void rebuildModelNumber() {
    }

    protected final void rebuildManufacturer() {
    }

    @Override
    public void build() {
    }
}

