/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.view.builder;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.ResourceLoader;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.dom.model.FragmentCategory;
import ai.platon.pulsar.dom.model.PageAttribute;
import ai.platon.pulsar.dom.model.PageEntity;
import ai.platon.scent.view.builder.EntityViewBuilder;
import ai.platon.scent.view.builder.ProductBuilder;
import ai.platon.scent.view.template.MiniTemplator;
import ai.platon.scent.view.wiki.Page;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u0000 !2\u00020\u0001:\u0001!B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0019\u001a\u00020\bJ\b\u0010\u001a\u001a\u00020\u0016H\u0002J\b\u0010\u001b\u001a\u00020\u0016H\u0002J\b\u0010\u001c\u001a\u00020\u0016H\u0002J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0002J\b\u0010\u001f\u001a\u00020\bH\u0016J\u0006\u0010 \u001a\u00020\u0018R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\fRN\u0010\u0013\u001aB\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00160\u0016 \u0015* \u0012\f\u0012\n \u0015*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00160\u0016\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lai/platon/scent/view/builder/ProductWikiBuilder;", "Lai/platon/scent/view/builder/ProductBuilder;", "pageEntity", "Lai/platon/pulsar/dom/model/PageEntity;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/dom/model/PageEntity;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "pageEntityCategory", "", "getPageEntityCategory$scent_build", "()Ljava/lang/String;", "setPageEntityCategory$scent_build", "(Ljava/lang/String;)V", "pageEntityName", "getPageEntityName$scent_build", "setPageEntityName$scent_build", "pageEntityTitle", "getPageEntityTitle$scent_build", "setPageEntityTitle$scent_build", "pages", "Ljava/util/HashMap;", "kotlin.jvm.PlatformType", "Lai/platon/scent/view/wiki/Page;", "build", "", "pageType", "buildDetailPage", "buildProductPage", "buildTradePage", "html2wiki", "html", "toString", "upload", "Companion", "scent-build"})
public final class ProductWikiBuilder
extends ProductBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String pageEntityTitle;
    @Nullable
    private String pageEntityName;
    @Nullable
    private String pageEntityCategory;
    private final HashMap<String, Page> pages;

    public ProductWikiBuilder(@NotNull PageEntity pageEntity, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)pageEntity, (String)"pageEntity");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        super(pageEntity, conf);
        this.pages = Maps.newHashMap();
        String string = this.pageEntityTitle = this.buildProductTitle();
        Intrinsics.checkNotNull((Object)string);
        this.pageEntityName = this.buildProductName(string);
        this.pageEntityCategory = this.buildCategoryNavigator();
        try {
            InputStream stream;
            String[] stringArray = new String[]{"template"};
            FileUtils.forceMkdir((File)AppPaths.INSTANCE.get("wwwroot", stringArray).toFile());
            String name = "";
            if (!Files.exists(ProductWikiBuilder.Companion.getProductTemplatePath(), new LinkOption[0])) {
                name = "wwwroot/template/product.template.wiki";
                InputStream inputStream = ResourceLoader.INSTANCE.getResourceAsStream(name);
                Intrinsics.checkNotNull((Object)inputStream);
                stream = inputStream;
                Files.copy(stream, ProductWikiBuilder.Companion.getProductTemplatePath(), new CopyOption[0]);
                stream.close();
            }
            if (!Files.exists(ProductWikiBuilder.Companion.getProductTradeTemplatePath(), new LinkOption[0])) {
                name = "wwwroot/template/product.trade.template.wiki";
                InputStream inputStream = ResourceLoader.INSTANCE.getResourceAsStream(name);
                Intrinsics.checkNotNull((Object)inputStream);
                stream = inputStream;
                Files.copy(stream, ProductWikiBuilder.Companion.getProductTradeTemplatePath(), new CopyOption[0]);
                stream.close();
            }
            if (!Files.exists(ProductWikiBuilder.Companion.getProductIntroduceTemplatePath(), new LinkOption[0])) {
                name = "wwwroot/template/product.introduce.template.wiki";
                InputStream inputStream = ResourceLoader.INSTANCE.getResourceAsStream(name);
                Intrinsics.checkNotNull((Object)inputStream);
                stream = inputStream;
                Files.copy(stream, ProductWikiBuilder.Companion.getProductIntroduceTemplatePath(), new CopyOption[0]);
                stream.close();
            }
        }
        catch (IOException e) {
            EntityViewBuilder.Companion.getLog().error(e.toString());
        }
    }

    @Nullable
    public final String getPageEntityTitle$scent_build() {
        return this.pageEntityTitle;
    }

    public final void setPageEntityTitle$scent_build(@Nullable String string) {
        this.pageEntityTitle = string;
    }

    @Nullable
    public final String getPageEntityName$scent_build() {
        return this.pageEntityName;
    }

    public final void setPageEntityName$scent_build(@Nullable String string) {
        this.pageEntityName = string;
    }

    @Nullable
    public final String getPageEntityCategory$scent_build() {
        return this.pageEntityCategory;
    }

    public final void setPageEntityCategory$scent_build(@Nullable String string) {
        this.pageEntityCategory = string;
    }

    @Override
    public void build() {
        Map<String, Page> map = this.pages;
        Intrinsics.checkNotNullExpressionValue(map, (String)"pages");
        map = map;
        String string = "ProductPage";
        Page page = this.buildProductPage();
        boolean bl = false;
        map.put(string, page);
        map = this.pages;
        Intrinsics.checkNotNullExpressionValue(map, (String)"pages");
        string = "TradePage";
        page = this.buildTradePage();
        bl = false;
        map.put(string, page);
        map = this.pages;
        Intrinsics.checkNotNullExpressionValue(map, (String)"pages");
        string = "DetailPage";
        page = this.buildDetailPage();
        bl = false;
        map.put(string, page);
    }

    @Nullable
    public final Page build(@NotNull String pageType) {
        Intrinsics.checkNotNullParameter((Object)pageType, (String)"pageType");
        Page page = null;
        int n = -1;
        switch (pageType.hashCode()) {
            case 176110590: {
                if (pageType.equals("ProductPage")) {
                    n = 1;
                }
                break;
            }
            case -1538222605: {
                if (pageType.equals("TradePage")) {
                    n = 2;
                }
                break;
            }
            case 957037216: {
                if (pageType.equals("DetailPage")) {
                    n = 3;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                page = this.buildProductPage();
                break;
            }
            case 2: {
                page = this.buildTradePage();
                break;
            }
            case 3: {
                page = this.buildDetailPage();
            }
        }
        Map<String, Page> map = this.pages;
        Intrinsics.checkNotNullExpressionValue(map, (String)"pages");
        map = map;
        boolean bl = false;
        map.put(pageType, page);
        return page;
    }

    public final void upload() {
        for (Page page : this.pages.values()) {
            page.setConf(this.getConf());
            page.upload();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Page buildProductPage() {
        Page page = new Page();
        if (this.pageEntityTitle == null) {
            return page;
        }
        try {
            void $this$filterTo$iv$iv;
            Object attribute3;
            MiniTemplator template2 = new MiniTemplator(((Object)ProductWikiBuilder.Companion.getProductTemplatePath()).toString());
            page.title(this.pageEntityTitle);
            page.summery(this.pageEntityTitle);
            template2.setVariable("\u4ea7\u54c1\u540d\u79f0", this.pageEntityName);
            template2.setVariable("\u4ea7\u54c1\u5206\u7c7b", this.pageEntityCategory);
            for (PageAttribute attribute2 : this.getPageEntity().get("page-keywords")) {
                template2.setVariable("\u5173\u952e\u8bcd", attribute2.getValue());
                template2.addBlock("\u5173\u952e\u8bcd");
            }
            String[] stringArray = new String[]{"\u4ea7\u54c1\u540d\u79f0", "\u4ea7\u54c1\u5206\u7c7b"};
            String[] ignoredBaseInfo = stringArray;
            for (Object attribute3 : this.getPageEntity().filterBy(new FragmentCategory("ProductShow", null, 2, null))) {
                if (attribute3.getName().length() > 30 || attribute3.getValue().length() > 200 || Arrays.asList(Arrays.copyOf(ignoredBaseInfo, ignoredBaseInfo.length)).contains(attribute3.getName())) continue;
                template2.setVariable("\u5c5e\u6027\u540d", attribute3.getName());
                template2.setVariable("\u5c5e\u6027\u503c", attribute3.getValue());
                template2.addBlock("\u57fa\u672c\u4fe1\u606f");
            }
            for (Object attribute3 : this.getPageEntity().filterBy(new FragmentCategory("ProductSpec", null, 2, null))) {
                if (attribute3.getName().length() > 30 || attribute3.getValue().length() > 200) continue;
                template2.setVariable("\u5c5e\u6027\u540d", attribute3.getName());
                template2.setVariable("\u5c5e\u6027\u503c", attribute3.getValue());
                template2.addBlock("\u89c4\u683c\u53c2\u6570");
            }
            for (Object attribute3 : this.getPageEntity().filterBy(new FragmentCategory("PreDefined", null, 2, null))) {
                if (attribute3.getName().length() > 30 || attribute3.getValue().length() > 200) continue;
                template2.setVariable("\u5c5e\u6027\u540d", attribute3.getName());
                template2.setVariable("\u5c5e\u6027\u503c", attribute3.getValue());
                template2.addBlock("\u89c4\u683c\u53c2\u6570");
            }
            attribute3 = this.getPageEntity().getAttributes().values();
            Intrinsics.checkNotNullExpressionValue((Object)attribute3, (String)"pageEntity.attributes.values");
            Iterable $this$filter$iv = (Iterable)attribute3;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PageAttribute it = (PageAttribute)element$iv$iv;
                boolean bl = false;
                if (!(it.getCategory() == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (Object attribute3 : (List)destination$iv$iv) {
                if (attribute3.getName().length() > 30 || attribute3.getValue().length() > 200) continue;
                template2.setVariable("\u5c5e\u6027\u540d", attribute3.getName());
                template2.setVariable("\u5c5e\u6027\u503c", attribute3.getValue());
                template2.addBlock("\u5176\u4ed6\u5c5e\u6027");
            }
            page.text(template2.generateOutput());
        }
        catch (MiniTemplator.TemplateSyntaxException e) {
            EntityViewBuilder.Companion.getLog().error(e.toString());
        }
        catch (IOException e) {
            EntityViewBuilder.Companion.getLog().error(e.toString());
        }
        return page;
    }

    private final Page buildTradePage() {
        Page page = new Page();
        if (this.pageEntityTitle == null) {
            return page;
        }
        try {
            MiniTemplator template2 = new MiniTemplator(ProductWikiBuilder.Companion.getProductTradeTemplatePath());
            String string = this.pageEntityTitle;
            Intrinsics.checkNotNull((Object)string);
            String title = this.buildProductTradePageTitle(string);
            page.title(title);
            page.summery(title);
            template2.setVariable("\u4ea7\u54c1\u540d\u79f0", this.pageEntityName);
            template2.setVariable("\u4ea4\u6613\u5e73\u53f0\u540d\u79f0", this.getAttrValue("\u4ea4\u6613\u5e73\u53f0\u540d\u79f0"));
            template2.setVariable("\u4ea4\u6613\u5e73\u53f0\u57df\u540d", this.getAttrValue("\u4ea4\u6613\u5e73\u53f0\u57df\u540d"));
            template2.setVariable("\u9500\u552e\u4ef7", this.getAttrValue("\u9500\u552e\u4ef7"));
            template2.setVariable("\u53ef\u9009\u989c\u8272", CollectionsKt.joinToString$default((Iterable)this.getPageEntity().get("\u989c\u8272"), null, null, null, (int)0, null, null, (int)63, null));
            template2.setVariable("\u53ef\u9009\u7248\u672c", CollectionsKt.joinToString$default((Iterable)this.getPageEntity().get("\u7248\u672c"), null, null, null, (int)0, null, null, (int)63, null));
            template2.setVariable("\u552e\u540e\u670d\u52a1", this.getAttrValue("\u552e\u540e\u670d\u52a1"));
            template2.setVariable("\u7269\u6d41\u4fe1\u606f", this.getAttrValue("\u7269\u6d41\u4fe1\u606f"));
            template2.setVariable("\u652f\u4ed8\u8bf4\u660e", this.getAttrValue("\u652f\u4ed8\u8bf4\u660e"));
            String string2 = this.pageEntityTitle;
            Intrinsics.checkNotNull((Object)string2);
            template2.setVariable("\u5546\u54c1\u8be6\u7ec6\u4ecb\u7ecd", this.buildProductIntroducePageTitle(string2));
            template2.setVariable("\u7f51\u9875\u6807\u9898", this.pageEntityTitle);
            template2.setVariable("\u7f51\u9875\u6458\u8981", this.getAttrValue("\u7f51\u9875\u6458\u8981"));
            template2.setVariable("\u7f51\u9875\u5173\u952e\u8bcd", PageEntity.joinToString$default((PageEntity)this.getPageEntity(), (String)"\u7f51\u9875\u5173\u952e\u8bcd", null, (int)2, null));
            template2.setVariable("\u7f51\u9875\u94fe\u63a5", this.getAttrValue("\u8d2d\u4e70\u94fe\u63a5"));
            page.text(template2.generateOutput());
        }
        catch (MiniTemplator.TemplateSyntaxException e) {
            EntityViewBuilder.Companion.getLog().error(e.toString());
        }
        catch (IOException e) {
            EntityViewBuilder.Companion.getLog().error(e.toString());
        }
        return page;
    }

    private final Page buildDetailPage() {
        Page page = new Page();
        if (this.pageEntityTitle == null) {
            return page;
        }
        try {
            MiniTemplator template2 = new MiniTemplator(ProductWikiBuilder.Companion.getProductIntroduceTemplatePath());
            String string = this.pageEntityTitle;
            Intrinsics.checkNotNull((Object)string);
            String title = this.buildProductIntroducePageTitle(string);
            page.title(title);
            page.summery(title);
            template2.setVariable("\u4ea7\u54c1\u540d\u79f0", this.pageEntityName);
            template2.setVariable("\u5546\u54c1\u8be6\u7ec6\u4ecb\u7ecd", this.html2wiki(this.getAttrValue("\u5546\u54c1\u8be6\u7ec6\u4ecb\u7ecd")));
            page.text(template2.generateOutput());
        }
        catch (MiniTemplator.TemplateSyntaxException e) {
            EntityViewBuilder.Companion.getLog().error(e.toString());
        }
        catch (IOException e) {
            EntityViewBuilder.Companion.getLog().error(e.toString());
        }
        return page;
    }

    private final String html2wiki(String html) {
        Object object = Jsoup.parse((String)html);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parse(html)");
        Document doc = object;
        object = doc.text();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"doc.text()");
        return object;
    }

    @NotNull
    public String toString() {
        Page page = this.pages.get("ProductPage");
        Intrinsics.checkNotNull((Object)page);
        String string = page.text();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pages[ai.platon.scent.vi\u2026age.ProductPage]!!.text()");
        return string;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lai/platon/scent/view/builder/ProductWikiBuilder$Companion;", "", "()V", "productIntroduceTemplatePath", "Ljava/nio/file/Path;", "getProductIntroduceTemplatePath", "()Ljava/nio/file/Path;", "productTemplatePath", "getProductTemplatePath", "productTradeTemplatePath", "getProductTradeTemplatePath", "scent-build"})
    public static final class Companion {
        private Companion() {
        }

        private final Path getProductTemplatePath() {
            String[] stringArray = new String[]{"template", "product.template.wiki"};
            return AppPaths.INSTANCE.get("wwwroot", stringArray);
        }

        private final Path getProductTradeTemplatePath() {
            String[] stringArray = new String[]{"template", "product.trade.template.wiki"};
            return AppPaths.INSTANCE.get("wwwroot", stringArray);
        }

        private final Path getProductIntroduceTemplatePath() {
            String[] stringArray = new String[]{"template", "product.introduce.template.wiki"};
            return AppPaths.INSTANCE.get("wwwroot", stringArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

