/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.view.builder;

import ai.platon.pulsar.common.Strings;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.dom.model.PageAttribute;
import ai.platon.pulsar.dom.model.PageEntity;
import ai.platon.scent.view.builder.EntityViewBuilder;
import com.google.common.collect.TreeMultimap;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.collections4.ComparatorUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0004J\b\u0010\f\u001a\u00020\bH\u0016J\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lai/platon/scent/view/builder/StringViewBuilder;", "Lai/platon/scent/view/builder/EntityViewBuilder;", "pageEntity", "Lai/platon/pulsar/dom/model/PageEntity;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/dom/model/PageEntity;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "view", "", "build", "", "buildString", "toString", "scent-build"})
public abstract class StringViewBuilder
extends EntityViewBuilder {
    @NotNull
    private String view;

    public StringViewBuilder(@NotNull PageEntity pageEntity, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)pageEntity, (String)"pageEntity");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        super(pageEntity, conf);
        this.view = "";
    }

    @Override
    public void build() {
        this.buildString();
    }

    @NotNull
    public final String view() {
        return this.view;
    }

    @NotNull
    protected final String buildString() {
        StringBuilder reporter = new StringBuilder();
        Formatter formatter = new Formatter(reporter, Locale.SIMPLIFIED_CHINESE);
        int counter = 0;
        TreeMultimap categorySortedattributes = TreeMultimap.create((Comparator)ComparatorUtils.reversedComparator((Comparator)ComparatorUtils.NATURAL_COMPARATOR), (Comparator)ComparatorUtils.NATURAL_COMPARATOR);
        for (PageAttribute attr : this.getPageEntity().getAttributes().values()) {
            if (attr.getCategory() != null) {
                ++counter;
            }
            categorySortedattributes.put((Object)StringsKt.substringBeforeLast$default((String)attr.getFullName(), (String)"/", null, (int)2, null), (Object)attr);
        }
        Object object = new Object[]{this.getPageEntity().getAttributes().size(), counter};
        formatter.format("\n\n total attributeRow : %d, categorized : %d \n\n", (Object[])object);
        object = new Object[]{"categories", "name", "value"};
        formatter.format("%-20s %-15s %-120s\n", (Object[])object);
        for (PageAttribute attr : categorySortedattributes.values()) {
            String value = StringUtils.substring((String)attr.getRichText(), (int)0, (int)12000000);
            value = Strings.stripNonCJKChar((String)value, (String)"~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./' \n\r\t");
            Object[] objectArray = new Object[]{StringUtils.substring((String)StringsKt.substringBeforeLast$default((String)attr.getFullName(), (String)"/", null, (int)2, null), (int)0, (int)20), StringUtils.substring((String)attr.getName(), (int)0, (int)12), value};
            formatter.format("%-20s %-15s %-120s\n", objectArray);
        }
        reporter.append("\n");
        object = reporter.toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"reporter.toString()");
        this.view = object;
        return this.view;
    }

    @NotNull
    public String toString() {
        return this.view();
    }
}

