/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.view.builder;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.scent.view.wiki.Page;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikiCategoryBuilder {
    public static final Logger LOG = LoggerFactory.getLogger(WikiCategoryBuilder.class);
    private ImmutableConfig conf;
    private Set<String> createdCategories = new HashSet<String>();
    private Set<Page> pages = new HashSet<Page>();

    public WikiCategoryBuilder(ImmutableConfig conf) {
        this.conf = conf;
    }

    public static void main(String[] args) {
        ImmutableConfig conf = new ImmutableConfig();
        WikiCategoryBuilder builder = new WikiCategoryBuilder(conf);
        builder.uploadAll();
    }

    private void buildCategoryPage(String name) {
        String[] parts = StringUtils.split((String)name, (String)">");
        for (int i = 0; i < parts.length; ++i) {
            String category = parts[i].trim();
            String title = "Category:" + category;
            if (this.createdCategories.contains(title)) continue;
            String summery = "\u521b\u5efa\u4ea7\u54c1\u5206\u7c7b\uff1a" + category;
            Object text = "\u8fd9\u662f\u4e00\u4e2a\u4ea7\u54c1\u5206\u7c7b\u3002\n\n";
            text = (String)text + "\u8be5\u5206\u7c7b\u6240\u5c5e\u7684\u7c7b\u522b\uff1a\n\n";
            text = (String)text + "<categorytree mode=parents>" + category + "</categorytree>\n\n";
            text = (String)text + "\u5c5e\u4e8e\u8be5\u5206\u7c7b\u7684\u7c7b\u522b\uff1a\n\n";
            text = (String)text + "<categorytree mode=categories>" + category + "</categorytree>\n\n";
            text = i == 0 ? (String)text + "[[Category:\u4ea7\u54c1\u5206\u7c7b]]\n\n" : (String)text + "[[Category:" + parts[i - 1].trim() + "]]\n\n";
            this.createdCategories.add(title);
            Page page = new Page(title, (String)text, summery);
            page.setConf(this.conf);
            this.pages.add(page);
        }
    }

    public void uploadAll() {
        int counter = 0;
        for (Page page : this.pages) {
            System.out.println("upload the " + counter + "th page : " + page.title());
            ++counter;
            page.upload();
        }
    }
}

