/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.view.template;

import ai.platon.scent.view.template.MiniTemplator;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

class MiniTemplatorParser {
    private static final int maxNestingLevel = 20;
    private static final int maxCondLevels = 20;
    private static final int maxInclTemplateSize = 1000000;
    private static final String cmdStartStr = "<!--";
    private static final String cmdEndStr = "-->";
    private static final String cmdStartStrShort = "<$";
    private static final String cmdEndStrShort = ">";
    public String templateText;
    public String[] varTab;
    public int varTabCnt;
    public VarRefTabRec[] varRefTab;
    public int varRefTabCnt;
    public BlockTabRec[] blockTab;
    public int blockTabCnt;
    private HashSet<String> conditionFlags;
    private boolean shortFormEnabled;
    private HashMap<String, Integer> varNameToNoMap;
    private HashMap<String, Integer> blockNameToNoMap;
    private int currentNestingLevel;
    private int[] openBlocksTab;
    private int condLevel;
    private boolean[] condEnabled;
    private boolean[] condPassed;
    private MiniTemplator miniTemplator;
    private boolean resumeCmdParsingFromStart;

    public MiniTemplatorParser(String templateText, Set<String> conditionFlags, boolean shortFormEnabled, MiniTemplator miniTemplator) throws MiniTemplator.TemplateSyntaxException {
        this.templateText = templateText;
        this.conditionFlags = this.createConditionFlagsSet(conditionFlags);
        this.shortFormEnabled = shortFormEnabled;
        this.miniTemplator = miniTemplator;
        this.parseTemplate();
        this.miniTemplator = null;
    }

    public static Object resizeArray(Object oldArray, int newSize) {
        int oldSize = Array.getLength(oldArray);
        Class<?> elementType = oldArray.getClass().getComponentType();
        Object newArray = Array.newInstance(elementType, newSize);
        int preserveLength = Math.min(oldSize, newSize);
        if (preserveLength > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, preserveLength);
        }
        return newArray;
    }

    private static int skipBlanks(String s, int p) {
        while (p < s.length() && Character.isWhitespace(s.charAt(p))) {
            ++p;
        }
        return p;
    }

    private static int skipNonBlanks(String s, int p) {
        while (p < s.length() && !Character.isWhitespace(s.charAt(p))) {
            ++p;
        }
        return p;
    }

    public static boolean isRestOfStringBlank(String s, int p) {
        return MiniTemplatorParser.skipBlanks(s, p) >= s.length();
    }

    private HashSet<String> createConditionFlagsSet(Set<String> flags) {
        if (flags == null || flags.isEmpty()) {
            return null;
        }
        HashSet<String> flags2 = new HashSet<String>(flags.size());
        for (String flag : flags) {
            flags2.add(flag.toUpperCase());
        }
        return flags2;
    }

    private void parseTemplate() throws MiniTemplator.TemplateSyntaxException {
        this.initParsing();
        this.beginMainBlock();
        this.parseTemplateCommands();
        this.endMainBlock();
        this.checkBlockDefinitionsComplete();
        if (this.condLevel != -1) {
            throw new MiniTemplator.TemplateSyntaxException("$if without matching $endIf.");
        }
        this.parseTemplateVariables();
        this.associateVariablesWithBlocks();
        this.terminateParsing();
    }

    private void initParsing() {
        this.varTab = new String[64];
        this.varTabCnt = 0;
        this.varNameToNoMap = new HashMap();
        this.varRefTab = new VarRefTabRec[64];
        this.varRefTabCnt = 0;
        this.blockTab = new BlockTabRec[16];
        this.blockTabCnt = 0;
        this.currentNestingLevel = 0;
        this.blockNameToNoMap = new HashMap();
        this.openBlocksTab = new int[21];
        this.condLevel = -1;
        this.condEnabled = new boolean[20];
        this.condPassed = new boolean[20];
    }

    private void terminateParsing() {
        this.openBlocksTab = null;
    }

    private void beginMainBlock() {
        int blockNo = this.registerBlock(null);
        BlockTabRec btr = this.blockTab[blockNo];
        btr.tPosBegin = 0;
        btr.tPosContentsBegin = 0;
        this.openBlocksTab[this.currentNestingLevel] = blockNo;
        ++this.currentNestingLevel;
    }

    private void endMainBlock() {
        BlockTabRec btr = this.blockTab[0];
        btr.tPosContentsEnd = this.templateText.length();
        btr.tPosEnd = this.templateText.length();
        btr.definitionIsOpen = false;
        --this.currentNestingLevel;
    }

    private void parseTemplateCommands() throws MiniTemplator.TemplateSyntaxException {
        int p = 0;
        while (true) {
            String cmdLine;
            int p0 = this.templateText.indexOf(cmdStartStr, p);
            boolean shortForm = false;
            if (this.shortFormEnabled && p0 != p) {
                if (p0 == -1) {
                    p0 = this.templateText.indexOf(cmdStartStrShort, p);
                    shortForm = true;
                } else {
                    int p2 = this.templateText.substring(p, p0).indexOf(cmdStartStrShort);
                    if (p2 != -1) {
                        p0 = p + p2;
                        shortForm = true;
                    }
                }
            }
            if (p0 == -1) break;
            this.conditionalExclude(p, p0);
            if (shortForm) {
                p = this.templateText.indexOf(cmdEndStrShort, p0 + cmdStartStrShort.length());
                if (p == -1) {
                    p = p0 + cmdStartStrShort.length();
                    this.conditionalExclude(p0, p);
                    continue;
                }
                cmdLine = this.templateText.substring(p0 + cmdStartStrShort.length(), (p += cmdEndStrShort.length()) - cmdEndStrShort.length());
                if (this.processShortFormTemplateCommand(cmdLine, p0, p)) continue;
                this.conditionalExclude(p0, p);
                continue;
            }
            p = this.templateText.indexOf(cmdEndStr, p0 + cmdStartStr.length());
            if (p == -1) {
                throw new MiniTemplator.TemplateSyntaxException("Invalid HTML comment in template at offset " + p0 + ".");
            }
            cmdLine = this.templateText.substring(p0 + cmdStartStr.length(), (p += cmdEndStr.length()) - cmdEndStr.length());
            this.resumeCmdParsingFromStart = false;
            if (!this.processTemplateCommand(cmdLine, p0, p)) {
                this.conditionalExclude(p0, p);
            }
            if (!this.resumeCmdParsingFromStart) continue;
            p = p0;
        }
    }

    private boolean processTemplateCommand(String cmdLine, int cmdTPosBegin, int cmdTPosEnd) throws MiniTemplator.TemplateSyntaxException {
        int p0 = MiniTemplatorParser.skipBlanks(cmdLine, 0);
        if (p0 >= cmdLine.length()) {
            return false;
        }
        int p = MiniTemplatorParser.skipNonBlanks(cmdLine, p0);
        String cmd = cmdLine.substring(p0, p);
        String parms = cmdLine.substring(p);
        if (cmd.equalsIgnoreCase("$beginBlock")) {
            this.processBeginBlockCmd(parms, cmdTPosBegin, cmdTPosEnd);
        } else if (cmd.equalsIgnoreCase("$endBlock")) {
            this.processEndBlockCmd(parms, cmdTPosBegin, cmdTPosEnd);
        } else if (cmd.equalsIgnoreCase("$include")) {
            this.processIncludeCmd(parms, cmdTPosBegin, cmdTPosEnd);
        } else if (cmd.equalsIgnoreCase("$if")) {
            this.processIfCmd(parms, cmdTPosBegin, cmdTPosEnd);
        } else if (cmd.equalsIgnoreCase("$elseIf")) {
            this.processElseIfCmd(parms, cmdTPosBegin, cmdTPosEnd);
        } else if (cmd.equalsIgnoreCase("$else")) {
            this.processElseCmd(parms, cmdTPosBegin, cmdTPosEnd);
        } else if (cmd.equalsIgnoreCase("$endIf")) {
            this.processEndIfCmd(parms, cmdTPosBegin, cmdTPosEnd);
        } else {
            if (cmd.startsWith("$") && !cmd.startsWith("${")) {
                throw new MiniTemplator.TemplateSyntaxException("Unknown command \"" + cmd + "\" in template at offset " + cmdTPosBegin + ".");
            }
            return false;
        }
        return true;
    }

    private boolean processShortFormTemplateCommand(String cmdLine, int cmdTPosBegin, int cmdTPosEnd) throws MiniTemplator.TemplateSyntaxException {
        char cmd1;
        int p0 = MiniTemplatorParser.skipBlanks(cmdLine, 0);
        if (p0 >= cmdLine.length()) {
            return false;
        }
        int p = p0;
        if ((cmd1 = cmdLine.charAt(p++)) == '/' && p < cmdLine.length() && !Character.isWhitespace(cmdLine.charAt(p))) {
            ++p;
        }
        String cmd = cmdLine.substring(p0, p);
        String parms = cmdLine.substring(p).trim();
        if (cmd.equals("?")) {
            this.processIfCmd(parms, cmdTPosBegin, cmdTPosEnd);
        } else if (cmd.equals(":")) {
            if (parms.length() > 0) {
                this.processElseIfCmd(parms, cmdTPosBegin, cmdTPosEnd);
            } else {
                this.processElseCmd(parms, cmdTPosBegin, cmdTPosEnd);
            }
        } else if (cmd.equals("/?")) {
            this.processEndIfCmd(parms, cmdTPosBegin, cmdTPosEnd);
        } else {
            return false;
        }
        return true;
    }

    private void processBeginBlockCmd(String parms, int cmdTPosBegin, int cmdTPosEnd) throws MiniTemplator.TemplateSyntaxException {
        if (this.conditionalExclude(cmdTPosBegin, cmdTPosEnd)) {
            return;
        }
        int p0 = MiniTemplatorParser.skipBlanks(parms, 0);
        if (p0 >= parms.length()) {
            throw new MiniTemplator.TemplateSyntaxException("Missing block name in $BeginBlock command in template at offset " + cmdTPosBegin + ".");
        }
        int p = MiniTemplatorParser.skipNonBlanks(parms, p0);
        String blockName = parms.substring(p0, p);
        if (!MiniTemplatorParser.isRestOfStringBlank(parms, p)) {
            throw new MiniTemplator.TemplateSyntaxException("Extra parameter in $BeginBlock command in template at offset " + cmdTPosBegin + ".");
        }
        int blockNo = this.registerBlock(blockName);
        BlockTabRec btr = this.blockTab[blockNo];
        btr.tPosBegin = cmdTPosBegin;
        btr.tPosContentsBegin = cmdTPosEnd;
        this.openBlocksTab[this.currentNestingLevel] = blockNo;
        ++this.currentNestingLevel;
        if (this.currentNestingLevel > 20) {
            throw new MiniTemplator.TemplateSyntaxException("Block nesting overflow for block \"" + blockName + "\" in template at offset " + cmdTPosBegin + ".");
        }
    }

    private void processEndBlockCmd(String parms, int cmdTPosBegin, int cmdTPosEnd) throws MiniTemplator.TemplateSyntaxException {
        if (this.conditionalExclude(cmdTPosBegin, cmdTPosEnd)) {
            return;
        }
        int p0 = MiniTemplatorParser.skipBlanks(parms, 0);
        if (p0 >= parms.length()) {
            throw new MiniTemplator.TemplateSyntaxException("Missing block name in $EndBlock command in template at offset " + cmdTPosBegin + ".");
        }
        int p = MiniTemplatorParser.skipNonBlanks(parms, p0);
        String blockName = parms.substring(p0, p);
        if (!MiniTemplatorParser.isRestOfStringBlank(parms, p)) {
            throw new MiniTemplator.TemplateSyntaxException("Extra parameter in $EndBlock command in template at offset " + cmdTPosBegin + ".");
        }
        int blockNo = this.lookupBlockName(blockName);
        if (blockNo == -1) {
            throw new MiniTemplator.TemplateSyntaxException("Undefined block name \"" + blockName + "\" in $EndBlock command in template at offset " + cmdTPosBegin + ".");
        }
        --this.currentNestingLevel;
        BlockTabRec btr = this.blockTab[blockNo];
        if (!btr.definitionIsOpen) {
            throw new MiniTemplator.TemplateSyntaxException("Multiple $EndBlock command for block \"" + blockName + "\" in template at offset " + cmdTPosBegin + ".");
        }
        if (btr.nestingLevel != this.currentNestingLevel) {
            throw new MiniTemplator.TemplateSyntaxException("Block nesting level mismatch at $EndBlock command for block \"" + blockName + "\" in template at offset " + cmdTPosBegin + ".");
        }
        btr.tPosContentsEnd = cmdTPosBegin;
        btr.tPosEnd = cmdTPosEnd;
        btr.definitionIsOpen = false;
    }

    private int registerBlock(String blockName) {
        BlockTabRec btr;
        int blockNo = this.blockTabCnt++;
        if (this.blockTabCnt > this.blockTab.length) {
            this.blockTab = (BlockTabRec[])MiniTemplatorParser.resizeArray(this.blockTab, 2 * this.blockTabCnt);
        }
        this.blockTab[blockNo] = btr = new BlockTabRec();
        btr.blockName = blockName;
        btr.nextWithSameName = blockName != null ? this.lookupBlockName(blockName) : -1;
        btr.nestingLevel = this.currentNestingLevel;
        btr.parentBlockNo = this.currentNestingLevel > 0 ? this.openBlocksTab[this.currentNestingLevel - 1] : -1;
        btr.definitionIsOpen = true;
        btr.blockVarCnt = 0;
        btr.firstVarRefNo = -1;
        btr.blockVarNoToVarNoMap = new int[32];
        btr.dummy = false;
        if (blockName != null) {
            this.blockNameToNoMap.put(blockName.toUpperCase(), new Integer(blockNo));
        }
        return blockNo;
    }

    private void excludeTemplateRange(int tPosBegin, int tPosEnd) {
        if (this.blockTabCnt > 0) {
            BlockTabRec btr = this.blockTab[this.blockTabCnt - 1];
            if (btr.dummy && btr.tPosEnd == tPosBegin) {
                btr.tPosContentsEnd = tPosEnd;
                btr.tPosEnd = tPosEnd;
                return;
            }
        }
        int blockNo = this.registerBlock(null);
        BlockTabRec btr = this.blockTab[blockNo];
        btr.tPosBegin = tPosBegin;
        btr.tPosContentsBegin = tPosBegin;
        btr.tPosContentsEnd = tPosEnd;
        btr.tPosEnd = tPosEnd;
        btr.definitionIsOpen = false;
        btr.dummy = true;
    }

    private void checkBlockDefinitionsComplete() throws MiniTemplator.TemplateSyntaxException {
        for (int blockNo = 0; blockNo < this.blockTabCnt; ++blockNo) {
            BlockTabRec btr = this.blockTab[blockNo];
            if (!btr.definitionIsOpen) continue;
            throw new MiniTemplator.TemplateSyntaxException("Missing $EndBlock command in template for block \"" + btr.blockName + "\".");
        }
        if (this.currentNestingLevel != 0) {
            throw new MiniTemplator.TemplateSyntaxException("Block nesting level error at end of template.");
        }
    }

    private void processIncludeCmd(String parms, int cmdTPosBegin, int cmdTPosEnd) throws MiniTemplator.TemplateSyntaxException {
        int p;
        if (this.conditionalExclude(cmdTPosBegin, cmdTPosEnd)) {
            return;
        }
        int p0 = MiniTemplatorParser.skipBlanks(parms, 0);
        if (p0 >= parms.length()) {
            throw new MiniTemplator.TemplateSyntaxException("Missing subtemplate name in $Include command in template at offset " + cmdTPosBegin + ".");
        }
        if (parms.charAt(p0) == '\"') {
            if ((p = parms.indexOf(34, ++p0)) == -1) {
                throw new MiniTemplator.TemplateSyntaxException("Missing closing quote for subtemplate name in $Include command in template at offset " + cmdTPosBegin + ".");
            }
        } else {
            p = MiniTemplatorParser.skipNonBlanks(parms, p0);
        }
        String subtemplateName = parms.substring(p0, p);
        if (!MiniTemplatorParser.isRestOfStringBlank(parms, ++p)) {
            throw new MiniTemplator.TemplateSyntaxException("Extra parameter in $Include command in template at offset " + cmdTPosBegin + ".");
        }
        this.insertSubtemplate(subtemplateName, cmdTPosBegin, cmdTPosEnd);
    }

    private void insertSubtemplate(String subtemplateName, int tPos1, int tPos2) {
        String subtemplate;
        if (this.templateText.length() > 1000000) {
            throw new RuntimeException("Subtemplate include aborted because the internal template string is longer than 1000000 characters.");
        }
        try {
            subtemplate = this.miniTemplator.loadSubtemplate(subtemplateName);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while loading subtemplate \"" + subtemplateName + "\"", e);
        }
        StringBuilder s = new StringBuilder(this.templateText.length() + subtemplate.length());
        s.append(this.templateText, 0, tPos1);
        s.append(subtemplate);
        s.append(this.templateText, tPos2, this.templateText.length());
        this.templateText = s.toString();
        this.resumeCmdParsingFromStart = true;
    }

    private boolean isCondEnabled(int condLevel2) {
        if (condLevel2 < 0) {
            return true;
        }
        return this.condEnabled[condLevel2];
    }

    private boolean conditionalExclude(int tPosBegin, int tPosEnd) {
        if (this.isCondEnabled(this.condLevel)) {
            return false;
        }
        this.excludeTemplateRange(tPosBegin, tPosEnd);
        return true;
    }

    private boolean evaluateConditionFlags(String flags) {
        int p = 0;
        while ((p = MiniTemplatorParser.skipBlanks(flags, p)) < flags.length()) {
            boolean complement = false;
            if (flags.charAt(p) == '!') {
                complement = true;
                ++p;
            }
            if ((p = MiniTemplatorParser.skipBlanks(flags, p)) >= flags.length()) break;
            int p0 = p;
            p = MiniTemplatorParser.skipNonBlanks(flags, p0 + 1);
            String flag = flags.substring(p0, p).toUpperCase();
            if (!((this.conditionFlags != null && this.conditionFlags.contains(flag)) ^ complement)) continue;
            return true;
        }
        return false;
    }

    private void processIfCmd(String parms, int cmdTPosBegin, int cmdTPosEnd) throws MiniTemplator.TemplateSyntaxException {
        boolean enabled;
        this.excludeTemplateRange(cmdTPosBegin, cmdTPosEnd);
        if (this.condLevel >= 19) {
            throw new MiniTemplator.TemplateSyntaxException("Too many nested $if commands.");
        }
        ++this.condLevel;
        this.condEnabled[this.condLevel] = enabled = this.isCondEnabled(this.condLevel - 1) && this.evaluateConditionFlags(parms);
        this.condPassed[this.condLevel] = enabled;
    }

    private void processElseIfCmd(String parms, int cmdTPosBegin, int cmdTPosEnd) throws MiniTemplator.TemplateSyntaxException {
        boolean enabled;
        this.excludeTemplateRange(cmdTPosBegin, cmdTPosEnd);
        if (this.condLevel < 0) {
            throw new MiniTemplator.TemplateSyntaxException("$elseIf without matching $if.");
        }
        this.condEnabled[this.condLevel] = enabled = this.isCondEnabled(this.condLevel - 1) && !this.condPassed[this.condLevel] && this.evaluateConditionFlags(parms);
        if (enabled) {
            this.condPassed[this.condLevel] = true;
        }
    }

    private void processElseCmd(String parms, int cmdTPosBegin, int cmdTPosEnd) throws MiniTemplator.TemplateSyntaxException {
        boolean enabled;
        this.excludeTemplateRange(cmdTPosBegin, cmdTPosEnd);
        if (parms.trim().length() != 0) {
            throw new MiniTemplator.TemplateSyntaxException("Invalid parameters for $else command.");
        }
        if (this.condLevel < 0) {
            throw new MiniTemplator.TemplateSyntaxException("$else without matching $if.");
        }
        this.condEnabled[this.condLevel] = enabled = this.isCondEnabled(this.condLevel - 1) && !this.condPassed[this.condLevel];
        if (enabled) {
            this.condPassed[this.condLevel] = true;
        }
    }

    private void processEndIfCmd(String parms, int cmdTPosBegin, int cmdTPosEnd) throws MiniTemplator.TemplateSyntaxException {
        this.excludeTemplateRange(cmdTPosBegin, cmdTPosEnd);
        if (parms.trim().length() != 0) {
            throw new MiniTemplator.TemplateSyntaxException("Invalid parameters for $endIf command.");
        }
        if (this.condLevel < 0) {
            throw new MiniTemplator.TemplateSyntaxException("$endif without matching $if.");
        }
        --this.condLevel;
    }

    private void associateVariablesWithBlocks() {
        int varRefNo = 0;
        int activeBlockNo = 0;
        int nextBlockNo = 1;
        while (varRefNo < this.varRefTabCnt) {
            int blockVarNo;
            VarRefTabRec vrtr = this.varRefTab[varRefNo];
            int varRefTPos = vrtr.tPosBegin;
            int varNo = vrtr.varNo;
            if (varRefTPos >= this.blockTab[activeBlockNo].tPosEnd) {
                activeBlockNo = this.blockTab[activeBlockNo].parentBlockNo;
                continue;
            }
            if (nextBlockNo < this.blockTabCnt && varRefTPos >= this.blockTab[nextBlockNo].tPosBegin) {
                activeBlockNo = nextBlockNo++;
                continue;
            }
            BlockTabRec btr = this.blockTab[activeBlockNo];
            if (varRefTPos < btr.tPosBegin) {
                throw new AssertionError();
            }
            ++btr.blockVarCnt;
            if (btr.blockVarCnt > btr.blockVarNoToVarNoMap.length) {
                btr.blockVarNoToVarNoMap = (int[])MiniTemplatorParser.resizeArray(btr.blockVarNoToVarNoMap, 2 * btr.blockVarCnt);
            }
            btr.blockVarNoToVarNoMap[blockVarNo] = varNo;
            if (btr.firstVarRefNo == -1) {
                btr.firstVarRefNo = varRefNo;
            }
            vrtr.blockNo = activeBlockNo;
            vrtr.blockVarNo = blockVarNo;
            ++varRefNo;
        }
    }

    private void parseTemplateVariables() throws MiniTemplator.TemplateSyntaxException {
        int p = 0;
        while ((p = this.templateText.indexOf("${", p)) != -1) {
            String varName;
            int p0 = p;
            if ((p = this.templateText.indexOf("}", p)) == -1) {
                throw new MiniTemplator.TemplateSyntaxException("Invalid variable reference in template at offset " + p0 + ".");
            }
            if ((varName = this.templateText.substring(p0 + 2, ++p - 1).trim()).length() == 0) {
                throw new MiniTemplator.TemplateSyntaxException("Empty variable name in template at offset " + p0 + ".");
            }
            this.registerVariableReference(varName, p0, p);
        }
    }

    private void registerVariableReference(String varName, int tPosBegin, int tPosEnd) {
        VarRefTabRec vrtr;
        int varNo = this.lookupVariableName(varName);
        if (varNo == -1) {
            varNo = this.registerVariable(varName);
        }
        int varRefNo = this.varRefTabCnt++;
        if (this.varRefTabCnt > this.varRefTab.length) {
            this.varRefTab = (VarRefTabRec[])MiniTemplatorParser.resizeArray(this.varRefTab, 2 * this.varRefTabCnt);
        }
        this.varRefTab[varRefNo] = vrtr = new VarRefTabRec();
        vrtr.tPosBegin = tPosBegin;
        vrtr.tPosEnd = tPosEnd;
        vrtr.varNo = varNo;
    }

    private int registerVariable(String varName) {
        int varNo = this.varTabCnt++;
        if (this.varTabCnt > this.varTab.length) {
            this.varTab = (String[])MiniTemplatorParser.resizeArray(this.varTab, 2 * this.varTabCnt);
        }
        this.varTab[varNo] = varName;
        this.varNameToNoMap.put(varName.toUpperCase(), new Integer(varNo));
        return varNo;
    }

    public int lookupVariableName(String varName) {
        Integer varNoWrapper = this.varNameToNoMap.get(varName.toUpperCase());
        if (varNoWrapper == null) {
            return -1;
        }
        int varNo = varNoWrapper;
        return varNo;
    }

    public int lookupBlockName(String blockName) {
        Integer blockNoWrapper = this.blockNameToNoMap.get(blockName.toUpperCase());
        if (blockNoWrapper == null) {
            return -1;
        }
        int blockNo = blockNoWrapper;
        return blockNo;
    }

    public static class BlockTabRec {
        String blockName;
        int nextWithSameName;
        int tPosBegin;
        int tPosContentsBegin;
        int tPosContentsEnd;
        int tPosEnd;
        int nestingLevel;
        int parentBlockNo;
        boolean definitionIsOpen;
        int blockVarCnt;
        int[] blockVarNoToVarNoMap;
        int firstVarRefNo;
        boolean dummy;
    }

    public static class VarRefTabRec {
        int varNo;
        int tPosBegin;
        int tPosEnd;
        int blockNo;
        int blockVarNo;
    }
}

