/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.view.wiki;

import ai.platon.pulsar.common.config.Configurable;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.scent.view.wiki.Qiwur;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Page
implements Configurable {
    public static final Logger LOG = LoggerFactory.getLogger(Page.class);
    public static final String ProductPage = "ProductPage";
    public static final String TradePage = "TradePage";
    public static final String DetailPage = "DetailPage";
    private ImmutableConfig conf;
    private String title = null;
    private String text = null;
    private String summery = null;

    public Page() {
    }

    public Page(String title, String text) {
        this.title = title;
        this.text = text;
    }

    public Page(String title, String text, String summery) {
        this.title = title;
        this.text = text;
        this.summery = summery;
    }

    public void upload() {
        try {
            if (StringUtils.isNotEmpty((CharSequence)this.title) && StringUtils.isNotEmpty((CharSequence)this.text)) {
                if (this.summery == null) {
                    this.summery = this.title;
                }
                Qiwur q = Qiwur.create(this.conf);
                q.edit(this.normarizeTitle(this.title), this.text, this.summery);
            } else {
                LOG.info("Invalid page title or text");
            }
        }
        catch (Exception e) {
            LOG.error(e.toString());
        }
    }

    public String summery() {
        return this.summery;
    }

    public void summery(String summery) {
        this.summery = summery;
    }

    public String title() {
        return this.title;
    }

    public void title(String title) {
        this.title = title;
    }

    public String text() {
        return this.text;
    }

    public void text(String text) {
        this.text = text;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("title : ");
        sb.append(this.title);
        sb.append("\n");
        sb.append("text : ");
        sb.append("\n");
        sb.append(this.text);
        return sb.toString();
    }

    private String normarizeTitle(String title) {
        return title;
    }

    public ImmutableConfig getConf() {
        return this.conf;
    }

    public void setConf(ImmutableConfig conf) {
        this.conf = conf;
    }
}

