/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.view.wiki;

import ai.platon.pulsar.common.ObjectCache;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.scent.view.wiki.Page;
import ai.platon.scent.view.wiki.Wiki;
import java.io.IOException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.slf4j.Logger;

public class Qiwur {
    public static final Logger LOG = Page.LOG;
    public static final int Throttle = 5;
    private final ImmutableConfig conf;
    private final String domain;
    private final String username;
    private final String password;
    private final Wiki wiki;
    private boolean alreadyLogin = false;

    private Qiwur(ImmutableConfig conf) {
        this.conf = conf;
        this.domain = this.conf.get("scent.wiki.domain");
        this.username = this.conf.get("scent.wiki.username");
        this.password = this.conf.get("scent.wiki.password");
        LOG.debug(this.domain);
        LOG.debug(this.username);
        LOG.debug(this.password);
        this.wiki = new Wiki(this.domain);
    }

    public static Qiwur create(ImmutableConfig conf) {
        ObjectCache objectCache = ObjectCache.get((ImmutableConfig)conf);
        if (objectCache.getBean(Qiwur.class) != null) {
            return (Qiwur)objectCache.getBean(Qiwur.class);
        }
        Qiwur qiwur = new Qiwur(conf);
        qiwur.login();
        objectCache.put((Object)qiwur);
        return qiwur;
    }

    public void login() {
        if (!this.alreadyLogin) {
            this.forceLogin();
        }
    }

    public void forceLogin() {
        try {
            this.wiki.login(this.username, this.password);
            this.wiki.setThrottle(5);
            this.wiki.setUsingCompressedRequests(false);
            this.alreadyLogin = true;
        }
        catch (IOException | FailedLoginException e) {
            LOG.error(e.toString());
        }
    }

    public void logout() {
        this.wiki.logout();
        this.alreadyLogin = false;
    }

    public void edit(String title, String text, String summery) throws IOException, LoginException {
        this.login();
        this.wiki.edit(title, text, summery);
    }
}

