/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.common;

import ai.platon.pulsar.common.AppContext;
import ai.platon.scent.common.Runtimes;
import ai.platon.scent.common.ScentConstantsKt;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u001f\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0013\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00132\b\b\u0002\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010\u0016\u001a\u00020\u0004JK\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u0014\"\u000e\b\u0001\u0010\u0018*\b\u0012\u0004\u0012\u0002H\u00140\u00192\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00132\u0006\u0010\u001a\u001a\u0002H\u00182\b\b\u0002\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010\u0016\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u001bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0019\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0006R\u0016\u0010\u0010\u001a\n \u000b*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lai/platon/scent/common/ClusterTools;", "", "()V", "crawlerCount", "", "getCrawlerCount", "()I", "devInstanceLimit", "getDevInstanceLimit", "hostName", "", "kotlin.jvm.PlatformType", "getHostName", "()Ljava/lang/String;", "instancePartition", "getInstancePartition", "log", "Lorg/slf4j/Logger;", "partition", "", "T", "items", "numPartitions", "partitionTo", "C", "", "destination", "(Ljava/util/Collection;Ljava/util/Collection;II)Ljava/util/Collection;", "scent-common"})
public final class ClusterTools {
    @NotNull
    public static final ClusterTools INSTANCE = new ClusterTools();
    private static final Logger log = LoggerFactory.getLogger(ClusterTools.class);
    private static final String hostName = AppContext.INSTANCE.getHOST_NAME();
    private static final int crawlerCount = ScentConstantsKt.getREGISTERED_CRAWLER_HOST_NAMES().size();
    private static final int instancePartition = RangesKt.coerceAtLeast((int)CollectionsKt.indexOf((Iterable)ScentConstantsKt.getREGISTERED_CRAWLER_HOST_NAMES(), (Object)hostName), (int)0);
    private static final int devInstanceLimit = 100;

    private ClusterTools() {
    }

    public final String getHostName() {
        return hostName;
    }

    public final int getCrawlerCount() {
        return crawlerCount;
    }

    public final int getInstancePartition() {
        return instancePartition;
    }

    public final int getDevInstanceLimit() {
        return devInstanceLimit;
    }

    @NotNull
    public final <T> Collection<T> partition(@NotNull Collection<? extends T> items, int partition, int numPartitions) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        return Runtimes.INSTANCE.isDevInstance() ? (Collection)CollectionsKt.take((Iterable)items, (int)devInstanceLimit) : (Runtimes.INSTANCE.isSingleInstanceMode() ? items : ClusterTools.partitionTo$default(this, items, new ArrayList(), 0, 0, 12, null));
    }

    public static /* synthetic */ Collection partition$default(ClusterTools clusterTools, Collection collection, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = instancePartition;
        }
        if ((n3 & 4) != 0) {
            n2 = crawlerCount;
        }
        return clusterTools.partition(collection, n, n2);
    }

    @NotNull
    public final <T, C extends Collection<T>> C partitionTo(@NotNull Collection<? extends T> items, @NotNull C destination, int partition, int numPartitions) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        int start = 0;
        int limit = 0;
        if (Runtimes.INSTANCE.isDevInstance()) {
            limit = devInstanceLimit;
        } else if (Runtimes.INSTANCE.isSingleInstanceMode()) {
            limit = items.size();
        } else {
            int partitionSize = items.size() / numPartitions;
            start = partition * partitionSize;
            limit = partition == numPartitions - 1 ? items.size() - partitionSize * partition : partitionSize;
        }
        Object[] objectArray = new Object[]{start, start + limit, hostName};
        log.info("Partition items from {} to {} on host <{}>", objectArray);
        return (C)SequencesKt.toCollection((Sequence)SequencesKt.take((Sequence)SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)items), (int)start), (int)limit), destination);
    }

    public static /* synthetic */ Collection partitionTo$default(ClusterTools clusterTools, Collection collection, Collection collection2, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = instancePartition;
        }
        if ((n3 & 8) != 0) {
            n2 = crawlerCount;
        }
        return clusterTools.partitionTo(collection, collection2, n, n2);
    }
}

