/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.common;

import ai.platon.pulsar.common.AppContext;
import ai.platon.scent.common.ScentConstantsKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.RandomStringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u0004\u0018\u00010\u0007J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\fJ\u0006\u0010\u000f\u001a\u00020\fJ\u0006\u0010\u0010\u001a\u00020\fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lai/platon/scent/common/Runtimes;", "", "()V", "testLabelPath", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "twistedHostname", "", "getTwistedHostname", "()Ljava/lang/String;", "getTestLabel", "isCluster", "", "isDevInstance", "isMaster", "isSingleInstanceMode", "isTestInstance", "scent-common"})
public final class Runtimes {
    @NotNull
    public static final Runtimes INSTANCE = new Runtimes();
    private static final Path testLabelPath = Paths.get(AppContext.INSTANCE.getUSER_DIR(), new String[0]).resolve(".TEST");

    private Runtimes() {
    }

    public final boolean isCluster() {
        return !((Collection)ScentConstantsKt.getREGISTERED_CRAWLER_HOST_NAMES()).isEmpty();
    }

    public final boolean isMaster() {
        String string = AppContext.INSTANCE.getHOST_NAME();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-HOST_NAME>(...)");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"platonai", (boolean)false, (int)2, null);
    }

    public final boolean isDevInstance() {
        return !ScentConstantsKt.getREGISTERED_CRAWLER_HOST_NAMES().contains(AppContext.INSTANCE.getHOST_NAME());
    }

    public final boolean isTestInstance() {
        return Files.exists(testLabelPath, new LinkOption[0]) || this.isDevInstance();
    }

    public final boolean isSingleInstanceMode() {
        return !ScentConstantsKt.getREGISTERED_CRAWLER_HOST_NAMES().contains(AppContext.INSTANCE.getHOST_NAME());
    }

    @Nullable
    public final String getTestLabel() {
        if (Files.exists(testLabelPath, new LinkOption[0])) {
            List<String> list = Files.readAllLines(testLabelPath);
            Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
            return (String)CollectionsKt.firstOrNull(list);
        }
        return null;
    }

    @NotNull
    public final String getTwistedHostname() {
        return AppContext.INSTANCE.getHOST_NAME() + RandomStringUtils.randomNumeric((int)5);
    }
}

