/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.common;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001c\u001a\u00020\u0004J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001c\u001a\u00020\u0004J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001c\u001a\u00020\u0004J\u0015\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u001c\u001a\u00020\u0004\u00a2\u0006\u0002\u0010!J\u0015\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001c\u001a\u00020\u0004\u00a2\u0006\u0002\u0010$J\u0010\u0010%\u001a\u00020&2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004J\u0010\u0010'\u001a\u00020&2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004J\u0010\u0010(\u001a\u00020&2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004J\u0010\u0010)\u001a\u00020&2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\u0013\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0014\u0010\u0015\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000eR\u0011\u0010\u0019\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000e\u00a8\u0006*"}, d2={"Lai/platon/scent/common/ScentStringUtils;", "", "()V", "CURRENCY_PREFIX_PATTERN", "", "getCURRENCY_PREFIX_PATTERN", "()Ljava/lang/String;", "CURRENCY_SUFFIX_PATTERN", "getCURRENCY_SUFFIX_PATTERN", "CURRENCY_SYMBOLS", "getCURRENCY_SYMBOLS", "NUMBER_CONTAINS_REGEX", "Lkotlin/text/Regex;", "getNUMBER_CONTAINS_REGEX", "()Lkotlin/text/Regex;", "NUMBER_ONLY_REGEX", "getNUMBER_ONLY_REGEX", "NUMBER_REGEX", "getNUMBER_REGEX", "PRICE_CONTAINS_REGEX", "getPRICE_CONTAINS_REGEX", "PRICE_NUMBER_PATTERN", "getPRICE_NUMBER_PATTERN", "PRICE_ONLY_REGEX", "getPRICE_ONLY_REGEX", "PRICE_REGEX", "getPRICE_REGEX", "findLastNumericSubstringOrNull", "s", "findNumber", "findPrice", "findTailingInt", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "findTailingLong", "", "(Ljava/lang/String;)Ljava/lang/Long;", "isNumberLike", "", "isNumberOnly", "isPriceLike", "isPriceOnly", "scent-common"})
public final class ScentStringUtils {
    @NotNull
    public static final ScentStringUtils INSTANCE = new ScentStringUtils();
    @NotNull
    private static final String CURRENCY_SYMBOLS = "$\u00a3\u20ac\u00a5\uffe5\u20b9\u20ba";
    @NotNull
    private static final Regex NUMBER_REGEX = new Regex("-?\\d{1,3}(?:,\\d{3})*(\\.\\d+)?");
    @NotNull
    private static final Regex NUMBER_CONTAINS_REGEX = new Regex(".*" + NUMBER_REGEX + ".*");
    @NotNull
    private static final Regex NUMBER_ONLY_REGEX = new Regex("\\s?^" + NUMBER_REGEX + "$\\s?");
    @NotNull
    private static final String CURRENCY_PREFIX_PATTERN = "USD|EUR|RMB|\u20ac|\\$|\u00a3|\u00a5|\uffe5|\u20b9|\u20ba";
    @NotNull
    private static final String CURRENCY_SUFFIX_PATTERN = "USD|EUR|RMB";
    @NotNull
    private static final String PRICE_NUMBER_PATTERN = "[0-9]{1,3}(?:[ ,]?[0-9]{3})*(?:[\\\\.,][0-9]{1,2})?";
    @NotNull
    private static final Regex PRICE_REGEX = new Regex(StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)"((CURRENCY_PREFIX_PATTERN)\\s?PRICE_NUMBER_PATTERN\\s?)|(PRICE_NUMBER_PATTERN\\s?(CURRENCY_SUFFIX_PATTERN))", (String)"PRICE_NUMBER_PATTERN", (String)PRICE_NUMBER_PATTERN, (boolean)false, (int)4, null), (String)"CURRENCY_PREFIX_PATTERN", (String)CURRENCY_PREFIX_PATTERN, (boolean)false, (int)4, null), (String)"CURRENCY_SUFFIX_PATTERN", (String)CURRENCY_SUFFIX_PATTERN, (boolean)false, (int)4, null));
    @NotNull
    private static final Regex PRICE_CONTAINS_REGEX = new Regex(".*" + PRICE_REGEX + ".*");
    @NotNull
    private static final Regex PRICE_ONLY_REGEX = new Regex("\\s?^" + PRICE_REGEX + "$\\s?");

    private ScentStringUtils() {
    }

    @NotNull
    public final String getCURRENCY_SYMBOLS() {
        return CURRENCY_SYMBOLS;
    }

    @NotNull
    public final Regex getNUMBER_REGEX() {
        return NUMBER_REGEX;
    }

    @NotNull
    public final Regex getNUMBER_CONTAINS_REGEX() {
        return NUMBER_CONTAINS_REGEX;
    }

    @NotNull
    public final Regex getNUMBER_ONLY_REGEX() {
        return NUMBER_ONLY_REGEX;
    }

    @NotNull
    public final String getCURRENCY_PREFIX_PATTERN() {
        return CURRENCY_PREFIX_PATTERN;
    }

    @NotNull
    public final String getCURRENCY_SUFFIX_PATTERN() {
        return CURRENCY_SUFFIX_PATTERN;
    }

    @NotNull
    public final String getPRICE_NUMBER_PATTERN() {
        return PRICE_NUMBER_PATTERN;
    }

    @NotNull
    public final Regex getPRICE_REGEX() {
        return PRICE_REGEX;
    }

    @NotNull
    public final Regex getPRICE_CONTAINS_REGEX() {
        return PRICE_CONTAINS_REGEX;
    }

    @NotNull
    public final Regex getPRICE_ONLY_REGEX() {
        return PRICE_ONLY_REGEX;
    }

    public final boolean isNumberLike(@Nullable String s) {
        CharSequence charSequence;
        return s != null && NUMBER_CONTAINS_REGEX.matches(charSequence = (CharSequence)s);
    }

    public final boolean isNumberOnly(@Nullable String s) {
        CharSequence charSequence;
        return s != null && NUMBER_ONLY_REGEX.matches(charSequence = (CharSequence)s);
    }

    public final boolean isPriceLike(@Nullable String s) {
        CharSequence charSequence;
        return s != null && PRICE_CONTAINS_REGEX.matches(charSequence = (CharSequence)s);
    }

    public final boolean isPriceOnly(@Nullable String s) {
        CharSequence charSequence;
        return s != null && PRICE_ONLY_REGEX.matches(charSequence = (CharSequence)s);
    }

    @Nullable
    public final String findNumber(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Object object = Regex.find$default((Regex)NUMBER_REGEX, (CharSequence)s, (int)0, (int)2, null);
        return object != null && (object = object.getGroupValues()) != null ? (String)CollectionsKt.lastOrNull((List)object) : null;
    }

    @Nullable
    public final String findPrice(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Object object = Regex.find$default((Regex)PRICE_REGEX, (CharSequence)s, (int)0, (int)2, null);
        return object != null && (object = object.getGroupValues()) != null ? (String)CollectionsKt.lastOrNull((List)object) : null;
    }

    @Nullable
    public final String findLastNumericSubstringOrNull(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Regex regex = new Regex("([1-9][0-9]*)$");
        Object object = Regex.find$default((Regex)regex, (CharSequence)s, (int)0, (int)2, null);
        return object != null && (object = object.getGroupValues()) != null ? (String)CollectionsKt.lastOrNull((List)object) : null;
    }

    @Nullable
    public final Long findTailingLong(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        String string = this.findLastNumericSubstringOrNull(s);
        return string != null ? Long.valueOf(Long.parseLong(string)) : null;
    }

    @Nullable
    public final Integer findTailingInt(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        String string = this.findLastNumericSubstringOrNull(s);
        return string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
    }
}

