/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent;

import ai.platon.pulsar.common.Systems;
import ai.platon.pulsar.dom.FeatureCalculatorFactory;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.dom.features.ChainedFeatureCalculator;
import ai.platon.pulsar.dom.features.FeatureCalculator;
import ai.platon.pulsar.dom.features.FeatureRegistry;
import ai.platon.pulsar.dom.features.NodeFeature;
import ai.platon.pulsar.dom.features.defined.F;
import ai.platon.pulsar.ql.H2Config;
import ai.platon.scent.ScentEnvironment;
import ai.platon.scent.dom.Level2FeatureCalculator;
import ai.platon.scent.dom.features.defined.DefinedFeaturesKt;
import ai.platon.scent.dom.features.defined.FF;
import ai.platon.scent.ql.h2.ClassFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.h2.util.JdbcUtils;
import org.h2.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0007\u001a\u00020\u0006H\u0002J\b\u0010\b\u001a\u00020\u0006H\u0002J\b\u0010\t\u001a\u00020\u0006H\u0002J\u0012\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lai/platon/scent/ScentEnvironment;", "", "()V", "logger", "Lorg/slf4j/Logger;", "checkEnvironment", "", "initialize", "installFeatureCalculators", "registerFullNodeFeatures", "setAllProperties", "replaceIfExist", "", "Companion", "scent-engine"})
public final class ScentEnvironment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private static final Map<String, String> properties;

    public ScentEnvironment() {
        Logger logger = LoggerFactory.getLogger(ScentEnvironment.class);
        Intrinsics.checkNotNull((Object)logger);
        this.logger = logger;
        this.initialize();
    }

    private final synchronized void initialize() {
        boolean initialized;
        String string = System.getProperty("proxy.loader.class");
        boolean bl = string == null ? false : (initialized = StringsKt.contains$default((CharSequence)string, (CharSequence)"scent", (boolean)false, (int)2, null));
        if (!initialized) {
            System.clearProperty("use_proxy");
            this.setAllProperties(true);
            this.registerFullNodeFeatures();
            this.installFeatureCalculators();
            H2Config.config();
            JdbcUtils.addClassFactory((Utils.ClassFactory)new ClassFactory());
            this.logger.info("Scent environment is initialized");
        }
    }

    public final synchronized void checkEnvironment() {
        boolean bl = StringsKt.startsWith$default((String)FeaturedDocument.Companion.getNIL().getHtml(), (String)"<html>", (boolean)false, (int)2, null);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = FeatureRegistry.INSTANCE.getDimension() == DefinedFeaturesKt.getN2();
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Expect " + DefinedFeaturesKt.getN2() + " actual " + FeatureRegistry.INSTANCE.getDimension();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    private final void installFeatureCalculators() {
        this.logger.info("Initializing feature calculator, use ChainedFeatureCalculator with Level2FeatureCalculator appended");
        FeatureCalculator[] featureCalculatorArray = new FeatureCalculator[]{(FeatureCalculator)new Level2FeatureCalculator()};
        FeatureCalculatorFactory.INSTANCE.setCalculator((FeatureCalculator)new ChainedFeatureCalculator(featureCalculatorArray));
    }

    private final void setAllProperties(boolean replaceIfExist) {
        Map<String, String> $this$forEach$iv = properties;
        boolean $i$f$forEach = false;
        Map<String, String> map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, String>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> $dstr$name$value = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<String, String> entry = $dstr$name$value;
            boolean bl3 = false;
            String name = entry.getKey();
            Map.Entry<String, String> entry2 = $dstr$name$value;
            boolean bl4 = false;
            String value = entry2.getValue();
            if (replaceIfExist) {
                Systems.INSTANCE.setProperty(name, (Object)value);
                continue;
            }
            Systems.INSTANCE.setPropertyIfAbsent(name, value);
        }
    }

    static /* synthetic */ void setAllProperties$default(ScentEnvironment scentEnvironment, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        scentEnvironment.setAllProperties(bl);
    }

    private final void registerFullNodeFeatures() {
        Object object;
        F it;
        Iterable iterable;
        F[] $this$mapTo$iv$iv;
        F[] $this$map$iv = F.values();
        boolean $i$f$map = false;
        F[] fArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (F item$iv$iv : $this$mapTo$iv$iv) {
            void var11_16 = item$iv$iv;
            iterable = destination$iv$iv;
            boolean bl = false;
            object = it.toFeature();
            iterable.add(object);
        }
        $this$map$iv = FF.values();
        iterable = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        F[] fArray2 = $this$mapTo$iv$iv;
        int n = fArray2.length;
        for (int i = 0; i < n; ++i) {
            F item$iv$iv;
            it = item$iv$iv = fArray2[i];
            object = destination$iv$iv;
            boolean bl = false;
            NodeFeature nodeFeature = it.toFeature();
            object.add(nodeFeature);
        }
        object = (List)destination$iv$iv;
        Set features2 = CollectionsKt.union((Iterable)iterable, (Iterable)((Iterable)object));
        FeatureRegistry.INSTANCE.register((Iterable)features2);
        int size = FeatureRegistry.INSTANCE.getRegisteredFeatures().size();
        String report2 = CollectionsKt.joinToString$default((Iterable)FeatureRegistry.INSTANCE.getRegisteredFeatures(), null, null, null, (int)0, null, (Function1)registerFullNodeFeatures.report.1.INSTANCE, (int)31, null);
        this.logger.info("Registered features(" + size + "): " + report2);
        boolean bl = FeatureRegistry.INSTANCE.getDimension() == DefinedFeaturesKt.getN2();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Expect " + DefinedFeaturesKt.getN2() + " actual " + FeatureRegistry.INSTANCE.getDimension() + ", features size: " + features2.size();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"legacy.config.profile", (Object)"default"), TuplesKt.to((Object)"proxy.enable.default.providers", (Object)"true"), TuplesKt.to((Object)"proxy.pool.monitor.class", (Object)"ai.platon.pulsar.common.proxy.ProxyPoolManager"), TuplesKt.to((Object)"proxy.loader.class", (Object)"ai.platon.scent.proxy.pool.ProxyVendorLoader"), TuplesKt.to((Object)"browser.launch.supervisor.process", (Object)"xvfb-run"), TuplesKt.to((Object)"browser.launch.supervisor.process.args", (Object)"-a, -e, /dev/stdout, -s, -screen 0 1920x1080x24"), TuplesKt.to((Object)"privacy.agent.generator.class", (Object)"ai.platon.pulsar.crawl.fetch.privacy.SequentialPrivacyContextIdGenerator"), TuplesKt.to((Object)"h2.sessionFactory", (Object)"ai.platon.scent.ql.h2.H2SessionFactory")};
        properties = MapsKt.mutableMapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/platon/scent/ScentEnvironment$Companion;", "", "()V", "properties", "", "", "getProperties", "()Ljava/util/Map;", "scent-engine"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, String> getProperties() {
            return properties;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

