/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.crawl;

import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.config.VolatileConfig;
import ai.platon.pulsar.common.options.LoadOptionDefaults;
import ai.platon.pulsar.common.options.LoadOptions;
import ai.platon.scent.common.ClusterTools;
import ai.platon.scent.crawl.ResidentTask;
import ai.platon.scent.mongo.v1.NaiveResidentTask;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\u0006*\u00020\b\u001a\n\u0010\t\u001a\u00020\u0006*\u00020\b\u001a\n\u0010\n\u001a\u00020\u0006*\u00020\u0002\u001a\n\u0010\n\u001a\u00020\u0006*\u00020\b\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\u0002\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\b\u001a\n\u0010\r\u001a\u00020\f*\u00020\u0002\u001a\n\u0010\r\u001a\u00020\f*\u00020\b\u001a\n\u0010\u000e\u001a\u00020\f*\u00020\u0002\u001a\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0002\u001a\n\u0010\u000f\u001a\u00020\u0010*\u00020\b\u001a\n\u0010\u0011\u001a\u00020\u0006*\u00020\b\u00a8\u0006\u0012"}, d2={"createArgs", "Lai/platon/pulsar/common/options/LoadOptions;", "Lai/platon/scent/crawl/ResidentTask;", "taskId", "", "taskTime", "Ljava/time/Instant;", "deadTime", "Lai/platon/scent/mongo/v1/NaiveResidentTask;", "endTime", "expireAt", "isDead", "", "isRunTime", "isSupervised", "localStartTime", "Ljava/time/LocalDateTime;", "startTime", "scent-engine"})
public final class ResidentTaskKt {
    @NotNull
    public static final Instant expireAt(@NotNull ResidentTask $this$expireAt) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)$this$expireAt, (String)"<this>");
        if ($this$expireAt.getTaskPeriod().toHours() == 1L) {
            Instant instant2 = Instant.now().truncatedTo(ChronoUnit.HOURS);
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now().truncatedTo(ChronoUnit.HOURS)");
            instant = instant2;
        } else if ($this$expireAt.getTaskPeriod().toDays() == 1L) {
            instant = (Instant)$this$expireAt.getStartTime().invoke();
        } else {
            Instant instant3 = LoadOptionDefaults.INSTANCE.getExpireAt();
            Intrinsics.checkNotNullExpressionValue((Object)instant3, (String)"LoadOptionDefaults.expireAt");
            instant = instant3;
        }
        return instant;
    }

    public static final boolean isDead(@NotNull ResidentTask $this$isDead) {
        Intrinsics.checkNotNullParameter((Object)$this$isDead, (String)"<this>");
        if ($this$isDead.getIgnoreTTL()) {
            return false;
        }
        return Instant.now().compareTo((Instant)$this$isDead.getDeadTime().invoke()) > 0;
    }

    public static final boolean isRunTime(@NotNull ResidentTask $this$isRunTime) {
        Intrinsics.checkNotNullParameter((Object)$this$isRunTime, (String)"<this>");
        if ($this$isRunTime.getIgnoreTTL()) {
            return true;
        }
        Instant now = Instant.now();
        return now.compareTo((Instant)$this$isRunTime.getStartTime().invoke()) >= 0 && now.compareTo((Instant)$this$isRunTime.getEndTime().invoke()) < 0;
    }

    @NotNull
    public static final LocalDateTime localStartTime(@NotNull ResidentTask $this$localStartTime) {
        Intrinsics.checkNotNullParameter((Object)$this$localStartTime, (String)"<this>");
        LocalDateTime localDateTime = ((Instant)$this$localStartTime.getStartTime().invoke()).atOffset(DateTimes.INSTANCE.getZoneOffset()).toLocalDateTime();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"startTime().atOffset(Dat\u2026Offset).toLocalDateTime()");
        return localDateTime;
    }

    @NotNull
    public static final LoadOptions createArgs(@NotNull ResidentTask $this$createArgs, @NotNull String taskId, @NotNull Instant taskTime) {
        Intrinsics.checkNotNullParameter((Object)$this$createArgs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Intrinsics.checkNotNullParameter((Object)taskTime, (String)"taskTime");
        LoadOptions loadOptions = LoadOptions.Companion.create(VolatileConfig.Companion.getUNSAFE());
        boolean bl = false;
        boolean bl2 = false;
        LoadOptions it = loadOptions;
        boolean bl3 = false;
        it.setParse(true);
        it.setExpires($this$createArgs.getExpires());
        it.setExpireAt(ResidentTaskKt.expireAt($this$createArgs));
        it.setTaskId(taskId);
        it.setTaskTime(taskTime);
        it.setLabel($this$createArgs.getLabel());
        it.setIgnoreFailure(true);
        it.setStoreContent($this$createArgs.getStoreContent());
        return loadOptions;
    }

    public static final boolean isSupervised(@NotNull ResidentTask $this$isSupervised) {
        Intrinsics.checkNotNullParameter((Object)$this$isSupervised, (String)"<this>");
        int mod = $this$isSupervised.getId() % ClusterTools.INSTANCE.getCrawlerCount();
        return ClusterTools.INSTANCE.getInstancePartition() == mod;
    }

    @NotNull
    public static final Instant startTime(@NotNull NaiveResidentTask $this$startTime) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)$this$startTime, (String)"<this>");
        switch ($this$startTime.getStartTimePolicy()) {
            case "START_OF_DAY": {
                instant = DateTimes.INSTANCE.startOfDay();
                break;
            }
            case "START_OF_HOUR": {
                instant = DateTimes.INSTANCE.startOfHour();
                break;
            }
            case "AT_9AM": {
                instant = DateTimes.timePointOfDay$default((DateTimes)DateTimes.INSTANCE, (int)9, (int)0, (int)0, (int)6, null);
                break;
            }
            default: {
                Instant instant2 = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now()");
                instant = instant2;
            }
        }
        return instant;
    }

    @NotNull
    public static final Instant endTime(@NotNull NaiveResidentTask $this$endTime) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)$this$endTime, (String)"<this>");
        String string = $this$endTime.getEndTimePolicy();
        if (Intrinsics.areEqual((Object)string, (Object)"END_OF_DAY")) {
            instant = DateTimes.INSTANCE.endOfDay();
        } else if (Intrinsics.areEqual((Object)string, (Object)"END_OF_HOUR")) {
            instant = DateTimes.INSTANCE.endOfHour();
        } else {
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now()");
            instant = instant2;
        }
        return instant;
    }

    @NotNull
    public static final Instant deadTime(@NotNull NaiveResidentTask $this$deadTime) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)$this$deadTime, (String)"<this>");
        String string = $this$deadTime.getEndTimePolicy();
        if (Intrinsics.areEqual((Object)string, (Object)"END_OF_DAY")) {
            instant = DateTimes.INSTANCE.endOfDay();
        } else if (Intrinsics.areEqual((Object)string, (Object)"END_OF_HOUR")) {
            instant = DateTimes.INSTANCE.endOfHour();
        } else {
            Instant instant2 = DateTimes.INSTANCE.getDoomsday();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"DateTimes.doomsday");
            instant = instant2;
        }
        return instant;
    }

    @NotNull
    public static final Instant expireAt(@NotNull NaiveResidentTask $this$expireAt) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)$this$expireAt, (String)"<this>");
        if ($this$expireAt.getTaskPeriod().toHours() == 1L) {
            Instant instant2 = Instant.now().truncatedTo(ChronoUnit.HOURS);
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now().truncatedTo(ChronoUnit.HOURS)");
            instant = instant2;
        } else if ($this$expireAt.getTaskPeriod().toDays() == 1L) {
            instant = ResidentTaskKt.startTime($this$expireAt);
        } else {
            Instant instant3 = LoadOptionDefaults.INSTANCE.getExpireAt();
            Intrinsics.checkNotNullExpressionValue((Object)instant3, (String)"LoadOptionDefaults.expireAt");
            instant = instant3;
        }
        return instant;
    }

    public static final boolean isDead(@NotNull NaiveResidentTask $this$isDead) {
        Intrinsics.checkNotNullParameter((Object)$this$isDead, (String)"<this>");
        if ($this$isDead.getIgnoreTTL()) {
            return false;
        }
        return Instant.now().compareTo(ResidentTaskKt.deadTime($this$isDead)) > 0;
    }

    public static final boolean isRunTime(@NotNull NaiveResidentTask $this$isRunTime) {
        Intrinsics.checkNotNullParameter((Object)$this$isRunTime, (String)"<this>");
        if ($this$isRunTime.getIgnoreTTL()) {
            return true;
        }
        Instant now = Instant.now();
        return now.compareTo(ResidentTaskKt.startTime($this$isRunTime)) >= 0 && now.compareTo(ResidentTaskKt.endTime($this$isRunTime)) < 0;
    }

    @NotNull
    public static final LocalDateTime localStartTime(@NotNull NaiveResidentTask $this$localStartTime) {
        Intrinsics.checkNotNullParameter((Object)$this$localStartTime, (String)"<this>");
        LocalDateTime localDateTime = ResidentTaskKt.startTime($this$localStartTime).atOffset(DateTimes.INSTANCE.getZoneOffset()).toLocalDateTime();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"startTime().atOffset(Dat\u2026Offset).toLocalDateTime()");
        return localDateTime;
    }
}

