/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.crawl.scrape;

import ai.platon.pulsar.common.AppFiles;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.files.ext.AppFilesExtKt;
import ai.platon.pulsar.common.message.PageLoadStatusFormatter;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.scent.common.ScrapeResultSet;
import ai.platon.scent.crawl.serialize.ScrapeResponse;
import ai.platon.scent.crawl.serialize.ScrapeResponseV2;
import ai.platon.scent.mongo.v1.ScrapeTask;
import ai.platon.scent.mongo.v2.ScrapeTaskStatusV2;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lai/platon/scent/crawl/scrape/ScrapeExceptionHandler;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "trackIfInconsistent", "", "task", "Lai/platon/scent/mongo/v1/ScrapeTask;", "response", "Lai/platon/scent/crawl/serialize/ScrapeResponse;", "page", "Lai/platon/pulsar/persist/WebPage;", "Lai/platon/scent/mongo/v2/ScrapeTaskStatusV2;", "Lai/platon/scent/crawl/serialize/ScrapeResponseV2;", "scent-engine"})
public final class ScrapeExceptionHandler {
    @NotNull
    public static final ScrapeExceptionHandler INSTANCE = new ScrapeExceptionHandler();
    private static final Logger logger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(INSTANCE.getClass()));

    private ScrapeExceptionHandler() {
    }

    public final void trackIfInconsistent(@NotNull ScrapeTask task, @NotNull ScrapeResponse response, @NotNull WebPage page) {
        boolean hasRecords;
        boolean bl;
        Object[] objectArray;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Object message = "";
        boolean hasContent = response.getPageContentBytes() > 0;
        List<Map<String, Object>> list = response.getResultSet();
        if (list == null) {
            bl2 = false;
        } else {
            objectArray = (Object[])list;
            bl = false;
            bl2 = hasRecords = !objectArray.isEmpty();
        }
        if (page.getProtocolStatus().isRetry()) {
            return;
        }
        if (hasRecords) {
            boolean bl3 = true;
            boolean bl4 = false;
            bl = false;
            bl = false;
            boolean bl5 = false;
            if (response.getPageStatusCode() != 200) {
                message = "R!C PSC:" + response.getPageStatusCode();
            }
            if (response.getStatusCode() != 200) {
                message = "R!C SC:" + response.getStatusCode();
            }
        } else if (hasContent) {
            message = "C!R";
            Path path = AppFilesExtKt.export$default((AppFiles)AppFiles.INSTANCE, (WebPage)page, null, null, (int)6, null);
            objectArray = new Object[]{page.getId(), message, page.getProtocolStatus(), path};
            logger.info("{}. {} {} | {}", objectArray);
        }
        if (!hasContent && response.getPageStatusCode() == 200) {
            message = (String)message + " !C PSC:" + response.getPageStatusCode();
        }
        CharSequence path = (CharSequence)message;
        boolean bl6 = false;
        if (!StringsKt.isBlank((CharSequence)path)) {
            String prefix = "Inconsistent";
            PageLoadStatusFormatter report2 = new PageLoadStatusFormatter(page, null, true, false, false, false, 58, null);
            Object[] objectArray2 = new Object[]{prefix, message, task.getId(), report2};
            logger.warn("{} {} {} | {}", objectArray2);
        }
    }

    public final void trackIfInconsistent(@NotNull ScrapeTaskStatusV2 task, @NotNull ScrapeResponseV2 response, @NotNull WebPage page) {
        boolean hasRecords;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Object message = "";
        boolean hasContent = response.getPageContentBytes() > 0;
        List<ScrapeResultSet> list = response.getResultSets();
        if (list == null) {
            bl = false;
        } else {
            boolean bl2;
            block14: {
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean bl3;
                        ScrapeResultSet it = (ScrapeResultSet)element$iv;
                        boolean bl4 = false;
                        List list2 = it.getRecords();
                        if (list2 == null) {
                            bl3 = false;
                        } else {
                            Collection collection = list2;
                            boolean bl5 = false;
                            bl3 = !collection.isEmpty();
                        }
                        if (!bl3) continue;
                        bl2 = true;
                        break block14;
                    }
                    bl2 = false;
                }
            }
            bl = hasRecords = bl2;
        }
        if (hasRecords) {
            boolean bl6 = true;
            boolean $this$any$iv = false;
            boolean bl7 = false;
            bl7 = false;
            boolean bl8 = false;
            if (response.getPageStatusCode() != 200) {
                message = "R!C PSC:" + response.getPageStatusCode();
            }
            if (response.getStatusCode() != 200) {
                message = "R!C SC:" + response.getStatusCode();
            }
        } else if (hasContent) {
            message = response.getResultSets() == null ? "C!R(empty)" : "C!R(null)";
            Path path = AppFilesExtKt.export$default((AppFiles)AppFiles.INSTANCE, (WebPage)page, null, null, (int)6, null);
            logger.info("{}. Page has content but no records, exported to {}", (Object)page.getId(), (Object)path);
        }
        if (!hasContent && response.getPageStatusCode() == 200) {
            message = (String)message + " !C PSC:" + response.getPageStatusCode();
        }
        CharSequence path = (CharSequence)message;
        boolean $this$any$iv = false;
        if (!StringsKt.isBlank((CharSequence)path)) {
            String prefix = "Inconsistent";
            PageLoadStatusFormatter report2 = new PageLoadStatusFormatter(page, null, true, false, false, false, 58, null);
            Object[] objectArray = new Object[]{prefix, message, task.getId(), report2};
            logger.warn("{} {} {} | {}", objectArray);
        }
    }
}

