/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.crawl.urls.experimental;

import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.concurrent.ConcurrentExpiringLRUCache;
import ai.platon.pulsar.common.urls.UrlAware;
import ai.platon.pulsar.crawl.PageEvent;
import ai.platon.pulsar.crawl.common.GlobalCache;
import ai.platon.pulsar.crawl.common.GlobalCacheFactory;
import ai.platon.pulsar.crawl.common.url.CompletableListenableHyperlink;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.ql.ResultSets;
import ai.platon.pulsar.ql.h2.H2MemoryDb;
import ai.platon.pulsar.ql.h2.utils.ResultSetUtils;
import ai.platon.scent.common.ScrapeResultSet;
import ai.platon.scent.crawl.urls.SinkAwareHyperlinkMetrics;
import ai.platon.scent.crawl.urls.experimental.GeneralScrapeTask;
import ai.platon.scent.crawl.urls.experimental.GeneralSinkAwareLoadEventHandler;
import ai.platon.scent.executors.SinkCommitter;
import ai.platon.scent.executors.SinkResponse;
import ai.platon.scent.jackson.ExtensionsKt;
import ai.platon.scent.mongo.v2.XSqlTaskStatus;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.gson.Gson;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.h2.jdbc.JdbcSQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002BO\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020;H\u0016J\u0018\u0010=\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0002J\u001d\u0010A\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010BJ\u0018\u0010C\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0002J7\u0010D\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u00002\u0018\u0010E\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020G\u0012\u0004\u0012\u00020\u000f0FH\u0004\u00a2\u0006\u0002\u0010HJ\u0010\u0010I\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0012\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010K\u001a\u00020LH\u0004J\u001a\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010K\u001a\u00020L2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0018\u0010M\u001a\u00020J2\u0006\u0010K\u001a\u00020L2\u0006\u0010N\u001a\u00020\nH\u0004J\u0018\u0010O\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0014J\r\u0010P\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00106J\u001e\u0010P\u001a\u00028\u00002\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020TH\u0096\u0002\u00a2\u0006\u0002\u0010UJ\u0018\u0010V\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020GH\u0004J\b\u0010%\u001a\u00020;H\u0016J\b\u0010(\u001a\u00020;H\u0016J\u0010\u0010W\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u001cX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u00020&X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010'R\u0014\u0010(\u001a\u00020)X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010*R\u0016\u0010+\u001a\n -*\u0004\u0018\u00010,0,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\u00020/X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0014\u00102\u001a\u00020\n8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0013\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u00107\u001a\u0004\b5\u00106R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"Lai/platon/scent/crawl/urls/experimental/GeneralSinkAwareHyperlink;", "Response", "Lai/platon/pulsar/crawl/common/url/CompletableListenableHyperlink;", "url", "", "task", "Lai/platon/scent/crawl/urls/experimental/GeneralScrapeTask;", "response", "connectionPool", "Ljava/util/Queue;", "Ljava/sql/Connection;", "sinkCommitter", "Lai/platon/scent/executors/SinkCommitter;", "taskUpdater", "Lkotlin/Function1;", "", "globalCacheFactory", "Lai/platon/pulsar/crawl/common/GlobalCacheFactory;", "(Ljava/lang/String;Lai/platon/scent/crawl/urls/experimental/GeneralScrapeTask;Ljava/lang/Object;Ljava/util/Queue;Lai/platon/scent/executors/SinkCommitter;Lkotlin/jvm/functions/Function1;Lai/platon/pulsar/crawl/common/GlobalCacheFactory;)V", "args", "getArgs", "()Ljava/lang/String;", "setArgs", "(Ljava/lang/String;)V", "authToken", "getAuthToken", "setAuthToken", "event", "Lai/platon/pulsar/crawl/PageEvent;", "getEvent", "()Lai/platon/pulsar/crawl/PageEvent;", "setEvent", "(Lai/platon/pulsar/crawl/PageEvent;)V", "globalCache", "Lai/platon/pulsar/crawl/common/GlobalCache;", "getGlobalCache", "()Lai/platon/pulsar/crawl/common/GlobalCache;", "isCancelled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "isDone", "Ljava/util/concurrent/CountDownLatch;", "()Ljava/util/concurrent/CountDownLatch;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "metrics", "Lai/platon/scent/crawl/urls/SinkAwareHyperlinkMetrics;", "getMetrics", "()Lai/platon/scent/crawl/urls/SinkAwareHyperlinkMetrics;", "randomConnection", "getRandomConnection", "()Ljava/sql/Connection;", "getResponse", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getTask", "()Lai/platon/scent/crawl/urls/experimental/GeneralScrapeTask;", "cancel", "", "mayInterruptIfRunning", "checkWebPage", "Lai/platon/pulsar/common/urls/UrlAware;", "page", "Lai/platon/pulsar/persist/WebPage;", "commit", "(Lai/platon/scent/crawl/urls/experimental/GeneralScrapeTask;Ljava/lang/Object;)V", "doExtract", "executeCallback", "thenAction", "Lkotlin/Function2;", "Lai/platon/scent/executors/SinkResponse;", "(Lai/platon/scent/crawl/urls/experimental/GeneralScrapeTask;Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)V", "executeQuery", "Ljava/sql/ResultSet;", "sqlTask", "Lai/platon/scent/mongo/v2/XSqlTaskStatus;", "executeQueryWithConnection", "conn", "extract", "get", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "handleSyncResponse", "updateTask", "scent-engine"})
public class GeneralSinkAwareHyperlink<Response>
extends CompletableListenableHyperlink<Response> {
    @NotNull
    private final GeneralScrapeTask task;
    private final Response response;
    @NotNull
    private final Queue<Connection> connectionPool;
    @NotNull
    private final SinkCommitter sinkCommitter;
    @NotNull
    private final Function1<GeneralScrapeTask, Unit> taskUpdater;
    @NotNull
    private final GlobalCacheFactory globalCacheFactory;
    private final Logger logger;
    @NotNull
    private final SinkAwareHyperlinkMetrics metrics;
    @NotNull
    private final AtomicBoolean isCancelled;
    @NotNull
    private final CountDownLatch isDone;
    @Nullable
    private String authToken;
    @Nullable
    private String args;
    @NotNull
    private PageEvent event;

    public GeneralSinkAwareHyperlink(@NotNull String url, @NotNull GeneralScrapeTask task, Response response, @NotNull Queue<Connection> connectionPool, @NotNull SinkCommitter sinkCommitter, @NotNull Function1<? super GeneralScrapeTask, Unit> taskUpdater, @NotNull GlobalCacheFactory globalCacheFactory) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter(connectionPool, (String)"connectionPool");
        Intrinsics.checkNotNullParameter((Object)sinkCommitter, (String)"sinkCommitter");
        Intrinsics.checkNotNullParameter(taskUpdater, (String)"taskUpdater");
        Intrinsics.checkNotNullParameter((Object)globalCacheFactory, (String)"globalCacheFactory");
        super(url, null, 0, null, null, null, null, 126, null);
        this.task = task;
        this.response = response;
        this.connectionPool = connectionPool;
        this.sinkCommitter = sinkCommitter;
        this.taskUpdater = taskUpdater;
        this.globalCacheFactory = globalCacheFactory;
        this.logger = LoggerFactory.getLogger(GeneralSinkAwareHyperlink.class);
        this.metrics = new SinkAwareHyperlinkMetrics("experimental");
        this.isCancelled = new AtomicBoolean();
        this.isDone = new CountDownLatch(1);
        this.authToken = this.task.getAuthToken();
        this.args = "-cacheContent true -storeContent false -parse";
        this.event = (PageEvent)new GeneralSinkAwareLoadEventHandler(this.task, this.metrics);
        this.metrics.getLinks().mark();
    }

    @NotNull
    public final GeneralScrapeTask getTask() {
        return this.task;
    }

    public final Response getResponse() {
        return this.response;
    }

    @NotNull
    protected final GlobalCache getGlobalCache() {
        return this.globalCacheFactory.getGlobalCache();
    }

    @NotNull
    protected final Connection getRandomConnection() {
        return new H2MemoryDb(null, 1, null).getRandomConnection();
    }

    @NotNull
    protected final SinkAwareHyperlinkMetrics getMetrics() {
        return this.metrics;
    }

    @NotNull
    protected final AtomicBoolean isCancelled() {
        return this.isCancelled;
    }

    @NotNull
    protected final CountDownLatch isDone() {
        return this.isDone;
    }

    @Nullable
    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(@Nullable String string) {
        this.authToken = string;
    }

    @Nullable
    public String getArgs() {
        return this.args;
    }

    public void setArgs(@Nullable String string) {
        this.args = string;
    }

    @NotNull
    public PageEvent getEvent() {
        return this.event;
    }

    public void setEvent(@NotNull PageEvent pageEvent) {
        Intrinsics.checkNotNullParameter((Object)pageEvent, (String)"<set-?>");
        this.event = pageEvent;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        this.isCancelled.set(true);
        this.isDone.countDown();
        return true;
    }

    public boolean isCancelled() {
        return this.isCancelled.get();
    }

    public boolean isDone() {
        return this.isDone.getCount() == 0L;
    }

    public Response get() {
        this.isDone.await();
        return this.response;
    }

    public Response get(long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        this.isDone.await(timeout, unit);
        return this.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extract(@NotNull UrlAware url, @NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        if (this.isCancelled.get()) {
            this.isDone.countDown();
            return;
        }
        try {
            this.doExtract(url, page);
        }
        catch (Exception e) {
            this.logger.warn("Unexpected exception", (Throwable)e);
        }
        finally {
            this.isDone.countDown();
        }
    }

    private final void doExtract(UrlAware url, WebPage page) {
        Object object;
        boolean bl = false;
        try {
            object = Result.Companion;
            boolean bl2 = false;
            this.checkWebPage(url, page);
            Unit unit = Unit.INSTANCE;
            boolean bl3 = false;
            object = Result.constructor-impl((Object)unit);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object object2 = object;
        boolean bl5 = false;
        boolean bl6 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl7 = false;
            this.logger.warn("Web page check failure | {}", (Object)ExceptionsKt.simplify$default((Throwable)it, null, null, (int)3, null));
            return;
        }
        this.executeQuery(this.task);
        this.task.setContentLength((int)page.getContentLength());
        this.task.setPageStatusCode(page.getProtocolStatus().getMinorCode());
        this.commit(this.task, this.response);
        this.updateTask(this.task);
    }

    private final void checkWebPage(UrlAware url, WebPage page) {
        if (!page.getProtocolStatus().isSuccess() || page.getContentLength() == 0L || page.getContent() == null) {
            this.task.setStatusCode(204);
            return;
        }
        boolean bl = page.isContentUpdated();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "require page.isContentUpdated to be true";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = page.getPersistContent() == null;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "page persistContent is not null";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = page.getTmpContent() != null;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "cachedContent of page is null";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ConcurrentExpiringLRUCache concurrentExpiringLRUCache = this.getGlobalCache().getPageCache();
        String string = page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.url");
        boolean bl7 = concurrentExpiringLRUCache.get((Object)string) != null;
        bl2 = false;
        bl3 = false;
        if (!bl7) {
            boolean bl8 = false;
            String string2 = "Page is NOT cached";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
    }

    protected void executeQuery(@NotNull GeneralScrapeTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        int failure = 0;
        task.setStatusCode(102);
        Iterable $this$forEach$iv = task.getSqlTasks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XSqlTaskStatus sqlTask = (XSqlTaskStatus)element$iv;
            boolean bl = false;
            ResultSet rs = this.executeQuery(sqlTask, task);
            if (sqlTask.getStatusCode() == 200) {
                List list;
                if (rs == null) continue;
                List entities = ResultSetUtils.INSTANCE.getEntitiesFromResultSet(rs);
                List list2 = task.getResultSets();
                if (list2 == null) {
                    boolean bl2 = false;
                    list = new ArrayList();
                } else {
                    list = list2;
                }
                List resultSets = list;
                resultSets.add(new ScrapeResultSet(sqlTask.getName(), entities));
                continue;
            }
            ++failure;
        }
        int n = failure;
        task.setStatusCode(n == 0 ? 200 : (n == task.getSqlTasks().size() ? 417 : 206));
    }

    protected void commit(@NotNull GeneralScrapeTask task, Response response) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        try {
            if (task.getCallbackUrl() != null) {
                this.executeCallback(task, response, (Function2<GeneralScrapeTask, SinkResponse, Unit>)((Function2)new Function2<GeneralScrapeTask, SinkResponse, Unit>(this, task){
                    final /* synthetic */ GeneralSinkAwareHyperlink<Response> this$0;
                    final /* synthetic */ GeneralScrapeTask $task;
                    {
                        this.this$0 = $receiver;
                        this.$task = $task;
                        super(2);
                    }

                    public final void invoke(@NotNull GeneralScrapeTask $noName_0, @NotNull SinkResponse sinkResponse) {
                        Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"$noName_0");
                        Intrinsics.checkNotNullParameter((Object)sinkResponse, (String)"sinkResponse");
                        this.this$0.handleSyncResponse(this.$task, sinkResponse);
                    }
                }));
            }
        }
        catch (JsonProcessingException e) {
            this.logger.warn("Failed serialize scrape response for <" + task.getUuid() + ">", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.warn("Failed to commit task <" + task.getUuid() + ">", (Throwable)e);
        }
    }

    @Nullable
    protected ResultSet executeQuery(@NotNull XSqlTaskStatus sqlTask, @NotNull GeneralScrapeTask task) {
        Intrinsics.checkNotNullParameter((Object)sqlTask, (String)"sqlTask");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        ResultSet rs = null;
        try {
            rs = this.executeQuery(sqlTask);
        }
        catch (Throwable e) {
            sqlTask.setStatusCode(417);
            this.logger.warn("Failed to execute task #" + task.getUuid() + "\n{}", (Object)ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null));
        }
        return rs;
    }

    @Nullable
    protected final ResultSet executeQuery(@NotNull XSqlTaskStatus sqlTask) {
        Object object;
        GeneralSinkAwareHyperlink<Response> generalSinkAwareHyperlink;
        Intrinsics.checkNotNullParameter((Object)sqlTask, (String)"sqlTask");
        Object object2 = this;
        boolean bl = false;
        boolean bl2 = false;
        GeneralSinkAwareHyperlink<Response> it2 = object2;
        boolean bl3 = false;
        GeneralSinkAwareHyperlink<Response> generalSinkAwareHyperlink2 = generalSinkAwareHyperlink = AppContext.INSTANCE.isActive() ? object2 : null;
        if (generalSinkAwareHyperlink == null) {
            return null;
        }
        object2 = this.connectionPool.poll();
        Object connection = object2 == null ? this.getRandomConnection() : object2;
        boolean bl4 = false;
        try {
            object = Result.Companion;
            boolean bl5 = false;
            ResultSet resultSet = this.executeQueryWithConnection(sqlTask, (Connection)connection);
            boolean it2 = false;
            object = Result.constructor-impl((Object)resultSet);
        }
        catch (Throwable throwable) {
            it2 = Result.Companion;
            bl3 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object object3 = object;
        boolean bl6 = false;
        boolean bl7 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
        if (throwable != null) {
            Throwable it3 = throwable;
            boolean bl8 = false;
            this.connectionPool.offer((Connection)connection);
            throw it3;
        }
        return (ResultSet)object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected final ResultSet executeQueryWithConnection(@NotNull XSqlTaskStatus sqlTask, @NotNull Connection conn) {
        AutoCloseable autoCloseable;
        AutoCloseable autoCloseable2;
        Intrinsics.checkNotNullParameter((Object)sqlTask, (String)"sqlTask");
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        String sql2 = sqlTask.getSql();
        ResultSet result2 = null;
        Statement statement = conn.createStatement(1005, 1007);
        if (statement != null) {
            autoCloseable2 = statement;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                ResultSet resultSet;
                Statement st = (Statement)autoCloseable2;
                boolean bl3 = false;
                try {
                    Unit unit;
                    resultSet = st.executeQuery(sql2);
                    if (resultSet == null) {
                        unit = null;
                    } else {
                        AutoCloseable autoCloseable3 = resultSet;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        Throwable throwable2 = null;
                        try {
                            ResultSet rs = (ResultSet)autoCloseable3;
                            boolean bl6 = false;
                            result2 = ResultSetUtils.copyResultSet$default((ResultSetUtils)ResultSetUtils.INSTANCE, (ResultSet)rs, (int)0, (int)2, null);
                            sqlTask.setStatusCode(200);
                            Unit unit2 = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable3, (Throwable)throwable2);
                        }
                        unit = Unit.INSTANCE;
                    }
                    resultSet = unit;
                }
                catch (JdbcSQLException e) {
                    String string = e.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.toString()");
                    String message = string;
                    if (StringsKt.contains$default((CharSequence)message, (CharSequence)"Syntax error in SQL statement", (boolean)false, (int)2, null)) {
                        sqlTask.setStatusCode(400);
                        this.logger.warn("Syntax error in SQL statement #" + this.getTask().getUuid() + "\n{}", (Object)ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null));
                    } else {
                        sqlTask.setStatusCode(417);
                        this.logger.warn("Failed to execute scrape task #" + this.getTask().getUuid() + "\n{}", (Object)ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null));
                    }
                    resultSet = Unit.INSTANCE;
                }
                ResultSet resultSet2 = resultSet;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable);
            }
        }
        statement = result2;
        if (statement == null) {
            autoCloseable2 = ResultSets.newResultSet();
            Intrinsics.checkNotNullExpressionValue((Object)autoCloseable2, (String)"newResultSet()");
            autoCloseable = autoCloseable2;
        } else {
            autoCloseable = statement;
        }
        return autoCloseable;
    }

    protected final void executeCallback(@NotNull GeneralScrapeTask task, Response response, @NotNull Function2<? super GeneralScrapeTask, ? super SinkResponse, Unit> thenAction) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter(thenAction, (String)"thenAction");
        String string = task.getCallbackUrl();
        if (string == null) {
            return;
        }
        String callbackUrl = string;
        this.metrics.getCommits().mark();
        try {
            String responseBody = ExtensionsKt.scentObjectMapper().writeValueAsString(response);
            this.logger.info("Writing " + responseBody);
            Intrinsics.checkNotNullExpressionValue((Object)responseBody, (String)"responseBody");
            this.sinkCommitter.commit(responseBody, callbackUrl, (Function1<? super SinkResponse, Unit>)((Function1)new Function1<SinkResponse, Unit>(thenAction, task){
                final /* synthetic */ Function2<GeneralScrapeTask, SinkResponse, Unit> $thenAction;
                final /* synthetic */ GeneralScrapeTask $task;
                {
                    this.$thenAction = $thenAction;
                    this.$task = $task;
                    super(1);
                }

                public final void invoke(@NotNull SinkResponse commitResponse) {
                    Intrinsics.checkNotNullParameter((Object)commitResponse, (String)"commitResponse");
                    this.$thenAction.invoke((Object)this.$task, (Object)commitResponse);
                }
            }));
        }
        catch (Exception e) {
            this.metrics.getFailedCommits().mark();
            task.setSyncError(e.getMessage());
        }
    }

    protected final void handleSyncResponse(@NotNull GeneralScrapeTask task, @NotNull SinkResponse response) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.metrics.getSyncResponses().mark();
        task.setSyncStatusCode(response.getStatusCode());
        if (response.getStatusCode() != 0 && response.getStatusCode() != 200) {
            this.metrics.getFailedSyncResponses().mark();
        }
        task.setSyncResponseHeaders(StringUtils.abbreviateMiddle((String)new Gson().toJson(response.getHeaders()), (String)"...", (int)256));
        task.setSyncResponseBody(StringUtils.abbreviateMiddle((String)response.getBody(), (String)"...", (int)1024));
        this.updateTask(task);
    }

    private final void updateTask(GeneralScrapeTask task) {
        block2: {
            boolean bl;
            boolean bl2;
            Object object;
            this.metrics.getPersists().mark();
            boolean bl3 = false;
            try {
                object = Result.Companion;
                boolean bl4 = false;
                this.taskUpdater.invoke((Object)task);
                Unit unit = Unit.INSTANCE;
                bl2 = false;
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                bl = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Object object2 = object;
            boolean bl5 = false;
            boolean bl6 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Throwable throwable2 = throwable;
            bl2 = false;
            bl = false;
            Throwable throwable3 = throwable2;
            boolean bl7 = false;
            Throwable it = throwable3;
            boolean bl8 = false;
            this.logger.warn("Failed to update task <" + task.getUuid() + ">", it);
        }
    }
}

