/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ql.h2.udfs;

import ai.platon.pulsar.common.LangKt;
import ai.platon.pulsar.common.OpenMapTable;
import ai.platon.pulsar.common.config.VolatileConfig;
import ai.platon.pulsar.common.options.LoadOptions;
import ai.platon.pulsar.common.urls.UrlUtils;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.dom.model.PageAttribute;
import ai.platon.pulsar.dom.model.PageEntity;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.ql.annotation.H2Context;
import ai.platon.pulsar.ql.annotation.UDFGroup;
import ai.platon.pulsar.ql.annotation.UDFunction;
import ai.platon.pulsar.ql.h2.H2ExtKt;
import ai.platon.pulsar.ql.types.ValueDom;
import ai.platon.pulsar.session.PulsarSession;
import ai.platon.scent.ScentSession;
import ai.platon.scent.common.options.CellType;
import ai.platon.scent.dom.HNormUrl;
import ai.platon.scent.dom.HarvestOptions;
import ai.platon.scent.dom.nodes.AnchorGroup;
import ai.platon.scent.entities.DataTypeStatistics;
import ai.platon.scent.entities.HarvestResult;
import ai.platon.scent.entities.PageTableKt;
import ai.platon.scent.extract.extractor.KVPatternExtractor;
import ai.platon.scent.ql.h2.H2SessionFactory;
import ai.platon.scent.ql.h2.ScentSQLSession;
import ai.platon.scent.ql.h2.udfs.ExtractFunctionTables;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.h2.command.CommandInterface;
import org.h2.engine.Session;
import org.h2.jdbc.JdbcConnection;
import org.h2.result.ResultWithGeneratedKeys;
import org.h2.tools.SimpleResultSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@UDFGroup(namespace="DOM")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010#\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0015H\u0002J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"H\u0002J \u0010#\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010%\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J \u0010&\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)H\u0002J\u0012\u0010*\u001a\u00020\u00152\b\b\u0001\u0010\u001e\u001a\u00020\u001fH\u0007J\u001a\u0010+\u001a\u00020\u00152\b\b\u0001\u0010\u001e\u001a\u00020'2\u0006\u0010,\u001a\u00020\u0005H\u0007J\u0010\u0010-\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u000200H\u0002J$\u00101\u001a\u0002022\b\b\u0001\u0010\u001e\u001a\u00020'2\u0006\u0010,\u001a\u00020\u00052\b\b\u0002\u00103\u001a\u00020\u0015H\u0007J\u001a\u00104\u001a\u0002022\b\b\u0001\u0010\u001e\u001a\u00020'2\u0006\u0010,\u001a\u00020\u0005H\u0007J$\u00105\u001a\u0002022\b\b\u0001\u0010\u001e\u001a\u00020'2\u0006\u0010,\u001a\u00020\u00052\b\b\u0002\u00103\u001a\u00020\u0015H\u0007JD\u00106\u001a\u0002022\b\b\u0001\u0010\u001e\u001a\u00020'2\u0006\u0010,\u001a\u00020\u00052\b\b\u0002\u00103\u001a\u00020\u00152\u001e\u00107\u001a\u001a\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u001d08H\u0002J(\u00109\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"H\u0002J\u001a\u0010:\u001a\u0002022\b\b\u0001\u0010\u001e\u001a\u00020'2\u0006\u0010;\u001a\u00020<H\u0007J\"\u0010:\u001a\u0002022\b\b\u0001\u0010\u001e\u001a\u00020'2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0005H\u0007J\u001a\u0010>\u001a\u0002022\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010?\u001a\u00020\u0015H\u0002J\u001a\u0010@\u001a\u0002022\b\b\u0001\u0010\u001e\u001a\u00020'2\u0006\u0010,\u001a\u00020\u0005H\u0007J\u0019\u0010A\u001a\u0004\u0018\u00010B2\b\u0010C\u001a\u0004\u0018\u00010DH\u0002\u00a2\u0006\u0002\u0010EJ\u0019\u0010F\u001a\u0004\u0018\u00010\u00152\b\u0010C\u001a\u0004\u0018\u00010DH\u0002\u00a2\u0006\u0002\u0010GJ\u0018\u0010H\u001a\u0002022\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\"\u0010I\u001a\u0002022\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00052\b\b\u0002\u0010?\u001a\u00020\u0015H\u0002J\u0018\u0010J\u001a\u00020K2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0005H\u0002J\u0010\u0010L\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R \u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lai/platon/scent/ql/h2/udfs/ExtractFunctionTables;", "", "()V", "harvestTaskTableFieldDefines", "", "", "harvestTaskTableFields", "", "harvestTaskTableFieldsPlaceholds", "integerFieldDefine", "joinedHarvestTaskTableFields", "kvPatternExtractor", "Ljava/util/concurrent/atomic/AtomicReference;", "Lai/platon/scent/extract/extractor/KVPatternExtractor;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "sessionTracker", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "", "buildTableName", "url", "tid", "buildTaskId", "createHarvestResultMetaTable", "", "conn", "Ljava/sql/Connection;", "tableName", "table", "Lai/platon/pulsar/common/OpenMapTable;", "createHarvestResultTable", "createHarvestTaskTableIfAbsent", "deleteHarvestTask", "doHarvest", "Lorg/h2/jdbc/JdbcConnection;", "options", "Lai/platon/scent/dom/HarvestOptions;", "dropAllHarvestTasks", "dropHarvest", "portalUrl", "dropHarvestTaskTable", "getKVPatternExtractor", "session", "Lai/platon/scent/ScentSession;", "harvest", "Ljava/sql/ResultSet;", "nthTable", "harvestMetadata", "harvestNthTable", "harvestNthTable0", "harvestFun", "Lkotlin/Function3;", "insertHarvestTask", "kvs", "dom", "Lai/platon/pulsar/ql/types/ValueDom;", "cssQuery", "listHarvestTasks", "limit", "loadAndGetAnchorGroups", "parseDouble", "", "cell", "Lai/platon/pulsar/common/OpenMapTable$Cell;", "(Lai/platon/pulsar/common/OpenMapTable$Cell;)Ljava/lang/Double;", "parseInt", "(Lai/platon/pulsar/common/OpenMapTable$Cell;)Ljava/lang/Integer;", "queryHarvestTaskTable", "queryTable", "tableExists", "", "truncateHarvestTaskTable", "scent-engine"})
public final class ExtractFunctionTables {
    @NotNull
    public static final ExtractFunctionTables INSTANCE = new ExtractFunctionTables();
    private static final Logger log = LoggerFactory.getLogger(ExtractFunctionTables.class);
    @NotNull
    private static final String integerFieldDefine = "INTEGER NOT NULL DEFAULT 0";
    @NotNull
    private static final ConcurrentHashMap<Integer, Set<Long>> sessionTracker = new ConcurrentHashMap();
    @NotNull
    private static final Map<String, String> harvestTaskTableFieldDefines;
    @NotNull
    private static final Set<String> harvestTaskTableFields;
    @NotNull
    private static final String joinedHarvestTaskTableFields;
    @NotNull
    private static final String harvestTaskTableFieldsPlaceholds;
    @NotNull
    private static final AtomicReference<KVPatternExtractor> kvPatternExtractor;

    private ExtractFunctionTables() {
    }

    public final Logger getLog() {
        return log;
    }

    @JvmStatic
    @UDFunction
    @NotNull
    public static final ResultSet kvs(@H2Context @NotNull JdbcConnection conn, @NotNull ValueDom dom) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)dom, (String)"dom");
        return ExtractFunctionTables.kvs(conn, dom, ":root");
    }

    @JvmStatic
    @UDFunction
    @NotNull
    public static final ResultSet kvs(@H2Context @NotNull JdbcConnection conn, @NotNull ValueDom dom, @NotNull String cssQuery) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)dom, (String)"dom");
        Intrinsics.checkNotNullParameter((Object)cssQuery, (String)"cssQuery");
        ScentSQLSession session = H2SessionFactory.INSTANCE.getSession((Connection)conn);
        SimpleResultSet rs = new SimpleResultSet();
        rs.setAutoClose(false);
        H2ExtKt.addColumn((SimpleResultSet)rs, (String)"NAME");
        H2ExtKt.addColumn((SimpleResultSet)rs, (String)"VALUE");
        if (H2SessionFactory.INSTANCE.isColumnRetrieval((Connection)conn)) {
            return (ResultSet)rs;
        }
        Object object = dom.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dom.element");
        PageEntity pageEntity = KVPatternExtractor.Companion.extractBy(object, cssQuery, INSTANCE.getKVPatternExtractor(session));
        object = pageEntity.getAttributes().values();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pageEntity.attributes.values");
        Iterable $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PageAttribute it = (PageAttribute)element$iv;
            boolean bl = false;
            Object[] objectArray = new Object[]{it.getName(), it.getValue()};
            rs.addRow(objectArray);
        }
        return (ResultSet)rs;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @UDFunction(hasShortcut=true, description="Load and find out all anchor groups, each anchor group is a recoverable page set")
    @NotNull
    public static final ResultSet loadAndGetAnchorGroups(@H2Context @NotNull JdbcConnection conn, @NotNull String portalUrl) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)portalUrl, (String)"portalUrl");
        SimpleResultSet rs = new SimpleResultSet();
        String[] stringArray = new String[]{"PATH", "DISTORT", "SCORE", "NUM_LINKS", "LINKS"};
        boolean $i$f$forEach = false;
        void var5_6 = $this$forEach$iv;
        int n = ((void)var5_6).length;
        for (int i = 0; i < n; ++i) {
            void element$iv;
            void it = element$iv = var5_6[i];
            boolean bl = false;
            H2ExtKt.addColumn((SimpleResultSet)rs, (String)it);
        }
        if (H2SessionFactory.INSTANCE.isColumnRetrieval((Connection)conn)) {
            return (ResultSet)rs;
        }
        ScentSQLSession scentSession = H2SessionFactory.INSTANCE.getSession((Connection)conn);
        VolatileConfig conf = scentSession.getSessionConfig().toVolatileConfig();
        HNormUrl normUrl = HNormUrl.Companion.parse(portalUrl, conf);
        HarvestOptions options = normUrl.getHOptions();
        WebPage page = scentSession.load(normUrl);
        FeaturedDocument doc = ScentSession.DefaultImpls.parse$default(scentSession, page, options, false, 4, null);
        SortedSet anchorGroups = scentSession.arrangeLinks(normUrl, doc);
        Iterable $this$forEach$iv2 = anchorGroups;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            String distort;
            AnchorGroup it = (AnchorGroup)element$iv;
            boolean bl = false;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Object[] objectArray = "%.4f";
            Object object = new Object[]{it.getDistortion()};
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)String.format((String)objectArray, Arrays.copyOf(object, ((Object[])object).length)), (String)"java.lang.String.format(format, *args)");
            objectArray = new Object[5];
            objectArray[0] = it.getPath();
            objectArray[1] = distort;
            object = it.getScore().toString();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.score.toString()");
            objectArray[2] = object;
            objectArray[3] = it.getUrlStrings().size();
            objectArray[4] = CollectionsKt.joinToString$default((Iterable)it.getUrlStrings(), null, null, null, (int)0, null, null, (int)63, null);
            Object[] values = objectArray;
            rs.addRow(Arrays.copyOf(values, values.length));
        }
        return (ResultSet)rs;
    }

    @JvmStatic
    @UDFunction(hasShortcut=true)
    @JvmOverloads
    @NotNull
    public static final ResultSet harvest(@H2Context @NotNull JdbcConnection conn, @NotNull String portalUrl, int nthTable) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)portalUrl, (String)"portalUrl");
        return ExtractFunctionTables.harvestNthTable(conn, portalUrl, nthTable);
    }

    public static /* synthetic */ ResultSet harvest$default(JdbcConnection jdbcConnection, String string, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        return ExtractFunctionTables.harvest(jdbcConnection, string, n);
    }

    @JvmStatic
    @UDFunction(hasShortcut=true)
    @JvmOverloads
    @NotNull
    public static final ResultSet harvestNthTable(@H2Context @NotNull JdbcConnection conn, @NotNull String portalUrl, int nthTable) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)portalUrl, (String)"portalUrl");
        return INSTANCE.harvestNthTable0(conn, portalUrl, nthTable, (Function3<? super JdbcConnection, ? super String, ? super HarvestOptions, Unit>)((Function3)new Function3<JdbcConnection, String, HarvestOptions, Unit>((Object)INSTANCE){

            public final void invoke(@NotNull JdbcConnection p0, @NotNull String p1, @NotNull HarvestOptions p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                ExtractFunctionTables.access$doHarvest((ExtractFunctionTables)this.receiver, p0, p1, p2);
            }
        }));
    }

    public static /* synthetic */ ResultSet harvestNthTable$default(JdbcConnection jdbcConnection, String string, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        return ExtractFunctionTables.harvestNthTable(jdbcConnection, string, n);
    }

    private final ResultSet harvestNthTable0(@H2Context JdbcConnection conn, String portalUrl, int nthTable, Function3<? super JdbcConnection, ? super String, ? super HarvestOptions, Unit> harvestFun) {
        boolean columnRetrieval = H2SessionFactory.INSTANCE.isColumnRetrieval((Connection)conn);
        if (columnRetrieval) {
            this.createHarvestTaskTableIfAbsent((Connection)conn);
        }
        ScentSQLSession scentSession = H2SessionFactory.INSTANCE.getSession((Connection)conn);
        Pair pair = UrlUtils.splitUrlArgs((String)portalUrl);
        String url = (String)pair.component1();
        String args = (String)pair.component2();
        LoadOptions loadOptions = PulsarSession.DefaultImpls.options$default((PulsarSession)scentSession, (String)args, null, (int)2, null);
        boolean bl = false;
        int n = 0;
        HarvestOptions $this$harvestNthTable0_u24lambda_u2d3 = (HarvestOptions)loadOptions;
        boolean bl2 = false;
        $this$harvestNthTable0_u24lambda_u2d3.setNoSubTable(true);
        HarvestOptions options = (HarvestOptions)loadOptions;
        ResultSet result2 = this.queryHarvestTaskTable((Connection)conn, url);
        if (!result2.next()) {
            boolean bl3;
            Object object;
            bl = false;
            try {
                object = Result.Companion;
                boolean bl4 = false;
                harvestFun.invoke((Object)conn, (Object)url, (Object)options);
                Unit unit = Unit.INSTANCE;
                boolean bl5 = false;
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                bl3 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Object object2 = object;
            n = 0;
            boolean bl6 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Throwable throwable2 = throwable;
                boolean bl7 = false;
                bl3 = false;
                Throwable throwable3 = throwable2;
                boolean bl8 = false;
                Throwable it = throwable3;
                boolean bl9 = false;
                INSTANCE.getLog().error("Failed to do the harvest", it);
            }
            result2 = this.queryHarvestTaskTable((Connection)conn, url);
        }
        result2.beforeFirst();
        int i = 0;
        while (result2.next()) {
            ResultSet resultSet;
            n = i;
            i = n + 1;
            if (n >= nthTable) break;
            if (i != nthTable) continue;
            String tableName = result2.getString("TABLE_NAME");
            if (columnRetrieval) {
                Connection connection = (Connection)conn;
                Intrinsics.checkNotNullExpressionValue((Object)tableName, (String)"tableName");
                resultSet = this.queryTable(connection, tableName, 0);
            } else {
                Connection connection = (Connection)conn;
                Intrinsics.checkNotNullExpressionValue((Object)tableName, (String)"tableName");
                resultSet = ExtractFunctionTables.queryTable$default(this, connection, tableName, 0, 4, null);
            }
            return resultSet;
        }
        return (ResultSet)new SimpleResultSet();
    }

    static /* synthetic */ ResultSet harvestNthTable0$default(ExtractFunctionTables extractFunctionTables, JdbcConnection jdbcConnection, String string, int n, Function3 function3, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        return extractFunctionTables.harvestNthTable0(jdbcConnection, string, n, (Function3<? super JdbcConnection, ? super String, ? super HarvestOptions, Unit>)function3);
    }

    @JvmStatic
    @UDFunction(hasShortcut=true)
    @NotNull
    public static final ResultSet harvestMetadata(@H2Context @NotNull JdbcConnection conn, @NotNull String portalUrl) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)portalUrl, (String)"portalUrl");
        if (H2SessionFactory.INSTANCE.isColumnRetrieval((Connection)conn)) {
            INSTANCE.createHarvestTaskTableIfAbsent((Connection)conn);
            return INSTANCE.listHarvestTasks((Connection)conn, 0);
        }
        ScentSQLSession scentSession = H2SessionFactory.INSTANCE.getSession((Connection)conn);
        Pair pair = UrlUtils.splitUrlArgs((String)portalUrl);
        String url = (String)pair.component1();
        String args = (String)pair.component2();
        ResultSet rs = INSTANCE.queryHarvestTaskTable((Connection)conn, url);
        if (!rs.isBeforeFirst()) {
            boolean bl;
            boolean bl2;
            Object object;
            HarvestOptions options = (HarvestOptions)PulsarSession.DefaultImpls.options$default((PulsarSession)scentSession, (String)args, null, (int)2, null);
            boolean bl3 = false;
            try {
                object = Result.Companion;
                boolean bl4 = false;
                INSTANCE.doHarvest(conn, url, options);
                Unit unit = Unit.INSTANCE;
                bl2 = false;
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                bl = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Object object2 = object;
            boolean bl5 = false;
            boolean bl6 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Throwable throwable2 = throwable;
                bl2 = false;
                bl = false;
                Throwable throwable3 = throwable2;
                boolean bl7 = false;
                Throwable it = throwable3;
                boolean bl8 = false;
                INSTANCE.getLog().error("Failed to do harvest", it);
            }
            rs = INSTANCE.queryHarvestTaskTable((Connection)conn, url);
        }
        return rs;
    }

    @JvmStatic
    @UDFunction(hasShortcut=true)
    public static final int dropHarvest(@H2Context @NotNull JdbcConnection conn, @NotNull String portalUrl) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)portalUrl, (String)"portalUrl");
        Pair pair = UrlUtils.splitUrlArgs((String)portalUrl);
        String url = (String)pair.component1();
        INSTANCE.createHarvestTaskTableIfAbsent((Connection)conn);
        ResultSet rs = INSTANCE.queryHarvestTaskTable((Connection)conn, url);
        while (rs.next()) {
            String tableName = rs.getString("TABLE_NAME");
            String sql2 = "DROP TABLE IF EXISTS " + tableName;
            CommandInterface command = conn.getSession().prepareCommand(sql2, 1000);
            ResultWithGeneratedKeys r = command.executeUpdate(null);
            if (!LangKt.alwaysFalse()) continue;
            tableName = rs.getString("META_TABLE_NAME");
            sql2 = "DROP TABLE IF EXISTS " + tableName;
            command = conn.getSession().prepareCommand(sql2, 1000);
            r = command.executeUpdate(null);
        }
        return INSTANCE.deleteHarvestTask((Connection)conn, url);
    }

    @JvmStatic
    @UDFunction(hasShortcut=true)
    public static final int dropAllHarvestTasks(@H2Context @NotNull Connection conn) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        log.warn("All harvest tasks will be dropped!");
        INSTANCE.createHarvestTaskTableIfAbsent(conn);
        Session h2session = H2SessionFactory.INSTANCE.getH2Session(conn);
        ResultSet rs = ExtractFunctionTables.listHarvestTasks$default(INSTANCE, conn, 0, 2, null);
        while (rs.next()) {
            String tableName = rs.getString("TABLE_NAME");
            String sql2 = "DROP TABLE IF EXISTS " + tableName;
            CommandInterface command = h2session.prepareCommand(sql2, Integer.MAX_VALUE);
            command.executeUpdate(null);
        }
        return INSTANCE.truncateHarvestTaskTable(conn);
    }

    /*
     * WARNING - void declaration
     */
    private final void doHarvest(JdbcConnection conn, String url, HarvestOptions options) {
        OpenMapTable it;
        void $this$filterTo$iv$iv;
        ScentSQLSession scentSession = H2SessionFactory.INSTANCE.getSession((Connection)conn);
        Session h2session = (Session)scentSession.getSessionDelegate().getImplementation();
        options.setDisableHarvestCache(true);
        long threadId = Thread.currentThread().getId();
        sessionTracker.computeIfAbsent(scentSession.getId(), ExtractFunctionTables::doHarvest$lambda-8).add(threadId);
        Object[] objectArray = sessionTracker.get(scentSession.getId());
        String threadIds2 = objectArray == null ? null : CollectionsKt.joinToString$default((Iterable)((Iterable)objectArray), null, null, null, (int)0, null, (Function1)doHarvest.threadIds.1.INSTANCE, (int)31, null);
        objectArray = new Object[]{h2session, scentSession, threadIds2, url};
        log.info("Starting harvest task in session [{}], scent session: {}, threadIds: [{}] | {} ", objectArray);
        if (options.getCellType() == CellType.AUTO) {
            options.setCellType(CellType.DATABASE);
        }
        HarvestResult result2 = (HarvestResult)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super HarvestResult>, Object>(scentSession, url, options, null){
            int label;
            final /* synthetic */ ScentSQLSession $scentSession;
            final /* synthetic */ String $url;
            final /* synthetic */ HarvestOptions $options;
            {
                this.$scentSession = $scentSession;
                this.$url = $url;
                this.$options = $options;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$scentSession.harvest(this.$url, this.$options, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super HarvestResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        scentSession.build(result2.getTableGroup(), options);
        boolean bl = false;
        List tableNames = new ArrayList();
        Iterable $this$filter$iv = result2.getTableGroup().getTables();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (OpenMapTable)element$iv$iv;
            boolean bl2 = false;
            Collection collection = it.getRows();
            boolean bl3 = false;
            boolean bl4 = !collection.isEmpty();
            if (!bl4) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tables = (List)destination$iv$iv;
        Iterable $this$forEachIndexed$iv = tables;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void table;
            int n = index$iv++;
            boolean bl5 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            it = (OpenMapTable)item$iv;
            int tid = n;
            boolean bl6 = false;
            String tableName = INSTANCE.buildTableName(url, tid);
            INSTANCE.createHarvestResultTable((Connection)conn, tableName, (OpenMapTable)table);
            INSTANCE.insertHarvestTask((Connection)conn, url, tableName, (OpenMapTable)table);
            tableNames.add(tableName);
        }
        conn.commit();
        log.debug("Tables are created | {}", (Object)CollectionsKt.joinToString$default((Iterable)tableNames, null, null, null, (int)0, null, null, (int)63, null));
        Set<Long> set = sessionTracker.get(scentSession.getId());
        if (set != null) {
            set.remove(threadId);
        }
    }

    private final String buildTaskId(String url) {
        int n = url.hashCode();
        int n2 = 0;
        n = Math.abs(n);
        n2 = 36;
        boolean bl = false;
        String string = Integer.toString(n, CharsKt.checkRadix((int)n2));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
        String hash = string;
        String string2 = new URL(url).getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"URL(url).host");
        String taskId = StringsKt.substringBeforeLast$default((String)StringsKt.removePrefix((String)string2, (CharSequence)"www."), (String)".", null, (int)2, null) + "-" + hash;
        return StringsKt.replace$default((String)taskId, (String)".", (String)"-", (boolean)false, (int)4, null);
    }

    private final String buildTableName(String url, int tid) {
        String taskId = this.buildTaskId(url);
        String string = StringsKt.replace$default((String)(taskId + "-" + (1 + tid)), (char)'-', (char)'_', (boolean)false, (int)4, null);
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
        String ident = string3;
        return "PG_" + ident;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void createHarvestResultTable(Connection conn, String tableName, OpenMapTable table) {
        boolean bl;
        AutoCloseable $this$mapIndexedTo$iv$iv;
        log.debug("Creating harvest task table {}", (Object)tableName);
        OpenMapTable.Column[] $this$mapIndexed$iv = table.getColumns();
        boolean $i$f$mapIndexed = false;
        OpenMapTable.Column[] columnArray = $this$mapIndexed$iv;
        Collection destination$iv$iv22 = new ArrayList($this$mapIndexed$iv.length);
        boolean $i$f$mapIndexedTo22 = false;
        int index$iv$iv = 0;
        for (OpenMapTable.Row item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void col;
            int n = index$iv$iv++;
            void var15_27 = item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv22;
            boolean bl2 = false;
            String string = PageTableKt.getData((OpenMapTable.Column)col).isInt() ? "INT" : (PageTableKt.getData((OpenMapTable.Column)col).isFloat() ? "DOUBLE" : "VARCHAR");
            boolean bl3 = false;
            bl = false;
            String it = string;
            boolean bl4 = false;
            String string2 = col.getName() + " " + it;
            collection.add(string2);
        }
        String fieldDefines2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv22), null, null, null, (int)0, null, (Function1)createHarvestResultTable.fieldDefines.2.INSTANCE, (int)31, null);
        String fieldNames2 = ArraysKt.joinToString$default((Object[])table.getColumns(), null, null, null, (int)0, null, (Function1)createHarvestResultTable.fieldNames.1.INSTANCE, (int)31, null);
        String createSql = "CREATE TABLE IF NOT EXISTS " + tableName + "( ID IDENTITY, " + fieldDefines2 + ", CREATED TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP);";
        $this$mapIndexedTo$iv$iv = conn.prepareStatement(createSql);
        boolean destination$iv$iv22 = false;
        $i$f$mapIndexedTo22 = false;
        Throwable $i$f$mapIndexedTo22 = null;
        try {
            PreparedStatement it = (PreparedStatement)$this$mapIndexedTo$iv$iv;
            boolean bl5 = false;
            int n = it.executeUpdate();
        }
        catch (Throwable throwable) {
            $i$f$mapIndexedTo22 = throwable;
            throw throwable;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)$this$mapIndexedTo$iv$iv, (Throwable)$i$f$mapIndexedTo22);
        }
        conn.commit();
        Iterable $this$forEachIndexed$iv = table.getRows();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void row;
            OpenMapTable.Row item$iv$iv;
            int n = index$iv++;
            int n3 = 0;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            item$iv$iv = (OpenMapTable.Row)item$iv;
            int i = n;
            boolean bl6 = false;
            String prefix = "INSERT INTO " + tableName + "(" + fieldNames2 + ") VALUES(";
            String sql2 = CollectionsKt.joinToString$default((Iterable)((Iterable)new IntRange(1, row.getCells().length)), (CharSequence)", ", (CharSequence)prefix, (CharSequence)")", (int)0, null, (Function1)createHarvestResultTable.2.sql.1.INSTANCE, (int)24, null);
            AutoCloseable autoCloseable = conn.prepareStatement(sql2);
            bl = false;
            boolean bl7 = false;
            Throwable throwable = null;
            try {
                PreparedStatement stat = (PreparedStatement)autoCloseable;
                boolean bl8 = false;
                boolean bl9 = row.getCells().length == table.getNumColumns();
                boolean bl10 = false;
                boolean bl11 = false;
                bl11 = false;
                boolean bl12 = false;
                if (!bl9) {
                    int n4 = 0;
                    String string = "Failed requirement.";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                OpenMapTable.Cell[] $this$forEachIndexed$iv2 = row.getCells();
                boolean $i$f$forEachIndexed2 = false;
                int index$iv2 = 0;
                for (OpenMapTable.Cell item$iv2 : $this$forEachIndexed$iv2) {
                    Unit unit;
                    boolean bl13;
                    boolean bl14;
                    Integer n5;
                    Object object;
                    void datum;
                    int n6 = index$iv2++;
                    OpenMapTable.Cell cell = item$iv2;
                    int j = n6;
                    boolean bl15 = false;
                    OpenMapTable.Column col = table.getColumns()[j];
                    int parameterIndex = j + 1;
                    if (PageTableKt.getData((OpenMapTable.Column)col).isInt()) {
                        Unit unit2;
                        object = INSTANCE.parseInt((OpenMapTable.Cell)datum);
                        if (object == null) {
                            unit2 = null;
                        } else {
                            n5 = object;
                            bl14 = false;
                            bl13 = false;
                            int it = ((Number)n5).intValue();
                            boolean bl16 = false;
                            stat.setInt(parameterIndex, it);
                            unit2 = unit = Unit.INSTANCE;
                        }
                        if (unit != null) continue;
                        stat.setNull(parameterIndex, 4);
                        continue;
                    }
                    if (PageTableKt.getData((OpenMapTable.Column)col).isFloat()) {
                        Unit unit3;
                        object = INSTANCE.parseDouble((OpenMapTable.Cell)datum);
                        if (object == null) {
                            unit3 = null;
                        } else {
                            n5 = object;
                            bl14 = false;
                            bl13 = false;
                            double it = ((Number)n5).doubleValue();
                            boolean bl17 = false;
                            stat.setDouble(parameterIndex, it);
                            unit3 = unit = Unit.INSTANCE;
                        }
                        if (unit != null) continue;
                        stat.setNull(parameterIndex, 8);
                        continue;
                    }
                    unit = datum;
                    stat.setString(parameterIndex, (String)(unit == null ? "" : ((object = unit.toString()) == null ? "" : object)));
                }
                stat.executeUpdate();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        conn.commit();
    }

    private final Integer parseInt(OpenMapTable.Cell cell) {
        if (cell == null) {
            return null;
        }
        Object v = cell.getValue();
        if (v instanceof Integer) {
            return (Integer)v;
        }
        return StringsKt.toIntOrNull((String)String.valueOf(v));
    }

    private final Double parseDouble(OpenMapTable.Cell cell) {
        if (cell == null) {
            return null;
        }
        Object v = cell.getValue();
        if (v instanceof Double || v instanceof Float) {
            return (double)((Double)v);
        }
        return StringsKt.toDoubleOrNull((String)String.valueOf(v));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void createHarvestResultMetaTable(Connection conn, String tableName, OpenMapTable table) {
        List it;
        void $this$mapTo$iv$iv;
        void $this$flatMapTo$iv;
        OpenMapTable.Column[] columnArray = table.getColumns();
        Collection destination$iv = new HashSet();
        boolean $i$f$flatMapTo22 = false;
        void var8_8 = $this$flatMapTo$iv;
        int n = ((void)var8_8).length;
        for (int i = 0; i < n; ++i) {
            void element$iv;
            void it2 = element$iv = var8_8[i];
            boolean bl = false;
            Iterable list$iv = it2.getAttributes().keySet();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        HashSet attrNames = (HashSet)destination$iv;
        String fieldDefines2 = ArraysKt.joinToString$default((Object[])table.getColumns(), null, null, null, (int)0, null, (Function1)createHarvestResultMetaTable.fieldDefines.1.INSTANCE, (int)31, null);
        String createSql = "CREATE TEMPORARY TABLE IF NOT EXISTS " + tableName + "(ID IDENTITY, NAME VARCHAR, " + fieldDefines2 + ");";
        AutoCloseable $i$f$flatMapTo22 = conn.prepareStatement(createSql);
        boolean bl = false;
        n = 0;
        Throwable throwable = null;
        try {
            PreparedStatement it22 = (PreparedStatement)$i$f$flatMapTo22;
            boolean bl2 = false;
            int it22 = it22.executeUpdate();
        }
        catch (Throwable it22) {
            throwable = it22;
            throw it22;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)$i$f$flatMapTo22, (Throwable)throwable);
        }
        String fields2 = ArraysKt.joinToString$default((Object[])table.getColumns(), null, null, null, (int)0, null, (Function1)createHarvestResultMetaTable.fields.1.INSTANCE, (int)31, null);
        Iterable $this$map$iv = attrNames;
        boolean $i$f$map = false;
        Iterable bl2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            List list = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)it), (Iterable)table.getMetadata().attributeRow((String)((Object)it)));
            collection.add(list);
        }
        List rows = (List)destination$iv$iv;
        Iterable $this$forEachIndexed$iv = rows;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void row;
            int n2 = index$iv++;
            boolean bl4 = false;
            if (n2 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            it = (List)item$iv;
            int i = n2;
            boolean bl5 = false;
            String prefix = "INSERT INTO " + tableName + "(NAME, " + fields2 + ") VALUES(";
            String sql2 = CollectionsKt.joinToString$default((Iterable)((Iterable)new IntRange(1, row.size())), (CharSequence)", ", (CharSequence)prefix, (CharSequence)")", (int)0, null, (Function1)createHarvestResultMetaTable.2.sql.1.INSTANCE, (int)24, null);
            AutoCloseable autoCloseable = conn.prepareStatement(sql2);
            boolean bl6 = false;
            boolean bl7 = false;
            Throwable throwable2 = null;
            try {
                PreparedStatement it3 = (PreparedStatement)autoCloseable;
                boolean bl8 = false;
                Iterable $this$forEachIndexed$iv2 = (Iterable)row;
                boolean $i$f$forEachIndexed2 = false;
                int index$iv2 = 0;
                for (Object item$iv2 : $this$forEachIndexed$iv2) {
                    String string;
                    void datum;
                    int n3 = index$iv2++;
                    boolean bl9 = false;
                    if (n3 < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Object t = item$iv2;
                    int j = n3;
                    boolean bl10 = false;
                    void var36_55 = datum;
                    it3.setString(j + 1, var36_55 == null ? "" : ((string = var36_55.toString()) == null ? "" : string));
                }
                it3.executeUpdate();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
            }
        }
    }

    private final ResultSet queryTable(Connection conn, String tableName, int limit) {
        String sql2 = "SELECT * FROM " + tableName + " limit " + limit;
        Statement stat = conn.createStatement();
        ResultSet resultSet = stat.executeQuery(sql2);
        Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"stat.executeQuery(sql)");
        return resultSet;
    }

    static /* synthetic */ ResultSet queryTable$default(ExtractFunctionTables extractFunctionTables, Connection connection, String string, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 1000;
        }
        return extractFunctionTables.queryTable(connection, string, n);
    }

    private final boolean tableExists(Connection conn, String tableName) {
        ResultSet rs = conn.getMetaData().getTables(null, null, tableName, null);
        return rs.next();
    }

    private final ResultSet listHarvestTasks(Connection conn, int limit) {
        String sql2 = "SELECT * FROM WEB_HARVEST_TASKS LIMIT " + limit;
        PreparedStatement stat = conn.prepareStatement(sql2, 1004, 1007, 2);
        ResultSet resultSet = stat.executeQuery();
        Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"stat.executeQuery()");
        return resultSet;
    }

    static /* synthetic */ ResultSet listHarvestTasks$default(ExtractFunctionTables extractFunctionTables, Connection connection, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1000;
        }
        return extractFunctionTables.listHarvestTasks(connection, n);
    }

    private final ResultSet queryHarvestTaskTable(Connection conn, String url) {
        String sql2 = "SELECT * FROM WEB_HARVEST_TASKS WHERE PORTAL_URL=?";
        PreparedStatement stat = conn.prepareStatement(sql2, 1004, 1007, 2);
        stat.setString(1, url);
        ResultSet resultSet = stat.executeQuery();
        Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"stat.executeQuery()");
        return resultSet;
    }

    private final int truncateHarvestTaskTable(Connection conn) {
        String sql2 = "TRUNCATE TABLE WEB_HARVEST_TASKS";
        Statement stat = conn.createStatement();
        return stat.executeUpdate(sql2);
    }

    private final void dropHarvestTaskTable(Connection conn) {
        String sql2 = "DROP TABLE IF EXISTS WEB_HARVEST_TASKS";
        conn.prepareStatement(sql2).executeUpdate();
    }

    /*
     * WARNING - void declaration
     */
    private final void insertHarvestTask(Connection conn, String portalUrl, String tableName, OpenMapTable table) {
        log.debug("Creating harvest task record for " + portalUrl + " with table name " + tableName);
        String score = PageTableKt.getData((OpenMapTable)table).getScore();
        int numColumns = table.getNumColumns();
        int numRows = table.getNumRows();
        Iterable $this$sumBy$iv = table.getRows();
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            void it;
            OpenMapTable.Row row = (OpenMapTable.Row)element$iv;
            int n = sum$iv;
            boolean bl = false;
            OpenMapTable.Cell[] $this$count$iv = it.getCells();
            boolean $i$f$count = false;
            int count$iv = 0;
            OpenMapTable.Cell[] cellArray = $this$count$iv;
            int n2 = cellArray.length;
            for (int i = 0; i < n2; ++i) {
                OpenMapTable.Cell element$iv2;
                OpenMapTable.Cell it2 = element$iv2 = cellArray[i];
                boolean bl2 = false;
                if (!(it2 == null)) continue;
                ++count$iv;
            }
            int n3 = count$iv;
            sum$iv = n + n3;
        }
        int numNulls = sum$iv;
        DataTypeStatistics ds = PageTableKt.getData((OpenMapTable)table).getDataTypeStatistics();
        String showSql = "SELECT * FROM " + tableName + ";";
        String sql2 = "INSERT INTO WEB_HARVEST_TASKS(" + joinedHarvestTaskTableFields + ") VALUES(" + harvestTaskTableFieldsPlaceholds + ");";
        PreparedStatement stat = conn.prepareStatement(sql2);
        int parameterIndex = 0;
        stat.setString(++parameterIndex, portalUrl);
        stat.setString(++parameterIndex, tableName);
        stat.setString(++parameterIndex, score.toString());
        stat.setInt(++parameterIndex, numColumns);
        stat.setInt(++parameterIndex, numRows);
        stat.setInt(++parameterIndex, numNulls);
        stat.setInt(++parameterIndex, ds.getNumLocallyConstants());
        stat.setInt(++parameterIndex, ds.getNumShortTexts());
        stat.setInt(++parameterIndex, ds.getNumMediumTexts());
        stat.setInt(++parameterIndex, ds.getNumTexts());
        stat.setInt(++parameterIndex, ds.getNumImages());
        stat.setInt(++parameterIndex, ds.getNumVariables());
        stat.setInt(++parameterIndex, ds.getNumInts());
        stat.setInt(++parameterIndex, ds.getNumFloats());
        stat.setInt(++parameterIndex, ds.getNumNumbers());
        stat.setInt(++parameterIndex, ds.getNumNumberLikes());
        stat.setInt(++parameterIndex, ds.getNumMoneyLikes());
        stat.setString(++parameterIndex, showSql);
        stat.executeUpdate();
        conn.commit();
    }

    private final int deleteHarvestTask(Connection conn, String url) {
        String sql2 = "DELETE TOP 1000 FROM `WEB_HARVEST_TASKS` WHERE `PORTAL_URL`=?";
        PreparedStatement stat = conn.prepareStatement(sql2);
        stat.setString(1, url);
        int affectedRows = stat.executeUpdate();
        conn.commit();
        return affectedRows;
    }

    private final void createHarvestTaskTableIfAbsent(Connection conn) {
        if (this.tableExists(conn, "WEB_HARVEST_TASKS")) {
            return;
        }
        String fieldDefines2 = CollectionsKt.joinToString$default((Iterable)harvestTaskTableFieldDefines.entrySet(), null, null, null, (int)0, null, (Function1)createHarvestTaskTableIfAbsent.fieldDefines.1.INSTANCE, (int)31, null);
        Object sql2 = "CREATE TABLE IF NOT EXISTS WEB_HARVEST_TASKS(ID IDENTITY, " + fieldDefines2 + ", CREATED TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP);";
        int result2 = conn.prepareStatement((String)sql2).executeUpdate();
        conn.commit();
        if (result2 > 0) {
            sql2 = "CREATE INDEX IF NOT EXISTS ON WEB_HARVEST_TASKS(PORTAL_URL);";
            conn.prepareStatement((String)sql2).executeUpdate();
            sql2 = "CREATE INDEX IF NOT EXISTS ON WEB_HARVEST_TASKS(TABLE_NAME);";
            conn.prepareStatement((String)sql2).executeUpdate();
            conn.commit();
        }
        int n = 1;
        do {
            int i = n++;
            if (this.tableExists(conn, "WEB_HARVEST_TASKS")) break;
            LangKt.sleepSeconds((long)1L);
        } while (n <= 10);
    }

    private final KVPatternExtractor getKVPatternExtractor(ScentSession session) {
        kvPatternExtractor.compareAndSet(null, new KVPatternExtractor(session.getUnmodifiedConfig(), null, 2, null));
        KVPatternExtractor kVPatternExtractor = kvPatternExtractor.get();
        Intrinsics.checkNotNullExpressionValue((Object)kVPatternExtractor, (String)"kvPatternExtractor.get()");
        return kVPatternExtractor;
    }

    @JvmStatic
    @UDFunction(hasShortcut=true)
    @JvmOverloads
    @NotNull
    public static final ResultSet harvest(@H2Context @NotNull JdbcConnection conn, @NotNull String portalUrl) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)portalUrl, (String)"portalUrl");
        return ExtractFunctionTables.harvest$default(conn, portalUrl, 0, 4, null);
    }

    @JvmStatic
    @UDFunction(hasShortcut=true)
    @JvmOverloads
    @NotNull
    public static final ResultSet harvestNthTable(@H2Context @NotNull JdbcConnection conn, @NotNull String portalUrl) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)portalUrl, (String)"portalUrl");
        return ExtractFunctionTables.harvestNthTable$default(conn, portalUrl, 0, 4, null);
    }

    private static final Set doHarvest$lambda-8(Integer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        boolean bl = false;
        return new LinkedHashSet();
    }

    public static final /* synthetic */ void access$doHarvest(ExtractFunctionTables $this, JdbcConnection conn, String url, HarvestOptions options) {
        $this.doHarvest(conn, url, options);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"PORTAL_URL", (Object)"VARCHAR(2046) NOT NULL"), TuplesKt.to((Object)"TABLE_NAME", (Object)"VARCHAR(256) NOT NULL"), TuplesKt.to((Object)"SCORE", (Object)"VARCHAR(256) NOT NULL"), TuplesKt.to((Object)"NUM_COLUMNS", (Object)integerFieldDefine), TuplesKt.to((Object)"NUM_ROWS", (Object)integerFieldDefine), TuplesKt.to((Object)"NUM_NULLS", (Object)integerFieldDefine), TuplesKt.to((Object)"NUM_LOCALLY_CONSTANTS", (Object)integerFieldDefine), TuplesKt.to((Object)"NUM_SHORT_TEXTS", (Object)integerFieldDefine), TuplesKt.to((Object)"NUM_MEDIUM_TEXTS", (Object)integerFieldDefine), TuplesKt.to((Object)"NUM_TEXTS", (Object)integerFieldDefine), TuplesKt.to((Object)"NUM_IMAGES", (Object)integerFieldDefine), TuplesKt.to((Object)"NUM_VARIABLES", (Object)integerFieldDefine), TuplesKt.to((Object)"NUM_INTS", (Object)integerFieldDefine), TuplesKt.to((Object)"NUM_FLOATS", (Object)integerFieldDefine), TuplesKt.to((Object)"NUM_NUMBERS", (Object)integerFieldDefine), TuplesKt.to((Object)"NUM_NUMBER_LIKES", (Object)integerFieldDefine), TuplesKt.to((Object)"NUM_MONEY_LIKES", (Object)integerFieldDefine), TuplesKt.to((Object)"NUM_TEXTS", (Object)integerFieldDefine), TuplesKt.to((Object)"NUM_IMAGES", (Object)integerFieldDefine), TuplesKt.to((Object)"SHOW_SQL", (Object)"VARCHAR(256)")};
        harvestTaskTableFieldDefines = MapsKt.mapOf((Pair[])pairArray);
        harvestTaskTableFields = harvestTaskTableFieldDefines.keySet();
        joinedHarvestTaskTableFields = CollectionsKt.joinToString$default((Iterable)harvestTaskTableFields, null, null, null, (int)0, null, (Function1)joinedHarvestTaskTableFields.1.INSTANCE, (int)31, null);
        harvestTaskTableFieldsPlaceholds = CollectionsKt.joinToString$default((Iterable)((Iterable)new IntRange(1, harvestTaskTableFields.size())), null, null, null, (int)0, null, (Function1)harvestTaskTableFieldsPlaceholds.1.INSTANCE, (int)31, null);
        kvPatternExtractor = new AtomicReference();
    }
}

