/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.tools;

import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.scent.BasicScentSession;
import ai.platon.scent.context.ScentContexts;
import ai.platon.scent.tools.PrivacyItem;
import ai.platon.scent.tools.WhatLeaks;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020\u001eH\u0016J\u000e\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u0013J\u0018\u0010\"\u001a\u0004\u0018\u00010\u00132\u0006\u0010!\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u0013J\u0006\u0010$\u001a\u00020%J\u001f\u0010$\u001a\u00020%2\u0012\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0014\"\u00020\u0013\u00a2\u0006\u0002\u0010'R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0007R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R#\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00140\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082D\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006("}, d2={"Lai/platon/scent/tools/WhatLeaks;", "Ljava/lang/AutoCloseable;", "()V", "i", "Lai/platon/scent/BasicScentSession;", "isInBlackList", "", "()Z", "isRTCLeaked", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "privacyItems", "", "Lai/platon/scent/tools/PrivacyItem;", "getPrivacyItems", "()Ljava/util/List;", "propertyGroups", "", "", "", "getPropertyGroups", "()Ljava/util/Map;", "url", "webRTC", "getWebRTC", "()Lai/platon/scent/tools/PrivacyItem;", "check", "", "checkOrExit", "", "close", "format", "group", "get", "name", "toParams", "Lai/platon/pulsar/common/config/Params;", "groups", "([Ljava/lang/String;)Lai/platon/pulsar/common/config/Params;", "scent-engine"})
public final class WhatLeaks
implements AutoCloseable {
    @NotNull
    private final BasicScentSession i = ScentContexts.INSTANCE.createSession();
    private final Logger log = LoggerFactory.getLogger(WhatLeaks.class);
    @NotNull
    private final String url;
    @NotNull
    private final Map<String, String[]> propertyGroups;
    @NotNull
    private final List<PrivacyItem> privacyItems;

    public WhatLeaks() {
        this.url = "https://whatleaks.com/";
        Pair[] pairArray = new Pair[7];
        String[] stringArray = new String[]{"IP", "City", "State", "ZIP", "Http headers", "Javascript", "DNS", "WebRTC", "Flash", "Result"};
        pairArray[0] = TuplesKt.to((Object)"General", (Object)stringArray);
        stringArray = new String[]{"Proxy headers", "Hostname", "TOR", "Ping", "Useragent", "Time check"};
        pairArray[1] = TuplesKt.to((Object)"Proxy", (Object)stringArray);
        stringArray = new String[]{"Http proxy", "Web proxy", "VPN", "SSH", "RDP", "VNC", "TeamViewer", "AnyplaceControl"};
        pairArray[2] = TuplesKt.to((Object)"OPEN PORTS", (Object)stringArray);
        stringArray = new String[]{"OS", "MTU", "Connection type", "Language"};
        pairArray[3] = TuplesKt.to((Object)"PASSIVE OS FINGERPRINT", (Object)stringArray);
        stringArray = new String[]{"HTTP headers", "Javascript", "Flash"};
        pairArray[4] = TuplesKt.to((Object)"LANGUAGE", (Object)stringArray);
        stringArray = new String[]{"Language", "Resolution", "OS", "Browser"};
        pairArray[5] = TuplesKt.to((Object)"FAKE NAVIGATOR PROPERTIES", (Object)stringArray);
        stringArray = new String[]{"Cookie", "localStorage"};
        pairArray[6] = TuplesKt.to((Object)"LATEST 10 VISITS", (Object)stringArray);
        this.propertyGroups = MapsKt.mapOf((Pair[])pairArray);
        boolean bl = false;
        this.privacyItems = new ArrayList();
    }

    @NotNull
    public final Map<String, String[]> getPropertyGroups() {
        return this.propertyGroups;
    }

    @NotNull
    public final List<PrivacyItem> getPrivacyItems() {
        return this.privacyItems;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isRTCLeaked() {
        boolean bl;
        Iterable $this$any$iv = this.privacyItems;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            PrivacyItem it = (PrivacyItem)element$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)it.getName(), (Object)"WebRTC")) {
                CharSequence charSequence = it.getValue();
                boolean bl3 = false;
                if (charSequence.length() > 0) {
                    return true;
                }
                boolean bl4 = false;
                if (bl4) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public final boolean isInBlackList() {
        return !Intrinsics.areEqual((Object)this.get("BLACKLISTS", "Result"), (Object)"CLEAN");
    }

    @Nullable
    public final PrivacyItem getWebRTC() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.privacyItems;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PrivacyItem it = (PrivacyItem)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"WebRTC")) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final void checkOrExit() {
        this.check();
        if (this.isRTCLeaked()) {
            this.log.info("Web RTC is on (leaked) | " + this.getWebRTC());
            int n = 0;
            boolean bl = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        Object[] objectArray = new Object[]{"Ping", this.get("PROXY", "Ping")};
        Params params = new Params("WebRTC", (Object)this.get("General", "WebRTC"), objectArray);
        objectArray = new Params[1];
        String[] stringArray = new String[]{"General", "PORTS", "BLACKLISTS"};
        objectArray[0] = this.toParams(stringArray);
        params.merge((Params[])objectArray).withLogger(this.log).info();
    }

    @NotNull
    public final List<PrivacyItem> check() {
        WebPage page = this.i.load(this.url, "-i 1s");
        FeaturedDocument doc = this.i.parse(page);
        doc.absoluteLinks();
        Path path = this.i.export(doc);
        this.log.info("Export to: file://{}", (Object)path);
        Map<String, String[]> $this$forEach$iv = this.propertyGroups;
        boolean $i$f$forEach = false;
        Map<String, String[]> map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, String[]>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            String[] names;
            Map.Entry<String, String[]> element$iv;
            Map.Entry<String, String[]> $dstr$group$names = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<String, String[]> entry = $dstr$group$names;
            boolean bl3 = false;
            String group = entry.getKey();
            Map.Entry<String, String[]> entry2 = $dstr$group$names;
            boolean bl4 = false;
            String[] $this$forEach$iv2 = names = entry2.getValue();
            boolean $i$f$forEach2 = false;
            String[] stringArray = $this$forEach$iv2;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string;
                String element$iv2;
                String name = element$iv2 = stringArray[i];
                boolean bl5 = false;
                Element element = doc.selectFirstOrNull("td div:contains(" + name + ") + div");
                if (element == null) {
                    string = null;
                } else {
                    String string2 = element.text();
                    if (string2 == null) {
                        string = null;
                    } else {
                        String string3 = string2;
                        boolean bl6 = false;
                        boolean bl7 = false;
                        String it = string3;
                        boolean bl8 = false;
                        string = !StringsKt.contains$default((CharSequence)it, (CharSequence)"N/A", (boolean)false, (int)2, null) ? string3 : null;
                    }
                }
                String value = string;
                element = value;
                this.getPrivacyItems().add(new PrivacyItem(group, name, element == null ? "" : element));
            }
        }
        return this.privacyItems;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String get(@NotNull String group, @NotNull String name) {
        Object v0;
        block2: {
            void $this$firstOrNull$iv;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable $this$filter$iv = this.privacyItems;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PrivacyItem it = (PrivacyItem)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getGroup(), (Object)group)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PrivacyItem it = (PrivacyItem)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        PrivacyItem privacyItem = v0;
        return privacyItem == null ? null : privacyItem.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Params toParams() {
        Params params = new Params();
        Iterable $this$forEach$iv = this.propertyGroups.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            void $this$filterTo$iv$iv;
            String group = (String)element$iv;
            boolean bl = false;
            Iterable $this$filter$iv = this.getPrivacyItems();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PrivacyItem it = (PrivacyItem)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getGroup(), (Object)group)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                PrivacyItem it = (PrivacyItem)element$iv2;
                boolean bl3 = false;
                params.put(it.getName(), (Object)it.getValue());
            }
        }
        return params;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Params toParams(String ... groups) {
        Intrinsics.checkNotNullParameter((Object)groups, (String)"groups");
        Params params = new Params();
        Iterable $this$forEach$iv = this.propertyGroups.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            void $this$filterTo$iv$iv;
            String group = (String)element$iv;
            boolean bl = false;
            if (!ArraysKt.contains((Object[])groups, (Object)group)) continue;
            Iterable $this$filter$iv = this.getPrivacyItems();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PrivacyItem it = (PrivacyItem)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getGroup(), (Object)group)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                PrivacyItem it = (PrivacyItem)element$iv2;
                boolean bl3 = false;
                params.put(it.getName(), (Object)it.getValue());
            }
        }
        return params;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String format(@NotNull String group) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Iterable $this$filter$iv = this.privacyItems;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PrivacyItem it = (PrivacyItem)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getGroup(), (Object)group)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, (Function1)format.2.INSTANCE, (int)30, null);
    }

    @Override
    public void close() {
        this.i.close();
    }
}

