/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent;

import ai.platon.pulsar.common.Systems;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.dom.features.FeatureRegistry;
import ai.platon.pulsar.ql.common.H2Config;
import ai.platon.scent.dom.Level2FeatureCalculator;
import ai.platon.scent.dom.features.defined.DefinedFeaturesKt;
import ai.platon.scent.ql.h2.ClassFactory;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.h2.util.JdbcUtils;
import org.h2.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0007\u001a\u00020\u0006H\u0002J\u0012\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lai/platon/scent/ScentEnvironment;", "", "()V", "logger", "Lorg/slf4j/Logger;", "ensureVitalEnvironment", "", "initialize", "setAllProperties", "overrideIfExist", "", "Companion", "scent-engine"})
@SourceDebugExtension(value={"SMAP\nScentEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScentEnvironment.kt\nai/platon/scent/ScentEnvironment\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,93:1\n1#2:94\n215#3,2:95\n215#3,2:97\n*S KotlinDebug\n*F\n+ 1 ScentEnvironment.kt\nai/platon/scent/ScentEnvironment\n*L\n74#1:95,2\n84#1:97,2\n*E\n"})
public final class ScentEnvironment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private static final Map<String, String> _vitalProperties;

    public ScentEnvironment() {
        Logger logger = LoggerFactory.getLogger(ScentEnvironment.class);
        Intrinsics.checkNotNull((Object)logger);
        this.logger = logger;
        this.initialize();
    }

    private final synchronized void initialize() {
        boolean initialized;
        String string = System.getProperty("h2.sessionFactory");
        boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"scent", (boolean)false, (int)2, null) : (initialized = false);
        if (!initialized) {
            System.clearProperty("use_proxy");
            this.setAllProperties(false);
            Level2FeatureCalculator.Companion.installFeatureCalculators();
            H2Config.config();
            JdbcUtils.addClassFactory((Utils.ClassFactory)new ClassFactory());
            String message = "Vital scent environment is initialized, the vital properties should not be modified";
            this.logger.info(message);
        }
    }

    public final synchronized void ensureVitalEnvironment() {
        if (!StringsKt.startsWith$default((String)FeaturedDocument.Companion.getNIL().getHtml(), (String)"<html>", (boolean)false, (int)2, null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(FeatureRegistry.INSTANCE.getDimension() == DefinedFeaturesKt.getN2())) {
            boolean $i$a$-require-ScentEnvironment$ensureVitalEnvironment$22 = false;
            String $i$a$-require-ScentEnvironment$ensureVitalEnvironment$22 = "Expect " + DefinedFeaturesKt.getN2() + " actual " + FeatureRegistry.INSTANCE.getDimension();
            throw new IllegalArgumentException($i$a$-require-ScentEnvironment$ensureVitalEnvironment$22.toString());
        }
        Map<String, String> $this$forEach$iv = Companion.getVitalProperties();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String name = entry.getKey();
            String value = entry.getValue();
            String actualValue = System.getProperty(name);
            if (Intrinsics.areEqual((Object)actualValue, (Object)value)) continue;
            this.logger.warn("Vital property " + name + " is not set to " + value + ", actually " + actualValue);
        }
    }

    private final void setAllProperties(boolean overrideIfExist) {
        Map<String, String> $this$forEach$iv = _vitalProperties;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String name = entry.getKey();
            String value = entry.getValue();
            if (overrideIfExist) {
                Systems.INSTANCE.setProperty(name, (Object)value);
                continue;
            }
            Systems.INSTANCE.setPropertyIfAbsent(name, value);
        }
    }

    static /* synthetic */ void setAllProperties$default(ScentEnvironment scentEnvironment, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        scentEnvironment.setAllProperties(bl);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"proxy.enable.default.providers", (Object)"true"), TuplesKt.to((Object)"storage.data.store.class", (Object)"org.apache.gora.mongodb.store.MongoStore"), TuplesKt.to((Object)"proxy.pool.manager.class", (Object)"ai.platon.pulsar.common.proxy.ProxyPoolManager"), TuplesKt.to((Object)"proxy.loader.class", (Object)"ai.platon.scent.proxy.pool.ProxyVendorLoader"), TuplesKt.to((Object)"browser.launch.supervisor.process", (Object)"xvfb-run"), TuplesKt.to((Object)"browser.launch.supervisor.process.args", (Object)"-a, -e, /dev/stdout, -s, -screen 0 1920x1080x24"), TuplesKt.to((Object)"privacy.agent.generator.class", (Object)"ai.platon.pulsar.skeleton.crawl.fetch.privacy.SequentialPrivacyAgentGenerator"), TuplesKt.to((Object)"h2.sessionFactory", (Object)"ai.platon.scent.ql.h2.H2SessionFactory")};
        _vitalProperties = MapsKt.mutableMapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lai/platon/scent/ScentEnvironment$Companion;", "", "()V", "_vitalProperties", "", "", "vitalProperties", "", "getVitalProperties", "()Ljava/util/Map;", "getVitalProperty", "key", "setVitalProperty", "", "value", "scent-engine"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, String> getVitalProperties() {
            return _vitalProperties;
        }

        public final void setVitalProperty(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            _vitalProperties.put(key, value);
        }

        @Nullable
        public final String getVitalProperty(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return (String)_vitalProperties.get(key);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

