/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.common.sites.amazon;

import ai.platon.pulsar.common.config.AppConstants;
import ai.platon.pulsar.skeleton.crawl.filter.UrlNormalizer;
import ai.platon.scent.common.sites.amazon.AmazonAsinUrlNormalizer;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\nJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\nJ\u0018\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\nJ\u0010\u0010\u001a\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\nJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001d\u001a\u00020\nR\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lai/platon/scent/common/sites/amazon/AmazonUrls;", "", "()V", "charset", "Ljava/nio/charset/Charset;", "kotlin.jvm.PlatformType", "getCharset", "()Ljava/nio/charset/Charset;", "indexPageUrlContains", "", "", "getIndexPageUrlContains", "()[Ljava/lang/String;", "[Ljava/lang/String;", "findAsin", "url", "findMarketplaceID", "findQueryParameter", "parameterName", "findSellerId", "isAmazon", "", "isIndexPage", "isItemPage", "isReviewPage", "isSearch", "normalizeAsinUrl", "asinUrl", "normalizeSellerUrl", "sellerUrl", "scent-engine"})
@SourceDebugExtension(value={"SMAP\nAmazonUrls.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AmazonUrls.kt\nai/platon/scent/common/sites/amazon/AmazonUrls\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n12474#2,2:94\n288#3,2:96\n288#3,2:98\n288#3,2:100\n*S KotlinDebug\n*F\n+ 1 AmazonUrls.kt\nai/platon/scent/common/sites/amazon/AmazonUrls\n*L\n23#1:94,2\n59#1:96,2\n70#1:98,2\n71#1:100,2\n*E\n"})
public final class AmazonUrls {
    @NotNull
    public static final AmazonUrls INSTANCE = new AmazonUrls();
    private static final Charset charset = Charset.defaultCharset();
    @NotNull
    private static final String[] indexPageUrlContains;

    private AmazonUrls() {
    }

    public final Charset getCharset() {
        return charset;
    }

    @NotNull
    public final String[] getIndexPageUrlContains() {
        return indexPageUrlContains;
    }

    public final boolean isAmazon(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return StringsKt.contains$default((CharSequence)url, (CharSequence)".amazon.", (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isIndexPage(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (!this.isAmazon(url)) return false;
        String[] $this$any$iv = indexPageUrlContains;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            String element$iv;
            String it = element$iv = $this$any$iv[n];
            boolean bl = false;
            if (StringsKt.contains$default((CharSequence)url, (CharSequence)it, (boolean)false, (int)2, null)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public final boolean isItemPage(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.isAmazon(url) && StringsKt.contains$default((CharSequence)url, (CharSequence)"/dp/", (boolean)false, (int)2, null);
    }

    public final boolean isReviewPage(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.isAmazon(url) && StringsKt.contains$default((CharSequence)url, (CharSequence)"/product-reviews/", (boolean)false, (int)2, null);
    }

    public final boolean isSearch(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.isAmazon(url) && StringsKt.contains$default((CharSequence)url, (CharSequence)"s?k=", (boolean)false, (int)2, null);
    }

    @Nullable
    public final String findAsin(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        int pos = StringsKt.indexOf$default((CharSequence)url, (String)"/dp/", (int)0, (boolean)false, (int)6, null) + 4;
        if (pos > AppConstants.SHORTEST_VALID_URL_LENGTH) {
            int pos2;
            for (pos2 = pos; pos2 < url.length() && Character.isLetterOrDigit(url.charAt(pos2)); ++pos2) {
            }
            if (pos2 <= url.length()) {
                String string = url.substring(pos, pos2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return string;
            }
        }
        return null;
    }

    @Nullable
    public final String findMarketplaceID(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.findQueryParameter(url, "marketplaceID");
    }

    @Nullable
    public final String findSellerId(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.findQueryParameter(url, "seller");
    }

    @Nullable
    public final String findQueryParameter(@NotNull String url, @NotNull String parameterName) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)parameterName, (String)"parameterName");
            List list = new URIBuilder(url).getQueryParams();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getQueryParams(...)");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                NameValuePair it = (NameValuePair)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)parameterName)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        NameValuePair nameValuePair = v1;
        return nameValuePair != null ? nameValuePair.getValue() : null;
    }

    @Nullable
    public final String normalizeAsinUrl(@NotNull String asinUrl) {
        Intrinsics.checkNotNullParameter((Object)asinUrl, (String)"asinUrl");
        return UrlNormalizer.DefaultImpls.normalize$default((UrlNormalizer)((UrlNormalizer)new AmazonAsinUrlNormalizer()), (String)asinUrl, null, (int)2, null);
    }

    @Nullable
    public final String normalizeSellerUrl(@NotNull String sellerUrl) {
        Object v4;
        String sellerId;
        URIBuilder builder;
        block6: {
            Object v1;
            NameValuePair it;
            boolean $i$f$firstOrNull;
            Iterable $this$firstOrNull$iv;
            List queryParams;
            block5: {
                Intrinsics.checkNotNullParameter((Object)sellerUrl, (String)"sellerUrl");
                builder = new URIBuilder(sellerUrl);
                List list = builder.getQueryParams();
                if (list == null) {
                    return null;
                }
                queryParams = list;
                $this$firstOrNull$iv = queryParams;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (NameValuePair)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"seller")) continue;
                    v1 = element$iv;
                    break block5;
                }
                v1 = null;
            }
            NameValuePair nameValuePair = v1;
            String string = nameValuePair != null ? nameValuePair.getValue() : null;
            if (string == null) {
                return null;
            }
            sellerId = string;
            $this$firstOrNull$iv = queryParams;
            $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (NameValuePair)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"marketplaceID")) continue;
                v4 = element$iv;
                break block6;
            }
            v4 = null;
        }
        NameValuePair nameValuePair = v4;
        String marketplaceID = nameValuePair != null ? nameValuePair.getValue() : null;
        builder.setPath("sp");
        builder.clearParameters();
        builder.setParameter("seller", sellerId);
        if (marketplaceID != null) {
            builder.setParameter("marketplaceID", marketplaceID);
        }
        return builder.toString();
    }

    static {
        String[] stringArray = new String[]{"/zgbs/", "/bestsellers/", "/most-wished-for/", "/new-releases/", "/movers-and-shakers/"};
        indexPageUrlContains = stringArray;
    }
}

