/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.crawl.scrape;

import ai.platon.pulsar.common.AppFiles;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.skeleton.common.files.ext.AppFilesExtKt;
import ai.platon.pulsar.skeleton.common.message.PageLoadStatusFormatter;
import ai.platon.scent.crawl.serialize.ScrapeResponse;
import ai.platon.scent.crawl.serialize.ScrapeResponseV2;
import ai.platon.scent.entities.ScrapeResultSet;
import ai.platon.scent.persist.mongo.v1.ScrapeTask;
import ai.platon.scent.persist.mongo.v2.ScrapeTaskStatusV2;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lai/platon/scent/crawl/scrape/ScrapeExceptionHandler;", "", "()V", "logger", "Lorg/slf4j/Logger;", "trackIfInconsistent", "", "task", "Lai/platon/scent/persist/mongo/v1/ScrapeTask;", "response", "Lai/platon/scent/crawl/serialize/ScrapeResponse;", "page", "Lai/platon/pulsar/persist/WebPage;", "Lai/platon/scent/persist/mongo/v2/ScrapeTaskStatusV2;", "Lai/platon/scent/crawl/serialize/ScrapeResponseV2;", "scent-engine"})
@SourceDebugExtension(value={"SMAP\nScrapeExceptionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScrapeExceptionHandler.kt\nai/platon/scent/crawl/scrape/ScrapeExceptionHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n1747#2,3:94\n*S KotlinDebug\n*F\n+ 1 ScrapeExceptionHandler.kt\nai/platon/scent/crawl/scrape/ScrapeExceptionHandler\n*L\n58#1:94,3\n*E\n"})
public final class ScrapeExceptionHandler {
    @NotNull
    public static final ScrapeExceptionHandler INSTANCE = new ScrapeExceptionHandler();
    @NotNull
    private static final Logger logger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(INSTANCE.getClass()));

    private ScrapeExceptionHandler() {
    }

    public final void trackIfInconsistent(@NotNull ScrapeTask task, @NotNull ScrapeResponse response, @NotNull WebPage page) {
        boolean hasRecords;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Object message = "";
        boolean hasContent = response.getPageContentBytes() > 0;
        List<Map<String, Object>> list = response.getResultSet();
        boolean bl = list != null ? !((Collection)list).isEmpty() : (hasRecords = false);
        if (page.getProtocolStatus().isRetry()) {
            return;
        }
        if (hasRecords) {
            if (response.getPageStatusCode() != 200) {
                message = "R!C PSC:" + response.getPageStatusCode();
            }
            if (response.getStatusCode() != 200) {
                message = "R!C SC:" + response.getStatusCode();
            }
        } else if (hasContent) {
            message = "C!R";
            Path path = AppFilesExtKt.export$default((AppFiles)AppFiles.INSTANCE, (WebPage)page, null, null, (int)6, null);
            Object[] objectArray = new Object[]{page.getId(), message, page.getProtocolStatus(), path};
            logger.info("{}. {} {} | {}", objectArray);
        }
        if (!hasContent && response.getPageStatusCode() == 200) {
            message = (String)message + " !C PSC:" + response.getPageStatusCode();
        }
        if (!StringsKt.isBlank((CharSequence)((CharSequence)message))) {
            String prefix = "Inconsistent";
            PageLoadStatusFormatter report = new PageLoadStatusFormatter(page, null, true, false, false, false, 58, null);
            Object[] objectArray = new Object[]{prefix, message, task.getId(), report};
            logger.warn("{} {} {} | {}", objectArray);
        }
    }

    public final void trackIfInconsistent(@NotNull ScrapeTaskStatusV2 task, @NotNull ScrapeResponseV2 response, @NotNull WebPage page) {
        boolean hasRecords;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Object message = "";
        boolean hasContent = response.getPageContentBytes() > 0;
        List<ScrapeResultSet> list = response.getResultSets();
        if (list != null) {
            boolean bl;
            block12: {
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ScrapeResultSet it = (ScrapeResultSet)element$iv;
                        boolean bl2 = false;
                        List list2 = it.getRecords();
                        boolean bl3 = list2 != null ? !((Collection)list2).isEmpty() : false;
                        if (!bl3) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            v4 = bl;
        } else {
            v4 = hasRecords = false;
        }
        if (hasRecords) {
            if (response.getPageStatusCode() != 200) {
                message = "R!C PSC:" + response.getPageStatusCode();
            }
            if (response.getStatusCode() != 200) {
                message = "R!C SC:" + response.getStatusCode();
            }
        } else if (hasContent) {
            message = response.getResultSets() == null ? "C!R(empty)" : "C!R(null)";
            Path path = AppFilesExtKt.export$default((AppFiles)AppFiles.INSTANCE, (WebPage)page, null, null, (int)6, null);
            logger.info("{}. Page has content but no records, exported to {}", (Object)page.getId(), (Object)path);
        }
        if (!hasContent && response.getPageStatusCode() == 200) {
            message = (String)message + " !C PSC:" + response.getPageStatusCode();
        }
        if (!StringsKt.isBlank((CharSequence)((CharSequence)message))) {
            String prefix = "Inconsistent";
            PageLoadStatusFormatter report = new PageLoadStatusFormatter(page, null, true, false, false, false, 58, null);
            Object[] objectArray = new Object[]{prefix, message, task.getId(), report};
            logger.warn("{} {} {} | {}", objectArray);
        }
    }
}

