/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.crawl.urls.experimental;

import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.concurrent.ConcurrentExpiringLRUCache;
import ai.platon.pulsar.common.urls.UrlAware;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.ql.common.ResultSets;
import ai.platon.pulsar.ql.h2.H2MemoryDb;
import ai.platon.pulsar.ql.h2.utils.ResultSetUtils;
import ai.platon.pulsar.skeleton.crawl.PageEventHandlers;
import ai.platon.pulsar.skeleton.crawl.common.GlobalCache;
import ai.platon.pulsar.skeleton.crawl.common.GlobalCacheFactory;
import ai.platon.pulsar.skeleton.crawl.common.url.CompletableListenableHyperlink;
import ai.platon.scent.common.jackson.ExtensionsKt;
import ai.platon.scent.crawl.urls.SinkAwareHyperlinkMetrics;
import ai.platon.scent.crawl.urls.experimental.GeneralScrapeTask;
import ai.platon.scent.crawl.urls.experimental.GeneralSinkAwareLoadEventHandler;
import ai.platon.scent.entities.ScrapeResultSet;
import ai.platon.scent.executors.SinkCommitter;
import ai.platon.scent.executors.SinkResponse;
import ai.platon.scent.persist.mongo.v2.XSqlTaskStatus;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.gson.Gson;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.h2.jdbc.JdbcSQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002BO\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020<H\u0016J\u0018\u0010>\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0002J\u001d\u0010B\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010CJ\u0018\u0010D\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0002J7\u0010E\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u00002\u0018\u0010F\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020H\u0012\u0004\u0012\u00020\u000f0GH\u0004\u00a2\u0006\u0002\u0010IJ\u0010\u0010J\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0012\u0010J\u001a\u0004\u0018\u00010K2\u0006\u0010L\u001a\u00020MH\u0004J\u001a\u0010J\u001a\u0004\u0018\u00010K2\u0006\u0010L\u001a\u00020M2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0018\u0010N\u001a\u00020K2\u0006\u0010L\u001a\u00020M2\u0006\u0010O\u001a\u00020\nH\u0004J\u0018\u0010P\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0014J\r\u0010Q\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00107J\u001e\u0010Q\u001a\u00028\u00002\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020UH\u0096\u0002\u00a2\u0006\u0002\u0010VJ\u0018\u0010W\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020HH\u0004J\b\u0010&\u001a\u00020<H\u0016J\b\u0010)\u001a\u00020<H\u0016J\u0010\u0010X\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020'X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010(R\u0014\u0010)\u001a\u00020*X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010+R\u0016\u0010,\u001a\n .*\u0004\u0018\u00010-0-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\u000200X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0014\u00103\u001a\u00020\n8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0013\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u00108\u001a\u0004\b6\u00107R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lai/platon/scent/crawl/urls/experimental/GeneralSinkAwareHyperlink;", "Response", "Lai/platon/pulsar/skeleton/crawl/common/url/CompletableListenableHyperlink;", "url", "", "task", "Lai/platon/scent/crawl/urls/experimental/GeneralScrapeTask;", "response", "connectionPool", "Ljava/util/Queue;", "Ljava/sql/Connection;", "sinkCommitter", "Lai/platon/scent/executors/SinkCommitter;", "taskUpdater", "Lkotlin/Function1;", "", "globalCacheFactory", "Lai/platon/pulsar/skeleton/crawl/common/GlobalCacheFactory;", "(Ljava/lang/String;Lai/platon/scent/crawl/urls/experimental/GeneralScrapeTask;Ljava/lang/Object;Ljava/util/Queue;Lai/platon/scent/executors/SinkCommitter;Lkotlin/jvm/functions/Function1;Lai/platon/pulsar/skeleton/crawl/common/GlobalCacheFactory;)V", "args", "getArgs", "()Ljava/lang/String;", "setArgs", "(Ljava/lang/String;)V", "authToken", "getAuthToken", "setAuthToken", "event", "Lai/platon/pulsar/skeleton/crawl/PageEventHandlers;", "Lai/platon/pulsar/skeleton/crawl/PageEvent;", "getEvent", "()Lai/platon/pulsar/skeleton/crawl/PageEventHandlers;", "setEvent", "(Lai/platon/pulsar/skeleton/crawl/PageEventHandlers;)V", "globalCache", "Lai/platon/pulsar/skeleton/crawl/common/GlobalCache;", "getGlobalCache", "()Lai/platon/pulsar/skeleton/crawl/common/GlobalCache;", "isCancelled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "isDone", "Ljava/util/concurrent/CountDownLatch;", "()Ljava/util/concurrent/CountDownLatch;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "metrics", "Lai/platon/scent/crawl/urls/SinkAwareHyperlinkMetrics;", "getMetrics", "()Lai/platon/scent/crawl/urls/SinkAwareHyperlinkMetrics;", "randomConnection", "getRandomConnection", "()Ljava/sql/Connection;", "getResponse", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getTask", "()Lai/platon/scent/crawl/urls/experimental/GeneralScrapeTask;", "cancel", "", "mayInterruptIfRunning", "checkWebPage", "Lai/platon/pulsar/common/urls/UrlAware;", "page", "Lai/platon/pulsar/persist/WebPage;", "commit", "(Lai/platon/scent/crawl/urls/experimental/GeneralScrapeTask;Ljava/lang/Object;)V", "doExtract", "executeCallback", "thenAction", "Lkotlin/Function2;", "Lai/platon/scent/executors/SinkResponse;", "(Lai/platon/scent/crawl/urls/experimental/GeneralScrapeTask;Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)V", "executeQuery", "Ljava/sql/ResultSet;", "sqlTask", "Lai/platon/scent/persist/mongo/v2/XSqlTaskStatus;", "executeQueryWithConnection", "conn", "extract", "get", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "handleSyncResponse", "updateTask", "scent-engine"})
@SourceDebugExtension(value={"SMAP\nGeneralSinkAwareHyperlink.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeneralSinkAwareHyperlink.kt\nai/platon/scent/crawl/urls/experimental/GeneralSinkAwareHyperlink\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,312:1\n1#2:313\n1855#3,2:314\n*S KotlinDebug\n*F\n+ 1 GeneralSinkAwareHyperlink.kt\nai/platon/scent/crawl/urls/experimental/GeneralSinkAwareHyperlink\n*L\n189#1:314,2\n*E\n"})
public class GeneralSinkAwareHyperlink<Response>
extends CompletableListenableHyperlink<Response> {
    @NotNull
    private final GeneralScrapeTask task;
    private final Response response;
    @NotNull
    private final Queue<Connection> connectionPool;
    @NotNull
    private final SinkCommitter sinkCommitter;
    @NotNull
    private final Function1<GeneralScrapeTask, Unit> taskUpdater;
    @NotNull
    private final GlobalCacheFactory globalCacheFactory;
    private final Logger logger;
    @NotNull
    private final SinkAwareHyperlinkMetrics metrics;
    @NotNull
    private final AtomicBoolean isCancelled;
    @NotNull
    private final CountDownLatch isDone;
    @Nullable
    private String authToken;
    @Nullable
    private String args;
    @NotNull
    private PageEventHandlers event;

    public GeneralSinkAwareHyperlink(@NotNull String url, @NotNull GeneralScrapeTask task, Response response, @NotNull Queue<Connection> connectionPool, @NotNull SinkCommitter sinkCommitter, @NotNull Function1<? super GeneralScrapeTask, Unit> taskUpdater, @NotNull GlobalCacheFactory globalCacheFactory) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter(connectionPool, (String)"connectionPool");
        Intrinsics.checkNotNullParameter((Object)sinkCommitter, (String)"sinkCommitter");
        Intrinsics.checkNotNullParameter(taskUpdater, (String)"taskUpdater");
        Intrinsics.checkNotNullParameter((Object)globalCacheFactory, (String)"globalCacheFactory");
        super(url, null, 0, null, null, null, 0, null, null, null, 0, 0, null, 8190, null);
        this.task = task;
        this.response = response;
        this.connectionPool = connectionPool;
        this.sinkCommitter = sinkCommitter;
        this.taskUpdater = taskUpdater;
        this.globalCacheFactory = globalCacheFactory;
        this.logger = LoggerFactory.getLogger(GeneralSinkAwareHyperlink.class);
        this.metrics = new SinkAwareHyperlinkMetrics("experimental");
        this.isCancelled = new AtomicBoolean();
        this.isDone = new CountDownLatch(1);
        this.authToken = this.task.getAuthToken();
        this.args = "-cacheContent true -storeContent false -parse";
        this.event = (PageEventHandlers)new GeneralSinkAwareLoadEventHandler(this.task, this.metrics);
        this.metrics.getLinks().mark();
    }

    @NotNull
    public final GeneralScrapeTask getTask() {
        return this.task;
    }

    public final Response getResponse() {
        return this.response;
    }

    @NotNull
    protected final GlobalCache getGlobalCache() {
        return this.globalCacheFactory.getGlobalCache();
    }

    @NotNull
    protected final Connection getRandomConnection() {
        return new H2MemoryDb(null, 1, null).getRandomConnection();
    }

    @NotNull
    protected final SinkAwareHyperlinkMetrics getMetrics() {
        return this.metrics;
    }

    @NotNull
    protected final AtomicBoolean isCancelled() {
        return this.isCancelled;
    }

    @NotNull
    protected final CountDownLatch isDone() {
        return this.isDone;
    }

    @Nullable
    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(@Nullable String string) {
        this.authToken = string;
    }

    @Nullable
    public String getArgs() {
        return this.args;
    }

    public void setArgs(@Nullable String string) {
        this.args = string;
    }

    @NotNull
    public PageEventHandlers getEvent() {
        return this.event;
    }

    public void setEvent(@NotNull PageEventHandlers pageEventHandlers) {
        Intrinsics.checkNotNullParameter((Object)pageEventHandlers, (String)"<set-?>");
        this.event = pageEventHandlers;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        this.isCancelled.set(true);
        this.isDone.countDown();
        return true;
    }

    public boolean isCancelled() {
        return this.isCancelled.get();
    }

    public boolean isDone() {
        return this.isDone.getCount() == 0L;
    }

    public Response get() {
        this.isDone.await();
        return this.response;
    }

    public Response get(long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        this.isDone.await(timeout, unit);
        return this.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extract(@NotNull UrlAware url, @NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        if (this.isCancelled.get()) {
            this.isDone.countDown();
            return;
        }
        try {
            this.doExtract(url, page);
        }
        catch (Exception e) {
            LogsKt.warnInterruptible((Object)((Object)this), (Throwable)e);
        }
        finally {
            this.isDone.countDown();
        }
    }

    private final void doExtract(UrlAware url, WebPage page) {
        Object object;
        try {
            boolean bl = false;
            this.checkWebPage(url, page);
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            this.logger.warn("Web page check failure | {}", (Object)ExceptionsKt.brief$default((Throwable)it, null, null, (int)3, null));
            return;
        }
        this.executeQuery(this.task);
        this.task.setContentLength((int)page.getContentLength());
        this.task.setPageStatusCode(page.getProtocolStatus().getMinorCode());
        this.commit(this.task, this.response);
        this.updateTask(this.task);
    }

    private final void checkWebPage(UrlAware url, WebPage page) {
        if (!page.getProtocolStatus().isSuccess() || page.getContentLength() == 0L || page.getContent() == null) {
            this.task.setStatusCode(204);
            return;
        }
        if (!page.isContentUpdated()) {
            boolean $i$a$-require-GeneralSinkAwareHyperlink$checkWebPage$52 = false;
            String $i$a$-require-GeneralSinkAwareHyperlink$checkWebPage$52 = "require page.isContentUpdated to be true";
            throw new IllegalArgumentException($i$a$-require-GeneralSinkAwareHyperlink$checkWebPage$52.toString());
        }
        if (!(page.getPersistContent() == null)) {
            boolean $i$a$-require-GeneralSinkAwareHyperlink$checkWebPage$62 = false;
            String $i$a$-require-GeneralSinkAwareHyperlink$checkWebPage$62 = "page persistContent is not null";
            throw new IllegalArgumentException($i$a$-require-GeneralSinkAwareHyperlink$checkWebPage$62.toString());
        }
        if (!(page.getTmpContent() != null)) {
            boolean $i$a$-require-GeneralSinkAwareHyperlink$checkWebPage$72 = false;
            String $i$a$-require-GeneralSinkAwareHyperlink$checkWebPage$72 = "cachedContent of page is null";
            throw new IllegalArgumentException($i$a$-require-GeneralSinkAwareHyperlink$checkWebPage$72.toString());
        }
        ConcurrentExpiringLRUCache concurrentExpiringLRUCache = this.getGlobalCache().getPageCache();
        String string = page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        if (!(concurrentExpiringLRUCache.get((Object)string) != null)) {
            boolean bl = false;
            String string2 = "Page is NOT cached";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    protected void executeQuery(@NotNull GeneralScrapeTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        int failure = 0;
        task.setStatusCode(102);
        Iterable $this$forEach$iv = task.getSqlTasks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XSqlTaskStatus sqlTask = (XSqlTaskStatus)element$iv;
            boolean bl = false;
            ResultSet rs = this.executeQuery(sqlTask, task);
            if (sqlTask.getStatusCode() == 200) {
                if (rs == null) continue;
                List entities = ResultSetUtils.INSTANCE.getEntitiesFromResultSet(rs);
                List list = task.getResultSets();
                if (list == null) {
                    list = new ArrayList();
                }
                List resultSets = list;
                resultSets.add(new ScrapeResultSet(sqlTask.getName(), entities));
                continue;
            }
            ++failure;
        }
        int n = failure;
        task.setStatusCode(n == 0 ? 200 : (n == task.getSqlTasks().size() ? 417 : 206));
    }

    protected void commit(@NotNull GeneralScrapeTask task, Response response) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        try {
            if (task.getCallbackUrl() != null) {
                this.executeCallback(task, response, (Function2<GeneralScrapeTask, SinkResponse, Unit>)((Function2)new Function2<GeneralScrapeTask, SinkResponse, Unit>(this, task){
                    final /* synthetic */ GeneralSinkAwareHyperlink<Response> this$0;
                    final /* synthetic */ GeneralScrapeTask $task;
                    {
                        this.this$0 = $receiver;
                        this.$task = $task;
                        super(2);
                    }

                    public final void invoke(@NotNull GeneralScrapeTask generalScrapeTask, @NotNull SinkResponse sinkResponse) {
                        Intrinsics.checkNotNullParameter((Object)generalScrapeTask, (String)"<anonymous parameter 0>");
                        Intrinsics.checkNotNullParameter((Object)sinkResponse, (String)"sinkResponse");
                        this.this$0.handleSyncResponse(this.$task, sinkResponse);
                    }
                }));
            }
        }
        catch (JsonProcessingException e) {
            this.logger.warn("Failed serialize scrape response for <" + task.getUuid() + ">", (Throwable)e);
        }
        catch (Exception e) {
            LogsKt.warnInterruptible((Object)((Object)this), (Throwable)e, (String)ExceptionsKt.brief$default((Throwable)e, (String)("Failed to commit response | " + task.getUuid() + " - "), null, (int)2, null), (Object[])new Object[0]);
        }
    }

    @Nullable
    protected ResultSet executeQuery(@NotNull XSqlTaskStatus sqlTask, @NotNull GeneralScrapeTask task) {
        Intrinsics.checkNotNullParameter((Object)sqlTask, (String)"sqlTask");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        ResultSet rs = null;
        try {
            rs = this.executeQuery(sqlTask);
        }
        catch (Throwable e) {
            sqlTask.setStatusCode(417);
            Object[] objectArray = new Object[]{ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null)};
            LogsKt.warnInterruptible((Object)((Object)this), (Throwable)e, (String)("Failed to execute task #" + task.getUuid() + "\n{}"), (Object[])objectArray);
        }
        return rs;
    }

    @Nullable
    protected final ResultSet executeQuery(@NotNull XSqlTaskStatus sqlTask) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)sqlTask, (String)"sqlTask");
        Object it22 = object = this;
        boolean bl = false;
        if ((AppContext.INSTANCE.isActive() ? object : null) == null) {
            return null;
        }
        Connection connection = this.connectionPool.poll();
        if (connection == null) {
            connection = this.getRandomConnection();
        }
        Connection connection2 = connection;
        try {
            boolean bl2 = false;
            object = Result.constructor-impl((Object)this.executeQueryWithConnection(sqlTask, connection2));
        }
        catch (Throwable it22) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)it22));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            it22 = throwable;
            boolean bl3 = false;
            this.connectionPool.offer(connection2);
            throw it22;
        }
        return (ResultSet)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected final ResultSet executeQueryWithConnection(@NotNull XSqlTaskStatus sqlTask, @NotNull Connection conn) {
        ResultSet resultSet;
        Intrinsics.checkNotNullParameter((Object)sqlTask, (String)"sqlTask");
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        String sql2 = sqlTask.getSql();
        ResultSet result2 = null;
        Statement statement = conn.createStatement(1005, 1007);
        if (statement != null) {
            AutoCloseable autoCloseable = statement;
            Throwable throwable = null;
            try {
                ResultSet resultSet2;
                Statement st = (Statement)autoCloseable;
                boolean bl = false;
                try {
                    Unit unit;
                    ResultSet resultSet3 = resultSet2 = st.executeQuery(sql2);
                    if (resultSet3 != null) {
                        Intrinsics.checkNotNull((Object)resultSet3);
                        AutoCloseable autoCloseable2 = resultSet2;
                        Throwable throwable2 = null;
                        try {
                            ResultSet rs = (ResultSet)autoCloseable2;
                            boolean bl2 = false;
                            result2 = ResultSetUtils.copyResultSet$default((ResultSetUtils)ResultSetUtils.INSTANCE, (ResultSet)rs, (int)0, (int)2, null);
                            sqlTask.setStatusCode(200);
                            Unit unit2 = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    resultSet2 = unit;
                }
                catch (JdbcSQLException e) {
                    String string = e.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    String message = string;
                    if (StringsKt.contains$default((CharSequence)message, (CharSequence)"Syntax error in SQL statement", (boolean)false, (int)2, null)) {
                        sqlTask.setStatusCode(400);
                        this.logger.warn("Syntax error in SQL statement #" + this.task.getUuid() + "\n{}", (Object)ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null));
                    } else {
                        sqlTask.setStatusCode(417);
                        this.logger.warn("Failed to execute scrape task #" + this.task.getUuid() + "\n{}", (Object)ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null));
                    }
                    resultSet2 = Unit.INSTANCE;
                }
                ResultSet resultSet4 = resultSet2;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        if ((resultSet = result2) == null) {
            ResultSet resultSet5 = ResultSets.newResultSet();
            resultSet = resultSet5;
            Intrinsics.checkNotNullExpressionValue((Object)resultSet5, (String)"newResultSet(...)");
        }
        return resultSet;
    }

    protected final void executeCallback(@NotNull GeneralScrapeTask task, Response response, @NotNull Function2<? super GeneralScrapeTask, ? super SinkResponse, Unit> thenAction) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter(thenAction, (String)"thenAction");
        String string = task.getCallbackUrl();
        if (string == null) {
            return;
        }
        String callbackUrl = string;
        this.metrics.getCommits().mark();
        try {
            String responseBody = ExtensionsKt.scentObjectMapper().writeValueAsString(response);
            this.logger.info("Writing " + responseBody);
            Intrinsics.checkNotNull((Object)responseBody);
            this.sinkCommitter.commit(responseBody, callbackUrl, (Function1<? super SinkResponse, Unit>)((Function1)new Function1<SinkResponse, Unit>(thenAction, task){
                final /* synthetic */ Function2<GeneralScrapeTask, SinkResponse, Unit> $thenAction;
                final /* synthetic */ GeneralScrapeTask $task;
                {
                    this.$thenAction = $thenAction;
                    this.$task = $task;
                    super(1);
                }

                public final void invoke(@NotNull SinkResponse commitResponse) {
                    Intrinsics.checkNotNullParameter((Object)commitResponse, (String)"commitResponse");
                    this.$thenAction.invoke((Object)this.$task, (Object)commitResponse);
                }
            }));
        }
        catch (Exception e) {
            this.metrics.getFailedCommits().mark();
            task.setSyncError(e.getMessage());
        }
    }

    protected final void handleSyncResponse(@NotNull GeneralScrapeTask task, @NotNull SinkResponse response) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.metrics.getSyncResponses().mark();
        task.setSyncStatusCode(response.getStatusCode());
        if (response.getStatusCode() != 0 && response.getStatusCode() != 200) {
            this.metrics.getFailedSyncResponses().mark();
        }
        task.setSyncResponseHeaders(StringUtils.abbreviateMiddle((String)new Gson().toJson(response.getHeaders()), (String)"...", (int)256));
        task.setSyncResponseBody(StringUtils.abbreviateMiddle((String)response.getBody(), (String)"...", (int)1024));
        this.updateTask(task);
    }

    private final void updateTask(GeneralScrapeTask task) {
        block2: {
            Throwable throwable;
            Object object;
            this.metrics.getPersists().mark();
            try {
                boolean bl = false;
                this.taskUpdater.invoke((Object)task);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            Throwable throwable3 = Result.exceptionOrNull-impl((Object)object);
            if (throwable3 == null) break block2;
            Throwable it = throwable = throwable3;
            boolean bl = false;
            LogsKt.warnInterruptible((Object)((Object)this), (Throwable)it, (String)ExceptionsKt.brief$default((Throwable)it, (String)("Failed to update task <" + task.getUuid() + "> - "), null, (int)2, null), (Object[])new Object[0]);
        }
    }
}

