/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ql.h2.context.support;

import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.Systems;
import ai.platon.pulsar.common.sql.SQLUtils;
import ai.platon.pulsar.ql.SessionDelegate;
import ai.platon.pulsar.ql.common.ResultSets;
import ai.platon.pulsar.skeleton.common.options.LoadOptions;
import ai.platon.pulsar.skeleton.common.urls.NormURL;
import ai.platon.scent.AbstractScentSession;
import ai.platon.scent.context.support.AbstractScentContext;
import ai.platon.scent.ql.h2.AbstractScentSQLSession;
import ai.platon.scent.ql.h2.context.ScentSQLContext;
import ai.platon.scent.ql.h2.context.support.AbstractScentSQLContext;
import java.sql.Connection;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.h2.engine.Session;
import org.h2.engine.SessionInterface;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.DbException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.AbstractApplicationContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 C2\u00020\u00012\u00020\u0002:\u0002CDB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0016H\u0016J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)H&J\b\u0010*\u001a\u00020$H\u0002J\u0010\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u0010,\u001a\u00020-H\u0016J\u001a\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u00020\n2\u0006\u00103\u001a\u000201H\u0002J\u0010\u00104\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u0016H\u0016J\u0010\u00104\u001a\u00020\u001a2\u0006\u00105\u001a\u000206H\u0016J \u00107\u001a\u0002082\u0006\u00109\u001a\u00020-2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0016J\u001c\u0010>\u001a\u00020$2\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020$0@H\u0016J\u001c\u0010A\u001a\u00020/2\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020/0@H\u0016J\b\u0010B\u001a\u00020\u0016H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082D\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006E"}, d2={"Lai/platon/scent/ql/h2/context/support/AbstractScentSQLContext;", "Lai/platon/scent/context/support/AbstractScentContext;", "Lai/platon/scent/ql/h2/context/ScentSQLContext;", "applicationContext", "Lorg/springframework/context/support/AbstractApplicationContext;", "(Lorg/springframework/context/support/AbstractApplicationContext;)V", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "connectionPool", "Ljava/util/concurrent/ArrayBlockingQueue;", "Ljava/sql/Connection;", "getConnectionPool", "()Ljava/util/concurrent/ArrayBlockingQueue;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "randomConnection", "getRandomConnection", "()Ljava/sql/Connection;", "randomConnectionOrNull", "getRandomConnectionOrNull", "resultSetConcurrency", "", "resultSetType", "sqlSessions", "Ljava/util/concurrent/ConcurrentHashMap;", "Lai/platon/scent/ql/h2/AbstractScentSQLSession;", "getSqlSessions", "()Ljava/util/concurrent/ConcurrentHashMap;", "status", "Lai/platon/scent/ql/h2/context/support/AbstractScentSQLContext$Status;", "getStatus", "()Lai/platon/scent/ql/h2/context/support/AbstractScentSQLContext$Status;", "setStatus", "(Lai/platon/scent/ql/h2/context/support/AbstractScentSQLContext$Status;)V", "close", "", "closeSession", "sessionId", "createSession", "sessionDelegate", "Lai/platon/pulsar/ql/SessionDelegate;", "ensureRunning", "execute", "sql", "", "executeQuery", "Ljava/sql/ResultSet;", "getJdbcExceptionOrNull", "Lorg/h2/jdbc/JdbcSQLException;", "conn", "e", "getSession", "sessionInterface", "Lorg/h2/engine/SessionInterface;", "normalize", "Lai/platon/pulsar/skeleton/common/urls/NormURL;", "url", "options", "Lai/platon/pulsar/skeleton/common/options/LoadOptions;", "toItemOption", "", "run", "block", "Lkotlin/Function1;", "runQuery", "sessionCount", "Companion", "Status", "scent-engine"})
@SourceDebugExtension(value={"SMAP\nAbstractScentSQLContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractScentSQLContext.kt\nai/platon/scent/ql/h2/context/support/AbstractScentSQLContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,217:1\n1#2:218\n1855#3,2:219\n1855#3,2:221\n*S KotlinDebug\n*F\n+ 1 AbstractScentSQLContext.kt\nai/platon/scent/ql/h2/context/support/AbstractScentSQLContext\n*L\n184#1:219,2\n186#1:221,2\n*E\n"})
public abstract class AbstractScentSQLContext
extends AbstractScentContext
implements ScentSQLContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger logger;
    @NotNull
    private Status status;
    @NotNull
    private final ArrayBlockingQueue<Connection> connectionPool;
    private final int resultSetType;
    private final int resultSetConcurrency;
    @NotNull
    private final ConcurrentHashMap<Integer, AbstractScentSQLSession> sqlSessions;
    @NotNull
    private final AtomicBoolean closed;
    public static final int ID_START = 0x200B20;
    public static final int ID_END = 2099999;

    public AbstractScentSQLContext(@NotNull AbstractApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        super(applicationContext, null, 2, null);
        this.logger = LoggerFactory.getLogger(AbstractScentSQLContext.class);
        this.status = Status.NOT_READY;
        this.connectionPool = new ArrayBlockingQueue(1000);
        this.resultSetType = 1005;
        this.resultSetConcurrency = 1007;
        this.sqlSessions = new ConcurrentHashMap();
        this.closed = new AtomicBoolean();
        Systems.INSTANCE.setPropertyIfAbsent("scent.extract.tabulate.cell.type", "DATABASE");
        this.status = Status.INITIALIZING;
        Object[] objectArray = new Object[]{this.getId(), this.getSessions().size(), this.getClass().getSimpleName()};
        this.logger.info("SQLContext is created | {}/{} | {}", objectArray);
        this.status = Status.RUNNING;
    }

    @NotNull
    public final Status getStatus() {
        return this.status;
    }

    public final void setStatus(@NotNull Status status) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"<set-?>");
        this.status = status;
    }

    @NotNull
    public abstract Connection getRandomConnection();

    @Nullable
    public final Connection getRandomConnectionOrNull() {
        Object object;
        block2: {
            Throwable throwable;
            try {
                boolean bl = false;
                object = Result.constructor-impl((Object)this.getRandomConnection());
            }
            catch (Throwable throwable2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            Throwable throwable3 = Result.exceptionOrNull-impl((Object)object);
            if (throwable3 == null) break block2;
            Throwable it = throwable = throwable3;
            boolean bl = false;
            LogsKt.warnInterruptible((Object)this, (Throwable)it, (String)ExceptionsKt.stringify$default((Throwable)it, null, null, (int)3, null), (Object[])new Object[0]);
        }
        return (Connection)(Result.isFailure-impl((Object)object) ? null : object);
    }

    @NotNull
    public final ArrayBlockingQueue<Connection> getConnectionPool() {
        return this.connectionPool;
    }

    @NotNull
    public final ConcurrentHashMap<Integer, AbstractScentSQLSession> getSqlSessions() {
        return this.sqlSessions;
    }

    @NotNull
    public NormURL normalize(@NotNull String url, @NotNull LoadOptions options, boolean toItemOption) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        NormURL normUrl = super.normalize(url, options, toItemOption);
        return new NormURL(SQLUtils.INSTANCE.unsanitizeUrl(normUrl.getSpec()), normUrl.getOptions(), normUrl.getHrefSpec(), null, 8, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(@NotNull String sql2) throws Exception {
        Connection it;
        Connection connection;
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        Connection connection2 = this.connectionPool.poll();
        if (connection2 == null) {
            connection2 = this.getRandomConnection();
        }
        Connection conn = connection2;
        try {
            conn.createStatement(this.resultSetType, this.resultSetConcurrency).execute(sql2);
            it = connection = conn;
            boolean bl = false;
        }
        catch (JdbcSQLException e) {
            Connection it2;
            Connection connection3;
            try {
                this.getJdbcExceptionOrNull(conn, e);
                it2 = connection3 = conn;
                boolean bl = false;
            }
            catch (Throwable throwable) {
                Connection connection4;
                Connection it3 = connection4 = conn;
                boolean bl = false;
                Connection connection5 = !it3.isClosed() ? connection4 : null;
                if (connection5 != null) {
                    it3 = connection5;
                    boolean bl2 = false;
                    this.connectionPool.add(conn);
                }
                throw throwable;
            }
            Connection connection6 = !it2.isClosed() ? connection3 : null;
            if (connection6 != null) {
                it2 = connection6;
                boolean bl = false;
                this.connectionPool.add(conn);
            }
        }
        Connection connection7 = !it.isClosed() ? connection : null;
        if (connection7 != null) {
            it = connection7;
            boolean bl = false;
            this.connectionPool.add(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ResultSet executeQuery(@NotNull String sql2) throws Exception {
        Connection it;
        Connection connection;
        ResultSet resultSet;
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        Connection connection2 = this.connectionPool.poll();
        if (connection2 == null) {
            connection2 = this.getRandomConnection();
        }
        Connection conn = connection2;
        try {
            resultSet = conn.createStatement(this.resultSetType, this.resultSetConcurrency).executeQuery(sql2);
            Intrinsics.checkNotNull((Object)resultSet);
            it = connection = conn;
            boolean bl = false;
        }
        catch (JdbcSQLException e) {
            block9: {
                Connection it2;
                Connection connection3;
                ResultSet resultSet2;
                try {
                    if (e.getErrorCode() != 90098) break block9;
                    this.logger.warn("Db is closed | {} | {}", (Object)conn, (Object)e.getMessage());
                    ResultSet resultSet3 = ResultSets.newResultSet();
                    Intrinsics.checkNotNullExpressionValue((Object)resultSet3, (String)"newResultSet(...)");
                    resultSet2 = resultSet3;
                    it2 = connection3 = conn;
                    boolean bl = false;
                }
                catch (Throwable throwable) {
                    Connection connection4;
                    Connection it3 = connection4 = conn;
                    boolean bl = false;
                    Connection connection5 = !it3.isClosed() ? connection4 : null;
                    if (connection5 != null) {
                        it3 = connection5;
                        boolean bl2 = false;
                        this.connectionPool.add(conn);
                    }
                    throw throwable;
                }
                Connection connection6 = !it2.isClosed() ? connection3 : null;
                if (connection6 != null) {
                    it2 = connection6;
                    boolean bl = false;
                    this.connectionPool.add(conn);
                }
                return resultSet2;
            }
            throw e;
        }
        Connection connection7 = !it.isClosed() ? connection : null;
        if (connection7 != null) {
            it = connection7;
            boolean connection3 = false;
            this.connectionPool.add(conn);
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull Function1<? super Connection, Unit> block) throws Exception {
        Connection it;
        Connection connection;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Connection connection2 = this.connectionPool.poll();
        if (connection2 == null) {
            connection2 = this.getRandomConnection();
        }
        Connection conn = connection2;
        try {
            block.invoke((Object)conn);
            it = connection = conn;
            boolean bl = false;
        }
        catch (JdbcSQLException e) {
            Object it2;
            Object object;
            try {
                object = this.getJdbcExceptionOrNull(conn, e);
                if (object != null) {
                    JdbcSQLException it3 = object;
                    boolean bl = false;
                    throw it3;
                }
                it2 = object = conn;
                boolean bl = false;
            }
            catch (Throwable throwable) {
                Connection connection3;
                Connection it4 = connection3 = conn;
                boolean bl = false;
                Connection connection4 = !it4.isClosed() ? connection3 : null;
                if (connection4 != null) {
                    it4 = connection4;
                    boolean bl2 = false;
                    this.connectionPool.add(conn);
                }
                throw throwable;
            }
            Object object2 = !it2.isClosed() ? object : null;
            if (object2 != null) {
                it2 = object2;
                boolean bl = false;
                this.connectionPool.add(conn);
            }
        }
        Connection connection5 = !it.isClosed() ? connection : null;
        if (connection5 != null) {
            it = connection5;
            boolean bl = false;
            this.connectionPool.add(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ResultSet runQuery(@NotNull Function1<? super Connection, ? extends ResultSet> block) throws Exception {
        Connection it;
        Connection connection;
        ResultSet resultSet;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Connection connection2 = this.connectionPool.poll();
        if (connection2 == null) {
            connection2 = this.getRandomConnection();
        }
        Connection conn = connection2;
        try {
            resultSet = (ResultSet)block.invoke((Object)conn);
            it = connection = conn;
            boolean bl = false;
        }
        catch (JdbcSQLException e) {
            block8: {
                Connection it2;
                Connection it3;
                ResultSet resultSet2;
                try {
                    if (e.getErrorCode() != 90098) break block8;
                    this.logger.warn("Db is closed | {} | {}", (Object)conn, (Object)e.getMessage());
                    ResultSet resultSet3 = ResultSets.newResultSet();
                    Intrinsics.checkNotNullExpressionValue((Object)resultSet3, (String)"newResultSet(...)");
                    resultSet2 = resultSet3;
                    it2 = it3 = conn;
                    boolean bl = false;
                }
                catch (Throwable throwable) {
                    block9: {
                        Connection connection3;
                        Connection it4 = connection3 = conn;
                        boolean bl = false;
                        Connection connection4 = !it4.isClosed() ? connection3 : null;
                        if (connection4 == null) break block9;
                        it4 = connection4;
                        boolean bl2 = false;
                        this.connectionPool.add(conn);
                    }
                    throw throwable;
                }
                Connection connection5 = !it2.isClosed() ? it3 : null;
                if (connection5 != null) {
                    it2 = connection5;
                    boolean bl = false;
                    this.connectionPool.add(conn);
                }
                return resultSet2;
            }
            throw e;
        }
        Connection connection6 = !it.isClosed() ? connection : null;
        if (connection6 != null) {
            it = connection6;
            boolean bl = false;
            this.connectionPool.add(conn);
        }
        return resultSet;
    }

    @Override
    @NotNull
    public abstract AbstractScentSQLSession createSession(@NotNull SessionDelegate var1) throws Exception;

    @Override
    public int sessionCount() {
        return this.sqlSessions.size();
    }

    @NotNull
    public AbstractScentSQLSession getSession(@NotNull SessionInterface sessionInterface) throws Exception {
        Intrinsics.checkNotNullParameter((Object)sessionInterface, (String)"sessionInterface");
        Session h2session = (Session)sessionInterface;
        return this.getSession(h2session.getSerialId());
    }

    @Override
    @NotNull
    public AbstractScentSQLSession getSession(int sessionId) throws Exception {
        AbstractScentSQLSession session2 = this.sqlSessions.get(sessionId);
        if (session2 == null) {
            Object[] objectArray = new Object[]{sessionId, this.getId()};
            String message = MessageFormat.format("Session is already closed | #{0}/{1}", objectArray);
            this.logger.warn(message);
            DbException dbException = DbException.get((int)90007, (String)message);
            Intrinsics.checkNotNullExpressionValue((Object)dbException, (String)"get(...)");
            throw (Throwable)dbException;
        }
        return session2;
    }

    @Override
    public void closeSession(int sessionId) {
        try {
            AbstractScentSQLSession abstractScentSQLSession = this.sqlSessions.remove(sessionId);
            if (abstractScentSQLSession != null) {
                abstractScentSQLSession.close();
            }
        }
        catch (Exception e) {
            LogsKt.warnInterruptible((Object)this, (Throwable)e);
        }
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            Set set = this.sqlSessions.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
            String sessionKeys2 = CollectionsKt.joinToString$default((Iterable)set, null, null, null, (int)0, null, (Function1)close.sessionKeys.1.INSTANCE, (int)31, null);
            Object[] objectArray = new Object[]{this.getId(), sessionKeys2, this.getClass().getName()};
            this.logger.info("Closing SQLContext {}, sql sessions: {} | {}", objectArray);
            this.status = Status.CLOSING;
            try {
                Object it;
                Collection<AbstractScentSQLSession> collection = this.sqlSessions.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (AbstractScentSQLSession)element$iv;
                    boolean bl = false;
                    ((AbstractScentSession)it).close();
                }
                this.sqlSessions.clear();
                $this$forEach$iv = this.connectionPool;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Connection)element$iv;
                    boolean bl = false;
                    it.close();
                }
                this.connectionPool.clear();
                super.close();
            }
            catch (Exception e) {
                LogsKt.warnInterruptible((Object)this, (Throwable)e);
            }
            this.status = Status.CLOSED;
        }
    }

    private final void ensureRunning() {
        if (!this.isActive()) {
            throw new IllegalStateException("SQLContext is closed | #" + this.getId());
        }
    }

    private final JdbcSQLException getJdbcExceptionOrNull(Connection conn, JdbcSQLException e) throws JdbcSQLException {
        String message;
        String string = e.getMessage();
        if (string == null) {
            string = message = ((Object)((Object)e)).getClass().getSimpleName();
        }
        if (e.getErrorCode() == 90098) {
            this.logger.warn("Db is closed | {} | {}", (Object)conn, (Object)message);
            return null;
        }
        return e;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/platon/scent/ql/h2/context/support/AbstractScentSQLContext$Companion;", "", "()V", "ID_END", "", "ID_START", "scent-engine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lai/platon/scent/ql/h2/context/support/AbstractScentSQLContext$Status;", "", "(Ljava/lang/String;I)V", "NOT_READY", "INITIALIZING", "RUNNING", "CLOSING", "CLOSED", "scent-engine"})
    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status NOT_READY = new Status();
        public static final /* enum */ Status INITIALIZING = new Status();
        public static final /* enum */ Status RUNNING = new Status();
        public static final /* enum */ Status CLOSING = new Status();
        public static final /* enum */ Status CLOSED = new Status();
        private static final /* synthetic */ Status[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String value) {
            return Enum.valueOf(Status.class, value);
        }

        @NotNull
        public static EnumEntries<Status> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = statusArray = new Status[]{Status.NOT_READY, Status.INITIALIZING, Status.RUNNING, Status.CLOSING, Status.CLOSED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

