/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ql.h2.udfs;

import ai.platon.pulsar.common.DateTimeDetector;
import ai.platon.pulsar.common.RegexExtractor;
import ai.platon.pulsar.ql.common.annotation.UDFGroup;
import ai.platon.pulsar.ql.common.annotation.UDFunction;
import java.time.OffsetDateTime;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UDFGroup(namespace="EXT")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0007J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0007J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0007J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lai/platon/scent/ql/h2/udfs/ExtractPieceFunctions;", "", "()V", "REGEX_PRICE", "", "getREGEX_PRICE", "()Ljava/lang/String;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "date", "text", "dateTime", "dateTimeLenient", "price", "scent-engine"})
public final class ExtractPieceFunctions {
    @NotNull
    public static final ExtractPieceFunctions INSTANCE = new ExtractPieceFunctions();
    private static final Logger log = LoggerFactory.getLogger(ExtractPieceFunctions.class);
    @NotNull
    private static final String REGEX_PRICE = "\\p{Sc}\\s*(\\d+(\\.\\d{0,2})?)";

    private ExtractPieceFunctions() {
    }

    public final Logger getLog() {
        return log;
    }

    @NotNull
    public final String getREGEX_PRICE() {
        return REGEX_PRICE;
    }

    @UDFunction
    @JvmStatic
    @NotNull
    public static final String price(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String string = new RegexExtractor().re1(text, REGEX_PRICE);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"re1(...)");
        return string;
    }

    @UDFunction
    @JvmStatic
    @NotNull
    public static final String date(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String string = new DateTimeDetector().detectDate(text).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @UDFunction
    @JvmStatic
    @NotNull
    public static final String dateTime(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String string = new DateTimeDetector().detectDateTime(text).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @UDFunction
    @JvmStatic
    @NotNull
    public static final String dateTimeLenient(@NotNull String text) {
        OffsetDateTime dateTime;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        OffsetDateTime offsetDateTime = dateTime = new DateTimeDetector().detectDateTimeLeniently(text);
        String string = offsetDateTime != null ? offsetDateTime.toString() : null;
        if (string == null) {
            string = "";
        }
        return string;
    }
}

