/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api;

import ai.platon.commons.distributed.lock.mongo.configuration.EnableMongoDistributedLock;
import ai.platon.pulsar.common.collect.ExternalUrlLoader;
import ai.platon.pulsar.common.collect.UrlFeederHelper;
import ai.platon.pulsar.common.collect.collector.UrlCacheCollector;
import ai.platon.pulsar.common.metrics.MetricFilters;
import ai.platon.scent.boot.autoconfigure.common.ScrapeTaskHandler;
import ai.platon.scent.boot.autoconfigure.component.CrawlSeedV3Loader;
import ai.platon.scent.boot.autoconfigure.component.ScentCrawlLoop;
import ai.platon.scent.boot.autoconfigure.component.ScrapeTaskV1Handler;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.json.MetricsModule;
import com.fasterxml.jackson.databind.Module;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableMongoDistributedLock
@ComponentScan(value={"ai.platon.scent.boot.autoconfigure", "ai.platon.scent.boot.autoconfigure.component", "ai.platon.scent.rest.api"})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0017J\b\u0010\u0011\u001a\u00020\u0012H\u0017J\b\u0010\u0013\u001a\u00020\u0012H\u0017J\b\u0010\u0014\u001a\u00020\u0015H\u0017R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lai/platon/scent/rest/api/ApiConfiguration;", "", "urlLoader", "Lai/platon/pulsar/common/collect/ExternalUrlLoader;", "crawlLoop", "Lai/platon/scent/boot/autoconfigure/component/ScentCrawlLoop;", "taskV1Handler", "Lai/platon/scent/boot/autoconfigure/component/ScrapeTaskV1Handler;", "(Lai/platon/pulsar/common/collect/ExternalUrlLoader;Lai/platon/scent/boot/autoconfigure/component/ScentCrawlLoop;Lai/platon/scent/boot/autoconfigure/component/ScrapeTaskV1Handler;)V", "getCrawlLoop", "()Lai/platon/scent/boot/autoconfigure/component/ScentCrawlLoop;", "getTaskV1Handler", "()Lai/platon/scent/boot/autoconfigure/component/ScrapeTaskV1Handler;", "getUrlLoader", "()Lai/platon/pulsar/common/collect/ExternalUrlLoader;", "getRestTemplate", "Lorg/springframework/web/client/RestTemplate;", "initCrawlSeedLoader", "", "initializeDataCollectors", "metricsModule", "Lcom/fasterxml/jackson/databind/Module;", "scent-rest"})
public class ApiConfiguration {
    @NotNull
    private final ExternalUrlLoader urlLoader;
    @NotNull
    private final ScentCrawlLoop crawlLoop;
    @NotNull
    private final ScrapeTaskV1Handler taskV1Handler;

    public ApiConfiguration(@NotNull ExternalUrlLoader urlLoader, @NotNull ScentCrawlLoop crawlLoop, @NotNull ScrapeTaskV1Handler taskV1Handler) {
        Intrinsics.checkNotNullParameter((Object)urlLoader, (String)"urlLoader");
        Intrinsics.checkNotNullParameter((Object)crawlLoop, (String)"crawlLoop");
        Intrinsics.checkNotNullParameter((Object)taskV1Handler, (String)"taskV1Handler");
        this.urlLoader = urlLoader;
        this.crawlLoop = crawlLoop;
        this.taskV1Handler = taskV1Handler;
    }

    @NotNull
    public ExternalUrlLoader getUrlLoader() {
        return this.urlLoader;
    }

    @NotNull
    public ScentCrawlLoop getCrawlLoop() {
        return this.crawlLoop;
    }

    @NotNull
    public ScrapeTaskV1Handler getTaskV1Handler() {
        return this.taskV1Handler;
    }

    @Bean
    public void initCrawlSeedLoader() {
        CrawlSeedV3Loader crawlSeedV3Loader;
        ExternalUrlLoader externalUrlLoader = this.getUrlLoader();
        CrawlSeedV3Loader crawlSeedV3Loader2 = crawlSeedV3Loader = externalUrlLoader instanceof CrawlSeedV3Loader ? (CrawlSeedV3Loader)externalUrlLoader : null;
        if (crawlSeedV3Loader != null) {
            crawlSeedV3Loader.setTaskV1Handler(this.getTaskV1Handler());
        }
    }

    @Bean
    @NotNull
    public Module metricsModule() {
        MetricFilter filter = MetricFilters.INSTANCE.notContains("._.");
        return (Module)new MetricsModule(TimeUnit.SECONDS, TimeUnit.MILLISECONDS, false, filter);
    }

    @Bean
    @NotNull
    public RestTemplate getRestTemplate() {
        return new RestTemplate();
    }

    @Bean
    public void initializeDataCollectors() {
        UrlFeederHelper urlFeederHelper = new UrlFeederHelper(this.getCrawlLoop().getUrlFeeder());
        UrlCacheCollector urlCacheCollector = urlFeederHelper.create("SCRAPE", ScrapeTaskHandler.Companion.getDEFAULT_TASK_PRIORITY().getValue(), this.getUrlLoader());
        boolean bl = false;
        boolean bl2 = false;
        UrlCacheCollector it = urlCacheCollector;
        boolean bl3 = false;
        it.getLabels().add("SCRAPE");
    }
}

