/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.controller;

import ai.platon.pulsar.common.urls.HyperlinkDatum;
import ai.platon.pulsar.common.urls.UrlUtils;
import ai.platon.pulsar.session.PulsarSession;
import ai.platon.scent.boot.autoconfigure.persist.HarvestTaskStatusRepository;
import ai.platon.scent.dom.HarvestOptions;
import ai.platon.scent.entities.HarvestTaskStatus;
import ai.platon.scent.rest.api.controller.ControllerBase;
import ai.platon.scent.rest.api.serialize.HarvestRequest;
import ai.platon.scent.rest.api.serialize.W3DocumentRequest;
import ai.platon.scent.rest.api.service.HarvestService;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"xx"})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0012\u0010\u0017\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0017J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0012\u0010\u0019\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0017J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0012\u0010\u001b\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0017J\u001c\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u0013\u001a\u00020\u001fH\u0017R\u001e\u0010\u0007\u001a\u00020\b8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lai/platon/scent/rest/api/controller/HarvestController;", "Lai/platon/scent/rest/api/controller/ControllerBase;", "httpSession", "Ljavax/servlet/http/HttpSession;", "taskRepository", "Lai/platon/scent/boot/autoconfigure/persist/HarvestTaskStatusRepository;", "(Ljavax/servlet/http/HttpSession;Lai/platon/scent/boot/autoconfigure/persist/HarvestTaskStatusRepository;)V", "harvestService", "Lai/platon/scent/rest/api/service/HarvestService;", "getHarvestService", "()Lai/platon/scent/rest/api/service/HarvestService;", "setHarvestService", "(Lai/platon/scent/rest/api/service/HarvestService;)V", "logger", "Lorg/slf4j/Logger;", "getTaskRepository", "()Lai/platon/scent/boot/autoconfigure/persist/HarvestTaskStatusRepository;", "doHarvest", "", "request", "Lai/platon/scent/rest/api/serialize/HarvestRequest;", "doHarvestArticle", "harvestArticle", "harvestArticlePost", "harvestArticles", "harvestArticlesPost", "harvestH", "harvestHPost", "hotLinks", "", "Lai/platon/pulsar/common/urls/HyperlinkDatum;", "Lai/platon/scent/rest/api/serialize/W3DocumentRequest;", "scent-rest"})
public class HarvestController
extends ControllerBase {
    @NotNull
    private final HarvestTaskStatusRepository taskRepository;
    @NotNull
    private final Logger logger;
    @Autowired
    public HarvestService harvestService;

    public HarvestController(@NotNull HttpSession httpSession, @NotNull HarvestTaskStatusRepository taskRepository) {
        Intrinsics.checkNotNullParameter((Object)httpSession, (String)"httpSession");
        Intrinsics.checkNotNullParameter((Object)taskRepository, (String)"taskRepository");
        super(httpSession);
        this.taskRepository = taskRepository;
        Logger logger = LoggerFactory.getLogger(HarvestController.class);
        Intrinsics.checkNotNull((Object)logger);
        this.logger = logger;
    }

    @NotNull
    public HarvestTaskStatusRepository getTaskRepository() {
        return this.taskRepository;
    }

    @NotNull
    public HarvestService getHarvestService() {
        HarvestService harvestService = this.harvestService;
        if (harvestService != null) {
            return harvestService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"harvestService");
        return null;
    }

    public void setHarvestService(@NotNull HarvestService harvestService) {
        Intrinsics.checkNotNullParameter((Object)harvestService, (String)"<set-?>");
        this.harvestService = harvestService;
    }

    @GetMapping(value={"h"})
    @NotNull
    public String harvestH(@NotNull HarvestRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.doHarvest(request);
    }

    @PostMapping(value={"h"}, consumes={"application/json"}, produces={"application/json"})
    @NotNull
    public String harvestHPost(@RequestBody @NotNull HarvestRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.doHarvest(request);
    }

    @GetMapping(value={"h/article"})
    @NotNull
    public String harvestArticle(@NotNull HarvestRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.doHarvestArticle(request);
    }

    @PostMapping(value={"h/article"}, consumes={"application/json"}, produces={"application/json"})
    @NotNull
    public String harvestArticlePost(@RequestBody @NotNull HarvestRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.doHarvestArticle(request);
    }

    @GetMapping(value={"h/articles"})
    @NotNull
    public String harvestArticles(@NotNull HarvestRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.getHarvestService().harvestArticles(request);
    }

    @PostMapping(value={"h/articles"}, consumes={"application/json"}, produces={"application/json"})
    @NotNull
    public String harvestArticlesPost(@RequestBody @NotNull HarvestRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.getHarvestService().harvestArticles(request);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"links/hot"}, produces={"application/json"})
    @NotNull
    public Map<String, HyperlinkDatum> hotLinks(@NotNull W3DocumentRequest request) {
        void $this$associateByTo$iv$iv;
        Object object;
        Object object2;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Iterable $this$map$iv = this.getHarvestService().findHotLinks();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HarvestTaskStatus harvestTaskStatus = (HarvestTaskStatus)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object = new HyperlinkDatum((String)UrlUtils.splitUrlArgs((String)it.getConfiguredUrl()).getFirst(), "", 0, null, null, null, false, 0, 252, null);
            object2.add(object);
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            HyperlinkDatum bl = (HyperlinkDatum)element$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl2 = false;
            object = it.getUrl();
            object2.put(object, element$iv$iv);
        }
        return destination$iv$iv2;
    }

    private final String doHarvest(HarvestRequest request) {
        return this.getHarvestService().harvest(request);
    }

    private final String doHarvestArticle(HarvestRequest request) {
        String string;
        String portalUrl = request.getPortalUrl();
        String htmlContent = request.getHtmlContent();
        HarvestOptions options = (HarvestOptions)PulsarSession.DefaultImpls.options$default((PulsarSession)((PulsarSession)this.getScentSession()), (String)((string = request.getArgs()) == null ? "" : string), null, (int)2, null);
        return htmlContent == null ? this.getHarvestService().harvestArticle(request) : this.getHarvestService().harvestArticle(portalUrl, htmlContent, options, request.getWithHtml());
    }
}

