/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.controller;

import ai.platon.scent.rest.api.common.Requests;
import ai.platon.scent.rest.api.serialize.Hello;
import ai.platon.scent.rest.api.service.HelloService;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"hello"})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\fH\u0017J\b\u0010\u000e\u001a\u00020\u000fH\u0017J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\b\u0010\u0013\u001a\u00020\u0014H\u0017J\b\u0010\u0015\u001a\u00020\u0016H\u0017J\b\u0010\u0003\u001a\u00020\fH\u0017J\b\u0010\u0017\u001a\u00020\fH\u0017J\u0012\u0010\u0018\u001a\u00020\f2\b\b\u0001\u0010\u0019\u001a\u00020\fH\u0017J\u0012\u0010\u001a\u001a\u00020\f2\b\b\u0001\u0010\u0019\u001a\u00020\fH\u0017J\u0010\u0010\u001b\u001a\n \u001c*\u0004\u0018\u00010\f0\fH\u0017J\u0012\u0010\u001d\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\fH\u0017J\u001e\u0010\u001e\u001a\u00020\f2\u0014\b\u0001\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0 H\u0017J\u0012\u0010!\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017R\u001e\u0010\u0003\u001a\u00020\u00048\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lai/platon/scent/rest/api/controller/HelloController;", "", "()V", "helloService", "Lai/platon/scent/rest/api/service/HelloService;", "getHelloService", "()Lai/platon/scent/rest/api/service/HelloService;", "setHelloService", "(Lai/platon/scent/rest/api/service/HelloService;)V", "log", "Lorg/slf4j/Logger;", "echo", "", "requestBody", "getDate", "Ljava/util/Date;", "getPath", "request", "Ljavax/servlet/http/HttpServletRequest;", "getTimestamp", "", "helloData", "Lai/platon/scent/rest/api/serialize/Hello;", "helloString", "load1", "targetUrl", "load2", "pwd", "kotlin.jvm.PlatformType", "swallow", "testPost", "allParams", "", "whoami", "scent-rest"})
public class HelloController {
    @NotNull
    private final Logger log;
    @Autowired
    public HelloService helloService;

    public HelloController() {
        Logger logger = LoggerFactory.getLogger(HelloController.class);
        Intrinsics.checkNotNull((Object)logger);
        this.log = logger;
    }

    @NotNull
    public HelloService getHelloService() {
        HelloService helloService = this.helloService;
        if (helloService != null) {
            return helloService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"helloService");
        return null;
    }

    public void setHelloService(@NotNull HelloService helloService) {
        Intrinsics.checkNotNullParameter((Object)helloService, (String)"<set-?>");
        this.helloService = helloService;
    }

    @GetMapping(value={"string"})
    @NotNull
    public String helloString() {
        return "Hello string!";
    }

    @GetMapping(value={"pwd"})
    public String pwd() {
        return System.getProperty("user.dir");
    }

    @GetMapping(value={"whoami"})
    @Nullable
    public String whoami(@NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return Requests.INSTANCE.getRemoteIP(request);
    }

    @GetMapping(value={"service"})
    @NotNull
    public String helloService() {
        return this.getHelloService().getHello();
    }

    @GetMapping(value={"data"})
    @NotNull
    public Hello helloData() {
        return new Hello("Hello data!");
    }

    @GetMapping(value={"path"})
    @NotNull
    public String getPath(@NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string = request.getServletPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.servletPath");
        return string;
    }

    @GetMapping(value={"date"})
    @NotNull
    public Date getDate() {
        return new Date();
    }

    @GetMapping(value={"timestamp"})
    public long getTimestamp() {
        return System.currentTimeMillis();
    }

    @PostMapping(value={"echo"})
    @NotNull
    public String echo(@RequestBody @NotNull String requestBody) {
        Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
        this.log.info("Echo: >>>\n" + requestBody + "\n<<<");
        return requestBody;
    }

    @PostMapping(value={"swallow"})
    @NotNull
    public String swallow(@RequestBody @NotNull String requestBody) {
        Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
        return "delicious";
    }

    @PostMapping(value={"test/post"})
    @NotNull
    public String testPost(@RequestParam @NotNull Map<String, String> allParams) {
        Intrinsics.checkNotNullParameter(allParams, (String)"allParams");
        return "Parameters are " + allParams.entrySet();
    }

    @GetMapping(value={"load1"})
    @NotNull
    public String load1(@RequestParam(value="u") @NotNull String targetUrl) {
        Intrinsics.checkNotNullParameter((Object)targetUrl, (String)"targetUrl");
        return this.getHelloService().load(targetUrl);
    }

    @PostMapping(value={"load2"})
    @NotNull
    public String load2(@RequestParam @NotNull String targetUrl) {
        Intrinsics.checkNotNullParameter((Object)targetUrl, (String)"targetUrl");
        return this.getHelloService().load(targetUrl);
    }
}

