/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.controller;

import ai.platon.scent.crawl.serialize.ScrapeStatusRequest;
import ai.platon.scent.mongo.v1.ScrapeTask;
import ai.platon.scent.rest.api.common.AuthGuard;
import ai.platon.scent.rest.api.service.UserService;
import ai.platon.scent.rest.api.service.scrape.TaskMonthlyHistoryService;
import ai.platon.scent.rest.api.service.scrape.TaskMultiHistoryService;
import ai.platon.scent.rest.api.service.v1.ScrapeServiceV1;
import java.time.Instant;
import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.ExperimentalTime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"x/v1/tasks"}, produces={"application/json"})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ2\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\n\b\u0003\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\n\b\u0003\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J&\u0010 \u001a\u0004\u0018\u00010!2\b\b\u0001\u0010\"\u001a\u00020\u001a2\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J8\u0010#\u001a\b\u0012\u0004\u0012\u00020!0$2\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\n\b\u0003\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\n\b\u0003\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006%"}, d2={"Lai/platon/scent/rest/api/controller/ScrapeTaskV1Controller;", "", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "scrapeService", "Lai/platon/scent/rest/api/service/v1/ScrapeServiceV1;", "multiHistoryService", "Lai/platon/scent/rest/api/service/scrape/TaskMultiHistoryService;", "monthlyHistoryService", "Lai/platon/scent/rest/api/service/scrape/TaskMonthlyHistoryService;", "userService", "Lai/platon/scent/rest/api/service/UserService;", "(Lorg/springframework/context/ApplicationContext;Lai/platon/scent/rest/api/service/v1/ScrapeServiceV1;Lai/platon/scent/rest/api/service/scrape/TaskMultiHistoryService;Lai/platon/scent/rest/api/service/scrape/TaskMonthlyHistoryService;Lai/platon/scent/rest/api/service/UserService;)V", "getApplicationContext", "()Lorg/springframework/context/ApplicationContext;", "getMonthlyHistoryService", "()Lai/platon/scent/rest/api/service/scrape/TaskMonthlyHistoryService;", "getMultiHistoryService", "()Lai/platon/scent/rest/api/service/scrape/TaskMultiHistoryService;", "getScrapeService", "()Lai/platon/scent/rest/api/service/v1/ScrapeServiceV1;", "getUserService", "()Lai/platon/scent/rest/api/service/UserService;", "count", "", "authToken", "", "startTime", "Ljava/time/Instant;", "endTime", "httpRequest", "Ljavax/servlet/http/HttpServletRequest;", "getById", "Lai/platon/scent/mongo/v1/ScrapeTask;", "id", "query", "Lorg/springframework/data/domain/Page;", "scent-rest"})
public class ScrapeTaskV1Controller {
    @NotNull
    private final ApplicationContext applicationContext;
    @NotNull
    private final ScrapeServiceV1 scrapeService;
    @NotNull
    private final TaskMultiHistoryService multiHistoryService;
    @NotNull
    private final TaskMonthlyHistoryService monthlyHistoryService;
    @NotNull
    private final UserService userService;

    public ScrapeTaskV1Controller(@NotNull ApplicationContext applicationContext, @NotNull ScrapeServiceV1 scrapeService, @NotNull TaskMultiHistoryService multiHistoryService, @NotNull TaskMonthlyHistoryService monthlyHistoryService, @NotNull UserService userService) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)((Object)scrapeService), (String)"scrapeService");
        Intrinsics.checkNotNullParameter((Object)multiHistoryService, (String)"multiHistoryService");
        Intrinsics.checkNotNullParameter((Object)monthlyHistoryService, (String)"monthlyHistoryService");
        Intrinsics.checkNotNullParameter((Object)userService, (String)"userService");
        this.applicationContext = applicationContext;
        this.scrapeService = scrapeService;
        this.multiHistoryService = multiHistoryService;
        this.monthlyHistoryService = monthlyHistoryService;
        this.userService = userService;
    }

    @NotNull
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @NotNull
    public ScrapeServiceV1 getScrapeService() {
        return this.scrapeService;
    }

    @NotNull
    public TaskMultiHistoryService getMultiHistoryService() {
        return this.multiHistoryService;
    }

    @NotNull
    public TaskMonthlyHistoryService getMonthlyHistoryService() {
        return this.monthlyHistoryService;
    }

    @NotNull
    public UserService getUserService() {
        return this.userService;
    }

    @GetMapping(value={"/count"}, consumes={"*/*"})
    public long count(@RequestParam @NotNull String authToken, @RequestParam(required=false) @Nullable Instant startTime, @RequestParam(required=false) @Nullable Instant endTime, @NotNull HttpServletRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        new AuthGuard(authToken, null, false, 6, null);
        Instant now = Instant.now();
        Instant instant = startTime;
        Instant startTime2 = instant == null ? now.minusSeconds(86400L) : instant;
        Instant instant2 = endTime;
        Instant endTime2 = instant2 == null ? now : instant2;
        TaskMultiHistoryService taskMultiHistoryService = this.getMultiHistoryService();
        Intrinsics.checkNotNullExpressionValue((Object)startTime2, (String)"startTime2");
        Intrinsics.checkNotNullExpressionValue((Object)endTime2, (String)"endTime2");
        return taskMultiHistoryService.countTasks(authToken, startTime2, endTime2);
    }

    public static /* synthetic */ long count$default(ScrapeTaskV1Controller scrapeTaskV1Controller, String string, Instant instant, Instant instant2, HttpServletRequest httpServletRequest, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: count");
        }
        if ((n & 2) != 0) {
            instant = null;
        }
        if ((n & 4) != 0) {
            instant2 = null;
        }
        return scrapeTaskV1Controller.count(string, instant, instant2, httpServletRequest);
    }

    @GetMapping(value={"/query"}, consumes={"*/*"})
    @ExperimentalTime
    @NotNull
    public Page<ScrapeTask> query(@RequestParam @NotNull String authToken, @RequestParam(required=false) @Nullable Instant startTime, @RequestParam(required=false) @Nullable Instant endTime, @NotNull HttpServletRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        new AuthGuard(authToken, null, false, 6, null);
        Instant now = Instant.now();
        Instant instant = startTime;
        Instant startTime2 = instant == null ? now.minusSeconds(86400L) : instant;
        Instant instant2 = endTime;
        Instant endTime2 = instant2 == null ? now : instant2;
        TaskMultiHistoryService taskMultiHistoryService = this.getMultiHistoryService();
        Intrinsics.checkNotNullExpressionValue((Object)startTime2, (String)"startTime2");
        Intrinsics.checkNotNullExpressionValue((Object)endTime2, (String)"endTime2");
        return taskMultiHistoryService.listTasks(authToken, startTime2, endTime2);
    }

    public static /* synthetic */ Page query$default(ScrapeTaskV1Controller scrapeTaskV1Controller, String string, Instant instant, Instant instant2, HttpServletRequest httpServletRequest, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: query");
        }
        if ((n & 2) != 0) {
            instant = null;
        }
        if ((n & 4) != 0) {
            instant2 = null;
        }
        return scrapeTaskV1Controller.query(string, instant, instant2, httpServletRequest);
    }

    @GetMapping(value={"/{id}"})
    @ExperimentalTime
    @Nullable
    public ScrapeTask getById(@PathVariable @NotNull String id, @RequestParam @NotNull String authToken, @NotNull HttpServletRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        ScrapeStatusRequest request = new ScrapeStatusRequest(authToken, id, 0, 4, null);
        new AuthGuard(request.getAuthToken(), null, false, 6, null);
        return this.getScrapeService().getScrapeTask(request);
    }
}

